using Gon;

namespace Gon {
 /// Abstarkcyjna klasa reprezentująca gracza.
 public abstract class Player {
 	public name: string;
	public color: Color;
	/// Ustawia ruch.
	///
	/// Funkcja jeśli jest taka potrzeba powinna ustawiać
	/// ruch na planszy, woła się ją z parametrami ruchu
	/// przeciwnika, potrzebne przy grze z komputerem lub grze przez sieć.
	virtual public SetMove(_i: int, _y: int) : void
	{
		
	}
	/// Pobierz ruch.
	///
	/// Funkcja pobiera ruch od gracz standardowo zwraca tzw. ruch 
	/// pusty tj trójkę (0,0,Color.Empty).
	virtual public Get() : int*int*Color
	{
		(0,0, Color.Empty); 
	}
	/// Kkonstruktor gracza.
	///
	/// Funkcja bierze nazwę i kolor dla gracza.
	public this (n: string, clr: Color)
	{
		name = n;
		color = clr;
	}
 }
 /// Abstrakcyjna klasa reprezentująca grę.
 public abstract class Game {
	public black: Player;
 	public white: Player;
	public mutable current: Color;
	public goban: Goban;

//	public abstract Display(array[2, Color]) : void;
	/// Konstruktor abstrakcyjnej gry go ;)
	///
	/// Funkcja bierze goban (plansze) i dwóch graczy.
	public this(g: Goban, b: Player, w: Player)
	{
		black = b;
		white = w;
		goban = g;
		current = Color.Black;
	}
 }

}
