using System;
using System.IO;

class EOF : System.Exception { public this () {} } 

class Lexer {
  f : StreamReader;
  mutable words : array [string];
  mutable pos : int;
  
  public GetWord () : string
  {
    def get_line () {
      def line = f.ReadLine ();
      if (line == null)
        throw EOF ()
      else {
        def ar = line.Split (" \t\n\r".ToCharArray ());
        def loop (pos) {
          if (pos >= ar.Length || (ar[pos] != "" && ar[pos][0] == '#'))
            pos
          else
            loop (pos + 1)
        };
        def end = loop (0);
        if (end > 0) {
          def res = array (end);
          Array.Copy (ar, res, end);
          res
        } else
          get_line ()
      }
    };
    
    try {
      when (words == null || pos >= words.Length) {
        pos = 0;
        words = get_line ();
      };
      ++pos;
      words [pos - 1]
    } catch {
      | _ : EOF => null
    }
  }
  
  public this (name : string)
  {
    f = StreamReader (name);
  }
}

class Parser {
  lex : Lexer;
  
  public this (lex : Lexer)
  {
    this.lex = lex;
  }

  parse_stmt () : Stmt
  {
    
  }

  public Parse () : list [Stmt]
  {
    
  }
}

module M {
  mutable lexer : Lexer;
  
  public Main () : void
  {
    def args = Environment.GetCommandLineArgs ();
    def lex = Lexer (args[1]);
    def parser = Parser (lex);
    def _stmts = parser.Parse ();
    ()
  }
}

