class A[T] {
  public static foo (_ : T) : void
  {
    System.Console.WriteLine (typeof (T));
  }

  public static bar () : void
  {
    System.Console.WriteLine (typeof (T));
  }

  public static mutable field : T;
  public static prop : T
  {
    get { field }
    set { field = value }
  }

  public static @* (a1 : A[T], a2 : A[T]) : A[T]
  {
    System.Console.WriteLine ($ "T=$(typeof(T)) a1:$(a1.GetType()) a2:$(a2.GetType())");
    a1
  }

  public this ()
  {
  }
  
  public this (_ : T)
  {
  }

  public static @: (_ : A2[T]) : A[T]
  {
    A ()
  }
}

class A2[T] {}

class B[T] 
  where T : System.IComparable [T]
{
  public static foo () : void
  {
    System.Console.WriteLine (typeof (T));
  }

  public static bar (_ : T) : void
  {
    foo ();
  }
}

A.foo (3);
A.foo ("kopytko");
A.bar ();
B.foo ();
B.bar (3);

A.field = 12;
A.field += 10;
A.prop += 10;
System.Console.WriteLine (A.prop + 10);
System.Console.WriteLine (A.field + 10);

A.field = "12";
A.field += "10";
A.prop += "10";
System.Console.WriteLine (A.prop + "10");
System.Console.WriteLine (A.field + "10");

_ = A(3) * A(42);
_ = A("foo") * A("bar");

_ = A2() * A(42);


/*
BEGIN-OUTPUT
System.Int32
System.String
System.Object
Nemerle.Hacks.IComparableClass
System.Int32
42
42
12101010
12101010
T=System.Int32 a1:A`1[System.Int32] a2:A`1[System.Int32]
T=System.String a1:A`1[System.String] a2:A`1[System.String]
T=System.Int32 a1:A`1[System.Int32] a2:A`1[System.Int32]
END-OUTPUT
*/
