using Nemerle.Collections;
using Nemerle.IO;
using Ala.Kot;

namespace Ala
{
public module Ptak
{
    public Main () : void
    {
        def l1 = [Pies ()];
        def l2 = [Kura ()];

        ShowIt (1, l1);
        ShowIt (1, l2);

        B("a").bar(B("z")); 
        C("a").bar(C("z"));

        assert (G.foo1 () == 42);
        assert (G.foo2 () == 42);
        assert (G[int].foo1.[string] () == 42);
        assert (G[string].foo2 () == 42);
        assert (G2.foo1 () == 42);
        assert (G2.foo2 () == 42);
        
        assert (G.foo1 (24) == 24);
        assert (G.foo2 (24) == 24);
        assert (G[int].foo1.[string] (24) == 24);
        assert (G[string].foo2 (24) == 24);
        assert (G2.foo1 (24) == 24);
        assert (G2.foo2 (24) == 24);
    }
}
}

public abstract class A['k] {
    public key: 'k;
    public this(k:'k) {key=k;}
    public abstract foo(k:'k) : void;

    public bar(other:A['k]) : void {
        foo(other.key)
    }
}
public class B['k] : A['k] {
    public this(k:'k) {base(k);}
    public override foo(_k:'k) : void {
      System.Console.WriteLine ("executing B.foo");
    }
}
public class C : A[string] {
    public this(k:string) {base(k);}
    public override foo(_k:string) : void {
      System.Console.WriteLine ("executing C.foo");
    }
}


// REFERENCE: gen-overload-lib.dll

/*
BEGIN-OUTPUT
Pies.
Kura.
executing B.foo
executing C.foo
END-OUTPUT
*/
