using System;
using System.Reflection;

//
// Test the setting for the default public constructor
//
abstract class Abstract {
}

//
// Test the setting for the default public consturctor
//
class Plain {
}

class Test {

	static protected internal MyProtectedInternal () :  void { }
	static internal MyInternal() :  void { }
	static public MyPublic () :  void { }
	static MyPrivate () :  void {}
	      
	static Main () :  int
	{
		mutable  myself = typeof (Test);
		mutable  bf = BindingFlags.Static %| BindingFlags.NonPublic %| BindingFlags.Public;
		mutable  mpia = Nemerle.Extensions.DefaultValue (MethodAttributes);
		mutable  mpi = Nemerle.Extensions.DefaultValue (MethodInfo);

		//
		// protected internal
		//
		mpi = myself.GetMethod ("MyProtectedInternal", bf);
		mpia = mpi.Attributes %& MethodAttributes.MemberAccessMask;
		if (mpia != MethodAttributes.FamORAssem)
		{
			 1;
		}
		else
	{

		//
		// internal
		//
		mpi = myself.GetMethod ("MyInternal", bf);
		mpia = mpi.Attributes %& MethodAttributes.MemberAccessMask;
		if (mpia != MethodAttributes.Assembly)
		{
			 2;
		}
		else
	{

		//
		// public
		//
		mpi = myself.GetMethod ("MyPublic", bf);
		mpia = mpi.Attributes %& MethodAttributes.MemberAccessMask;
		if (mpia != MethodAttributes.Public)
		{
			 3;
		}
		else
	{

		//
		// private
		//
		mpi = myself.GetMethod ("MyPrivate", bf);
		mpia = mpi.Attributes %& MethodAttributes.MemberAccessMask;
		if (mpia != MethodAttributes.Private)
		{
			 4;
		}
		else
	{

		//
		// Test 17.10.4 accessibility (default constructor permissions)
		//
		mutable  ci = typeof (Abstract).GetConstructor
			(BindingFlags.Public %| BindingFlags.NonPublic %| BindingFlags.Instance, null,  array(0),  array(0));

		if (!ci.IsFamily)

		{
			 5;

		}

		else
	{

		ci = typeof (Plain).GetConstructor
			(BindingFlags.Public %| BindingFlags.NonPublic %| BindingFlags.Instance, null,  array(0),  array(0));

		if (!ci.IsPublic)

		{
			 6;

		}

		else
	{
		
		Console.WriteLine ("All tests pass");
		 0;
	}
	}
	}
	}
	}
	}
	}
}

/*
BEGIN-OUTPUT
All tests pass
END-OUTPUT
*/
