/*
 * NASPRO - NASPRO Architecture for Sound Processing
 * Core library
 *
 * Copyright (C) 2007-2010 Stefano D'Angelo <zanga.mail@gmail.com>
 *
 * See the COPYING file for license conditions.
 */

#ifndef _NACORE_PATH_H
#define _NACORE_PATH_H

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Scans the entries in each directory of the specified path.
 *
 * path is the path to scan (on Windows it's a semicolon-separated list of
 *   directories, on all other systems it's colon-separated)
 * callback is the function which is called for each (non filtered) entry,
 *   where file is the full filename and basename contains the filename stripped
 *   of its directory path
 * filter, if not NULL, is a function which filters filenames to be passed to
 *   callback, when it returns 0 the file is not passed to callback
 */
void nacore_path_for_each(const char *path,
	void (*callback)(const char *file, const char *basename, void *data),
	char (*filter)(const char *file), void *data);

/*
 * Like nacore_path_for_each(), but here the directories contained in path are
 * intended as relative to the user's home directory.
 */
void nacore_path_home_for_each(const char *dir,
	void (*callback)(const char *file, const char *basename, void *data),
	char (*filter)(const char *file), void *data);

#ifdef __cplusplus
}
#endif

#endif /* !_NACORE_PATH_H */
