/* 
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _WF_WIZARD_H_
#define _WF_WIZARD_H_

using namespace std;

/**
 * Declaration of the wrapper of the mforms wizard form.
 */
namespace MySQL {
  namespace Forms {

    /**
     * Need this separate class to set protected members.
     */
    public ref class BufferedPanel : public FlowLayoutPanel
    {
    public:
      BufferedPanel();
    };

    /**
     * Wrapper for a native .NET wizard skeleton.
     */
    public ref class WizardImpl : public FormImpl
    {
    private:
      FlowLayoutPanel^ _sidebar;
      Label^ _title;
      Button^ _extra_button;
      TableLayoutPanel^ _footer;
      FlowLayoutPanel^ _button_bar;
      Button^ _back_button;
      Button^ _next_button;
      Button^ _cancel_button;
      Panel^ _content; // This is where the actual wizard content is docked to.
      Image^ _sidebar_overlay;
    protected:
      static bool create(::mforms::Wizard *self, ::mforms::Form* parent);
      static void set_title(::mforms::Wizard *self, const std::string &title);
      static void run_modal(::mforms::Wizard *self);
      static void close(::mforms::Wizard *self);
      static void flush_events(::mforms::Wizard *self);
      static void set_content(::mforms::Wizard *self, ::mforms::View *view);
      static void set_heading(::mforms::Wizard *self, const std::string& heading);
      static void set_step_list(::mforms::Wizard *self, const vector<string>& steps);
      static void set_allow_cancel(::mforms::Wizard *self, bool flag);
      static void set_allow_back(::mforms::Wizard *self, bool flag);
      static void set_allow_next(::mforms::Wizard *self, bool flag);
      static void set_show_extra(::mforms::Wizard *self, bool flag);
      static void set_extra_caption(::mforms::Wizard *self, const std::string& caption);
      static void set_next_caption(::mforms::Wizard *self, const std::string& caption);

      void sidebarPaint(Object^ sender, PaintEventArgs^ arguments);
      void setupLayout(mforms::Wizard* wizard);

      static void nextClick(Object^ sender, EventArgs^ arguments);
      static void backClick(Object^ sender, EventArgs^ arguments);
      static void cancelClick(Object^ sender, EventArgs^ arguments);
      static void extraClick(Object^ sender, EventArgs^ arguments);
      static void resize(Object^ sender, EventArgs^ arguments);
    public:
      WizardImpl(mforms::Wizard* self, mforms::Form* owner);

      void set_title(const std::string &title);
      void run_modal();
      void close();
      void flush_events();
      void set_content(::mforms::View *view);
      void set_heading(const std::string & heading);
      void set_step_list(const vector<string>& steps);
      void set_allow_cancel(bool flag);
      void set_allow_back(bool flag);
      void set_allow_next(bool flag);
      void set_show_extra(bool flag);
      void set_extra_caption(const std::string& caption);
      void set_next_caption(const std::string& caption);

      static void init(Manager ^mgr)
      {
        ::mforms::ControlFactory *f= ::mforms::ControlFactory::get_instance();

        DEF_CALLBACK2(bool, ::mforms::Wizard*, ::mforms::Form*, mgr, f->_wizard_impl, WizardImpl, create);
        DEF_CALLBACK2(void, ::mforms::Wizard*, const std::string&, mgr, f->_wizard_impl, WizardImpl, set_title);
        DEF_CALLBACK1(void, ::mforms::Wizard*, mgr, f->_wizard_impl, WizardImpl, run_modal);
        DEF_CALLBACK1(void, ::mforms::Wizard*, mgr, f->_wizard_impl, WizardImpl, close);
        DEF_CALLBACK1(void, ::mforms::Wizard*, mgr, f->_wizard_impl, WizardImpl, flush_events);
        DEF_CALLBACK2(void, ::mforms::Wizard*, ::mforms::View*, mgr, f->_wizard_impl, WizardImpl, set_content);
        DEF_CALLBACK2(void, ::mforms::Wizard*, const std::string&, mgr, f->_wizard_impl, WizardImpl, set_heading);
        DEF_CALLBACK2(void, ::mforms::Wizard*, const vector<string>&, mgr, f->_wizard_impl, WizardImpl, set_step_list);
        DEF_CALLBACK2(void, ::mforms::Wizard*, bool, mgr, f->_wizard_impl, WizardImpl, set_allow_cancel);
        DEF_CALLBACK2(void, ::mforms::Wizard*, bool, mgr, f->_wizard_impl, WizardImpl, set_allow_back);
        DEF_CALLBACK2(void, ::mforms::Wizard*, bool, mgr, f->_wizard_impl, WizardImpl, set_allow_next);
        DEF_CALLBACK2(void, ::mforms::Wizard*, bool, mgr, f->_wizard_impl, WizardImpl, set_show_extra);
        DEF_CALLBACK2(void, ::mforms::Wizard*, const std::string&, mgr, f->_wizard_impl, WizardImpl, set_extra_caption);
        DEF_CALLBACK2(void, ::mforms::Wizard*, const std::string&, mgr, f->_wizard_impl, WizardImpl, set_next_caption);
      }
    };
  }
}

#endif // _WF_WIZARD_H_