#ifndef _WB_CATALOG_TREE_H_
#define _WB_CATALOG_TREE_H_

#include "grt/grt_value_tree.h"
#include "grts/structs.workbench.physical.h"
#ifdef _WIN32
#include <hash_set>
#else
#include <set>
//#include <ext/hash_set>
#endif

namespace wb 
{
  class WBComponentPhysical;

  class CatalogTreeBE : public bec::ValueTreeBE
  {
    typedef bec::ValueTreeBE super;
    #ifdef _WIN32
    typedef stdext::hash_set<grt::internal::Value*> HashSet;
    #else
    typedef std::set<grt::internal::Value*> HashSet;
    #endif

    struct sortnode 
    {
      bool operator ()(Node *a, Node *b) const
      {
        return a->name < b->name;
      }
    };

    HashSet _current_diagram_objects;
    WBComponentPhysical *_owner;

    virtual void rescan_node(const bec::NodeId &node_id, bec::ValueTreeBE::Node *node, const std::string &path, const grt::ObjectRef &value);
    virtual void rescan_node(const bec::NodeId &node_id, bec::ValueTreeBE::Node *node, const std::string &path, const grt::BaseListRef &value);

    virtual bool get_field(const bec::NodeId &node_id, int column, std::string &value);

    virtual bool set_field(const bec::NodeId &node_id, int column, const std::string &value);

    virtual bec::MenuItemList get_popup_items_for_nodes(const std::vector<bec::NodeId> &nodes);
    virtual bool activate_popup_item_for_nodes(const std::string &name, const std::vector<bec::NodeId> &nodes);

  public:
    CatalogTreeBE(grt::GRT *grt, WBComponentPhysical *owner);

    void refresh_for_diagram(const workbench_physical_DiagramRef &view);
  };
};

#endif
