#ifndef _SCHEMA_SELECTION_PAGE_H_
#define _SCHEMA_SELECTION_PAGE_H_

#include "grtui/wizard_schema_filter_page.h"

class SchemaSelectionPage : public WizardSchemaFilterPage
{
public:
  SchemaSelectionPage(WizardForm *form, const char *name= "pickSchemata",const bool selected_only = false)
    : WizardSchemaFilterPage(form, name), _dbplugin(0), _selected_only(selected_only)
  {
    set_short_title(_("Select Schemata"));
    set_title(_("Select Schemata to Reverse Engineer"));
    
    add(&_missing_label, false, true);
    _missing_label.show(false);
  }

  virtual void leave(bool advancing)
  {
    if (advancing)
    {
      grt::StringListRef list(_form->grtm()->get_grt());
      std::vector<std::string> selection= _check_list.get_selection();

      for (std::vector<std::string>::const_iterator iter= _schemas.begin();
           iter != _schemas.end(); ++iter)
        if (std::find(selection.begin(),selection.end(),*iter) == selection.end())
          list.insert(*iter);
      values().set("unSelectedSchemata", list);
    }
    WizardSchemaFilterPage::leave(advancing);
  }

  virtual void enter(bool advancing)
  {
    if (advancing)
    {
      _schemas.clear();
      _dbplugin->default_schemata_selection(_schemas);

      if (_selected_only)
        _check_list.set_strings(_schemas);
      else
        WizardSchemaFilterPage::enter(advancing);
      
      if (_selected_only)
      {
        std::string missing_names;
        int missing_count= 0;
        grt::StringListRef db_list(grt::StringListRef::cast_from(values().get("schemata")));

        // check for schemas that exist only in the model and not in DB
        for (std::vector<std::string>::const_iterator iter= _schemas.begin();
             iter != _schemas.end(); ++iter)
        {
          bool found= false;
          for (grt::StringListRef::const_iterator j= db_list.begin(); j != db_list.end(); ++j)
          {
            if (g_strcasecmp(iter->c_str(), (*j).c_str()) == 0)
              found= true;
          }

          if (!found)
          {
            if (missing_count > 0)
              missing_names.append(", ");
            missing_names.append(*iter);
            missing_count++;
          }
          else
            _check_list.set_selected(*iter, true);      
        }

        if (missing_count == 1)  
        {
          if (_schemas.size() > 1)
            _missing_label.set_text(base::strfmt(_("The schema '%s' from your model is missing from the RDBMS server."),
                                    missing_names.c_str()));
          else
            _missing_label.set_text(base::strfmt(_("The schema '%s' from your model is missing from the RDBMS server.\nIf your model has never been created in the target server, please use Forward Engineer to create it."),
                                    missing_names.c_str()));
          _missing_label.show(true);
        }
        else if (missing_count > 1)
        {
          _missing_label.set_text(base::strfmt(_("Note: The following schemata from your model are missing from the target RDBMS server:\n%s\nIf you want to synchronize them, it is advisable to create them first\nusing the Forward Engineer function."),
                                  missing_names.c_str()));
          _missing_label.show(true);
        }
      }
      else
      {
        for (std::vector<std::string>::const_iterator iter= _schemas.begin();
             iter != _schemas.end(); ++iter)
          _check_list.set_selected(*iter, true);
      }   
    }
  }
  
  void set_db_plugin(Db_plugin *pl)
  {
    _dbplugin= pl;
  }

private:
  std::vector<std::string> _schemas;
  Db_plugin *_dbplugin;
  mforms::Label _missing_label;
  bool _selected_only;
};


#endif /* _SCHEMA_SELECTION_PAGE_H_ */
