#include "tut_stdafx.h"

#include "grt_test_utility.h"
#include "testgrt.h"
#include "grtdiff.h"
#include "grtpp.h"
#include "diffchange.h"
#include "changeobjects.h"
#include "changelistobjects.h"
#include "grtdb/diff_dbobjectmatch.h"
#include "wb_helpers.h"
#include "syntetic_mysql_model.h"

using namespace grt;

BEGIN_TEST_DATA_CLASS(comparer_test)
public:
  WBTester tester;
END_TEST_DATA_CLASS

TEST_MODULE(comparer_test, "comparer test");

TEST_FUNCTION(1)
{
    grt::DbObjectMatchAlterOmf omf;
    db_TableRef table1 = db_mysql_TableRef(tester.grt);
    table1->name("Table");
    db_TableRef table2 = db_mysql_TableRef(tester.grt);
    table2->name("TABLE");
    grt::NormalizedComparer normalizer(tester.grt);
    normalizer.init_omf(&omf);
    boost::shared_ptr<DiffChange> change = diff_make(table1,table2,&omf);
    ensure("Case table name comparison:", change.get() == NULL);
}

TEST_FUNCTION(2)
{
    grt::DbObjectMatchAlterOmf omf;
    db_TableRef table1 = db_mysql_TableRef(tester.grt);
    table1->name("Table");
    db_TableRef table2 = db_mysql_TableRef(tester.grt);
    table2->name("TABLE");
    grt::NormalizedComparer normalizer(tester.grt, true);
    normalizer.init_omf(&omf);
    boost::shared_ptr<DiffChange> change = diff_make(table1,table2,&omf);
    ensure("Caseless table name comparison:", change.get() != NULL);
}

struct test_params
{
    test_params(const bool cr, const bool clr, const boost::function<void (SynteticMySQLModel&, SynteticMySQLModel&)>& f, const std::string &c):
        case_result(cr), caseless_result(clr), model_init(f), comment(c) {};
    bool case_result;
    bool caseless_result;
    boost::function<void (SynteticMySQLModel&, SynteticMySQLModel&)> model_init;
    std::string comment;
};

void table_name_case(SynteticMySQLModel& model1, SynteticMySQLModel& model2)
{
    model1.table->name("table1");
    model2.table->name("TABLE1");
}

void cloumn_name_case(SynteticMySQLModel& model1, SynteticMySQLModel& model2)
{
    model1.column->name("col");
    model2.column->name("COL");
}

void index_cloumn_name(SynteticMySQLModel& model1, SynteticMySQLModel& model2)
{
    model1.primaryKey->columns().get(0)->name("Iname1");
    model2.primaryKey->columns().get(0)->name("Iname2");
}

void pack_keys_case(SynteticMySQLModel& model1, SynteticMySQLModel& model2)
{
    model1.table->packKeys("Test keys");
    model2.table->packKeys("Test Keys");
}

void pack_keys_defaults(SynteticMySQLModel& model1, SynteticMySQLModel& model2)
{
    model1.table->packKeys("");
    model2.table->packKeys("DEFAULT");
}

//Bug #11889204 60478: CASE CHANGES IN ENUM VALUES ARE NOT RECOGNIZED
void enum_case(SynteticMySQLModel& model1, SynteticMySQLModel& model2)
{
    model1.columnEnum->datatypeExplicitParams("(E1,e2)");
    model2.columnEnum->datatypeExplicitParams("(e1,E2)");
}

TEST_FUNCTION(3)
{
    SynteticMySQLModel model1(tester.grt);
    SynteticMySQLModel model2(tester.grt);
    grt::DbObjectMatchAlterOmf omf;
    grt::NormalizedComparer case_normalizer(tester.grt, true);
    case_normalizer.init_omf(&omf);
    boost::shared_ptr<DiffChange> change = diff_make(model1.catalog,model2.catalog,&omf);
    ensure("Syntetic model comparison:", change.get() == NULL);
    grt::DbObjectMatchAlterOmf caselsess_omf;
    grt::NormalizedComparer caseless_normalizer(tester.grt, false);
    caseless_normalizer.init_omf(&caselsess_omf);
    change = diff_make(model1.catalog,model2.catalog,&caselsess_omf);
    ensure("Syntetic model caseless comparison:", change.get() == NULL);
}

TEST_FUNCTION(4)
{
    std::vector<test_params> test_cases;
    test_cases.push_back(test_params(true,false,table_name_case,"Table Name Case"));
    test_cases.push_back(test_params(true,true,cloumn_name_case,"Column Name Case"));//columns are always case sesitive
    test_cases.push_back(test_params(false,false,index_cloumn_name,"Index Column"));//index columns doesn't get compared and thus always equal
    test_cases.push_back(test_params(false,false,pack_keys_case,"Pack keys Case"));
    test_cases.push_back(test_params(false,false,pack_keys_defaults,"Pack keys Defauls"));
    test_cases.push_back(test_params(true,true,enum_case,"ENUM case compare"));
    for (std::vector<test_params>::const_iterator It = test_cases.begin(); It != test_cases.end(); ++It)
    {
        boost::shared_ptr<DiffChange> change;
        SynteticMySQLModel model1(tester.grt);
        SynteticMySQLModel model2(tester.grt);
        It->model_init(model1, model2);

        grt::DbObjectMatchAlterOmf omf;
        grt::NormalizedComparer case_normalizer(tester.grt, true);
        case_normalizer.init_omf(&omf);

        change = diff_make(model1.catalog,model2.catalog,&omf);
        ensure(std::string("Case sensitive comparison: ") + It->comment, (change.get() != NULL) == It->case_result);

        grt::DbObjectMatchAlterOmf caselsess_omf;
        grt::NormalizedComparer caseless_normalizer(tester.grt, false);
        caseless_normalizer.init_omf(&caselsess_omf);

        change = diff_make(model1.catalog,model2.catalog,&caselsess_omf);
        ensure(std::string("Case insensitive comparison: ") + It->comment, (change.get() != NULL) == It->caseless_result);
    }

}

END_TESTS
