/* 
 * Copyright (c) 2008, 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _WF_TEXTBOX_H_
#define _WF_TEXTBOX_H_

#include "wf_view.h"

using namespace System::Windows;

namespace MySQL {
  namespace Forms {

    // Small helper class to implement certain key press processing.
    private ref class TextBoxEx : public Windows::Forms::TextBox
    {
    protected:
      virtual bool ProcessCmdKey(Message% msg, Keys keyData) override;
    public:
      mforms::ModifierKey getModifiers(Keys keyData);
    };

    public ref class TextBoxImpl : public ViewImpl
    {
    private:
      mforms::ModifierKey modifiers; // Converted modifier keys for key down and key press events.
    protected:
      static bool create(::mforms::TextBox *self, ::mforms::ScrollBars scroll_bars);
      static void set_text(::mforms::TextBox *self, const std::string &text);
      static void append_text(::mforms::TextBox *self, const std::string &text, bool scroll_to_end);
      static std::string get_text(::mforms::TextBox *self);
      static void set_read_only(::mforms::TextBox *self, bool flag);
      static void set_padding(::mforms::TextBox *self, int pad);
      static void set_bordered(::mforms::TextBox *self, bool flag);
      static void set_monospaced(::mforms::TextBox *self, bool flag);
      static void get_selected_range(::mforms::TextBox *self, int &start, int &end);
      static void clear(::mforms::TextBox *self);

      void OnChange(Object^ sender, EventArgs^ args);
      void OnKeyDown(Object^ sender, KeyEventArgs^ args);
      void OnKeyPress(Object^ sender, KeyPressEventArgs^ args);
    public:
      TextBoxImpl(::mforms::TextBox *text);

      static void init(Manager ^mgr)
      {
        ::mforms::ControlFactory *f= ::mforms::ControlFactory::get_instance();

        DEF_CALLBACK2(bool, ::mforms::TextBox*, ::mforms::ScrollBars, mgr, f->_textbox_impl, TextBoxImpl, create);
        DEF_CALLBACK2(void, ::mforms::TextBox*, bool, mgr, f->_textbox_impl, TextBoxImpl, set_bordered);
        DEF_CALLBACK2(void, ::mforms::TextBox*, const std::string&, mgr, f->_textbox_impl, TextBoxImpl, set_text);
        DEF_CALLBACK3(void, ::mforms::TextBox*, const std::string&, bool, mgr, f->_textbox_impl, TextBoxImpl, append_text);
        DEF_CALLBACK2(void, ::mforms::TextBox*, bool, mgr, f->_textbox_impl, TextBoxImpl, set_read_only);
        DEF_CALLBACK2(void, ::mforms::TextBox*, int, mgr, f->_textbox_impl, TextBoxImpl, set_padding);
        DEF_CALLBACK1(std::string, ::mforms::TextBox*, mgr, f->_textbox_impl, TextBoxImpl, get_text);
        DEF_CALLBACK3(void, ::mforms::TextBox*, int&, int&, mgr, f->_textbox_impl, TextBoxImpl, get_selected_range);
        DEF_CALLBACK2(void, ::mforms::TextBox*, bool, mgr, f->_textbox_impl, TextBoxImpl, set_monospaced);
        DEF_CALLBACK1(void, ::mforms::TextBox*, mgr, f->_textbox_impl, TextBoxImpl, clear);
      }
    };

  };
};

#endif
