/* 
 * Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _WF_MENUBAR_H_
#define _WF_MENUBAR_H_

#include "mforms/menubar.h"
#include "wf_mforms.h"

using namespace System;
using namespace Windows::Forms;

namespace MySQL {
  namespace Forms {

    /**
     * Managed implementation of a menu item.
     */
    public ref class MenuItemImpl : public ObjectImpl
    {
    public:
      MenuItemImpl(mforms::MenuItem* item);

      void menuItemClick(Object^ sender, System::EventArgs^ e);
    };

    /**
     * Managed implementation of a menu strip.
     */
    public ref class MenuBarImpl : public ObjectImpl
    {
    protected:
      MenuBarImpl(mforms::MenuBar *self);
      ~MenuBarImpl();

      static bool create_menu_bar(mforms::MenuBar* item);
      static bool create_menu_item(mforms::MenuItem* item, const std::string& title,
        const mforms::MenuItemType type);
      static void set_title(mforms::MenuItem* item, const std::string& title);
      static std::string get_title(mforms::MenuItem* item);
      static void set_shortcut(mforms::MenuItem* item, const std::string& value);
      static void set_enabled(mforms::MenuBase* item, bool state);
      static bool get_enabled(mforms::MenuBase* item);
      static void set_checked(mforms::MenuItem* item, bool state);
      static bool get_checked(mforms::MenuItem* item);

      static void insert_item(mforms::MenuBase* menu, int index, mforms::MenuItem* item);
      static void remove_item(mforms::MenuBase* menu, mforms::MenuItem* item); // NULL item to remove all

      static void DropDownOpened(Object^ sender, System::EventArgs^ e);
    public:
      static void init(Manager^ mgr)
      {
        mforms::ControlFactory* f= mforms::ControlFactory::get_instance();

        DEF_CALLBACK1(bool, mforms::MenuBar*, mgr, f->_menu_item_impl, MenuBarImpl, create_menu_bar);
        DEF_CALLBACK3(bool, mforms::MenuItem*, const std::string&, const mforms::MenuItemType, mgr, f->_menu_item_impl, MenuBarImpl, create_menu_item);
        DEF_CALLBACK2(void, mforms::MenuItem*, const std::string&, mgr, f->_menu_item_impl, MenuBarImpl, set_title);
        DEF_CALLBACK1(std::string, mforms::MenuItem*, mgr, f->_menu_item_impl, MenuBarImpl, get_title);
        DEF_CALLBACK2(void, mforms::MenuItem*, const std::string&, mgr, f->_menu_item_impl, MenuBarImpl, set_shortcut);
        DEF_CALLBACK2(void, mforms::MenuBase*, bool, mgr, f->_menu_item_impl, MenuBarImpl, set_enabled);
        DEF_CALLBACK1(bool, mforms::MenuBase*, mgr, f->_menu_item_impl, MenuBarImpl, get_enabled);
        DEF_CALLBACK2(void, mforms::MenuItem*, bool, mgr, f->_menu_item_impl, MenuBarImpl, set_checked);
        DEF_CALLBACK1(bool, mforms::MenuItem*, mgr, f->_menu_item_impl, MenuBarImpl, get_checked);
        DEF_CALLBACK3(void, mforms::MenuBase*, int, mforms::MenuItem*, mgr, f->_menu_item_impl, MenuBarImpl, insert_item);
        DEF_CALLBACK2(void, mforms::MenuBase*, mforms::MenuItem*, mgr, f->_menu_item_impl, MenuBarImpl, remove_item);
      }
    };

  };
};

#endif // _WF_MENUBAR_H_
