//
//  MWorkerManager.h
//  MySQLGUICommon
//
//  Created by Alfredo Kojima on Tue Jun 22 2004.
//  Copyright (c) 2004 MySQL AB. All rights reserved.
//

#import <Foundation/Foundation.h>

#include <myx_public_interface.h>

extern NSString *MConnectionDidFinishNotification;
extern NSString *MWorkerDidFinishNotification;
extern NSString *MQueryDidFinishNotification;

@class MMySQLWorker;

typedef int MDataToken;
typedef void*(*MCallback1)(MYSQL*,void*);
typedef void*(*MCallback2)(MYSQL*,void*,void*);

@interface MWorkerManager : NSObject {
  NSMutableArray *_freeWorkers;
  NSMutableDictionary *_workerConnections;
  
  // This is a hack to transfer data from the worker threads to the main
  // thread. Usually we can't just pass data between threads through 
  // DO/NSConnection because it will magically swap the contents with 
  // proxies or copies (in case of pointers, like MYSQL*)
  // So threads can put data into this dictionary and notify the parent
  // that there's something in there through a token.
  NSLock *_transferAreaLock;
  MDataToken _token;
  NSMutableDictionary *_transferArea;
}

+ (MWorkerManager*)manager;
- (id)init;
- (MMySQLWorker*)createWorker;
- (MMySQLWorker*)worker;
- (void)workerFinished: (MMySQLWorker*)aWorker;

- (MDataToken)putData: (id)data;
- (NSNumber*)putDataNumber: (id)data;
- (id)getData: (MDataToken)token;
- (id)getDataWithNumber: (NSNumber*)token;

- (void)notifyConnection: (MDataToken)token;
- (void)notifyFinished: (NSString*)identifier
                result: (MDataToken)result;

- (oneway void)connectToInstance: (MYX_USER_CONNECTION*)connInfo;

- (void)performSelector: (SEL)sel
                        target: (id)anObject
                      argument: (id)argument
                    identifier: (NSString*)identifier;

- (void*)performCallbackAndWait: (MCallback1)cback
                       argument: (void*)arg1
                          mysql: (MYSQL*)mysql;

@end
