//
//  MSchemaDataSource.m
//  MySQLGUICommon
//
//  Created by Alfredo Kojima on Sun Jun 27 2004.
//  Copyright (c) 2004 MySQL AB. All rights reserved.
//

#import "MSchemaDataSource.h"


@implementation MSchemaItem

- (id)initWithCatalog: (MYX_CATALOG*)catalog
                 icon: (NSImage*)aicon
{
  if (!(self= [super init]))
    return nil;
  
  type= MCatalogItemType;
  _object.catalog= catalog;
  _repr= nil;
  icon= [aicon retain];
  _children= nil;
  return self;
}

- (id)initWithSchema: (MYX_SCHEMA*)schema
                icon: (NSImage*)aicon
{
  if (!(self= [super init]))
    return nil;
  
  type= MSchemaItemType;
  _object.schema= schema;
  _repr= nil;
  icon= [aicon retain];
  _children= nil;
  return self;
}

- (id)initWithTable: (MYX_SCHEMA_TABLE*)table
               icon: (NSImage*)aicon
{
  if (!(self= [super init]))
    return nil;
  
  type= MTableItemType;
  _object.table= table;
  _repr= nil;
  icon= [aicon retain];
  _children= nil;
  return self;
}

- (id)initWithColumn: (MYX_SCHEMA_TABLE_COLUMN*)column
                icon: (NSImage*)aicon
{
  if (!(self= [super init]))
    return nil;
  
  type= MColumnItemType;
  _object.column= column;
  _repr= nil;
  icon= [aicon retain];
  _children= nil;
  return self;
}

- (void)dealloc
{
  [_repr release];
  [icon release];
  [_children release];
}

- (NSMutableArray*)children
{
  return _children;
}

- (void)setChildren: (NSMutableArray*)children
{
  int i, c= [children count];
  _children= [children retain];
  for (i= 0; i < c; i++)
  {
    MSchemaItem *item= (MSchemaItem*)[_children objectAtIndex: i];
    item->parent= self;
  }
}

- (NSImage*)icon
{
  return icon;
}

- (NSString*)repr
{
  if (!_repr)
  {
    switch (type)
    {
      case MCatalogItemType:
        _repr= [NSString stringWithUTF8String: _object.catalog->catalog_name?:"?"];
        break;
      case MSchemaItemType:
        _repr= [NSString stringWithUTF8String: _object.schema->schema_name?:""];
        break;
      case MTableItemType:
        _repr= [NSString stringWithUTF8String: _object.table->table_name?:""];
        break;
      case MColumnItemType:
        _repr= [NSString stringWithUTF8String: _object.column->column_name?:""];
        break;
    }
    [_repr retain];
  }
  return _repr;
}

- (MYX_CATALOG*)catalog
{
  MSchemaItem *item= nil;
  switch (type)
  {
    case MCatalogItemType:
      item= self;
      break;
    case MSchemaItemType:
      item= self->parent;
      break;
    case MTableItemType:
      item= self->parent->parent;
      break;
    case MColumnItemType:
      item= self->parent->parent->parent;
      break;
  }
  return item ? item->_object.catalog : NULL;
}

- (MYX_SCHEMA*)schema
{
  MSchemaItem *item= nil;
  switch (type)
  {
    case MSchemaItemType:
      item= self;
      break;
    case MTableItemType:
      item= self->parent;
      break;
    case MColumnItemType:
      item= self->parent->parent;
      break;
    default:
      NSAssert(0,@"invalid type (table)");
      break;      
  }
  return item ? item->_object.schema : NULL;
}

- (MYX_SCHEMA_TABLE*)table
{
  MSchemaItem *item= nil;
  switch (type)
  {
    case MTableItemType:
      item= self;
      break;
    case MColumnItemType:
      item= self->parent;
      break;
    default:
      NSAssert(0,@"invalid type (table)");
      break;
  }
  return item ? item->_object.table : NULL;  
}

- (MYX_SCHEMA_TABLE_COLUMN*)column
{
  MSchemaItem *item= nil;
  switch (type)
  {
    case MColumnItemType:
      item= self;
      break;
    default:
      NSAssert(0,@"invalid type (table)");
      break;
  }
  return item ? item->_object.column : NULL;  
}

- (MSchemaItem*)findChild: (NSString*)name
{
  int i, c= [_children count];
  for (i= 0; i < c; i++)
  {
    if ([[[_children objectAtIndex:i] repr] isEqualToString:name])
      return [_children objectAtIndex:i];
  }
  return nil;
}

@end




@implementation MSchemaDataSource

- (MSchemaItem*)findItem: (NSString*)name
{
  int i, c= [_rows count];
  for (i= 0; i < c; i++)
  {
    if ([[[_rows objectAtIndex:i] repr] isEqualToString:name])
      return [_rows objectAtIndex:i];
  }
  return nil;
}

- (id)initWithRoot: (MSchemaDSItemType)root
              leaf: (MSchemaDSItemType)leaf
{
  self= [super init];
  if (self)
  {
    _rootType= root;
    _leafType= leaf;
    _rows= nil;
  }
  return self;
}

- (void)dealloc
{
  if (_rows)
    [_rows release];
  if (_tableFetcher)
    [_tableFetcher release];
}

- (void)setTableFetcher: (id)target selector:(SEL)sel
{
  if (_tableFetcher)
    [_tableFetcher release];
  _tableFetcher= [target retain];
  _tableFetcherAction= sel;  
}

- (void)setRootList: (NSMutableArray*)array
{
  if (_rows)
    [_rows release];
  _rows= [array retain];
}

- (NSMutableArray*)rootList
{
  return _rows;
}

- (id)outlineView:(NSOutlineView *)outlineView 
            child:(int)index 
           ofItem:(id)item
{
  if (item == nil)
    return [_rows objectAtIndex: index];
  else
  {
    id tmp= [item children];
    if (!tmp)
    {
      [_tableFetcher performSelector:_tableFetcherAction withObject:self withObject:item];
      return @"Loading...";
    }
    else
    {
      return [tmp objectAtIndex: index];
    }
  }
}

- (BOOL)outlineView:(NSOutlineView *)outlineView 
   isItemExpandable:(id)item
{
  if ([item isMemberOfClass:[MSchemaItem class]] && ((MSchemaItem*)item)->type < _leafType)
    return YES;
  else
    return NO;
}

- (int)outlineView:(NSOutlineView *)outlineView 
numberOfChildrenOfItem:(id)item
{
  MSchemaItem *sitem= (MSchemaItem*)item;
  
  if (item == nil)
    return [_rows count];
  else if ([item isKindOfClass: [NSString class]])
    return 0;
  else if (sitem->type == MSchemaItemType)
  {
    id ch= [item children];
    if (ch)
      return [ch count];
    else
      return 1; // for Loading...
  }
  else
  {
    return [[item children] count];
  }
}

- (id)outlineView:(NSOutlineView *)outlineView 
objectValueForTableColumn:(NSTableColumn *)tableColumn 
           byItem:(id)item
{
  if ([item isMemberOfClass: [MSchemaItem class]])
    return [item repr];
  else
    return item; // NSString for Loading...
}

@end
