#import "MConnectionPanel.h"
#import "MWorkerManager.h"
#import "MDialogs.h"
#import "MPreferences.h"
#include "myxutil.h"

// TODO
// - autocompletion for history items

@interface MConnectionPanel(Private)
- (void)setEnabled: (BOOL)flag;
- (void)controlTextDidChange:(NSNotification *)aNotification;

- (void)showConnectionError: (MYSQL*)mysql
                       info: (MYX_USER_CONNECTION*)info;


- (void)connectionFinished:(NSNotification*)aNotification;

- (void)checkConnectOK;
- (MYX_USER_CONNECTION*)getDisplayedConnection;
- (void)displayConnection:(MYX_USER_CONNECTION*)info;
- (void)fillConnectionPopUp;
- (void)startConnection: (MYX_USER_CONNECTION*)connectionInfo;

- (void)showConnectionEditor:(id)sender;
- (void)saveConnection:(id)sender;

- (void)finish;
@end


@implementation MConnectionPanel(Private)

- (void)finish
{
  int rc;
  MYX_USER_CONNECTION *info= NULL;
  
  if (_mysql && myx_mysql_errno(_mysql)==0)
  {
    MYX_USER_CONNECTION *conn= [self getDisplayedConnection];
    
    info= myx_copy_user_connection(conn);
    rc= 1;
    
    // save
    if (conn && conn->connection_name)
    {
      int i;
      for (i= 0; i < _connections->user_connections_num; i++)
      {
        if (strcmp(conn->connection_name,
                   _connections->user_connections[i].connection_name)==0)
        {
          _connections->last_connection= i;
          break;
        }
      }
    }
    else
    {
      int r= myx_add_user_connection(&_connections, conn);
      _connections->last_connection= r;
    }
    //XXX check return value
    myx_store_user_connections(_connections,[MPreferences preferences]->passwordStorageType,
                               [_connectionsFile UTF8String]);
  }
  else if (_mysql)
  {
    NSLog(@"connected with errno %i", myx_mysql_errno(_mysql));
    myx_mysql_close(_mysql);
    _mysql= NULL;
    rc= -1;
  }
  else
    rc= 0;
  [[self window] close];
  
  if (rc > 0)
    [_delegate connectionPanel:self finished:_mysql info:info];
  else
    [_delegate connectionPanel:self aborted:(rc<0?YES:NO)];
}


- (void)setEnabled: (BOOL)flag
{
  [connectButton setEnabled: flag];
  [detailsButton setEnabled: flag];
  
  [hostname setEnabled: flag];
  [password setEnabled: flag];
  [username setEnabled: flag];
  [port setEnabled: flag];
  [portSpin setEnabled: flag];
}


- (void)connectionFinished: (NSNotification*)aNotification
{
  NSDictionary *info= [aNotification userInfo];
  NSAssert(info != nil, @"Notification info cant be nil");
  
  _connecting= NO;
  
  [progressIndicator stopAnimation: self];
  [self setEnabled: YES];
  
  if (_mysql)
    myx_mysql_close(_mysql);
  _mysql= [[info objectForKey: @"mysql"] pointerValue];
  
  if (!_mysql)
  {
    NSRunAlertPanelRelativeToWindow(@"Error",
                                    @"Could not initialize MySQL connection.",
                                    @"OK", nil, nil, [self window]);
  }
  else if (myx_mysql_errno(_mysql)!=0)
  {
    NSLog(@"connection failed");
    [self showConnectionError: _mysql
                         info: [[info valueForKey: @"info"] pointerValue]];
    if (_mysql)
      myx_mysql_close(_mysql);
    _mysql= NULL;
  }
  else
  {
    NSLog(@"connection succeeded! (%p)", _mysql);
    [self finish];
  }
}


- (void)startConnection: (MYX_USER_CONNECTION*)connectionInfo
{
  if (!_connecting)
  {
    [[MWorkerManager manager] connectToInstance: connectionInfo];
  }
}


- (MYX_USER_CONNECTION*)getDisplayedConnection
{
  id item= [connectionPopUp selectedItem];
  if (item && [item representedObject])
  {
    return [[item representedObject] pointerValue];
  }
  else
  {    
    g_free(_new_connection.username);
    _new_connection.username= g_strdup([[username stringValue] UTF8String]);
    g_free(_new_connection.password);
    _new_connection.password= g_strdup([[password stringValue] UTF8String]);
    g_free(_new_connection.hostname);
    _new_connection.hostname= g_strdup([[hostname stringValue] UTF8String]);
    _new_connection.port= [port intValue];
    _new_connection.storage_type= MYX_HISTORY_USER_CONNECTION;
    return &_new_connection;
  }
}

- (void)displayConnection:(MYX_USER_CONNECTION*)info
{
  if (info)
  {
    [username setStringValue: [NSString stringWithUTF8String: info->username?:""]];
    [password setStringValue: [NSString stringWithUTF8String: info->password?:""]];
    [hostname setStringValue: [NSString stringWithUTF8String: info->hostname?:""]];
    [port setIntValue: info->port];
  }
}

- (void)fillConnectionPopUp
{
  unsigned int i;
  id selectItem= nil;
  id item;
  
  [connectionPopUp removeAllItems];
  [connectionPopUp addItemWithTitle:@""];
  
  for (i= 0; i < _connections->user_connections_num; i++)
  {
    MYX_USER_CONNECTION *conn= _connections->user_connections+i;
    if (conn->connection_name && conn->storage_type == MYX_FAVORITE_USER_CONNECTION)
    {
      NSString *name= [NSString stringWithUTF8String: conn->connection_name];
      
      // dont add duplicated items
      if ([connectionPopUp itemWithTitle:name])
      {
        if (i== _connections->last_connection)
          selectItem= [connectionPopUp itemWithTitle:name];
        continue;
      }
      
      [connectionPopUp addItemWithTitle: name];
      
      [[connectionPopUp lastItem] setRepresentedObject: [NSValue valueWithPointer: conn]];
      if (i == _connections->last_connection)
      {
        selectItem= [connectionPopUp lastItem];
      }
    } 
    else if (conn->storage_type == MYX_HISTORY_USER_CONNECTION)
    {
      if (i == _connections->last_connection)
      {
        [connectionPopUp insertItemWithTitle:@"(last connection)"
                                     atIndex:1];
        [(selectItem= [connectionPopUp itemAtIndex: 1]) setRepresentedObject:
          [NSValue valueWithPointer: conn]];
      }
    }
  }
  
  [[connectionPopUp menu] addItem: [NSMenuItem separatorItem]];

  [connectionPopUp addItemWithTitle: @"Save Connection..."];
  item= [connectionPopUp lastItem];
  [item setTarget: self];
  [item setAction: @selector(saveConnection:)];
  
  [connectionPopUp addItemWithTitle: @"Open Connection Editor"];
  item = [connectionPopUp lastItem];
  [item setAction: @selector(showConnectionEditor:)];
  [item setTarget: self];
  
  if (selectItem)
  {
    [connectionPopUp selectItem:selectItem];
    [self connectionChanged:self];
  }
}


- (void)controlTextDidChange:(NSNotification *)aNotification
{
  [self checkConnectOK];
  [connectionPopUp selectItemAtIndex:0];
}

- (void)checkConnectOK
{
  if ([[username stringValue] length] > 0
      && [[hostname stringValue] length] > 0)
    [connectButton setEnabled: YES];
  else
    [connectButton setEnabled: NO];
}

- (void)showConnectionError: (MYSQL*)mysql
                       info: (MYX_USER_CONNECTION*)info
{
  NSRect f= [errorPanel frame];
  f.size= [errorPanel minSize];
  
  [errorText setStringValue: 
    [NSString stringWithFormat: @"Could not connect to MySQL instance at %s.\nError: %s (code %i)",
      info->hostname, myx_mysql_error(mysql), myx_mysql_errno(mysql)]];
  
  //  [[[self window] viewWithTag: 10] setVisible: NO];
  
  [pingText setHidden: YES];
  
  [errorPanel setFrame: f
               display: YES];
  
  [NSApp runModalForWindow: errorPanel];
}

- (void)showConnectionEditor:(id)sender
{
}

- (void)saveConnection:(id)sender
{
  MStringRequestSheet *sheet= [MStringRequestSheet sheetWithMessage:@"Name for connection."];
  
  [sheet runModal:[self window]];
  
  [sheet release];
}

@end

//==========================================================================

@implementation MConnectionPanel

- (id)initWithConnectionsFile:(NSString*)file
{
  MYX_LIB_ERROR error;

  self= [super initWithWindowNibName: @"ConnectPanel"];
  
  _connectionsFile= [file retain];
  _connections= myx_load_user_connections([file cString], &error);
  if (!_connections)
  {
    if (error != MYX_ERROR_CANT_OPEN_FILE)
      NSLog(@"Could not load user connections file");
    _connections= g_malloc0(sizeof(MYX_USER_CONNECTIONS));
  }
  
  _connecting= NO;
  _mysql= NULL;
  memset(&_new_connection, 0, sizeof(MYX_USER_CONNECTION));
  
  [[NSNotificationCenter defaultCenter] 
          addObserver: self
             selector: @selector(connectionFinished:)
                 name: MConnectionDidFinishNotification
               object: nil];
  
  return self;
}

- (void)dealloc
{
  [_connectionsFile release];
  if (_connections)
    myx_free_user_connections(_connections);
  myx_free_user_connection_content(&_new_connection);
  [[NSNotificationCenter defaultCenter] removeObserver: self];
  [super dealloc];
}

- (IBAction)cancel:(id)sender
{
  if (!_connecting)
  {
    [self finish];
  }
}


- (IBAction)connect:(id)sender
{
  MYX_USER_CONNECTION *conn;
  
  [progressIndicator startAnimation: self];
  [self setEnabled: NO];
  
  conn= [self getDisplayedConnection];
  if (conn)
    [self startConnection: conn];
}

- (IBAction)connectionChanged:(id)sender
{
  id item= [[connectionPopUp selectedItem] representedObject];
  MYX_USER_CONNECTION *conn= [item pointerValue];
  if (conn)
    [self displayConnection:conn];
  [self checkConnectOK];
}

- (IBAction)toggleDetails:(id)sender
{
  NSRect frame= [[self window] frame];
  NSSize newSize;
  BOOL flag;
  
  if ([detailsButton state])
  {
    flag= NO;
    newSize= [[self window] maxSize];
  }
  else
  {
    flag= YES;
    newSize= [[self window] minSize];
  }
  
  frame.origin.y += (frame.size.height - newSize.height);
  frame.size= newSize;

  if (flag)
    [[self window] setFrame:frame display:YES animate:YES];
  [extraView setHidden:flag];
  if (!flag)
    [[self window] setFrame:frame display:YES animate:YES];
}

- (void)windowDidLoad
{
  // fill list of saved connections
  [self fillConnectionPopUp];
  
  [self checkConnectOK];
}

- (void)show
{ 
  [self showWindow: self];  
}

- (void)setDelegate:(id)deleg
{
  _delegate= deleg;
}


// --------------------------

- (IBAction)pingHost:(id)sender
{
  NSRect f= [errorPanel frame];
  f.origin.y+= (f.size.height - [errorPanel maxSize].height);
  f.size= [errorPanel maxSize];
  
  [errorPanel setFrame: f
               display: YES
               animate: YES];
  
  [pingText setHidden: NO];
  
  [pingText setString: @"Hoorray!"];
}


- (IBAction)closeErrorPanel:(id)sender
{
  [NSApp stopModal];
  [errorPanel close];
}


@end
