/* Copyright (C) 2004 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */


#ifndef __GRT_JAVA_H_
#define __GRT_JAVA_H_

#include "myx_grt_private.h"
#include <jni.h>

typedef struct MYX_GRT_MODULE_LOADER_PRIVATE
{
  JavaVM *jvm;
  JNIEnv *env;
  jclass grt_class;
  jmethodID grt_call_func;
} MYX_JAVA_LOADER;


typedef struct MYX_GRT_MODULE_PRIVATE
{
  jclass class_ref;
} MYX_JAVA_MODULE;

typedef struct MYX_GRT_FUNCTION_PRIVATE
{
  char *java_signature;
} MYX_JAVA_FUNCTION;

MYX_GRT_MODULE_LOADER *myx_java_init_loader(MYX_GRT *grt, const char *class_path,
                                            MYX_GRT_ERROR *error);

#endif
