
#import <Cocoa/Cocoa.h>

#include "myx_public_interface.h"

@class MQueryBrowser;
@class MQHistory;
@class MQBookmarkList;

// this does the role of a NSDocumentController
@interface MQueryBrowserController : NSObject
{
  IBOutlet id aboutPanel;
  IBOutlet id versionLabel;
  IBOutlet id recentMenu;
  
  MQHistory *_history;
  BOOL _historyNeedsSave;
  MQBookmarkList *_bookmarks;

  id _prefPanel;
  NSMutableArray *_instances;
}

- (IBAction)showAbout:(id)sender;
- (IBAction)showPreferences:(id)sender;
- (IBAction)clearRecentMenu:(id)sender;

+ (MQueryBrowserController*)sharedDocumentController;

- (void)newDocument: (id)sender;

- (void)addInstance: (MQueryBrowser*)instance;

- (void)removeInstance: (MQueryBrowser*)instance;

- (void)openInstanceWithConnectionName: (NSString*)connectionName;

- (void)noteNewRecentConnection: (MYX_USER_CONNECTION*)info;



- (MQHistory*)history;
- (MQBookmarkList*)bookmarks;
- (void)rememberQuery:(NSString*)query
			  catalog:(NSString*)catalog
			   schema:(NSString*)schema;

@end
