/* Copyright (C) 2004 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#include "MQTableClauseMenu.h"

#include "myg_gtkutils.h"

// floating menu for selecting clause type for query composition
// displayed when a table is "dragged" from the table list


void MQTableClauseMenu::paint_contents()
{
  Glib::RefPtr<Gdk::Window> window= get_window();
  
  if (_recompose)
  {
    _image->composite(_background, 0, 0,
                      _background->get_width(), _background->get_height(),
                      0.0, 0.0, 1.0, 1.0, Gdk::INTERP_HYPER, 255);

    _pixmap= Gdk::Pixmap::create(window, 
                                 _background->get_width(), _background->get_height(),
                                 window->get_depth());

    _background->render_to_drawable(_pixmap, get_style()->get_black_gc(),
                                  0, 0, 0, 0, _background->get_width(), _background->get_height(),
                                  Gdk::RGB_DITHER_NORMAL, 0, 0);
    _recompose= false;
  }
  window->draw_drawable(get_style()->get_black_gc(), _pixmap, 0, 0, 0, 0);

  paint_buttons();
}


void MQTableClauseMenu::paint_buttons(bool all)
{
  Glib::RefPtr<Gdk::Window> window= get_window();
  Glib::RefPtr<Pango::Layout> l= create_pango_layout("");

  for (std::vector<Item>::const_iterator iter= _items.begin();
       iter != _items.end(); ++iter)
  {
    int x, y;
    int w, h;

    if (_mouse_x >= iter->x && _mouse_x < iter->x + iter->w &&
        _mouse_y >= iter->y && _mouse_y < iter->y + iter->h)
    {
    }
    else
    {
      if (iter->code == _selection || all)
      {
        window->draw_rectangle(get_style()->get_bg_gc(Gtk::STATE_NORMAL), true,
                               iter->x, iter->y, iter->w, iter->h);
        _selection= (MYX_Q_TABLE_ADD_TYPE)-1;
        l->set_text(iter->text);
        l->get_pixel_size(w, h);
        x= iter->x + (iter->w-w)/2;
        y= iter->y + (iter->h-h)/2;
        window->draw_layout(get_style()->get_fg_gc(Gtk::STATE_NORMAL), x, y, l);
        window->draw_rectangle(get_style()->get_fg_gc(Gtk::STATE_NORMAL), false,
                               iter->x, iter->y, iter->w, iter->h);
      }
    }
  }

  for (std::vector<Item>::const_iterator iter= _items.begin();
       iter != _items.end(); ++iter)
  {
    int x, y;
    int w, h;

    if (_mouse_x >= iter->x && _mouse_x < iter->x + iter->w &&
        _mouse_y >= iter->y && _mouse_y < iter->y + iter->h)
    {
      if (!iter->decoration && (_selection != iter->code || all))
      {
        window->draw_rectangle(get_style()->get_bg_gc(Gtk::STATE_SELECTED), true,
                               iter->x, iter->y, iter->w, iter->h);
        _selection= iter->code;

        l->set_text(iter->text);
        l->get_pixel_size(w, h);
        x= iter->x + (iter->w-w)/2;
        y= iter->y + (iter->h-h)/2;
        window->draw_layout(get_style()->get_fg_gc(Gtk::STATE_SELECTED), x, y, l);
      }
    }
  }
}


void MQTableClauseMenu::update_mouse(int x, int y)
{
  _mouse_x= x;
  _mouse_y= y;
  paint_buttons(false);
}



static struct {
  MYX_Q_TABLE_ADD_TYPE code;
  char *text;
  bool decoration;
} items[]= {
  {(MYX_Q_TABLE_ADD_TYPE)-1, "Drop on an action:", true},
  {(MYX_Q_TABLE_ADD_TYPE)-1, " ", true},
  {MYX_QTAT_SELECT, "SELECT", false},
  {MYX_QTAT_SELECT_ADD, "Add Table(s)", false},
  {(MYX_Q_TABLE_ADD_TYPE)-1, " ", true},
  {MYX_QTAT_SELECT_JOIN, "JOIN Table(s)", false},
  {MYX_QTAT_SELECT_LEFT_OUTER_JOIN, "LEFT OUTER JOIN", false},
  {(MYX_Q_TABLE_ADD_TYPE)-1, " ", true},
  {MYX_QTAT_UPDATE, "UPDATE", false},
  {MYX_QTAT_INSERT, "INSERT", false},
  {MYX_QTAT_DELETE, "DELETE", false},
  {(MYX_Q_TABLE_ADD_TYPE)-1, NULL, true}
};

  
MQTableClauseMenu::MQTableClauseMenu(unsigned int prefered_width)
  : MGFloatingWidget()
{
  unsigned int width= prefered_width;
  Item item;
  Glib::RefPtr<Pango::Layout> l;
  int x;
  unsigned int total_width;
  int count;
  int slack= 0;

  Pango::FontDescription font;
  font.set_size(Pango::SCALE*8);
  modify_font(font);
  
  l= create_pango_layout("");

  total_width= 0;
  for (count= 0; items[count].text; count++)
  {
    int w,h;
    l->set_text(items[count].text);
    l->get_pixel_size(w, h);

    total_width+= w;
  }

  if (width < total_width)
    width= total_width;
  else
    slack= (width-total_width)/count;

  x= 0;
  for (int i= 0; i < count; i++)
  {
    int w,h;
    l->set_text(items[i].text);
    l->get_pixel_size(w, h);

    item.x= x;
    item.y= 0;
    item.w= w+slack;
    item.h= 19;
    item.decoration= items[i].decoration;
    item.code= items[i].code;
    item.text= items[i].text;
    _items.push_back(item);
    
    x+= item.w;
  }

  set_size_request(width+1, 20);
  _image= Gdk::Pixbuf::create(Gdk::COLORSPACE_RGB, true, 8, width+1, 20);
  _image->fill(0xffffff80);
}


bool MQTableClauseMenu::show_at(int x, int y)
{
  _selection= (MYX_Q_TABLE_ADD_TYPE)-1;
  _recompose= true;
  return superclass::show_at(x, y) && _selection != (MYX_Q_TABLE_ADD_TYPE)-1;
}
