unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, GenericCanvasViewer, StdCtrls, ComCtrls, ToolWin, ImgList, XPStyleActnCtrls, ActnList, ActnMan, XPMan,
  ExtCtrls;

type
  TMainForm = class(TForm)
    StatusBar: TStatusBar;
    CoolBar1: TCoolBar;
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    ImageList1: TImageList;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ActionManager: TActionManager;
    NewAction: TAction;
    NewFigureAction: TAction;
    ClearAction: TAction;
    ToolButton5: TToolButton;
    CreateMultiFiguresAction: TAction;
    XPManifest1: TXPManifest;
    ZoomInAction: TAction;
    ZoomOutAction: TAction;
    ToolButton6: TToolButton;
    Timer1: TTimer;
    procedure CanvasContainerResize(Sender: TObject);
    procedure ZoomOutActionExecute(Sender: TObject);
    procedure ZoomInActionExecute(Sender: TObject);
    procedure CreateMultiFiguresActionExecute(Sender: TObject);
    procedure NewFigureActionExecute(Sender: TObject);
    procedure ClearActionExecute(Sender: TObject);
    procedure ViewerChange(Sender, Source: TObject; Reason: TGCChangeReason);
    procedure ViewerError(Sender: TObject; const Message: string);
    procedure FormCreate(Sender: TObject);
    procedure ViewerZoomChange(Sender: TObject);
    procedure ToolButton6Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    FViewer: TGenericCanvasViewer;
    FMainLayer: TLayer;
    FPaperLayer: TLayer;
    procedure CreateFigures(Amount: Integer; FigureType: Integer = -1);
    procedure PreparePaper;
  protected
  public
  end;

var
  MainForm: TMainForm;

//----------------------------------------------------------------------------------------------------------------------

implementation

{$R *.dfm}

uses
  MMSystem, Math;

const
  BaseWidth  = 7000;
  BaseHeight = 5000;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.FormCreate(Sender: TObject);

var
  Error: TGCError;
  Color: COLORREF;
  Background: array[0..3] of Single;

begin
  Randomize;
  FViewer := TGenericCanvasViewer.Create(Self);
  with FViewer do
  begin
    OnError := ViewerError;
    OnChange := ViewerChange;
    OnZoomChange := ViewerZoomChange;

    Parent := Self;
    Align := alClient;
    BaseSizeX := BaseWidth;
    BaseSizeY := BaseHeight;
    Color := ColorToRGB(clBtnShadow);
    Background[0] := GetRValue(Color) / 255;
    Background[1] := GetGValue(Color) / 255;
    Background[2] := GetBValue(Color) / 255;
    Background[3] := 0;
    Canvas.CurrentView.Color(Background);

    AutoScrollInterval := 500;
    //Options := Options + [cvoAutoCenterZoom] - [];
    Error := LoadStyles('./xml/layout.styles.db.xml');
    if Error <> GC_NO_ERROR then
      raise Exception.Create('XML parse error.');
    Error := LoadLayouts('./xml/layout.figures.db.xml');
    if Error <> GC_NO_ERROR then
      raise Exception.Create('XML parse error.');

    // The layers are automatically added to the canvas. We keep references, though, for adding figures to them.
    PreparePaper;
    FMainLayer := Canvas.CreateLayer('Main', True);
  end;
  ActiveControl := FViewer;
  Caption := Format('MySQL Workbench - %.2f%%', [FViewer.ZoomX * 100]);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.CreateFigures(Amount: Integer; FigureType: Integer = -1);

const
  Objects: array[0..6] of PChar = (
    'model',
    'simple',
    'table',
    'column',
    'structured-datatype',
    'simple-datatype',
    'distinct-datatype'
  );

var
  Figure: TFigure;
  Scale: Double;
  I: Integer;
  Instance: TFigureInstance;

begin
  for I := 0 to Amount - 1 do
  begin
    if FigureType > -1 then
    begin
      Figure := FViewer.Canvas.CreateFigure(Objects[FigureType]);
      Scale := 1;
    end
    else
    begin
      Figure := FViewer.Canvas.CreateFigure(Objects[Random(7)]);
      Scale := 0.3 + Random(1);
    end;
    Instance := FMainLayer.CreateInstance(Figure);
    Instance.Scale(Scale, Scale, 1, False);
    //Figure.Scale(Scale, Scale, 1, False);
    Instance.Translate(Random(BaseWidth) * 0.9, Random(BaseHeight) * 0.9, 0, False);
    //Figure.Translate(Random(BaseWidth) * 0.9, Random(BaseHeight) * 0.9, 0, False);
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ViewerChange(Sender, Source: TObject; Reason: TGCChangeReason);

begin
  case Reason of
    GC_CHANGE_SELECTION_ADD: // Figure instance added to selection.
      ;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ViewerError(Sender: TObject; const Message: string);

begin
  StatusBar.SimpleText := Message;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ClearActionExecute(Sender: TObject);

begin
  FViewer.Canvas.ClearContent;
  PreparePaper;
  StatusBar.SimpleText := '';
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.NewFigureActionExecute(Sender: TObject);

begin
  CreateFigures(1, 0);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.CreateMultiFiguresActionExecute(Sender: TObject);

var
  StartTime: DWORD;

begin
  StartTime := timeGetTime;
  CreateFigures(100, -1);
  Statusbar.SimpleText := Format('Time used: %d ms', [timeGetTime - StartTime]);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.PreparePaper;

var
  Paper: TFigure;
  
begin
  if FPaperLayer = nil then
  begin
    FPaperLayer := FViewer.Canvas.CreateLayer('Paper', True);
    FPaperLayer.Enabled(False);
  end;
  Paper := FViewer.Canvas.CreateFigure('paper');
  FPaperLayer.CreateInstance(Paper);
  Paper.Scale(BaseWidth / 62, BaseHeight / 62, 1, False);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ZoomInActionExecute(Sender: TObject);

begin
  FViewer.ZoomIn(FViewer.Width div 2, FViewer.Height div 2);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ZoomOutActionExecute(Sender: TObject);

begin
  FViewer.ZoomOut(FViewer.Width div 2, FViewer.Height div 2);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.CanvasContainerResize(Sender: TObject);

begin
  FViewer.Left := Max(0, (Width - FViewer.Width) div 2);
  FViewer.Top := Max(0, (Height - FViewer.Height) div 2);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ViewerZoomChange(Sender: TObject);

begin
  // Both zoom factors should be the same to keep aspect ratio.
  Caption := Format('MySQL Workbench - %.2f%%', [FViewer.ZoomX * 100]);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ToolButton6Click(Sender: TObject);

begin
  CreateFigures(100, 2);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.Timer1Timer(Sender: TObject);

begin
  Caption := Format('%.3f FPS', [FViewer.FPS]);
end;

//----------------------------------------------------------------------------------------------------------------------

end.
