#include <qlistview.h>
#include <qdatetime.h>
#include <qmessagebox.h>
#include <qtabwidget.h>
#include <stdio.h>
#include "user.h"
#include "mainwindow.h"
#include "loglistviewitem.h"
#include "include/sql.h"

void User::slot_close()
{
	parentWidget()->close();
}

void User::slot_fire()
{
	if(user_add->isOn())
	{
		if(host1->text().isEmpty())
		{
			QMessageBox::warning(this, tr("MySQL Navigator"), tr("Please enter host."));
			return;
		}

		if(user1->text().isEmpty())
		{
			QMessageBox::warning(this, tr("MySQL Navigator"), tr("Please enter user."));
			return;
		}

		if(password1->text() != again1->text())
		{
			QMessageBox::warning(this, tr("MySQL Navigator"), tr("Passwords are not equal."));
			return;
		}

		char query[1000];

		sprintf(query,
				"insert into user values('%s',	\
										 '%s',\
										 password('%s'),\
										 '%c',\
										 '%c',\
										 '%c',\
										 '%c',\
										 '%c',\
										 '%c',\
										 '%c',\
										 '%c',\
										 '%c',\
										 '%c',\
										 '%c',	\
										 '%c',\
										 '%c',\
										 '%c')",\
										 host1->text().latin1(),\
										 user1->text().latin1(),\
										 password1->text().latin1(),\
										 select->isOn()?'Y':'N',\
										 insert->isOn()?'Y':'N',\
										 update->isOn()?'Y':'N',\
										 _delete->isOn()?'Y':'N',\
										 create->isOn()?'Y':'N',\
										 drop->isOn()?'Y':'N',\
										 reload->isOn()?'Y':'N',\
										 shutdown->isOn()?'Y':'N',\
										 process->isOn()?'Y':'N',\
										 file->isOn()?'Y':'N',\
										 grant->isOn()?'Y':'N',\
										 references->isOn()?'Y':'N',\
										 index->isOn()?'Y':'N',\
										 alter->isOn()?'Y':'N');
		
		if(mysql_select_db(mysql,"mysql"))
			return;

		if(SQL::sql_query(query))
		{
			QMessageBox::warning(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(mysql)));
			return;
		}
		else
		{
			mysql_reload(mysql);	

			emit signal_schema();

			QMessageBox::information(this, tr("MySQL Navigator"), tr("User has been successfully created."));
		}
	}
	else if(user_drop->isOn())
	{
		if(host1->text().isEmpty())
		{
			QMessageBox::warning(this, tr("MySQL Navigator"), tr("Please enter host."));
			return;
		}

		if(user1->text().isEmpty())
		{
			QMessageBox::warning(this, tr("MySQL Navigator"), tr("Please enter user."));
			return;
		}
		
		char query[1000];

		sprintf(query,"delete from user where user='%s' && host='%s'",
						user1->text().latin1(),
						host1->text().latin1());
		
		if(mysql_select_db(mysql,"mysql"))
			return;

		if(SQL::sql_query(query))
		{
			QMessageBox::warning(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(mysql)));
			return;
		}
		else
		{

			mysql_reload(mysql);	

			emit signal_schema();

			QMessageBox::information(this, tr("MySQL Navigator"), tr("User has been successfully deleted."));
		}
	}
	else if(user_alter->isOn())
	{
		char query[1000];

		if(host1->text().isEmpty())
		{
			QMessageBox::warning(this, tr("MySQL Navigator"), tr("Please enter host."));
			return;
		}

		if(user1->text().isEmpty())
		{
			QMessageBox::warning(this, tr("MySQL Navigator"), tr("Please enter user."));
			return;
		}

		if(password1->text() != again1->text())
		{
			QMessageBox::warning(this, tr("MySQL Navigator"), tr("Passwords are not equal."));
			return;	
		}

		if(password1->text().isEmpty())
		{
			sprintf(query,"update user set  \
									  select_priv='%c',\
									  insert_priv='%c',\
									  update_priv='%c',\
									  delete_priv='%c',\
									  create_priv='%c',\
									  drop_priv='%c',\
									  reload_priv='%c',\
									  shutdown_priv='%c',\
									  process_priv='%c',\
									  file_priv='%c',\
									  grant_priv='%c',\
									  references_priv='%c',\
									  index_priv='%c',\
									  alter_priv='%c'\
									  where host='%s' && user='%s'",\
									  select->isOn()?'Y':'N',\
									  insert->isOn()?'Y':'N',\
								      update->isOn()?'Y':'N',\
									  _delete->isOn()?'Y':'N',\
									  create->isOn()?'Y':'N',\
									  drop->isOn()?'Y':'N',\
									  reload->isOn()?'Y':'N',\
									  shutdown->isOn()?'Y':'N',\
									  process->isOn()?'Y':'N',\
									  file->isOn()?'Y':'N',\
									  grant->isOn()?'Y':'N',\
									  references->isOn()?'Y':'N',\
									  index->isOn()?'Y':'N',\
									  alter->isOn()?'Y':'N',\
									  host1->text().latin1(),\
									  user1->text().latin1());
		}
		else
		{
			sprintf(query,"update user set password = password('%s'), \
									  select_priv='%c',\
									  insert_priv='%c',\
									  update_priv='%c',\
									  delete_priv='%c',\
									  create_priv='%c',\
									  drop_priv='%c',\
									  reload_priv='%c',\
									  shutdown_priv='%c',\
									  process_priv='%c',\
									  file_priv='%c',\
									  grant_priv='%c',\
									  references_priv='%c',\
									  index_priv='%c',\
									  alter_priv='%c'\
									  where host='%s' && user='%s'",\
									  password1->text().latin1(), \
									  select->isOn()?'Y':'N',\
									  insert->isOn()?'Y':'N',\
								      update->isOn()?'Y':'N',\
									  _delete->isOn()?'Y':'N',\
									  create->isOn()?'Y':'N',\
									  drop->isOn()?'Y':'N',\
									  reload->isOn()?'Y':'N',\
									  shutdown->isOn()?'Y':'N',\
									  process->isOn()?'Y':'N',\
									  file->isOn()?'Y':'N',\
									  grant->isOn()?'Y':'N',\
									  references->isOn()?'Y':'N',\
									  index->isOn()?'Y':'N',\
									  alter->isOn()?'Y':'N',\
									  host1->text().latin1(),\
									  user1->text().latin1());
		}

		if(mysql_select_db(mysql,"mysql"))
			return;

		if(SQL::sql_query(query))
		{
			QMessageBox::warning(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(mysql)));
			return;
		}
		else
		{
			mysql_reload(mysql);	

			emit signal_schema();

			QMessageBox::information(this, tr("MySQL Navigator"), tr(" User has been successfully modified."));
		}
	}
}

void User::slot_radio()
{
	if(user_add->isOn())
	{
		privilage_groupbox->setEnabled(TRUE);	
		password1->setEnabled(TRUE);
		again1->setEnabled(TRUE);
	}
	else if(user_drop->isOn())
	{
		privilage_groupbox->setEnabled(FALSE);	
		password1->setEnabled(FALSE);
		again1->setEnabled(FALSE);
	}
	else if(user_alter->isOn())
	{
		privilage_groupbox->setEnabled(TRUE);
		password1->setEnabled(TRUE);
		again1->setEnabled(TRUE);
	}
}

void User::clear()
{
	all->setChecked(FALSE);
	host1->setText("");
	user1->setText("");
	password1->setText("");
	again1->setText("");
	select->setOn(FALSE);
	insert->setOn(FALSE);
	update->setOn(FALSE);
	_delete->setOn(FALSE);
	create->setOn(FALSE);
	drop->setOn(FALSE);
	reload->setOn(FALSE);
	shutdown->setOn(FALSE);
	process->setOn(FALSE);
	file->setOn(FALSE);
	grant->setOn(FALSE);
	references->setOn(FALSE);
	index->setOn(FALSE);
	alter->setOn(FALSE);
}

void User::slot_select_all()
{
	if(all->isOn())
	{
		select->setOn(TRUE);
		insert->setOn(TRUE);
		update->setOn(TRUE);
		_delete->setOn(TRUE);
		create->setOn(TRUE);
		drop->setOn(TRUE);
		reload->setOn(TRUE);
		shutdown->setOn(TRUE);
		process->setOn(TRUE);
		file->setOn(TRUE);
		grant->setOn(TRUE);
		references->setOn(TRUE);
		index->setOn(TRUE);
		alter->setOn(TRUE);
	}
	else
	{
		select->setOn(FALSE);
		insert->setOn(FALSE);
		update->setOn(FALSE);
		_delete->setOn(FALSE);
		create->setOn(FALSE);
		drop->setOn(FALSE);
		reload->setOn(FALSE);
		shutdown->setOn(FALSE);
		process->setOn(FALSE);
		file->setOn(FALSE);
		grant->setOn(FALSE);
		references->setOn(FALSE);
		index->setOn(FALSE);
		alter->setOn(FALSE);
	}
}

void User::slot_user_data(int flag, const QString &host, const QString &user)
{
	QString sql;

	clear();
	this->host1->setText(host);
	this->user1->setText(user);
	
	// delete
	if(flag == 2)
	{
		user_drop->setChecked(TRUE);
		tabWidget->setCurrentPage(1);
		slot_radio();
		host1->setFocus();
		return;
	}
	// create
	else if(flag == 0)
	{
		user_add->setChecked(TRUE);
		tabWidget->setCurrentPage(1);
		slot_radio();
		host1->setFocus();
		return;
	}
	// alter
	else if(flag == 1)
	{
		user_alter->setChecked(TRUE);
		tabWidget->setCurrentPage(1);
		slot_radio();
		host1->setFocus();
	}
	
	if(mysql_select_db(mysql, "mysql"))
		return;

	sql.sprintf("select * from user where host = '%s' && user = '%s'", host.latin1(), user.latin1());

	if(SQL::sql_query(sql.latin1()))
		return;
	
	result = mysql_store_result(mysql);

	if(result == NULL)
		return;

	row = mysql_fetch_row(result);
	
	if(row[3][0] == 'Y')
		select->setOn(TRUE);
	else
		select->setOn(FALSE);
	if(row[4][0] == 'Y')
		insert->setOn(TRUE);
	else
		insert->setOn(FALSE);
	if(row[5][0] == 'Y')
		update->setOn(TRUE);
	else
		update->setOn(FALSE);
	if(row[6][0] == 'Y')
		_delete->setOn(TRUE);
	else
		_delete->setOn(FALSE);
	if(row[7][0] == 'Y')
		create->setOn(TRUE);
	else
		create->setOn(FALSE);
	if(row[8][0] == 'Y')
		drop->setOn(TRUE);
	else
		drop->setOn(FALSE);
	if(row[9][0] == 'Y')
		reload->setOn(TRUE);
	else
		reload->setOn(FALSE);
	if(row[10][0] == 'Y')
		shutdown->setOn(TRUE);
	else
		shutdown->setOn(FALSE);
	if(row[11][0] == 'Y')
		process->setOn(TRUE);
	else
		process->setOn(FALSE);
	if(row[12][0] == 'Y')
		file->setOn(TRUE);
	else
		file->setOn(FALSE);
	if(row[13][0] == 'Y')
		grant->setOn(TRUE);
	else
		grant->setOn(FALSE);
	if(row[14][0] == 'Y')
		references->setOn(TRUE);
	else
		references->setOn(FALSE);
	if(row[15][0] == 'Y')
		index->setOn(TRUE);
	else
		index->setOn(FALSE);
	if(row[16] [0]== 'Y')
		alter->setOn(TRUE);
	else
		alter->setOn(FALSE);

	mysql_free_result(result);
}
