/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.powertoys;

import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.powertoys.DBMException;
import com.sap.dbtech.rte.comm.JdbcCommFactory;
import com.sap.dbtech.rte.comm.JdbcCommunication;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.rte.comm.SecureCommunication;
import com.sap.dbtech.util.StructuredMem;
import java.util.Properties;

public class DBM {
    private static final String hostKeyC = "host";
    private static final String hostDefaultC = "localhost";
    private static final String dbnameKeyC = "dbname";
    private static final String dbnameDefaultC = "";
    private static final String dbrootKeyC = "dbroot";
    private static final String dbrootDefaultC = "";
    private static final String userKeyC = "user";
    private static final String pgmNameC = "dbmsrv";
    private static final String transportC = "transport";
    private static final int alignSizeC = 8;
    static final int indicatorLengthC = 4;
    private JdbcCommunication connection;

    public DBM(Properties properties) throws RTEException {
        String string = properties.getProperty(hostKeyC, hostDefaultC);
        String string2 = properties.getProperty(dbnameKeyC, "");
        String string3 = properties.getProperty(dbrootKeyC, "");
        String string4 = properties.getProperty(transportC, "socket");
        JdbcCommFactory jdbcCommFactory = DriverSapDB.getCommunicationFactory();
        if (string4.equalsIgnoreCase("secure")) {
            jdbcCommFactory = SecureCommunication.factory;
        }
        this.connection = jdbcCommFactory.xopen(string, string2, string3, pgmNameC, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws RTEException {
        if (this.connection != null) {
            try {
                try {
                    this.cmd("release");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.connection.release();
            }
            finally {
                this.connection = null;
            }
        }
    }

    public void finalize() throws RTEException {
        this.release();
    }

    public String cmd(String string) throws RTEException, DBMException {
        StructuredMem structuredMem = this.connection.getRequestPacket();
        int n = (string.length() + 8 - 1) / 8 * 8;
        structuredMem.putString(string, 0);
        this.connection.request(structuredMem, n);
        StructuredMem structuredMem2 = this.connection.receive();
        String string2 = structuredMem2.getString(0, Math.min(4, structuredMem2.size()));
        if (!string2.startsWith("OK")) {
            throw DBMException.create(structuredMem2);
        }
        int n2 = string2.indexOf(10) + 1;
        String string3 = structuredMem2.getString(n2, structuredMem2.size() - n2);
        return string3;
    }

    public static DBM dbDBM(String string, String string2) throws RTEException {
        Properties properties = new Properties();
        if (string != null) {
            properties.put(hostKeyC, string);
        }
        if (string2 != null) {
            properties.put(dbnameKeyC, string2);
        }
        return new DBM(properties);
    }

    public static DBM dbrootDBM(String string, String string2) throws RTEException {
        Properties properties = new Properties();
        if (string != null) {
            properties.put(hostKeyC, string);
        }
        properties.put(dbrootKeyC, string2);
        return new DBM(properties);
    }
}

