// test_user_management.cpp : Defines the entry point for the console application.
//

#include "myx_admin_public_interface.h"

const char * test_name= 0;

void print_usage()
{
  printf(
    "usage : test_make_backup.exe <path_to_connection_file>\n");
}

void print_space_till(unsigned char * name, size_t num)
{
  size_t start_pos= !name ? sizeof("(null)")-1 : strlen((const char*)name);
  for (size_t i= start_pos; i<num; i++)
    printf(" ");
}

int compare_priv(const void * p1, const void * p2)
{
  char ** c1= (char**)p1;
  char ** c2= (char**)p2;
  return strcmp(*c1,*c2);
}

void trace_user_object_privilege(MYX_USER_OBJECT_PRIVILEGES * privileges)
{
  printf("    \"%s\"",privileges->host); fflush(stdout);
  print_space_till(privileges->host,15); fflush(stdout);
  printf("\"%s\" ",privileges->object_name); fflush(stdout);
  print_space_till(privileges->object_name,15);
  qsort(privileges->user_privileges,privileges->user_privileges_num,
        sizeof(char*),compare_priv);
  unsigned char ** user_privilege= privileges->user_privileges;
  unsigned char ** user_privileges_end=
                              user_privilege + privileges->user_privileges_num;
  for (; user_privilege!=user_privileges_end; user_privilege++)
    printf("%s|",*user_privilege);
  printf("\n");
}

void trace_icon(MYX_USER * user)
{
  printf("  icon_length=          %u\n",user->icon_length);
  if (user->icon_length)
  {
    char buf[101];
    size_t len= user->icon_length>100 ? 100 : user->icon_length;
    memcpy(buf,user->icon,len);
    buf[len]= 0;
    printf("  icon=                 \"%s\"\n",buf);
  }
}

void trace_user(MYX_USER * user)
{
  printf("name= \"%s\"\n",user->user_name);
  printf("  password=             \"%s\"\n",user->password);
  printf("  full_name=            \"%s\"\n",user->full_name);
  printf("  description=          \"%s\"\n",user->description);
  printf("  email=                \"%s\"\n",user->email);
  printf("  contact_information=  \"%s\"\n",user->contact_information);
  trace_icon(user);

  printf("\n  hosts(%u) :",(unsigned int)user->hosts_num);
  unsigned char ** host= user->hosts;
  unsigned char ** hosts_end= host + user->hosts_num;
  for (; host!=hosts_end; host++)
    printf(" \"%s\"",*host);
  printf("\n");

  printf("\n  objects(%u) :\n",(unsigned int)user->user_object_privileges_num);
  MYX_USER_OBJECT_PRIVILEGES * privileges= user->user_object_privileges;
  MYX_USER_OBJECT_PRIVILEGES * privileges_end=
                                 privileges + user->user_object_privileges_num;
  for (; privileges!=privileges_end; privileges++)
    trace_user_object_privilege(privileges);
  printf("\n");
}

void trace_user(MYSQL * mysql, const char * user_name)
{
  MYX_USER * user= myx_get_user_with_privileges(mysql,user_name);
  if (user)
  {
    trace_user(user);
    myx_free_user(user);
  }
}

void trace_users(MYSQL * mysql)
{
  printf("--------------- users : -------------\n");
  MYX_USER_NAMES * users= myx_get_user_names(mysql);
  if (users)
  {
    char ** user_name= users->user_names;
    char ** user_names_end= user_name + users->user_names_num;

    for (; user_name!=user_names_end; user_name++)
      trace_user(mysql,*user_name);
    myx_free_user_names(users);
  }
}

int trace_error(MYSQL * mysql)
{
  char * errmsg= myx_mysql_error(mysql);
  int errnum= myx_mysql_errno(mysql);

  printf("!!!!!!!! mysql error : %d, \"%s\"\n",
         errnum,errmsg);
  return 1;
}

int iversion= 0;

unsigned char * const_empty_global_privileges_40[]=
{
  (unsigned char *)"Alter_priv=N",           (unsigned char *)"Insert_priv=N",
  (unsigned char *)"Update_priv=N",           (unsigned char *)"Delete_priv=N",
  (unsigned char *)"Create_priv=N",             (unsigned char *)"Drop_priv=N",
  (unsigned char *)"Reload_priv=N",         (unsigned char *)"Shutdown_priv=N",
  (unsigned char *)"Process_priv=N",            (unsigned char *)"File_priv=N",
  (unsigned char *)"Grant_priv=N",        (unsigned char *)"References_priv=N",
  (unsigned char *)"Index_priv=N",            (unsigned char *)"Select_priv=N",
  (unsigned char *)"Show_db_priv=N",           (unsigned char *)"Super_priv=N",
  (unsigned char *)"Create_tmp_table_priv=N", 
  (unsigned char *)"Lock_tables_priv=N",     (unsigned char *)"Execute_priv=N",
  (unsigned char *)"Repl_slave_priv=N",  (unsigned char *)"Repl_client_priv=N",

  (unsigned char *)"max_questions=0", (unsigned char *)"max_updates=0",
  (unsigned char *)"max_connections=0"
};
unsigned long size_empty_global_privileges_40=
         (unsigned long)sizeof(const_empty_global_privileges_40)/sizeof(char*);


unsigned char * const_empty_global_privileges_41[]=
{
  (unsigned char *)"Alter_priv=N",           (unsigned char *)"Insert_priv=N",
  (unsigned char *)"Update_priv=N",           (unsigned char *)"Delete_priv=N",
  (unsigned char *)"Create_priv=N",             (unsigned char *)"Drop_priv=N",
  (unsigned char *)"Reload_priv=N",         (unsigned char *)"Shutdown_priv=N",
  (unsigned char *)"Process_priv=N",            (unsigned char *)"File_priv=N",
  (unsigned char *)"Grant_priv=N",        (unsigned char *)"References_priv=N",
  (unsigned char *)"Index_priv=N",            (unsigned char *)"Select_priv=N",
  (unsigned char *)"Show_db_priv=N",           (unsigned char *)"Super_priv=N",
  (unsigned char *)"Create_tmp_table_priv=N", 
  (unsigned char *)"Lock_tables_priv=N",     (unsigned char *)"Execute_priv=N",
  (unsigned char *)"Repl_slave_priv=N",  (unsigned char *)"Repl_client_priv=N",

  (unsigned char *)"max_questions=0", (unsigned char *)"max_updates=0",
  (unsigned char *)"max_connections=0"
};
unsigned long size_empty_global_privileges_41=
         (unsigned long)sizeof(const_empty_global_privileges_41)/sizeof(char*);

unsigned long const_size_empty_global_privileges[2]=
{
  size_empty_global_privileges_40,
  size_empty_global_privileges_41
};
unsigned char ** const_empty_global_privileges[2]=
{
  const_empty_global_privileges_40,
  const_empty_global_privileges_41
};

unsigned long size_empty_global_privileges;
unsigned char ** empty_global_privileges;

unsigned char * const_empty_db_privileges_40[]=
{
  (unsigned char*)"Alter_priv=N", (unsigned char*)"Insert_priv=N",
  (unsigned char*)"Update_priv=N", (unsigned char*)"Delete_priv=N",
  (unsigned char*)"Create_priv=N", (unsigned char*)"Drop_priv=N",
  (unsigned char*)"Grant_priv=N", (unsigned char*)"References_priv=N",
  (unsigned char*)"Index_priv=N", (unsigned char*)"Select_priv=N",
  (unsigned char*)"Create_tmp_table_priv=N",
  (unsigned char*)"Lock_tables_priv=N"
};
unsigned long size_empty_db_privileges_40=
             (unsigned long)sizeof(const_empty_db_privileges_40)/sizeof(char*);
unsigned char ** empty_db_privileges_40;
unsigned char ** empty_db_privileges_40_1;

unsigned char * const_empty_table_privileges_40[]=
{
  (unsigned char*)"Table_priv_Alter=N", (unsigned char*)"Table_priv_Insert=N",
  (unsigned char*)"Table_priv_Update=N", (unsigned char*)"Table_priv_Delete=N",
  (unsigned char*)"Table_priv_Create=N", (unsigned char*)"Table_priv_Drop=N",
  (unsigned char*)"Table_priv_Grant=N",
  (unsigned char*)"Table_priv_References=N",
  (unsigned char*)"Table_priv_Index=N", (unsigned char*)"Table_priv_Select=N",

  (unsigned char*)"Column_priv_Insert=N",
  (unsigned char*)"Column_priv_Select=N",
  (unsigned char*)"Column_priv_Update=N",
  (unsigned char*)"Column_priv_Delete=N",
  (unsigned char*)"Column_priv_Create=N",
  (unsigned char*)"Column_priv_Drop=N",
  (unsigned char*)"Column_priv_Grant=N",
  (unsigned char*)"Column_priv_References=N",
  (unsigned char*)"Column_priv_Index=N",
  (unsigned char*)"Column_priv_Alter=N"
};
unsigned long size_empty_table_privileges_40=
          (unsigned long)sizeof(const_empty_table_privileges_40)/sizeof(char*);
unsigned char ** empty_table_privileges_40;

unsigned char ** empty_columns_privileges_40= empty_table_privileges_40+10;
unsigned long size_empty_columns_privileges_40=
                size_empty_table_privileges_40 - 
                (empty_columns_privileges_40-empty_table_privileges_40);
unsigned long size_empty_table_only_privileges_40;

unsigned char * const_empty_column_privileges_40[]=
{
  (unsigned char*)"Column_priv_Insert=N",
  (unsigned char*)"Column_priv_Select=Y",
  (unsigned char*)"Column_priv_Update=N",
  (unsigned char*)"Column_priv_References=N"
};
unsigned long size_empty_column_privileges_40=
         (unsigned long)sizeof(const_empty_column_privileges_40)/sizeof(char*);
unsigned char ** empty_column_privileges_40;

unsigned char * percent= (unsigned char*)"%";
unsigned char * empty= (unsigned char*)"";
unsigned char * localhost= (unsigned char*)"localhost";
unsigned char * customhost= (unsigned char*)"customhost";
unsigned char * test= (unsigned char*)"test";
unsigned char * test_t1= (unsigned char*)"test.t1";
unsigned char * test_t1_c= (unsigned char*)"test.t1.c";
unsigned char * TEST= (unsigned char*)"TEST";

MYX_USER_OBJECT_PRIVILEGES object_privs[]=
{
  {percent, 0, size_empty_global_privileges, empty_global_privileges},
  {localhost, 0, size_empty_global_privileges, empty_global_privileges},
  {localhost, test, size_empty_db_privileges_40, empty_db_privileges_40},
  {localhost, test_t1, size_empty_table_privileges_40,
                                                    empty_table_privileges_40},
  {localhost, test_t1_c, size_empty_column_privileges_40,
                                                  empty_column_privileges_40},
  {localhost, TEST, size_empty_db_privileges_40, empty_db_privileges_40_1},
};

unsigned char * hosts[]= { percent, localhost, customhost };

void set_value(unsigned char * privilege, char c)
{
  size_t len= strlen((const char*)privilege);
  privilege[len-1]= c;
}

void set_values(unsigned char ** privileges, unsigned long count,
                char value_for_first_item, char values_for_the_rest)
{
  unsigned char ** privileges_end= privileges + count;
  set_value(*privileges,value_for_first_item);
  privileges++;
  for ( ; privileges!=privileges_end; privileges++)
    set_value(*privileges,values_for_the_rest);
}

void copy_privileges(unsigned char *** dst, 
                     unsigned char ** src, unsigned long count)
{
  unsigned char ** privilege_dst, ** privilege_src, ** privileges_end;

  *dst= new unsigned char * [count];

  for (   privilege_dst= *dst,
          privilege_src= src,
          privileges_end= privilege_src + count
       ;  privilege_src!=privileges_end
       ;  privilege_dst++, privilege_src++)
  {
    *privilege_dst= (unsigned char*)strdup((const char*)*privilege_src);
  }
}

void init_consts()
{
  copy_privileges(&empty_global_privileges,
                  const_empty_global_privileges[iversion],
                  const_size_empty_global_privileges[iversion]);
  size_empty_global_privileges= const_size_empty_global_privileges[iversion];

  copy_privileges(&empty_db_privileges_40,
                  const_empty_db_privileges_40,
                  size_empty_db_privileges_40);
  copy_privileges(&empty_db_privileges_40_1,
                  const_empty_db_privileges_40,
                  size_empty_db_privileges_40);

  copy_privileges(&empty_table_privileges_40,
                  const_empty_table_privileges_40,
                  size_empty_table_privileges_40);
  empty_columns_privileges_40= empty_table_privileges_40+10;
  size_empty_columns_privileges_40=
                size_empty_table_privileges_40 - 
                (empty_columns_privileges_40-empty_table_privileges_40);
  size_empty_table_only_privileges_40= size_empty_table_privileges_40- 
                                              size_empty_columns_privileges_40;
  copy_privileges(&empty_column_privileges_40,
                  const_empty_column_privileges_40,
                  size_empty_column_privileges_40);

  object_privs[0].user_privileges= const_empty_global_privileges[iversion];
  object_privs[0].user_privileges_num=
                                  const_size_empty_global_privileges[iversion];
  object_privs[1].user_privileges= empty_global_privileges;
  object_privs[1].user_privileges_num= size_empty_global_privileges;
  object_privs[2].user_privileges= empty_db_privileges_40;
  object_privs[3].user_privileges= empty_table_privileges_40;
  object_privs[4].user_privileges= empty_column_privileges_40;
  object_privs[5].user_privileges= empty_db_privileges_40_1;
}

const char *query[]= 
{
  "delete from mysql.user_info where user=\'test_user\' or user=\'test_user1\'",
  "delete from mysql.user where user=\'test_user\' or user=\'test_user1\'",
  "delete from mysql.db where user=\'test_user\' or user=\'test_user1\'",
  "delete from mysql.tables_priv where user=\'test_user\' or user=\'test_user1\'",
  "delete from mysql.columns_priv where user=\'test_user\'or user=\'test_user1\'",
};

int clear_test_user(MYSQL * mysql)
{
  const char **q= query;
  myx_mysql_query(mysql, *q);
  q++;
  const char **query_end= query + sizeof(query)/sizeof(char*);
  for (; q!=query_end; q++)
  {
    if (myx_mysql_query(mysql, *q))
      return trace_error(mysql);
  }

  return 1;
}

int common_test(MYSQL * mysql)
{ 
  clear_test_user(mysql);
  init_consts();

  trace_users(mysql);
  const char * previous_user_name= "";

  MYX_USER user;

  user.hosts_num= 1;
  user.hosts= (unsigned char **)&hosts;

  user.user_object_privileges_num= 1;
  user.user_object_privileges= object_privs;

  user.user_name= (unsigned char*)"test_user";
  user.password= (unsigned char*)"test_password";
  user.full_name= (unsigned char*)"test user";
  user.description= (unsigned char*)"1\n2\n";
  user.email= (unsigned char*)"a@b.com";
  user.contact_information= (unsigned char*)"a b c";
  user.icon= (unsigned char*)"test icon";
  user.icon_length= (unsigned int)strlen((const char*)user.icon);

  printf("*********** add user(test_user,test_password,"
                               "test user,1\\n\\n,a@b.com,a b c,test icon)\n");

  if (myx_set_user(mysql,&user,previous_user_name,1))
    return trace_error(mysql);
  trace_users(mysql);

  previous_user_name= (const char*)user.user_name;
  user.password= (unsigned char*)"test_password2";
  user.full_name= (unsigned char*)"test user2";
  user.description= (unsigned char*)"1\n2\n3\n4\n";
  user.email= (unsigned char*)"a2@b.com";
  user.contact_information= (unsigned char*)"a2 b c";
  user.icon= (unsigned char*)"test icon2";
  user.icon_length= (unsigned int)strlen((const char*)user.icon);

  printf("*********** set user test_user to (test_user,test_password2,"
                               "test user2,1\\n\\n3\\n4\\n,a2@b.com,"
                               "a2 b c,test icon2)\n");

  if (myx_set_user(mysql,&user,previous_user_name,0))
    return trace_error(mysql);
  previous_user_name= (const char*)user.user_name;
  trace_users(mysql);

  previous_user_name= (const char*)user.user_name;
  user.user_name= (unsigned char*)"test_user1";
  user.password= (unsigned char*)"test_password1";
  user.full_name= (unsigned char*)"test user1";
  user.description= (unsigned char*)"1\n2\n3\n";
  user.email= (unsigned char*)"a1@b.com";
  user.contact_information= (unsigned char*)"a1 b c";
  user.icon= (unsigned char*)"test icon1";
  user.icon_length= (unsigned int)strlen((const char*)user.icon);

  printf("*********** set user test_user to (test_user1,test_password1,"
                               "test user1,1\\n\\n3\\n,a1@b.com,"
                               "a1 b c,test icon1)\n");

  if (myx_set_user(mysql,&user,previous_user_name,0))
    return trace_error(mysql);
  previous_user_name= (const char*)user.user_name;
  trace_users(mysql);

  printf("*********** add host localhost\n");
  user.hosts_num= 2;
  if (myx_set_user(mysql,&user,previous_user_name,0))
    return trace_error(mysql);
  trace_user(mysql,(const char*)user.user_name);

  printf("*********** add host customhost\n");
  user.hosts_num= 3;
  if (myx_set_user(mysql,&user,previous_user_name,0))
    return trace_error(mysql);
  trace_user(mysql,(const char*)user.user_name);

  printf("*********** drop host customhost\n");
  user.hosts_num= 2;
  if (myx_set_user(mysql,&user,previous_user_name,0))
    return trace_error(mysql);
  trace_user(mysql,(const char*)user.user_name);

  printf("*********** allow to alter localhost\n");
  user.user_object_privileges_num= 2;
  set_values(empty_global_privileges,
             size_empty_global_privileges,'Y','N');
  if (myx_set_user(mysql,&user,previous_user_name,0))
    return trace_error(mysql);
  trace_user(mysql,(const char*)user.user_name);

  printf("*********** allow to alter localhost test\n");
  user.user_object_privileges_num= 3;
  set_values(empty_db_privileges_40,size_empty_db_privileges_40,'Y','N');
  if (myx_set_user(mysql,&user,previous_user_name,0))
    return trace_error(mysql);
  trace_user(mysql,(const char*)user.user_name);

  printf("*********** allow to alter localhost test.t1\n");
  user.user_object_privileges_num= 4;
  set_values(empty_table_privileges_40,size_empty_table_privileges_40,'Y','N');
  if (myx_set_user(mysql,&user,previous_user_name,0))
    return trace_error(mysql);
  trace_user(mysql,(const char*)user.user_name);

  printf("*********** allow to insert localhost test.t1.*\n");
  set_values(empty_columns_privileges_40,
             size_empty_columns_privileges_40,'Y','N');
  if (myx_set_user(mysql,&user,previous_user_name,0))
    return trace_error(mysql);
  trace_user(mysql,(const char*)user.user_name);

  printf("*********** allow to insert localhost test.t1.c\n");
  user.user_object_privileges_num= 5;
  set_values(empty_column_privileges_40,
             size_empty_column_privileges_40,'Y','N');
  if (myx_set_user(mysql,&user,previous_user_name,0))
    return trace_error(mysql);
  trace_user(mysql,(const char*)user.user_name);

  printf("*********** allow everything for localhost test.t1.c\n");
  set_values(empty_column_privileges_40,
             size_empty_column_privileges_40,'Y','Y');
  if (myx_set_user(mysql,&user,previous_user_name,0))
    return trace_error(mysql);
  trace_user(mysql,(const char*)user.user_name);

  printf("*********** forbid to insert to localhost test.t1.c\n");
  set_values(empty_column_privileges_40,
             size_empty_column_privileges_40,'N','Y');
  if (myx_set_user(mysql,&user,previous_user_name,0))
    return trace_error(mysql);
  trace_user(mysql,(const char*)user.user_name);

  printf("*********** allow everything for localhost test.t1.*\n");
  set_values(empty_columns_privileges_40,
             size_empty_columns_privileges_40,'Y','Y');
  if (myx_set_user(mysql,&user,previous_user_name,0))
    return trace_error(mysql);
  trace_user(mysql,(const char*)user.user_name);

  printf("*********** forbid to insert localhost test.t1.*\n");
  set_values(empty_columns_privileges_40,
             size_empty_columns_privileges_40,'N','Y');
  if (myx_set_user(mysql,&user,previous_user_name,0))
    return trace_error(mysql);
  trace_user(mysql,(const char*)user.user_name);

  printf("*********** allow everything for localhost test.t1\n");
  set_values(empty_table_privileges_40,
             size_empty_table_only_privileges_40,'Y','Y');
  if (myx_set_user(mysql,&user,previous_user_name,0))
    return trace_error(mysql);
  trace_user(mysql,(const char*)user.user_name);

  printf("*********** forbid to alter localhost test.t1\n");
  set_values(empty_table_privileges_40,
             size_empty_table_only_privileges_40,'N','Y');
  if (myx_set_user(mysql,&user,previous_user_name,0))
    return trace_error(mysql);
  trace_user(mysql,(const char*)user.user_name);

  printf("*********** allow everything for localhost test\n");
  set_values(empty_db_privileges_40,size_empty_db_privileges_40,'Y','Y');
  if (myx_set_user(mysql,&user,previous_user_name,0))
    return trace_error(mysql);
  trace_user(mysql,(const char*)user.user_name);

  printf("*********** forbid to alter localhost test\n");
  set_values(empty_db_privileges_40,size_empty_db_privileges_40,'N','Y');
  if (myx_set_user(mysql,&user,previous_user_name,0))
    return trace_error(mysql);
  trace_user(mysql,(const char*)user.user_name);

  printf("*********** allow everything for localhost\n");
  set_values(empty_global_privileges,
             size_empty_global_privileges,'Y','Y');
  if (myx_set_user(mysql,&user,previous_user_name,0))
    return trace_error(mysql);
  trace_user(mysql,(const char*)user.user_name);

  printf("*********** forbid to alter localhost\n");
  set_values(empty_global_privileges,
             size_empty_global_privileges,'N','Y');
  if (myx_set_user(mysql,&user,previous_user_name,0))
    return trace_error(mysql);
  trace_user(mysql,(const char*)user.user_name);

  printf("*********** forbid everything for localhost test.t1.c\n");
  user.user_object_privileges_num= 4;
  if (myx_set_user(mysql,&user,previous_user_name,0))
    return trace_error(mysql);
  trace_user(mysql,(const char*)user.user_name);

  printf("*********** forbid everything for localhost test.t1\n");
  user.user_object_privileges_num= 3;
  if (myx_set_user(mysql,&user,previous_user_name,0))
    return trace_error(mysql);
  trace_user(mysql,(const char*)user.user_name);

  printf("*********** forbid everything for localhost test\n");
  user.user_object_privileges_num= 2;
  if (myx_set_user(mysql,&user,previous_user_name,0))
    return trace_error(mysql);
  trace_user(mysql,(const char*)user.user_name);

  printf("*********** drop host localhost\n");
  user.hosts_num= 1;
  user.user_object_privileges_num= 1;
  if (myx_set_user(mysql,&user,previous_user_name,0))
    return trace_error(mysql);
  trace_user(mysql,(const char*)user.user_name);

  printf("*********** del user test_user1\n");

  if (myx_del_user(mysql,(const char*)user.user_name))
    return trace_error(mysql);
  trace_users(mysql);

  return 0;
}

int test_for_BUG_5440(MYSQL * mysql)
{
  clear_test_user(mysql);
  init_consts();

  const char * previous_user_name= "";

  MYX_USER user;

  user.hosts_num= 1;
  user.hosts= (unsigned char **)&hosts;

  user.user_object_privileges_num= 1;
  user.user_object_privileges= object_privs;

  user.user_name= (unsigned char*)"test_user";
  user.password= (unsigned char*)"";
  user.full_name= (unsigned char*)"";
  user.description= (unsigned char*)"";
  user.email= (unsigned char*)"";
  user.contact_information= (unsigned char*)"";
  user.icon= (unsigned char*)"";
  user.icon_length= (unsigned int)strlen((const char*)user.icon);

  printf("*********** add user(test_user\n");

  if (myx_set_user(mysql,&user,previous_user_name,1))
    return trace_error(mysql);
  trace_user(mysql,"test_user");

  printf("*********** add host localhost\n");
  previous_user_name= (const char*)user.user_name;
  user.hosts_num= 2;
  if (myx_set_user(mysql,&user,previous_user_name,0))
    return trace_error(mysql);
  trace_user(mysql,(const char*)user.user_name);

  printf("*********** allow to alter localhost test\n");
  user.user_object_privileges_num= 3;
  set_values(empty_db_privileges_40,size_empty_db_privileges_40,'Y','N');
  if (myx_set_user(mysql,&user,previous_user_name,0))
    return trace_error(mysql);
  trace_user(mysql,(const char*)user.user_name);
  
  myx_mysql_query(mysql, "create database TEST");

  printf("*********** forbid to alter localhost TEST\n");
  user.user_object_privileges_num= 6;
  set_values(empty_db_privileges_40_1,size_empty_db_privileges_40,'N','Y');
  if (myx_set_user(mysql,&user,previous_user_name,0))
    return trace_error(mysql);
  trace_user(mysql,(const char*)user.user_name);

  printf("*********** del user test_user1\n");
  if (myx_del_user(mysql,(const char*)user.user_name))
    return trace_error(mysql);
  trace_users(mysql);

  myx_mysql_query(mysql, "drop database TEST");

  return 0;
}

int test_with_mysql(MYSQL * mysql)
{
  if (!test_name)
    return common_test(mysql);

  if (!strcmp(test_name,"BUG_5440"))
    return test_for_BUG_5440(mysql);

  return common_test(mysql);
}

int test_with_connecton(MYX_USER_CONNECTION * user_conn)
{
  char * var;
  if ((var= getenv("my_cnf_path")))
    myx_set_my_cnf_path(var);

  MYSQL * mysql= myx_mysql_init();
  if (!mysql)
  {
    fprintf(stderr,"can't init mysql!\n");
    return -1;
  }
  else
  {
    int res;
    if (!myx_connect_to_instance(user_conn,mysql))
    {
      res= test_with_mysql(mysql);
    }
    else
    {
      fprintf(stderr,"can't connect to mysql!\n");
      res= -1;
    }
    myx_mysql_close(mysql);
    return res;
  }
}


int main(int argc, char* argv[])
{
  if (argc<2)
  {
    print_usage();
    return 0;
  }
  else
  {
    const char * connection_path= argv[1];
    if (argc>2)
      test_name= argv[2];
    MYX_LIB_ERROR err;
    MYX_USER_CONNECTIONS * connections=
                               myx_load_user_connections(connection_path,&err);
    if (!connections)
    {
      fprintf(stderr,"Can't read connection file \"%s\", error=%d\n",
              connection_path,(int)err);
      return -1;
    }
    else
    {
      int res;
      if (connections->user_connections_num)
      {
        res= test_with_connecton(connections->user_connections);
      }
      else
      {
        fprintf(stderr,"there aren't connections in the connection file\n");
        res= -1;
      }
      myx_free_user_connections(connections);
      return res;
    }
  }
}

