//
//  MSourceTextController.m
//  MySQLGUICommon
//
//  Created by Alfredo Kojima on 5/19/05.
//  Copyright 2005 MySQL AB. All rights reserved.
//

#import "MSourceTextController.h"
#import "MTextGutterView.h"
#import "MSourceTextView.h"
#import "MSourceLayoutManager.h"
#import "MSyntaxColoring.h"
#include "mxUtils.h"

@implementation MSourceTextController


- (void)applyDefaults
{
  [_textView setBackgroundColor:[_defaults objectForKey:@"BackgroundColor"]?:[NSColor whiteColor]];
  [_textView setFont:[_defaults objectForKey:@"TextFont"]?:[NSFont fontWithName:@"Monaco" size:11]];
}

- (id)init
{
  self= [super init];
  if (self)
  { 
    [MSyntaxColoring setupDefaultColors];
    
    _defaults= [[NSUserDefaults standardUserDefaults] retain];

    NSSize size;
    _textScroll= [[NSScrollView alloc] initWithFrame:NSMakeRect(0,0,200,200)];
    size= [_textScroll contentSize];
    _textView= [[MSourceTextView alloc] initWithFrame:NSMakeRect(0,0,size.width-2,size.height)];
    [_textScroll setHasVerticalScroller:YES];
    [_textScroll setHasHorizontalScroller:YES];
    [_textScroll setAutoresizesSubviews:YES];
    [[_textScroll contentView] setAutoresizesSubviews:YES];
    [_textScroll setAutoresizesSubviews:YES];
    [_textScroll setAutoresizingMask:NSViewHeightSizable|NSViewWidthSizable];
    [_textScroll setBorderType:NSBezelBorder];
    [_textScroll setDocumentView:_textView];
    [_textView setEditable:YES];
    [_textView setHorizontallyResizable:YES];
    [[_textView textContainer] setWidthTracksTextView:NO];
    [[_textView textContainer] setContainerSize:NSMakeSize(FLT_MAX, FLT_MAX)];
    [_textView setAutoresizingMask:NSViewHeightSizable|NSViewWidthSizable];
    [_textView setDelegate:self];
    [[NSNotificationCenter defaultCenter] addObserver:self
											 selector:@selector(viewBoundsDidChange:)
												 name:NSViewBoundsDidChangeNotification
											   object:[_textScroll contentView]];
        
    [self applyDefaults];
    _gutterWidth= 30.0;
    
    _bpGutter= [MXGetImageFromBundle([NSBundle bundleForClass:[self class]],@"gutter_breakpoint.png") retain];
    _pcGutter= [MXGetImageFromBundle([NSBundle bundleForClass:[self class]],@"gutter_current_pos.png") retain];
    _stGutter= [MXGetImageFromBundle([NSBundle bundleForClass:[self class]],@"gutter_query_start.png") retain];
  }
  return self;
}

- (void)dealloc
{
  [_bpGutter release];
  [_pcGutter release];
  [_defaults release];
  [_defaultKeyMapping release];
  [[NSNotificationCenter defaultCenter] removeObserver:self];
  [super dealloc];
}


- (void)setDelegate:(id)deleg
{
  _delegate= deleg;
}


- (void)resizeViews
{
  NSRect rect= [containerView frame];
  
  if (_gutterScroll)
  {
    NSRect grect, trect;
    
    rect.origin= NSMakePoint(0, 0);
    
    NSDivideRect(rect, &grect, &trect, _gutterWidth, NSMinXEdge);
    grect.size.width+= 1.0;
    [_gutterScroll setFrame:grect];
    [_textScroll setFrame:trect];
  }
  else
    [_textScroll setFrame:rect];
}

- (MSourceTextView*)textView
{
  return _textView;
}

- (void)setShowGutter:(BOOL)flag
{
  if (_showGutter != flag)
  {
    if (!flag)
    {
      [_gutterScroll removeFromSuperview];
      [_gutterScroll release];
      [_gutterView release];
      _gutterScroll= nil;
      _gutterView= nil;
    }
    else
    {
      _gutterScroll= [[NSScrollView alloc] initWithFrame:NSMakeRect(0,0,40,200)];
      _gutterView= [[MTextGutterView alloc] initWithFrame:NSMakeRect(0,0,40,200)];
      [_gutterView setDelegate:self];
      [_gutterScroll setDocumentView:_gutterView];
      [_gutterScroll setAutoresizingMask:NSViewHeightSizable];
      [_gutterScroll setAutoresizesSubviews:YES];
      [_gutterScroll setBorderType:NSBezelBorder];
      [_gutterView setLineHeight:[[_textView layoutManager] defaultLineHeightForFont:[_textView font]]];
      
      [containerView addSubview:_gutterScroll];
    }
    
    _showGutter= flag;
    
    [self resizeViews];
  }
}

- (void)setContainerView:(NSView*)view
{
  containerView= view;
  
  if (_gutterScroll)
    [view addSubview:_gutterScroll];
  [view addSubview:_textScroll];
  
  [self resizeViews];
}


- (void)gutterView:(MTextGutterView*)gutter drawLine:(unsigned int)line rect:(NSRect)rect
{
  if ([[_textView syntaxColorer] marker:@"breakpoint" atLine:line])
    [_bpGutter compositeToPoint:rect.origin operation:NSCompositeSourceOver];
  else if ([[_textView syntaxColorer] marker:@"statement" atLine:line])
    [_stGutter compositeToPoint:rect.origin operation:NSCompositeSourceOver];
}

- (void)gutterView:(MTextGutterView*)gutter clickedLine:(unsigned int)line
{
  MSyntaxColoring *colorer= [_textView syntaxColorer];

  if ([colorer marker:@"breakpoint" atLine:line])
    [colorer removeMarker:@"breakpoint" atLine:line];
  else
    [colorer addMarker:@"breakpoint" atLine:line];
  [_gutterView setNeedsDisplay:YES];
}

- (void)setSyntaxColorer:(MSyntaxColoring*)colorer
{
  [_textView setSyntaxColorer:colorer];
  [colorer setDelegate:self];
}

- (void)viewBoundsDidChange:(NSNotification*)notif
{
  [_gutterView setFrameSize:NSMakeSize(_gutterWidth, NSHeight([_textView frame])+[NSScroller scrollerWidth])];
  [_gutterView scrollPoint:NSMakePoint(0, [[_textScroll contentView] bounds].origin.y)];
}

- (void)syntaxColoringDidFinish:(MSyntaxColoring*)colorer
{
  [_gutterView setNumberOfLines:[[_textView syntaxColorer] numberOfLines]];
}

@end
