//
//  MSourceTextController.h
//  MySQLGUICommon
//
//  Created by Alfredo Kojima on 5/19/05.
//  Copyright 2005 MySQL AB. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class MTextGutterView;
@class MSourceTextView;
@class MSyntaxColoring;

@interface MSourceTextController : NSObject 
{
  IBOutlet NSView *containerView;
  
  NSScrollView *_gutterScroll;
  MTextGutterView *_gutterView;
 
  NSScrollView *_textScroll;
  MSourceTextView *_textView;
  
  float _gutterWidth;
  BOOL _showGutter;
  
  id _delegate;
  
  NSImage *_bpGutter;
  NSImage *_pcGutter;
  NSImage *_stGutter;

  NSUserDefaults *_defaults;
  NSDictionary *_defaultKeyMapping;
}

- (void)setShowGutter:(BOOL)flag;
- (void)setContainerView:(NSView*)view;

- (void)setDelegate:(id)deleg;

- (void)setSyntaxColorer:(MSyntaxColoring*)colorer;

- (MSourceTextView*)textView;

@end
