/* MQResultSetView */

#import <Cocoa/Cocoa.h>

#include <myx_public_interface.h>

@class MQResultSetDataSource;
@class MQTableView;
@class MAccessoryScrollView;
@class MSplitView;

typedef enum {
  MQDNone,
  MQDVertical,
  MQDHorizontal
} MQRSSplitDirection;

@interface MQResultSetView : NSObject
{
  IBOutlet MAccessoryScrollView *sview;
  IBOutlet MQTableView *table;
  IBOutlet NSView *view;
  IBOutlet MSplitView *splitView;
  IBOutlet NSTextField *statusLabel;
  IBOutlet NSTableView *messageTable;

  NSString *_query;
  NSString *_defaultSchema;
  
  MYSQL *_mysql;
  id _delegate;
  MQResultSetDataSource *_dataSource;
  
  NSColor *_statusColors[5];
  NSSize _editBarSizes[8];

  NSMutableArray *_viewers;
  MQRSSplitDirection _direction;
  id _messageDS;

  BOOL _closeable;
  BOOL _busy;
  BOOL _active;
  BOOL _compact;
}

- (IBAction)addRow:(id)sender;
- (IBAction)deleteRow:(id)sender;
- (IBAction)copyField:(id)sender;
- (IBAction)saveField:(id)sender;
- (IBAction)loadField:(id)sender;
- (IBAction)clearField:(id)sender;
- (IBAction)editField:(id)sender;
- (IBAction)viewField:(id)sender;

- (IBAction)editRS:(id)sender;
- (IBAction)commitRS:(id)sender;
- (IBAction)discardRS:(id)sender;
- (IBAction)goFirst:(id)sender;
- (IBAction)goLast:(id)sender;

- (void)setActive:(BOOL)flag;
- (BOOL)active;

- (void)splitV:(id)sender;
- (void)splitH:(id)sender;
- (void)unsplit:(id)sender;

- (id)initWithConnectionTo:(MYX_USER_CONNECTION*)info;

- (void)changeSplitDirection:(MQRSSplitDirection)newDir;
- (void)setDefaultSchema:(NSString*)schema;
- (MYSQL*)mysql;
- (NSString*)defaultCatalog;
- (NSString*)defaultSchema;

- (void)setCompact:(BOOL)flag;

- (MQTableView*)tableView;
- (id)view;

- (void)setDelegate:(id)delegate;

- (void)performQuery:(NSString*)query;
- (void)performApply;

- (void)setCloseable:(BOOL)flag;
- (BOOL)closeable;

- (BOOL)isBusy;

- (void)setQuery:(NSString*)query;
- (NSString*)query;

@end
