//
//  MSchemaEditHelper.m
//  MySQLGUICommon
//
//  Created by Alfredo Kojima on 3/23/05.
//  Copyright 2005 MySQL AB. All rights reserved.
//

#import "MSchemaEditHelper.h"
#import "MMySQLDispatcher.h"
#import "MSchemaDataSource.h"
#import "MDialogs.h"

#import "MTableEditor.h"
#include "myxutil.h"

@implementation MSchemaEditHelper


- (id)init
{
  self= [super init];
  if (self)
  {
    _editors= [[NSMutableArray alloc] init];
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(tableEditorChange:)
                                                 name:MTableEditorTableDidChange
                                               object:nil];
  }
  return self;
}

- (void)dealloc
{
  [_editors makeObjectsPerformSelector:@selector(close:) withObject:nil];
  [_editors release];
  
  [[NSNotificationCenter defaultCenter] removeObserver:self];
  [super dealloc];
}

- (void)tableEditorChange:(NSNotification*)notif
{
  [delegate performSelector:@selector(schemaHelperChangedSchemata:) withObject:self];
}

- (void)tableEditorClose:(NSNotification*)notif
{
  id window= [notif object];
  unsigned int i, c= [_editors count];
  for (i= 0; i < c; i++)
  {
    id obj= [_editors objectAtIndex:i];
    if ([obj window] == window)
    {
      [_editors removeObject:obj];
      break;
    }
  }
}


- (void)setConnection:(MYSQL*)mysql
{
  _mysql= mysql;
}

- (void)setDelegate:(id)deleg
{
  delegate= deleg;
}

- (IBAction)createSchema:(id)sender
{
  MStringRequestSheet *sheet= [MStringRequestSheet sheetWithTitle:@"Create Schema"
														   labels:[NSArray arrayWithObject:@"New Schema Name:"]];
  NSArray *name;
  
  if ((name= [sheet runModal:parentWindow]))
  {
	char *query;
	MYX_LIB_ERROR error;
    
	query= g_strdup_printf("create database `%s`", [[name objectAtIndex:0] UTF8String]);
    myx_query_execute_direct(_mysql,query,&error);
    g_free(query);
    
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(tableEditorClose:)
                                                 name:NSWindowWillCloseNotification
                                               object:nil];
  
    [delegate performSelector:@selector(schemaHelperChangedSchemata:) withObject:self];
  }
}

- (void)editSchema:(MSchemaItem*)item
{
  MStringRequestSheet *sheet= [MStringRequestSheet sheetWithTitle:@"Edit Schema"
														   labels:[NSArray arrayWithObject:@"Schema Name:"]];
  NSArray *name;

  if ((name= [sheet runModal:parentWindow]))
  {
	char *query;
	MYX_LIB_ERROR error;

	query= g_strdup_printf("create database `%s`", [[name objectAtIndex:0] UTF8String]);
    myx_query_execute_direct(_mysql, query, &error);
    g_free(query);

    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(tableEditorClose:)
                                                 name:NSWindowWillCloseNotification
                                               object:nil];

    [delegate performSelector:@selector(schemaHelperChangedSchemata:) withObject:self];
  }  
}

- (IBAction)createTable:(id)sender
{
  MSchemaItem *item= [outline itemAtRow:[outline selectedRow]];
  MYX_SCHEMA *schema= [item schema];
  MTableEditor *editor;
  
  if (schema)
  {
    editor= [[MTableEditor alloc] init];
    
    [editor setConnection:_mysql];
    [editor setCatalogs:(MYX_CATALOGS*)[[outline dataSource] catalogs]];
    [editor showNewTableForCatalog:NSStr(schema->catalog_name)
                            schema:NSStr(schema->schema_name)];
    
    [_editors addObject:editor];
    [editor setReleaseOnClose:YES];
  }
}

- (void)editTable:(MSchemaItem*)item
{
  MTableEditor *editor= [[MTableEditor alloc] init];
  MYX_SCHEMA_TABLE *table= [item table];
  MYX_SCHEMA *schema= [item schema];
  
  [editor setConnection:_mysql];
  [editor setCatalogs:(MYX_CATALOGS*)[[outline dataSource] catalogs]];
  [editor showTable:NSStr((char*)table->table_name) catalog:NSStr(schema->catalog_name)
             schema:NSStr(schema->schema_name)];
  
  [_editors addObject:editor];
  [editor setReleaseOnClose:YES];
}


- (void)dropTableAlertDidEnd:(NSAlert *)sheet 
                  returnCode:(int)returnCode
                 contextInfo:(void *)contextInfo
{
  MSchemaItem *item= (MSchemaItem*)contextInfo;
  char *query;
  MYX_LIB_ERROR error;
  
  [[sheet window] orderOut:self];
  
  if (returnCode != NSAlertAlternateReturn)
    return;

  query= g_strdup_printf("drop table `%s`.`%s`", [item schema]->schema_name, [item table]->table_name);
  myx_query_execute_direct(_mysql,query,&error);
  g_free(query);

  [delegate performSelector:@selector(schemaHelperChangedSchemata:) withObject:self];
}


- (void)dropTable:(MSchemaItem*)item
{
  NSAlert *alert = [NSAlert alertWithMessageText:@"Drop Table"
                                   defaultButton:@"Cancel" 
                                 alternateButton:@"Drop Table"
                                     otherButton:nil
                       informativeTextWithFormat:@"The table '%s' will be dropped and all data contained in it will be permanently erased.",
    [item table]->table_name];

  [alert beginSheetModalForWindow:parentWindow modalDelegate:self 
                   didEndSelector:@selector(dropTableAlertDidEnd:returnCode:contextInfo:) 
                      contextInfo:item];
}



- (void)dropSchemaAlertDidEnd:(NSAlert *)sheet 
                   returnCode:(int)returnCode
                  contextInfo:(void *)contextInfo
{
  MSchemaItem *item= (MSchemaItem*)contextInfo;
  char *query;
  MYX_LIB_ERROR error;
  
  [[sheet window] orderOut:self];
  
  if (returnCode != NSAlertAlternateReturn)
    return;
  
  query= g_strdup_printf("drop database `%s`", [item schema]->schema_name);
  myx_query_execute_direct(_mysql,query,&error);
  g_free(query);
  
  [delegate performSelector:@selector(schemaHelperChangedSchemata:) withObject:self];
}


- (void)dropSchema:(MSchemaItem*)item
{
  NSAlert *alert = [NSAlert alertWithMessageText:@"Drop Schema"
                                   defaultButton:@"Cancel" 
                                 alternateButton:@"Drop Schema"
                                     otherButton:nil
                       informativeTextWithFormat:@"The schema (database) '%s' will be dropped and all its tables will be permanently erased.",
    [item schema]->schema_name];

  [alert beginSheetModalForWindow:parentWindow modalDelegate:self 
                   didEndSelector:@selector(dropSchemaAlertDidEnd:returnCode:contextInfo:) 
                      contextInfo:item];
}


- (IBAction)createSP:(id)sender
{
}

- (IBAction)createView:(id)sender
{
}


- (IBAction)editSelection:(id)sender
{
  int row= [outline selectedRow];
  
  if (row >= 0)
  {
    MSchemaItem *item= [outline itemAtRow:row];
    
    switch (item->type)
    {
      case MSchemaItemType:
        break;
      case MTableItemType:
        [self editTable:item];
        break;
    }
  }    
}

- (IBAction)dropSelection:(id)sender
{
  int row= [outline selectedRow];
  
  if (row >= 0)
  {
    MSchemaItem *item= [outline itemAtRow:row];
    
    switch (item->type)
    {
      case MSchemaItemType:
        [self dropSchema:item];
        break;
      case MTableItemType:
        [self dropTable:item];
        break;
    }
  }    
}

@end
