/* Copyright (C) 2004 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/**
 * @file myx_gc_model.h 
 * @brief Implementation of the model that manages the visual representation in the generic canvas.
 * 
 */

#ifndef __GC_MODEL_H__
#define __GC_MODEL_H__

#include "myx_gc_style.h"

//----------------------------------------------------------------------------------------------------------------------

class CGenericCanvas;

class GENERIC_CANVAS_API CModelFigureListener: public CGCListener
{
  friend class CGCModel;
protected:
  CGCModel* model;
public:
  virtual void __cdecl onChange(CGCBase* sender, CGCBase* origin, TGCChangeReason reason);
  virtual void __cdecl onDestroy(CGCBase* sender);
  virtual void __cdecl onError(CGCBase* sender, CGCBase* origin, const char* message);
};

class GENERIC_CANVAS_API CGCModel: public CGCBase
{
  friend class CFigure;
  friend class CFigureParser;
  friend class CSVGParser;
  friend class CModelFigureListener;
private:
  CGenericCanvas* FCanvas;   // The canvas to which this model belongs and by which it is controlled.
  CLayoutList FLayouts;      // List of templates to create figures from.
  CFigureList FFigures;      // The list of concrete figures.
  CStyleList FStyles;        // A list of elements for visual representation of figure elements.
  CModelFigureListener FListener;
protected:
  void addFigure(CFigure* figure);
  void checkError(void);
  void removeFigure(CFigure* figure);
public:
  CGCModel(CGenericCanvas* Controller);
  virtual ~CGCModel(void);

  CGenericCanvas* canvas(void);
  void clearFigures(void);
  void clearLayouts(void);
  void clearStyles(void);
  CFigure* createFigure(wstring type, wstring layoutClass);
  CFigureTemplate* createLayout(wstring type, wstring layoutClass);
  CFigureTemplate* getLayout(const char* type, const char* layoutClass);
  CFigureTemplate* getLayout(wstring type, wstring layoutClass);
  virtual TGCVariant __cdecl property(const char* name, unsigned int index);
  virtual void __cdecl property(const char* name, unsigned int index, const TGCVariant& value);
  CGCStyle* style(wstring ID);
};

//----------------------------------------------------------------------------------------------------------------------

#endif // #ifdef __GC_MODEL_H__

