#import "MAStartupVariables.h"
#import "MAXMLGUIController.h"

@implementation MAStartupVariables

- (IBAction)discardChanges:(id)sender
{
  [_xmlGUI revertToSaved];
}

- (IBAction)saveChanges:(id)sender
{
  [_xmlGUI save];
}



+ (NSImage*)icon
{
  return [[[NSImage alloc] initWithContentsOfFile: 
    [[NSBundle mainBundle] pathForResource:@"startup_variables"
                                    ofType:@"png"]] autorelease];
}

+ (NSString*)label
{
  return @"Options";
}

+ (NSString*)toolTip
{
  return @"Configurable Startup Variables of the MySQL Server.";
}

- (id)initWithOwner: (id<MAdministratorProtocol>)owner
{
  int i;
  
  self= [super initWithNibFile: @"StartupVariables" panelOwner: owner];
  if (self)
  {
    _defaultFrame= [[self topView] frame];
    
#warning put correct version number and path
    [tabView removeTabViewItem:[tabView tabViewItemAtIndex:0]];
    _xmlGUI= [[MAXMLGUIController alloc] initInTabView:tabView
                                                 mysql:[_owner mysql]
                                               version:"4.0.0"
                                                  file:@"/etc/my.cnf"
                                               section:nil];
    [popup removeAllItems];
    for (i= 0; i < [tabView numberOfTabViewItems]; i++)
    {
      [popup addItemWithTitle:[[tabView tabViewItemAtIndex:i] label]];
    }
  }
  return self;
}

- (void)dealloc
{
  [_xmlGUI release];
  [super dealloc];
}

@end
