<?  ##############################################
   ### MySource ------------------------------###
  ##- Include Files ------ PHP4 --------------##
 #-- Copyright Squiz.net ---------------------#
##############################################
## This file is subject to version 1.0 of the
## MySource License, that is bundled with
## this package in the file LICENSE, and is
## available at through the world-wide-web at
## http://mysource.squiz.net/
## If you did not receive a copy of the MySource
## license and are unable to obtain it through
## the world-wide-web, please contact us at
## mysource@squiz.net so we can mail you a copy
## immediately.
##
## File: include/report.inc
## Desc: Parent class for system reporting
## $Source: /home/cvsroot/xtras/wizards/expired_users/expired_users.inc,v $
## $Revision: 1.1.2.8 $
## $Author: gsherwood $
## $Date: 2002/11/19 23:07:59 $
#######################################################################
global $INCLUDE_PATH;
include_once("$INCLUDE_PATH/wizard.inc");
#---------------------------------------------------------------------#

/**
* Expired Users Wizard
* A wizard to produce a list of all user accounts that are due 
* to expire today and in the future. The results can be
* for any or all organisations.
*
* @access public
* @package Wizards
*/
class Expired_Users extends Wizard {

	var $compatible_with = array('users');
	var $parameters = array('range' => '0',
							'export_type' => 'csv',
							'export_show_headers' => 0,
							'export_show_fields' => array('userid','login','firstname',
														 'surname','email','mobile_no',
														 'expiry_date','created_date','comments',
														 'title')
							  );


	 ##############################
	# Constructor
	function Expired_Users (&$asset) {	
		Wizard::Wizard($asset);
		$this->add_button('Export','Export',100,3);
	}


	/**
	* Returns an array of organisations for use in the select box
	*
	* @access public
	* @returns array
	*/
	function get_org_options() {
		$options = $this->caller->organisation_array_with_sticks();
		$options[0] = 'Unaffiliated Users';
		return $options;
	}


	function process_special_action($action) {
		$backend = &$this->get_backend();
		if ($action == 'Export') {
			# show the export options screen
			$backend->add_button('Export',"document.edit.action.value='Commit_Export';document.edit.submit()");
			$backend->add_button('Cancel',"document.edit.action.value='';document.edit.submit()");
			$pset = &$this->get_pset();
			$pset->print_screen($backend,'User Export');
			exit();
		} else if ($action == 'Commit_Export') {
			$pset = &$this->get_pset();
			$pset->process_screen($backend,'User Export');
			$this->process_export();
			exit();
		}
	}


	function process_export() {
		$userids = $this->get_userids();

		$export_type		 = $this->parameters['export_type'];
		$export_show_headers = $this->parameters['export_show_headers'];
		$export_show_fields  = $this->parameters['export_show_fields'];

		$fields = array();
		foreach ($export_show_fields as $field) $fields[$field] = 1;

		switch($export_type) {
			case 'xml' :
				$this->caller->xml_export($userids,$fields);
				break;
			default :
				$this->caller->csv_export($userids,$export_show_headers,$fields);
		}
	}



	function get_userids() {
		$db = &$this->get_db();

		$range = $this->parameters['range'];

		# make a list of organisationids
		$organisationids = '';
		foreach ($this->parameters['organisationids'] as $id) {
			if (!$id) continue;
			$organisationids .= "$id, ";
		}
		$organisationids = '(0'.substr($organisationids,0,-2).')';
		
		# if the user selected Unaffiliated Users as well,
		# ensure that these users are also displayed
		if (in_array(0,$this->parameters['organisationids'])) {
			$organisationids .= ' OR affiliation.organisationid IS NULL';
		}

		$range_date = '';
		$today = date('Y-m-d');
		$tomorrow = strtotime('+1 day');
		$tomorrow = date('Y-m-d', $tomorrow);

		
		switch($range) {
			case '0':
				$range_cond = "expiry_date = '$today'";
				$range_desc = 'that have expired today ('.date('jS F Y').')';
				break;
			case '1':
				$range_cond = "expiry_date = '$tomorrow'";
				$range_desc = 'due to expiry tomorrow ('.date('jS F Y',strtotime('+1 day')).')';
				break;
			default:
				$range_date = strtotime("+$range days");
				$range_cond = "expiry_date >= '$tomorrow' AND expiry_date <= '".date('Y-m-d', $range_date)."'";
				$range_desc = "due to expiry in the next $range days (up to and incl. ".date('jS F Y',$range_date).")";
		}
		
		$userids = $db->single_column("SELECT DISTINCT(user.userid) FROM user LEFT JOIN affiliation ON affiliation.userid=user.userid WHERE $range_cond AND (affiliation.organisationid IN $organisationids) ORDER BY expiry_date");

		return $userids;
	}

	 ########################################################################################
	# Prints the interface - assumes a backend has already been setup and the header printed
	function process_wizard(&$backend) {
		
		if (!method_exists($backend,'open_field')) $backend = &$this->get_backend();
		
		$userids = $this->get_userids();
		$backend->open_section("User accounts $range_desc");
		$backend->open_field('&nbsp;');
		$this->caller->display_users_table($userids,array(),array(),'page_counter',false,array('expiry_date' => 'Expiry Date'),'window.opener');

	}

}