<?  ##############################################
   ### MySource ------------------------------###
  ##- Include Files ------ PHP4 --------------##
 #-- Copyright Squiz.net ---------------------#
##############################################
## This file is subject to version 1.0 of the
## MySource License, that is bundled with
## this package in the file LICENSE, and is
## available at through the world-wide-web at
## http://mysource.squiz.net/
## If you did not receive a copy of the MySource
## license and are unable to obtain it through
## the world-wide-web, please contact us at
## mysource@squiz.net so we can mail you a copy
## immediately.
##
## File: xtras/page/templates/standard/standard.inc
## Desc: A page template class.. the standard template is the most generic you can get
## $Source: /home/cvsroot/xtras/page/templates/standard/standard.inc,v $
## $Revision: 2.0.4.1 $
## $Author: bvial $
## $Date: 2003/01/24 01:21:38 $
#######################################################################
global $INCLUDE_PATH, $SQUIZLIB_PATH;
include_once("$INCLUDE_PATH/page_template.inc");
include_once("$SQUIZLIB_PATH/bodycopy/bodycopy.inc");
#---------------------------------------------------------------------#

class Page_Template_Standard extends Page_Template {

	 ##############################################################
	# A title and a bodycopy. Simple requirments for a simple page
	var $title; 
	var $bodycopy; 

	 ##############################
	# Constructor
	function Page_Template_Standard($pageid) {
		return Page_Template::Page_Template($pageid);
	}


	 ######################################################################
	# Create a new record in the databse and load it into this object
	function create($pageid) {
		$message = Page_Template::create($pageid);
		if(!$this->id)	return false;
		$db = &$this->get_db();
		# Set the title to the title of the current page.
		$page = &$this->get_page($pageid);
		$db->update("UPDATE $this->table_name SET title = '".addslashes($page->name)."' WHERE pageid='$pageid'");
		$id = $this->load($pageid);
		return $message;
	}



	 ################################################
	# Loads the temaplte details, from cache or database
	function load($pageid) {
		if ($pageid <= 0 && !($pageid = $this->id)) { # Tries "re"loading
			$this->_set_error("Attempt to load $this->name page template without a valid pageid.",__FILE__,__LINE__);
		}

		 #################
		# Check the cache 
		if ($this->load_from_cache($pageid)) return $pageid;

		 #################################################
		# Load from the database - not everything though 
		$db = &$this->get_db();
		list($this->id,$this->title,$this->bodycopy) = $db->single_row("SELECT pageid, title, bodycopy FROM $this->table_name WHERE pageid='$pageid'");

		 #####################################
		# Create a new record if none exists
		if (!$this->id) {
			return $this->create($pageid);
		}

		$this->set_generated_information();

		 ###################
		# Save to the cache 
		$this->save_to_cache($pageid);
		return $pageid;
	}

	 #######################################################
	# Removes the extension utterly from existance !
	function delete()   {
		$bodycopy = new BodyCopy($this->bodycopy);
		$bodycopy->delete();
		return Page_Template::delete();
	}

	# dupe and new_id need no change from the default

	 #################################################################################
	# Provides an associative array of data that other templates might like to import
	function export_data() {
		return array("title"=>$this->title,"bodycopy"=>$this->bodycopy);
	}

	 
	 #################################################################################
	# Provides an associative array of data that other templates might like to import
	function import_data(&$data) {
		foreach($data as $code => $datum) {
			$code = strtolower(eregi_replace("[^a-z]+","",$code));
			if ($code == title || $code == name) {
				$this->title = $datum;
			}
			if ($code == bodycopy) {
				$this->bodycopy = $datum;
			}
		}
		$db = &$this->get_db();
		$db->update("UPDATE $this->table_name SET
			title='".addslashes($this->title)."',
			bodycopy='".addslashes($this->bodycopy)."'
			WHERE pageid='$this->id'");

		$this->clear_cache($this->id);
	}


	 ##############################################
	# Grabs keywords out of the title and bodycopy
	function extract_keywords() {
		$bodycopy = new BodyCopy($this->bodycopy, "bodycopy");
		return "$this->title ".strip_tags_padded($bodycopy->get_html());
	}


	 #################################
	# Change the title of the page
	function set_title($title) {
        if ($title == $this->title) return "";   
		$db = &$this->get_db();
        $this->title = $title;
        if ($db->update("UPDATE $this->table_name SET title='".addslashes($this->title)."' WHERE pageid='$this->id'"))  {
			$this->clear_cache();
            return "Title updated.";
        } else {
			return "";
		}
	}



	 ###############################################################
	# Set the bodycopy - assumes its all ready to shove in the db
	function set_bodycopy($bodycopy) {
        if ($bodycopy == $this->bodycopy) return "";   
		$db = &$this->get_db();
        $this->bodycopy = $bodycopy;
        if ($db->update("UPDATE $this->table_name SET bodycopy='".addslashes($this->bodycopy)."' WHERE pageid='$this->id'"))  {
			$this->clear_cache();
            return "Bodycopy updated.";
        } else {
            return "";
		}

	}


     ##################################################################
	# Prints the backend for the user - usually completely overwritten
	function print_backend() {

		$backend = &$this->setup_backend();
		$page = &$this->get_page();
		$db = &$this->get_db();

		$bodycopy = new BodyCopy($this->bodycopy, "bodycopy");

		global $action;
		switch($action) {
			case "Commit":
				global $title;
				$backend->add_message($this->set_title(gpc_stripslashes($title)));
				$backend->add_message($bodycopy->update("bodycopy"));
				$backend->add_message($this->set_bodycopy($bodycopy->pack()));
				$this->updated();
				break;
			default:
				break;
		}

		$backend->print_header();		

		$backend->open_section();		
		
		$backend->open_field("Title");		
		echo text_box(title,$this->title,50,128);

		$backend->open_field("Body&nbsp;Copy","top");
		$this->print_bodycopy_backend($bodycopy, "bodycopy");

		$backend->print_commit_button("Commit","document.edit.action.value='Commit';document.edit.submit();");

		$backend->print_footer();		
	}


	 ###########################################################
	# Returns the title as it should be printed on the frontend
	function get_title() {
		return $this->title;
	}


	  ##########################################################################
	 # Define print_body() - this *should* get called by the site's design xtra
	function print_body($abs=false) {
		$page = &$this->get_page();
		$bodycopy = new BodyCopy($this->bodycopy, "bodycopy");
		$bodycopy->paint($abs);
	}

}

?>
