<?  ##############################################
   ### MySource ------------------------------###
  ##- Include Files ------ PHP4 --------------##
 #-- Copyright Squiz.net ---------------------#
##############################################
## This file is subject to version 1.0 of the
## MySource License, that is bundled with
## this package in the file LICENSE, and is
## available at through the world-wide-web at
## http://mysource.squiz.net/
## If you did not receive a copy of the MySource
## license and are unable to obtain it through
## the world-wide-web, please contact us at
## mysource@squiz.net so we can mail you a copy
## immediately.
##
## File: xtras/page/templates/form/form.inc
## Desc: A template which allows the user to generate a customized form
## $Source: /home/cvsroot/xtras/page/templates/form/form.inc,v $
## $Revision: 2.26.2.16 $
## $Author: ramato $
## $Date: 2003/01/16 05:36:05 $
#######################################################################
global $INCLUDE_PATH, $SQUIZLIB_PATH;
include_once("$INCLUDE_PATH/page_template.inc");
include_once("$SQUIZLIB_PATH/bodycopy/bodycopy.inc");
include_once("$SQUIZLIB_PATH/form/form.inc");
include_once("$SQUIZLIB_PATH/csv/csv.inc");
include_once("$SQUIZLIB_PATH/xml/xml.inc");
include_once("$INCLUDE_PATH/parameter_set.inc");
include_once("$INCLUDE_PATH/html_body_format.inc");
#---------------------------------------------------------------------#

# Shoved in here so this old template works in the new system
class Page_Template_Form extends Page_Template {

	 ##############################################################
	# A title and a bodycopy. Simple requirments for a simple page
	var $parameters=array();

	 ##############################
	# Constructor
	function Page_Template_Form($pageid, &$system) {
		return Page_Template::Page_Template($pageid, &$system);
	}


	 ######################################################################
	# Create a new record in the databse and load it into this object
	function create($pageid) {
		global $SESSION;
		$message = Page_Template::create($pageid);
		if(!$this->id)	return false;
		$db = &$this->get_db();
		# Set the title to the title of the current page.
		$page = &$this->get_page($pageid);
		$this->parameters['copy']['title'] = $page->name;
		$form = new Form("form");
		$form->title($page->name);
		$form->offer_standard_var("file","type","page");
		$this->parameters['form'] = $form->pack();
		$db->update("UPDATE $this->table_name SET parameters='".addslashes(serialize($this->parameters))."' WHERE pageid='$pageid'");
		$id = $this->load($pageid);
		return $message;
	}




	 ################################################
	# Loads the temaplte details, from cache or database
	function load($pageid) {
		if ($pageid <= 0 && !($pageid = $this->id)) { # Tries "re"loading
			$this->_set_error("Attempt to load $this->name page template without a valid pageid.",__FILE__,__LINE__);
		}

		 #################
		# Check the cache 
		if ($this->load_from_cache($pageid)) return $pageid;

		 ########################
		# Load from the database
		$db = &$this->get_db();
		list($this->id, $tmp) = $db->single_row("SELECT pageid, parameters FROM $this->table_name WHERE pageid='$pageid'");
		$this->parameters = unserialize($tmp);

		 #####################################
		# Create a new record if none exists
		if (!$this->id) {
			return $this->create($pageid);
		}

		$this->set_generated_information();

		 ###################
		# Save to the cache 
		$this->save_to_cache($pageid);
		return $pageid;
	}

	 #######################################################
	# Removes the extension utterly from existance !
	function delete()   {
		return Page_Template::delete();
	}

	# dupe and new_id need no change from the default

	 #################################################################################
	# Provides an associative array of data that other templates might like to import
	function export_data() {
		return array("title"=>$this->get_title(),"bodycopy"=>$this->parameters['copy']['bodycopy'],"thankyou"=>$this->parameters['copy']['thankyou_bodycopy'],"form"=>$this->parameters['form']);
	}

	 
	 #################################################################################
	# Provides an associative array of data that other templates might like to import
	function import_data(&$data) {
		foreach($data as $code => $datum) {
			$code = strtolower(eregi_replace("[^a-z]+","",$code));
			if ($code == title || $code == name) $this->parameters['copy']['title'] = $datum;
			if ($code == bodycopy) 	$this->parameters['copy']['bodycopy'] = $datum;
			if ($code == form) 	$this->parameters['form'] = $datum;
			if ($code == thankyou) 	$this->parameters['copy']['thankyou_bodycopy'] = $datum;
		}
		$db = &$this->get_db();

		$db->update("UPDATE $this->table_name SET parameters='".addslashes(serialize($this->parameters))."'
			WHERE pageid='$this->id'");
		$this->clear_cache($this->id);
	}


	 ##################################################
	# Grabs keywords out of the title and bodycopy etc
	function extract_keywords() {
		$db = &$this->get_db();
		foreach($this->parameters[copy] as $code => $bit) {
			if(substr(stripslashes($bit),0,14) == 'O:8:"bodycopy"') {
				$bodycopy = new BodyCopy($bit, $code);
				$copy .= strip_tags_padded($bodycopy->get_html())." ";
			} else $copy .= "$bit ";
		}
		return $copy;
	}
	 #####################################
	# grabs the value for a valued option
	function &get_value($code) {
		return $this->parameters[$code];
	}

	 #####################################################
	# Prints the page copy, with some keyword replacement
	function get_copy($code, $replacements) {
		$copy = &$this->parameters[copy][$code];
		#if its a bodycopy, get the html and do the replacement on that instead
		if(substr(stripslashes($copy),0,14) == 'O:8:"bodycopy"') {
			$bodycopy = new BodyCopy($copy, $code);
			$copy = $bodycopy->get_html();
		}
		$copy = replace_keywords($copy, array_merge($this->get_universal_replacements(),$replacements));
		return $copy;
	}

	 #################################################
	# Returns an instance of a form in the parameters
	function &get_form($code) {
		$g = $this->table_name."_instanced_forms";
		global $$g;
		$l = &${$g}[$code];
		if(get_class($l) != "form") {
			$l = new Form($this->get_value($code));
		}
		return $l;
	}

	 #########################################
	# Prints a bit o' non-bodycopy copy
	function print_copy($code,$replacements) {
		echo eregi_replace("\r\n","<br>", $this->get_copy($code,$replacements));
		return;
	}

	 #########################################
	# Prints a bit o' cpoy
	function print_bodycopy($code,$replacements) {
		$bodycopy = new BodyCopy($this->parameters[copy][$code], $code);
		$bodycopy->add_replace_keywords(array_merge($this->get_universal_replacements(),$replacements));
		$bodycopy->paint();
		return;
	}
	


	 ######################################################
	# Returns an associaive array of universal replacements
	# These can be used to replace special keywords in copy
	function &get_universal_replacements($descs) {
		$k = &Page_Template::get_universal_replacements();
		$d = &Page_Template::get_universal_replacements(1);
		if($descs) return $d;
		return $k;
	}


	/**
	 ** Always returns true as for printer_friendly_pages this is a dynmaic page that needs special attention.
	 ** @public
	 ** @returns boolean
	 **/
	function is_dynamic() {
		return true;
	}

	 #################################################
	# Set which answers to which questions go where?
	function process_selective_emails() {
		$new_selective_email = $_POST['new_selective_email'];
		$selective_emails = $_POST['selective_emails'];

		$current_details = &$this->get_value('selective_emails');

		foreach($new_selective_email as $questionid => $val_emails) {
			if(valid_email($val_emails['email']) && !stristr($current_details[$questionid][$val_emails['val']],$val_emails['email'])) $current_details[$questionid][$val_emails['val']] .= $val_emails['email'].';';
		}
		if($current_details != $selective_emails) {
			foreach($current_details as $questionid => $val_emails) {
				foreach($selective_emails[$questionid] as $val => $emails) {
					$current_details[$questionid][$val] = "";
					$possible_emails = split("[\; ]+",$emails);
					if(count($possible_emails) > 1)	{
						foreach($possible_emails as $email) {
							if(!valid_email($email)) continue;
							$current_details[$questionid][$val] .= $email.";";
						}
					}
				}
			}
			$db = &$this->get_db();
			if ($db->update("UPDATE $this->table_name SET parameters='".addslashes(serialize($this->parameters))."' WHERE pageid='$this->id'"))  {
				$this->clear_cache();
				return $message."Selective emails updated.";
			} else {
				return;
			}
		}
		return;
	}

	 #################################################
	# Set keywords for formelements
	function process_formelements_keyword() {
		$formelements_keyword = $_POST['formelements_keyword'];
		$current_details = &$this->get_value('formelements_keyword');

		$changed = false; # have any of the keywords been changed ?
		# Check if any of the submitted values are different
		# from what we have stored currently in the database
		foreach ($formelements_keyword as $questionid => $keyword) {
			if ($keyword != $current_details[$questionid]) {
				$changed = true;
				$current_details = $formelements_keyword;
				break; #as soon as we find one different, just save them all
			}
		}
		
		# If any of the keywords have been changed, update the database
		if ($changed) {
			$db = &$this->get_db();
			$query = "UPDATE $this->table_name SET parameters='".addslashes(serialize($this->parameters))."' WHERE pageid='$this->id'";
			if ($db->update($query))  {
				$this->clear_cache();
				return "Form Element keywords updated.";
			} else {
				return;
			}
		}
		return;
	}

	 ###############################################################
	# Insert serialized answers of this form into the database
	function set_log_answers($answers) {
		global $SESSION;
		$db = &$this->get_db();
		$db->insert("INSERT INTO $this->table_name"."_log (pageid,submission_time,answers,userid,sessionid) VALUES ('$this->id',now(),'".addslashes($answers)."','".$SESSION->user->id."','".session_id()."')");
		return "";
	}



	 ##################################################################
	# Prints the backend for the user - usually completely overwritten
	function print_backend() {
		$db = &$this->get_db();
		$forms = $db->associative_array("SELECT * FROM $this->table_name");
		$form = current($forms);
		if($form['title']) { 
			# its oldstyle! 
		}

		global $PARAMETER_SCREEN, $action;
		if($_POST['form_export']) { # someone clicked the export button
			switch($_POST['export_type']) {
				case 'csv': $this->csv_export(); return; 
				case 'xml': $this->xml_export(); return;
			}
		}
		$backend = &$this->setup_backend();		
		$backend->set_hidden_field('action');
		$pset = &$this->get_pset();
		$pset->set_tabs($backend,"template_screen", $this->get_backend_href());
		if($pset->process($backend)) {
			$this->save_parameters();
		}

		# prints the rest of the tabs at the top
		$pset->print_backend($backend);
		return;
	}

	 ######################################################
	# Lets print the selective email addresses
	function print_selective_emails() {
		$form = $this->get_form("form");
		$backend = &$this->get_backend();
		$questions = $form->get_questions_by_type("listbox");
		$questions = array_merge($questions,$form->get_questions_by_type("tickbox"));
		if(count($questions)) {
			foreach($questions as $questionid => $title) {
				$question = &$form->get_question_ref($questionid);
				$backend->open_field($title,"top");
				echo "<table><tr><td>";
				echo combo_box("new_selective_email[$questionid][val]",$question->options(),"");
				echo "</td><td>";
				echo text_box("new_selective_email[$questionid][email]","",20,128);
				echo "</td></tr>";
				foreach($this->parameters['selective_emails'][$questionid] as $val => $emails) {
					if(in_array($val,$question->options()) && $emails) echo '<tr><td><b>'.$val.'</b></td><td>'.text_box("selective_emails[$questionid][$val]",$emails,50,128).'</td></tr>';
				}
				echo "</table>";
			}
		}
	}


	 ######################################################
	# Decide whether or not to print the selective emails
	function show_if_selective_emails() {
		$form = $this->get_form("form"); 
		$questions = $form->get_questions_by_type("listbox");
		$questions = array_merge($questions,$form->get_questions_by_type("tickbox"));
		if(count($questions)) {
			return true;
		} else {
			return false;
		}
	}
		

	 #####################################
	# Lets print the formelements keyword
	function print_formelements_keyword() {
		$form = $this->get_form("form");
		$backend = &$this->get_backend();
		$questions = $form->get_questions_by_type("listbox");
		$questions = array_merge($questions,$form->get_questions_by_type("tickbox"));
		$questions = array_merge($questions,$form->get_questions_by_type("textbox"));
		$questions = array_merge($questions,$form->get_questions_by_type("hidden"));
		if(count($questions)) {
			foreach($questions as $questionid => $title) {
				$backend->open_field($title,"top");
				echo '<table>';
				if ($this->parameters['formelements_keyword'][$questionid] != '') {
					echo '<tr><td><b>'.$val.'</b></td><td>'.text_box("formelements_keyword[$questionid]",$this->parameters['formelements_keyword'][$questionid],50,128).'</td></tr>';
				} else {
					echo '<tr><td><b>'.$val.'</b></td><td>'.text_box("formelements_keyword[$questionid]",$this->parameters['formelements_keyword'][$questionid],50,128).'</td></tr>';
				}

				echo "</table>";
			}
		}
	}

	 ######################################################
	# Decide whether or not to print the selective emails
	function show_if_formelements_keyword() {
		$form = $this->get_form("form"); 
		$questions = $form->get_questions_by_type("listbox");
		$questions = array_merge($questions,$form->get_questions_by_type("tickbox"));
		$questions = array_merge($questions,$form->get_questions_by_type("textbox"));
		$questions = array_merge($questions,$form->get_questions_by_type("hidden"));
		if(count($questions)) {
			return true;
		} else {
			return false;
		}
	}


	 ############################################################
	# Prints a list of the fields available to export for the csv
	function print_csv_export_fields() {
		$backend = &$this->get_backend();
		$form = &$this->get_form("form");
		echo "<table>";
		echo "<tr><td><input type=checkbox name=other_fields[submission_time] value=1 checked></td><td>Submission Time</td></tr>";
		echo "<tr><td><input type=checkbox name=other_fields[userid] value=1 checked></td><td>User</td></tr>";
		reset($form->sections);
		$section_index = 0;
		while(list($sectionid,$section) = each($form->sections)) {
			$section_var_prefix = "section_$sectionid"."_";
			reset($section[questions]);
			while(list($questionid,$question) = each($section[questions])) {
				$question_index++;
				$question_var_prefix = $section_var_prefix."question_$questionid";
				echo "<tr><td><input type=checkbox name=form_fields[$question_var_prefix] checked></td><td>";
				echo "$question->title</td></tr>";
			}
		}
		echo "</table>";
		echo '<input type=hidden name="form_export" value="">';
		$backend->print_icon_button("javascript: document.edit.action.value='Export Submission History';document.edit.form_export.value=1;document.edit.submit();","Export Submission History","find");
		return;
	}


	 ###########################
	# prints a list of the logs
	function print_log_history() {
		$db = &$this->get_db();
		if($_POST['delete_logid']) {
			$db->delete("delete from $this->table_name"."_log where logid='".$_POST['delete_logid']."'");
		}

		$logids = $db->single_column("SELECT logid FROM $this->table_name"."_log WHERE pageid='$this->id'");
		$users_system = &get_users_system();
		global $log_page;
		if (!$log_page) $log_page = 1;
		
		if (count($logids)) {
			$log_count  = count($logids);
			$per_page    = 50;
			$page_count  = ceil($log_count / $per_page);
			if ($log_page > $page_count) $log_page = $page_count;
			$offset      = ($log_page - 1) * $per_page;

			$logs = $db->associative_array("SELECT logid,submission_time,userid FROM $this->table_name"."_log WHERE pageid='$this->id'");
		?>
			<input type="hidden" name="log_page" value="<?=$log_page?>">
			<input type="hidden" name="view_logid" value="">
			<input type="hidden" name="delete_logid" value="">
			<table cellpadding=2 cellspacing=2 border=0>
				<tr>
					<td><p class=field>ID</td>
					<td><p class=field>Submission Time</td>
					<td><p class=field>User</td>
					<td>&nbsp;</td>
				</tr>
			<?
			foreach($logs as $logid => $data) {
				$user = $users_system->get_user($data["userid"]);
				?>
				<tr bgcolor=#d0d0d0>
					<td align="right"><p class=data><?=$logid?></td>
					<td><p class=data><?=readable_datetime(mysql_to_timestamp($data["submission_time"]))?></td>
					<td><p class=data><? echo (($user->id)?"<a href=\"user.php?userid=".$user->id."\">".$user->name()."</a>":"Anonymous") ?></td>
					<td><input type="button" name="view" value="View Log" onClick="javascript:document.edit.view_logid.value=<?=$logid?>;document.edit.form_export.value=0; document.edit.submit(); return false;">
					<input type="button" name="delete" value="Delete Log" onClick="javascript:if(confirm('Are you sure you want to delete this submission?')) 			{ document.edit.delete_logid.value=<?=$logid?>;document.edit.form_export.value=0; document.edit.submit(); return false;}">
					</td>
				</tr>
				<?
			}
			if ($page_count > 1) {
			?>
				<script language=javascript>
					function jump_log_page(p) {
						document.edit.log_page.value = p;
						document.edit.submit();
					}
				</script>
				<tr>
					<td colspan=1 align=left><b>
					<? if ($log_page > 1) { ?>
						<a href="javascript:jump_log_page(<?=($log_page-1)?>);" onmouseover="javascript: window.status='View the previous page of logs'; return true;" onmouseout="javascript: window.status=''; return true;">&lt;&lt; Prev</a>
					<? } else { ?>
						&lt;&lt; Prev
					<? }#end if ?>
					</td>
					<td colspan=2 align=center><font face=arial size=2><? echo("Page $log_page of $page_count") ?></td>
					<td colspan=1 align=right><font face=arial size=><b>
					<? if ($log_page != $page_count) { ?>
						<a href="javascript:jump_log_page(<?=($log_page+1)?>);" onmouseover="javascript: window.status='View the next page of logs'; return true;" onmouseout="javascript: window.status=''; return true;">Next &gt;&gt;</a>
					<? } else { ?>
						Next &gt;&gt;
					<? }#end if ?>
					</td>
				</tr>
				<tr>
					<td colspan=4>
						<font face=courier>
						<?
						$digits = strlen((int) $page_count);

						for($i = 1; $i <= $page_count; $i++) {
							$num = sprintf("%0$digits"."d",$i);
							if ($i == $log_page) { 
							?>
								<span style="color:red;"><?=$num?></span>
							<?
							} else {
							?>
								<a href="javascript:jump_log_page(<?=$i?>)" onmouseover="javascript: window.status='Jump to page <?=$i?> of the logs'; return true;" onmouseout="javascript: window.status=''; return true;"><?=$num?></a>
							<?
							}
						}

						?>						
					</td>
				</tr>
			<?
			}
			?>
			</table>
			<? 
		} else {
			echo "<p class=data>None";
		}
		return;
	}




	 ##########################
	# prints an individual log. 
	function print_individual_log_details() {
		$db = &$this->get_db();
		$users_system = &get_users_system();
		$logid = $_POST['view_logid'];

		if($logid) {
			$backend = &$this->get_backend();
			$log = $db->single_row("SELECT * FROM $this->table_name"."_log WHERE logid='$logid'");
			$user = $users_system->get_user($log["userid"]);

			$form = $this->get_form("form");
			$form->import_answers($log["answers"]);

			$backend->open_field("Submission Time");
			echo "<p class=data>".readable_datetime(mysql_to_timestamp($log["submission_time"]));
			$backend->open_field("Submitted By");
			echo (($user->id)?"<a href=\"user.php?userid=".$user->id."\">".$user->name()."</a>":"Anonymous");

			$backend->open_field("Answers","top");
			$form->print_answers();
		} else {
			echo "No log chosen.";
		}
		return;
	} 

	 ###########################################################
	# Returns the title as it should be printed on the frontend
	function get_title() {
		return $this->get_copy('title');
	}

	 ###########################################################################
	# This is where the REAL frontend happens. We like to be in the right scope
	function print_body() {
		global $SESSION;
		$system_config = &get_system_config();
		$page = &$this->get_page();
		$site = &$this->get_site();

		$form_format = $this->get_copy('form_format');

		if($this->get_value('paginate')) {
			$current_page = $_POST['current_page'];
			if(!$current_page) {
				$form = $this->get_form("form");
				$current_page = 1;
			} else {
				if(!$form = &$SESSION->get_var("form_$this->id")) {
					$form = $this->get_form("form");
				} else {
					$form = new Form($form);
				}
			}
			if($current_page >= count($form->sections)) $end = true;
		} else {
			$form = $this->get_form("form");
			$end = true;
		}

		global $moving_back;
		if(!$moving_back) {
			if ($form->process($current_page)) {
				$form->check_results = array();
				if(!$form->check($current_page)) {
					$results = $form->check_results;
					echo("<p><span class=error>You have not filled out this form correctly:</span></p>");
					echo("<ul>");
					foreach($results as $result) {
						echo "<li><span class=error>$result</span></li>";
					}
					echo("</ul>");

					# if we decide to put a reject message bodycopy in use this code...
					# $problems = $form->check_results;
					# $problems = "<ul><li>".implode("</li><li>",$problems)."</li></ul>";
					# $this->print_bodycopy("reject_message",array("problems"=>$problems));

				} elseif($end) {
					$extra_data  = "Site: $site->name (ID: $site->id)\n";
					$extra_data .= "Page: $page->name (ID: $page->id)\n";
					

					if ($SESSION->logged_in()) {
						$extra_data .= "User: ".$SESSION->user->name()." (ID: ".$SESSION->user->id.")\n";
					}
					if(!($name  = $form->get_requested_information("name")) && $SESSION->user) $name = $SESSION->user->name();
                    if(!($email = $form->get_requested_information("email")) && $SESSION->user) $email = $SESSION->user->email;

					if(valid_email($email)) {
						$name = ereg_replace("[\n\r\t]+"," ",$name);
						$from_email = (($name)?"$name <$email>":$email);
					} else {
						$from_email = $system_config->webmaster_email;
					}

					# for use replacing in various copies
					$replacements = array(); 
					$replace_answers = unserialize($form->export_answers());
					while(list($r_sectionid, $r_sectionvals) = each($replace_answers)) {
						while(list($r_questionid, $r_answer) = each($r_sectionvals)) {
							$r_index = "$r_sectionid.$r_questionid";
							# if it was a checkbox etc then the value will be an array. so go get
							# all the individual elements out of that. 
							if(is_array($r_answer['value'])) {
								$answerval = '';
								foreach($r_answer['value'] as $k => $v) {
									$answerval .= "$v,";
								}
								$answerval = trim($answerval, ",");
							} else {
								$answerval = $r_answer['value'];
							}
							$replacements[$this->parameters['formelements_keyword'][$r_index]] = $answerval;
						}
					}

					$replacements['name'] = $name;
					$replacements['email'] = $email;

					$recipient_email_text = $form->form_summary($this->get_value('recipient_html_email'),$extra_data."\n".$this->get_copy('recipient_email_body',$replacements));
					$receipt_email_text = $form->form_summary($this->get_value('receipt_html_email'),$extra_data."\n".$this->get_copy('receipt_email_body',$replacements));

					foreach(explode("\n",trim($this->parameters['recipient_emails'])) as $recipient_email) {
						if($this->get_value('recipient_html_email')) #add encoding
							$fromstring = "From: $from_email\nContent-Type: text/html; charset=iso-8859-1";
						else # plain text, no need
							$fromstring = "From: $from_email";

						# send it off...
						mail($recipient_email,"Form Submission - ".$this->get_title()."",$recipient_email_text,$fromstring,"-f$from_email");
					}
					if($this->get_value('receipt_email') && valid_email($email)) {
						if(!$receipt_from_email = current(explode("\n",trim($this->parameters['recipient_emails'])))) { 
							$receipt_from_email = $system_config->webmaster_email;
						}

						$fromstring = $receipt_from_email;

						if($this->get_value('receipt_html_email')) # add encoding string to end of 'From:' line
							$fromstring .= "\nContent-Type: text/html; charset=iso-8859-1";

						mail((($name)?"$name <$email>":$email),"Form Submission - ".$this->get_title()."",$receipt_email_text,"From: ".$fromstring,"-f$receipt_from_email");
					}
					foreach($this->get_value('selective_emails') as $questionid => $val_emails) {
						if(!$form->question_exists($questionid)) continue;
						$question = &$form->get_question_ref($questionid);
						$value = $question->value();
						if(is_array($value)) {
							foreach($value as $value) {
								$selective_email_recipients = array_merge(split("[\; ]+",$this->parameters['selective_emails'][$questionid][$value]),$selective_email_recipients);
							}
						} else {
							$selective_email_recipients = split("[\; ]+",$this->parameters['selective_emails'][$questionid][$value]);
						}
						foreach($selective_email_recipients as $email) {
							if($this->get_value('recipient_html_email')) # need to add encoding
								$fromstring = "From: $from_email\nContent-Type: text/html; charset=iso-8859-1";
							else # plain text
								$fromstring = "From: $from_email";

							if(valid_email($email)) mail($email,"Form Submission - ".$this->get_title(),$recipient_email_text,$fromstring,"-f$from_email");
						}
					}
					
					$friend_email = $form->get_requested_information("friend_email");
					$friend_body = str_replace("\n","\n\r",$this->get_copy('send_to_a_friend_body',$replacements));
					if($friend_email && !empty($friend_body)){
						if(valid_email($friend_email)) {
							$friend_subject = $this->get_copy('send_to_a_friend_subject',$replacements);
							if(empty($friend_subject)) {
								$friend_subject = 'Your friend has sent you an email from '.$site->name;
							}
							$friend_from_email = $this->get_copy('send_to_a_friend_from_email');
							if(!$friend_from_email) {
								# use the site name and webmaster email
								$friend_from_email =  ereg_replace("[\n\r\t]+"," ",$site->name)." <".$system_config->webmaster_email.">";
							} 
							mail($friend_email, $friend_subject, $friend_body, "From: ".$friend_from_email);
						}
					}

					if($this->get_value('log_form_submission')) {
						$this->set_log_answers($form->export_answers());
					}
					if ($this->get_value('hide_results')) {
						# If they are hiding the results, do a keyword substitution
						# on the html about to be output
						include_once("$INCLUDE_PATH/text.inc");
						$this->print_bodycopy("thankyou_bodycopy",$replacements);
#						echo replace_keywords($thankyou->get_html(), $keywords);
					} else {
						# If they are not hiding the results, display the page
						# as per normal
						$this->print_bodycopy('thankyou_bodycopy',$replacements);
						$form->print_answers();
					}
					return;
				} else {
					$current_page++;
				}
			}
		}

		$form_format = str_replace('section_?', 'section_'.($current_page), $form_format);

		if(!($current_page > 1)) {
			$this->print_bodycopy('bodycopy');
		} else {
			echo "<p>&nbsp;</p>";
		}

		?><form name="form" enctype="multipart/form-data" method=post><?
		if($SESSION->logged_in() && $current_page <= 1 && !$moving_back) {
			$users_system = &get_users_system();
			$form->answer_auto_answer("name",$SESSION->user->name());
			$form->answer_auto_answer("email",$SESSION->user->email);
			# Grab the first placement and use that
			$placement = reset($SESSION->user->placements);
			$location = &$users_system->get_location($placement[locationid]);
			$form->answer_auto_answer("phone",$placement[direct_phone]);
			$form->answer_auto_answer("mobile",$SESSION->user->mobile_no);
			$form->answer_auto_answer("fax",$placement[direct_fax]);
			$form->answer_auto_answer("s_address",$location->s_address);
			$form->answer_auto_answer("s_suburb",$location->s_suburb);
			$form->answer_auto_answer("s_state",$location->s_state);
			$form->answer_auto_answer("s_postcode",$location->s_postcode);
			$form->answer_auto_answer("s_countryid",$location->s_countryid);
		}
		$xtra_html = "<input type=\"hidden\" name=\"current_page\" value=\"$current_page\">";
		if($this->get_copy('back_button_text') && ($current_page > 1)) {
			$form_format = str_replace('%back_button%', "<input type=hidden name=moving_back value=\"\">
			<input type=button value=\"".$this->get_copy('back_button_text')."\" onclick=\"form.form_".$form->name()."_action.value='Submit Form';form.current_page.value='".($current_page-1)."';form.moving_back.value=1;form.submit();\">", $form_format);
		}
		$form->render($current_page,$xtra_html,false,$form_format);
		?></form><?
		$SESSION->set_var("form_$this->id",$form->pack());
	}

	 ###############################################################
	# Export data for the given fields between start and end dates
	function csv_export() {
		$other_fields = $_POST['other_fields'];
		$form_fields = $_POST['form_fields'];

		#construct a nice string yyyy-mm-dd
		$startdate = $_POST['export_from_datevalue']['y'].'-'.str_pad($_POST['export_from_datevalue']['m'],2,'0',STR_PAD_LEFT).'-'. str_pad($_POST['export_from_datevalue']['d'],2,'0',STR_PAD_LEFT);
		#construct a nice string yyyy-mm-dd
		$enddate = $_POST['export_to_datevalue']['y'].'-'. str_pad($_POST['export_to_datevalue']['m'],2,'0',STR_PAD_LEFT).'-'. str_pad($_POST['export_to_datevalue']['d'],2,'0',STR_PAD_LEFT);

		$db = &$this->get_db();
		$form = $this->get_form('form');
		$csv = new Csv();
		if($startdate > $enddate) return;
		$logs = $db->associative_array("SELECT * FROM $this->table_name"."_log l WHERE l.pageid='$this->id'".(($startdate)?" AND l.submission_time >= '$startdate 00:00:00' AND l.submission_time <= '$enddate 23:59:59'":""));
		if($this->get_value('show_field_headers')) {
			foreach($other_fields as $key => $on) {
				if($on) $field_headers[] = $key;
			}
			reset($form_fields);
			while(list($question_var_prefix,$on) = each($form_fields)) {
				if($on) {
					$sectionid = substr($question_var_prefix,8,strpos($question_var_prefix,"question_")-9);
					$questionid = substr($question_var_prefix,strpos($question_var_prefix,"question_")+9);
					$field_headers[] = $form->sections[$sectionid]["questions"][$questionid]->title;
				}
			}
			$csv->set_field_headers(&$field_headers);
		}
		while(list($logid,$log) = each($logs)) {
			$csv_fields = "";
			$answers = unserialize($log["answers"]);
			foreach($other_fields as $key => $on) {
				if($on) $csv_fields[] = $log[$key];
			}
			reset($form_fields);
			while(list($question_var_prefix,$on) = each($form_fields)) {
				if($on) {
					$sectionid = substr($question_var_prefix,8,strpos($question_var_prefix,"question_")-9);
					$questionid = substr($question_var_prefix,strpos($question_var_prefix,"question_")+9);
					$csv_fields[] = $answers[$sectionid][$questionid]["value"];
				}
			}
			$csv_data[] = $csv_fields;
		}
		$csv->set_filename("form_log_".date("Y-m-d").".csv");
		$csv->set_values(&$csv_data);
		$csv->export($csv_data);
		return;
	}

	 ###############################################################
	# Export data for the given fields between start and end dates
	function xml_export(&$other_fields,&$form_fields) {
		$db = &$this->get_db();
		$form = $this->get_form('form');

		#construct a nice string yyyy-mm-dd
		$startdate = $_POST['export_from_datevalue']['y'].'-'.str_pad($_POST['export_from_datevalue']['m'],2,'0',STR_PAD_LEFT).'-'. str_pad($_POST['export_from_datevalue']['d'],2,'0',STR_PAD_LEFT);
		#construct a nice string yyyy-mm-dd
		$enddate = $_POST['export_to_datevalue']['y'].'-'. str_pad($_POST['export_to_datevalue']['m'],2,'0',STR_PAD_LEFT).'-'. str_pad($_POST['export_to_datevalue']['d'],2,'0',STR_PAD_LEFT);

		$xml = new Xml();
		if($startdate > $enddate) return;
		$logs = $db->associative_array("SELECT * FROM $this->table_name"."_log l WHERE  l.pageid='$this->id'".(($startdate)?" AND l.submission_time >= '$startdate 00:00:00' AND l.submission_time <= '$enddate 23:59:59'":""));
		$xml->tag_open("formdata");
		while(list($logid,$log) = each($logs)) {
			$xml->tag_open("submission");
			$answers = unserialize($log["answers"]);
			foreach($other_fields as $key => $on) {
				if($on) {
					$xml->tag_open(ereg_replace("","_",$key));
					$xml->add_data($log[$key]);
					$xml->tag_close();
				}
			}
			reset($form_fields);
			while(list($question_var_prefix,$on) = each($form_fields)) {
				if($on) {
					$sectionid = substr($question_var_prefix,8,strpos($question_var_prefix,"question_")-9);
					$questionid = substr($question_var_prefix,strpos($question_var_prefix,"question_")+9);
					$xml->tag_open(ereg_replace(" ","_",$form->sections[$sectionid]["questions"][$questionid]->title));
					$xml->add_data($answers[$sectionid][$questionid]["value"]);
					$xml->tag_close();
				}
			}
			$xml->tag_close();
		}
		$xml->tag_close();
		$xml->set_filename("form_log_".date("Y-m-d").".xml");
		$xml->export();
		return;
	}

}

?>
