<?  ##############################################
   ### SQUIZLIB ------------------------------###
  ##- Bodycopy Editor ---- PHP4 --------------##
 #-- Copyright Squiz.net ---------------------#
##############################################
## This file is subject to version 1.0 of the
## MySource License, that is bundled with
## this package in the file LICENSE, and is
## available at through the world-wide-web at
## http://mysource.squiz.net/
## If you did not receive a copy of the MySource
## license and are unable to obtain it through
## the world-wide-web, please contact us at
## mysource@squiz.net so we can mail you a copy
## immediately.
##
## $Source: /home/cvsroot/squizlib/wysiwyg/pop_ups/insert_url_page_selector.php,v $
## $Revision: 1.2.2.1 $
## $Author: dchong $
## $Date: 2003/01/13 05:45:36 $
#######################################################################
include_once(dirname(__FILE__).'/../../../web/init.php');
include_once(dirname(__FILE__).'/../../html_form/html_form.inc');
# because this page gets the list of files each time is shouldn't be cached
header('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
header('Pragma: no-cache');
header('Expires: '. gmdate('D, d M Y H:i:s',time()-3600) . ' GMT');

$web   = &get_web_system();

# retrieve the current url link
$link = (isset($_GET['link'])) ? trim(gpc_stripslashes($_GET['link'])) : '';

# get the site, page and file id's of the page that we are editing
$current_siteid = (isset($_REQUEST['current_siteid'])) ? (int) gpc_stripslashes($_REQUEST['current_siteid']) : 0;
$current_pageid = (isset($_REQUEST['current_pageid'])) ? (int) gpc_stripslashes($_REQUEST['current_pageid']) : 0;

$action = (isset($_REQUEST['action'])) ? (int) gpc_stripslashes($_REQUEST['action']) : '';

# these are the id's for what the link actually points to, initially set to zero but when we start 
# refreshing ourselves we'll pass these through
$siteid = (isset($_REQUEST['siteid'])) ? (int) gpc_stripslashes($_REQUEST['siteid']) : 0;
$pageid = (isset($_REQUEST['pageid'])) ? (int) gpc_stripslashes($_REQUEST['pageid']) : 0;
$fileid = (isset($_REQUEST['fileid'])) ? (int) gpc_stripslashes($_REQUEST['fileid']) : 0;


# if there is a link passed through check if it is in 
# a form we can understand, if so reset the site, page or file id's
if ($link != '') {
	if (preg_match('/^.\/\?([spf])=([0-9]+)$/', $link, $matches)) {
		# depending on what type of link it is get the id's from different places
		switch($matches[1]) {
			# a file link
			case 'f' :
				$fileid = (int) $matches[2];
			break;
			# a page link
			case 'p' :
				$pageid = (int) $matches[2];
			break;
			# a site link
			case 's' :
				$siteid = (int) $matches[2];
			break;
		}#end switch

		if ($fileid) {
			$file = &$web->get_file($fileid);
			if ($file->id) {
				$pageid = $file->pageid;
			} else {
				$fileid = 0;
			}#end if
		}#end if
				
		if ($pageid) {
			$page = &$web->get_page($pageid);
			if ($page->id) {
				$siteid = $page->siteid;
			} else {
				$pageid = 0;
				$fileid = 0;
			}#end if
		}#end if
				
		if ($siteid) {
			$site = &$web->get_site($siteid);
			if (!$site->id) {
				$siteid = 0;
				$pageid = 0;
				$fileid = 0;
			}#end if
		}#end if

	}#end if preg match

# else set the site and page to the current site and current page if they aren't set to anything
} else {
	if (!$siteid) {
		$siteid = $current_siteid;
		$pageid = $current_pageid;
	}

}#end if 


$can_upload_file = ($pageid == $current_pageid);

?>
<html>
<head>
<style type="text/css">
	body { 
		background-color: #c0c0c0; 
	}
	td, input { 
		font-family: "MS Sans Serif"; font-size: xx-small; 
	}
	select { 
		font-family: "Courier, monospace"; 
		font-size: xx-small; 
		vertical-align: middle; 
	}
	table.dlg { 
		border:0; 
	}
	.dlg td { 
		align: left; height: 20; 
	}
	.dlg input { 
		border-size: 2px; 
	}
	input.button { 
		border-top: 1px solid white; 
		border-left: 1px solid white;
		border-bottom: 1px solid black; 
		border-right: 1px solid black;
		font-size: x-small; 
		width: 60; 
	}
	select { 
		height: 75%; 
	}

	input, select { 
		font-family: Arial, Verdana, Sans-Serif; 
		font-size: 10px; 
	}

</style>
<title>Insert URL Page Selector</title>
<script language="JavaScript" type="text/javascript" src="<?=squizlib_href('js','form_functions.js')?>"></script>
<script language="JavaScript" type="text/javascript" src="<?=squizlib_href('js','general.js')?>"></script>
<script language="JavaScript" type="text/javascript" src="<?=squizlib_href('js','debug.js')?>"></script>
<script language="JavaScript">

	function init() {

		var f = document.edit
		self.parent.set_page_selector_status('');
		// if a page has been selected then give that combo the focus, 
		// otherwise give the site combo focus
		//if (elementValue(f.pageid) != '') f.pageid.focus();
		//else f.siteid.focus();


	}// end set_page_url()

	function set_site_url(f) {

		var siteid = elementValue(f.siteid);
		if (siteid != "") {
			self.parent.set_url("", "./?s=" + siteid, null, false);
			// now just refresh so that we get that sites page list appears correctly
			self.parent.set_page_selector_status('Refreshing, please wait...');
			f.submit();
		}// end if

	}// end set_page_url()

	function set_page_url(f, refresh) {

		var pageid = elementValue(f.pageid);
		if (pageid != "") {

			self.parent.set_url("", "./?p=" + pageid, null, false);
			if (refresh) {
				// now just refresh so that we get that pages file list appearing
				self.parent.set_page_selector_status('Refreshing, please wait...');
				f.submit();
			}
		// if they have selected the blank, then set the url to the site link
		} else {
			set_site_url(f);

		}// end if

	}// end set_page_url()

	function set_file_url(f) {

		var fileid   = elementValue(f.fileid);
		if (fileid != "") {
			self.parent.set_url("", "./?f=" + fileid, "", false);
		// if they have selected the blank, then set the url to the page link
		} else {
			set_page_url(f, false);
		}// end if

	}// end set_file_url()

	function save_fileid(fileid, filename) {
		var f = document.edit
		if (fileid != "") {
			var option_num = 0;
			option_num = f.fileid.options.length;
			f.fileid.options[option_num] = new Option(filename, fileid);
			f.fileid.selectedIndex = option_num;

			set_file_url(f);
		
		}// end if

	}// end save_fileid()

	save_popup_fileid = save_fileid;

	var file_upload_progress_interval_id = 0;
	var file_upload_progress_counter     = 0;
	var file_upload_progress_counter_str = '';
	function start_new_file_upload_progress() {
		file_upload_progress_counter     = 0;
		file_upload_progress_interval_id = setInterval(increment_new_file_upload_progress, 250);
	}// end start_new_file_upload_progress()

	function increment_new_file_upload_progress() {

		if (file_upload_progress_counter == 0) {
			file_upload_progress_counter_str = 'Uploading ';
			set_new_file_upload_progress(file_upload_progress_counter_str);
			file_upload_progress_counter++;
			return;

		} else if (file_upload_progress_counter > 30) {
			file_upload_progress_counter = -1;
		} 

		file_upload_progress_counter_str += '-';
		set_new_file_upload_progress(file_upload_progress_counter_str + '>');
		file_upload_progress_counter++;

	}// end stop_new_file_upload_progress()

	function stop_new_file_upload_progress() {
		if (file_upload_progress_interval_id) clearInterval(file_upload_progress_interval_id);
		file_upload_progress_counter_str  = ' ';
		set_new_file_upload_progress(file_upload_progress_counter_str);
	}// end stop_new_file_upload_progress()

	function set_new_file_upload_progress(text) {
		self.parent.set_page_selector_status(text);
	}// end set_new_file_upload_progress(text)

</script>
</head>

<body topmargin="0" leftmargin="0" onLoad="javascript: init();">
<form name="edit" action="<?=$_SERVER['PHP_SELF']?>" method="POST">
<input type="hidden" name="current_siteid" value="<?=$current_siteid?>">
<input type="hidden" name="current_pageid" value="<?=$current_pageid?>">
<table class="dlg" cellpadding="0" cellspacing="2" border="0" width="100%">
	<tr>
		<td>&nbsp;</td>
		<td valign="top">
			Sites :
		</td>
		<td valign="top">
		<?
			$sites = $web->get_editable_sites($SESSION->user->id);
			asort($sites);
			$sites[$current_siteid] = "[THIS SITE] ".$sites[$current_siteid];
			$sites = Array('' => '') + $sites;
			echo combo_box("siteid", $sites, $siteid, "onchange=\"set_site_url(this.form);\"");
		?>
		</td>
	</tr>
	<tr>
		<td>&nbsp;</td>
		<td valign="top">
			Pages :
		</td>
		<td valign="top">
		<?
			if (!$siteid) {
				echo 'No Site Selected';
			} else {
				$pages = $web->page_array_with_sticks($siteid);
				$pages = Array('' => '') + $pages;
				echo combo_box('pageid', $pages, $pageid, 'onChange="javascript: set_page_url(this.form, true);"');
			}
		?>
		</td>
	</tr>
	<tr>
		<td>&nbsp;</td>
		<td valign="top">
			Files :
		</td>
		<td valign="top">
		<?
			if (!$pageid) {
				echo 'No Page Selected';
			} else {
				$page = &$web->get_page($pageid);
				if ($page->id) $fileids = &$page->file_index;
				else $fileids = Array();

				# if there are no files and the page that we are displaying isn't the current page
				# (which means that we can't add files to it, therefore don't need the blank combo)
				if (!count($fileids) && !$can_upload_file) {
					echo 'No Files Available';

				} else {
					$files = Array('' => '');
					if ($fileids) {
						foreach($fileids as $id) {
							$file = &$page->get_file($id);
							$files[$id] = $file->filename;
						}
					}
					echo combo_box('fileid', $files, $fileid, 'onChange="javascript: set_file_url(this.form);"');

				}#end if
			}#end if no pageid
		?>
		</td>
	</tr>
<?
# only show the new button if the page displayed is the current page we are on
if ($can_upload_file) {
?> 
	<tr>
		<td>&nbsp;</td>
		<td valign="top">
			New File :
		</td>
		<td valign="top">
				<iframe id="new_file_uploader" src="new_file.php?siteid=<?=$siteid?>&pageid=<?=$pageid?>" scrolling="auto" width="100%" height="30" marginwidth="0" marginheight="0" frameborder="no"></iframe>
				<div id="new_file_uploader_status" style="color: red; font-size:8px;">&nbsp;</div>
		</td>
	</tr>
<?
}#end if
?>
</table>
</form>
</body>
</html>
