/*  ##############################################
   ### SQUIZLIB ------------------------------###
  ##- BodyCopy Include Files - Javascript ----##
 #-- Copyright Squiz.net ---------------------#
##############################################
## This file is subject to version 1.0 of the
## MySource License, that is bundled with
## this package in the file LICENSE, and is
## available at through the world-wide-web at
## http://mysource.squiz.net/
## If you did not receive a copy of the MySource
## license and are unable to obtain it through
## the world-wide-web, please contact us at
## mysource@squiz.net so we can mail you a copy
## immediately.
##
## Desc: JS functions needed for the Editing of the cell type "WYSIWYG"
## $Source: /home/cvsroot/squizlib/bodycopy/send_files/js/bodycopy_edit_table_cell_type_wysiwyg.js,v $
## $Revision: 2.0.4.1 $
## $Author: gsherwood $
## $Date: 2002/09/25 06:03:09 $
#######################################################################
*/

function bodycopy_edit_table_cell_type_wysiwyg(bodycopy_name, tableid, rowid, cellid) {

	bodycopy_current_edit["bodycopy_name"] = bodycopy_name;
	bodycopy_current_edit["data"] = new Object();
	bodycopy_current_edit["data"]["tableid"] = tableid;
	bodycopy_current_edit["data"]["rowid"]   = rowid;
	bodycopy_current_edit["data"]["cellid"]  = cellid;
	var data = get_bodycopy_current_data(bodycopy_name, tableid, rowid, cellid);
	bodycopy_current_edit["data"]["html"] = data["type"]["html"];

	// unfortunately the wysiwyg editor is IE 5.5 specific and only on a windows box :(, 
	// so Netscape users will have to use the RawHTML
	if (is_ie5_5up && is_win32) {
		bodycopy_show_popup("edit_table_cell_type_wysiwyg.php", 680, 400);
	} else {
		if (confirm('Unfortunately you are unable to use the WYSIWYG Editor that this cell has had it\'s cell type set to.\nYou will be given the Raw HTML editing interface. If you want to use the RichText editing interface, cancel and change the type of this cell to RichText.\n\nDo you want to use the Raw HTML interface?')) {
			bodycopy_show_popup("edit_table_cell_type_rawhtml.php", 650, 400);
		}
	}//end if

}// end bodycopy_edit_table_cell_type_wysiwyg()

function bodycopy_save_table_cell_type_wysiwyg(html) {

	bodycopy_current_edit["data"]["html"] = html;
	bodycopy_hide_popup();
	bodycopy_submit("edit table cell contents", bodycopy_current_edit["bodycopy_name"], bodycopy_current_edit["data"]);

}// end bodycopy_save_table_cell_type_wysiwyg()
