<?  ##############################################
   ### SQUIZLIB ------------------------------###
  ##- Bodycopy Editor ---- PHP4 --------------##
 #-- Copyright Squiz.net ---------------------#
##############################################
## This file is subject to version 1.0 of the
## MySource License, that is bundled with
## this package in the file LICENSE, and is
## available at through the world-wide-web at
## http://mysource.squiz.net/
## If you did not receive a copy of the MySource
## license and are unable to obtain it through
## the world-wide-web, please contact us at
## mysource@squiz.net so we can mail you a copy
## immediately.
##
## Desc: This allows the editing of the Files in a table cell
## $Source: /home/cvsroot/squizlib/bodycopy/bodycopy_table_cell_type_nest_content.inc,v $
## $Revision: 2.5.2.2 $
## $Author: gsherwood $
## $Date: 2002/11/21 05:09:24 $
#######################################################################
#---------------------------------------------------------------------#

 ####################################################################
# An array of the available cell types (class_name => display_name)
$_BODYCOPY['TABLE_CELL']['types']['bodycopy_table_cell_type_nest_content']
		= Array('name' => 'Nest Content', 
				'description' => 'This allows the nesting of another page contents into a cell');

   ####################################################################
  # this indicates to the class when it's printing the edit interface
 # whether another instance of it has already been printed, so it knows not to 
# print out the JS edit functions
$_BODYCOPY['TABLE_CELL_TYPE']['nest_content']['edit_initialised'] = false;


/** 
* @access public
* @package Bodycopy
*/
class BodyCopy_Table_Cell_Type_Nest_Content extends BodyCopy_Table_Cell_Type {
	
	var $pageid = ''; # the page we want to nest
	var $html = '';   # raw html code used for converting this file type

	 ##############################
	# Constructor
	function BodyCopy_Table_Cell_Type_Nest_Content() {
	}#end constructor

	 #########################################
	# set the pageid variable
	function set_pageid($pageid) {
		if ($this->pageid == $pageid) return '';
		# make sure we dont' reference ourselves
		$web  = &get_web_system();
		$page = &$web->get_page();
		if ($page->id == $pageid) return '';
		$this->pageid = $pageid;
		return 'Page updated';
	}

	 ##############################
	# Delete this bastard
	function delete() {
		unset($this);
		$this = new BodyCopy_Table_Cell_Type_Nest_Content();
		return true;
	}#end delete()

	 ###################################
	# paints the html
	function paint($from_backend=false, &$keyword_replacements) {

		# if there's no page the exit
		if (!$this->pageid) return;

		$web = &get_web_system();
		$page = &$web->get_page($this->pageid);
		if ($page->id) {
			if ($page->read_access()){
				$template = &$page->get_template();
				# if we aren't in the backend just print
				if (!$from_backend) {
					$template->print_body();
				# OK, we are in the backend, let's grab the html from the template 
				# and send it to paint_raw_html()
				} else {
					ob_start();
					$template->print_body();
					$html = ob_get_contents();
					ob_end_clean();
					$tmp = Array();
					$this->paint_raw_html($html, $tmp, true);
				}
			}
		}#end if

	}#end paint()

	 #################################################
	# Given a map of file and page ids from old to new
	# (usually during duplication of sites or pages)
	# this will change all the links etc in the bodycopy
	# to reflect the mapping
	function remap_link_ids(&$map) {
		if(isset($map['page'][$this->pageid]))
			$this->pageid = $map['page'][$this->pageid];
	}


	#####################################################
	# Given a fileid, cell type checks its contents to
	# see if the file is used
	function uses_file($fileid) {
		return false;
	}


	 #########################################################################
	# returns true if there is nothing to print (ie no content) for the cell
	function empty_cell() {
		if ($this->pageid) {
			$web = &get_web_system();
			$page = &$web->get_page($this->pageid);
			return ($page->id <= 0);
		} else {
			return true;
		}
		
	}#end empty_cell()


	  ###########################################################
	 # prints the JavaScript needed by the backend functions for 
	# this table 
	function print_backend_js_data($this_bodycopy_name, $tableid, $rowid, $cellid) {

		?> 
										retVal["type"]["pageid"]       = '<?=$this->js_string_escape($this->pageid, '\'')?>';
		<?

	}#end print_backend_js_data()

	 ############################################################
	# function to initialise some things need by this cell type
	# NOTE : should be able to be called without an instance of the object
	#        ie. NO references to $this
	#        eg.  BodyCopy_Table_Cell_Type_SOMENAME::init_backend();
	function init_backend() {
		global $_BODYCOPY;
		
		# do some thing for the first time we print this object on this page
		if (!$_BODYCOPY['TABLE_CELL_TYPE']['page']['edit_initialised']) {
			?><script language="JavaScript" src="<?=$_BODYCOPY['file_prefix']?>js/bodycopy_edit_table_cell_type_nest_content.js"></script><?
			$_BODYCOPY['TABLE_CELL_TYPE']['page']['edit_initialised'] = true;

		}#endif

	}#end init_backend()

	 #####################################################
	# prints the backend interface for this table cell
	function print_backend($this_bodycopy_name, $tableid, $rowid, $cellid) {
		
		# initilaise the backend for this cell type
		$this->init_backend();

		# print out the edit button
		print_bodycopy_icon("javascript: bodycopy_edit_table_cell_type_nest_content('$this_bodycopy_name', $tableid, $rowid, $cellid);", 'Edit the Contents of Cell '.($cellid + 1), '', 'edit_content');

	}#end print_backend()

	 #########################################################
	# process the input created by print_backend()'s popup
	function update($this_bodycopy_name='bodycopy', $tableid, $rowid, $cellid) {
		global $bodycopy_action, $bodycopy_name, $bodycopy_data; 
		global $_BODYCOPY;

		$msg = Array();

		switch($bodycopy_action) {
			case 'edit table cell contents' :
				if ($tmp_msg = $this->set_pageid($bodycopy_data['pageid'])) {
					$msg = array_merge($msg, $tmp_msg);
				}

				# save the html so this cell can be converted
				# to another cell type later
				ob_start();
				$this->paint();
				$this->html = ob_get_contents();
				ob_end_clean();

			break;
		}#end switch

		return $msg;

	}#end update()

}#end Class 

?>