<?  ##############################################
   ### MySource ------------------------------###
  ##- Include Files ------ PHP4 --------------##
 #-- Copyright Squiz.net ---------------------#
##############################################
## This file is subject to version 1.0 of the
## MySource License, that is bundled with
## this package in the file LICENSE, and is
## available at through the world-wide-web at
## http://mysource.squiz.net/
## If you did not receive a copy of the MySource
## license and are unable to obtain it through
## the world-wide-web, please contact us at
## mysource@squiz.net so we can mail you a copy
## immediately.
##
## File: include/report.inc
## Desc: Parent class for system reporting
## $Source: /home/cvsroot/mysource/include/wizard.inc,v $
## $Revision: 1.1.2.15 $
## $Author: gsherwood $
## $Date: 2003/01/19 22:51:21 $
#######################################################################
global $INCLUDE_PATH;
include_once("$INCLUDE_PATH/systemobject.inc");
include_once("$INCLUDE_PATH/parameter_set.inc");
#---------------------------------------------------------------------#


/**
* The base class for creating wizards
* The base class for creating wizards to guide users
* through the more complex actions in MySource
*
* @access  public
* @package Wizards
*/
class Wizard extends SystemObject {

	/**
	* The type of asset that calls us (page, site etc)
	* @var string
	*/
	var $asset_type = '';

	/**
	* A reference to the asset that called us
	* @var object
	*/
	var $caller;
	
	/**
	* An array to hold parameters for the pset
	* @var array
	* @see &get_pset()
	*/
	var $parameters = array();
	
	/**
	* A reference to the wizard backend object
	* @var object Wizard_Backend
	* @see &get_backend();
	*/
	var $backend;
	

	/**
	* The names of the standard wizard buttons
	* @var array
	*/
	var $button_names = array(	'back' => ' Back',
								'next' => 'Next ', 
								'start' => 'Start Over', 
								'finish' => 'Finish',
								'cancel' => 'Cancel'
								);

	/**
	* Array of buttons that we should use - NOT DONE YET
	* @var array
	*/
	var $buttons = array('back','next','start','finish','cancel');
	

	/**
	* An array to hold additional buttons to show on the various steps of the wizard
	* @var array
	*/
	var $special_buttons = array();


	/**
	* An XtrasRegistry of all the wizards that are available to us
	* @var object XtrasRegistry
	*/
	var $_types = array();


	/**
	* An array of asset types that this wizard is compatible with.
	* eg. array('site','page') - the wizard can be run on a site or page
	* @var array
	*/
	var $compatible_with = array();



	/**
	* Constructor
	*
	* @param   object &$asset A reference to the asset that called us
	* @returns object Wizard
	* @access  public
	*/
	function Wizard (&$asset) {
		global $XTRAS_PATH;
		SystemObject::SystemObject();
		$this->asset_type = get_class($asset);
		$this->caller = $asset;
		$this->_types = new XtrasRegistry($XTRAS_PATH.'/wizards/', 'Wizard');
	}


	/**
	* Prints a list of all the wizards that can be run by this asset type
	*
	* @returns void
	* @access  public
	*/
	function print_backend() {

		# Check if we are printing a wizard or if we need to select the type of wizard
		global $XTRAS_PATH;
		if ($wizard_type = $this->type_set()) {
			$wizard_type = $this->_types->register[$wizard_type];
			include_once($XTRAS_PATH.'/wizards/'.$wizard_type->codename.'/'.$wizard_type->codename.'.inc');
			$wizard = new $wizard_type->codename($this->caller);
			$wizard->print_wizard();
			return;
		}

		$web_system = &$this->get_web_system();	# get the web system
		$backend = &$web_system->get_backend();	# to get the mysource backend
		$wizards_available = array();			# (not the wizard backend)

		# loop through the wizards and add them to a category
		# the wizards are grouped by the category found in the xtra.info file
		foreach ($this->_types->register as $wizard_type) {
			# get the wizard - include the file and create the object
			include_once($XTRAS_PATH.'/wizards/'.$wizard_type->codename.'/'.$wizard_type->codename.'.inc');
			$wizard = new $wizard_type->codename($this->caller);

			# check that this wizard is compatible with the asset that called us
			if ($wizard->is_compatible($this->asset_type)) {
				# if the category is not set, add this wizard to the miscelaneous category
				if (!isset($wizard_type->extra_values['category'])) $wizard_type->extra_values['category'] = 'Miscellaneous';
				$wizards_available[$wizard_type->extra_values['category']][] = $wizard_type;
			}
		}

		if (!empty($wizards_available)) {
			foreach ($wizards_available as $category => $wizards) {
				$backend->open_section(ucfirst($category)); # print category name
				foreach ($wizards as $wizard_type) {
					$backend->open_field($wizard_type->name, 'top'); # print wizard name
					$wizard = new $wizard_type->codename($this->caller);
					$description = $wizard->get_description($wizard_type->description);
					# print a link to open the wizard
					?>
					<a href="#" onclick="window.open('<?=$this->get_wizard_link($wizard_type->codename)?>&wizard_start=1','<?=$this->get_code($wizard_type->codename)?>','toolbar=no,status=yes,width=700,height=350,titlebar=false,scrollbars=yes,resizable=yes');"><?=$description?></a><br>
					<?
					$backend->close_field();
				}
				$backend->close_section();
			}
		} else {
			# we got nothin'
			$backend->open_section('There are no wizards available.');
			$backend->close_section();
		}
	}



	/**
	* Returns a unique id string for this wizard
	*
	* @param   string $wizard_type The type of this wizard
	* @returns string
	* @access  public
	*/
	function get_code($wizard_type='') {
		if (!$wizard_type) $wizard_type = $this->type_set();
		return 'mysource_wizard_'.$this->_types->register[$wizard_type]->codename."_{$this->asset_type}_{$this->caller->id}";
	}



	/**
	* Returns a custom description for this wizard.
	*
	* If this fucnction returns an empty string, the description
	* from the Xtra.info file will be used instead. Override this
	* function for a custom description.
	*
	* @param   default string The default description from the Xtra.info file
	* @returns string
	* @access  public
	*/
	function get_description($default) {
		return $default;
	}



	/**
	* Is this wizard compatible with the asset that called us?
	*
	* This function will check the compatible_with array by default
	* so for basic wizards, this function does not have to be overridden
	* but for more complex wizards, other checks can be made
	*
	* @param   string $asset_type The type of asset we are checking the compatability of (eg. site, page etc)
	* @returns boolean
	* @access  public
	*/
	function is_compatible($asset_type) {
		return in_array($asset_type,$this->compatible_with);
	}



	/**
	* The function that actually prints the wizard
	*
	* This function handles moving between steps with the
	* back and forward buttons and also allows some interaction with
	* the wizard to process complex actions and print additional buttons
	*
	* @returns void
	* @access  public
	*/
	function print_wizard() {

		$wizard_start = $_REQUEST['wizard_start'];

		$session = &get_mysource_session();

		# the code for this wizards so we can find its params in the session
		$param_code = $this->get_code().'_params';

		# if we are starting the wizard (usually from the
		# Start Over button or from a new window opening),
		# clear the params in the session and set the defaults
		if ($wizard_start) {
			$session->unset_var($param_code);
			
			# set dynamic defaults such as dates
			# other defaults can be hard coded into the params array
			$this->set_defaults();
		}

		# get params from session if they are there
		if ($session->has_var($param_code)) {
			$this->parameters = $session->get_var($param_code);
		}

		$backend = &$this->get_backend(); # the wizard backend

		$backend->set_hidden_field('wizard_start','');
		$backend->set_hidden_field('active_step','');
		$backend->set_hidden_field('action','');

		# process any special actions for this wizard
		# the wizard needs to handle the processing and can then
		# change the global var $active_step at this point to trick
		# the wizard into displaying another screen
		$action = $_REQUEST['action'];
		$this->process_special_action($action);

		# working out the heading for this wizard
		# involves checking the caller object to see
		# what information we have access to (eg. an
		# ID, a name, a lineage) and then creating the
		# headng using a combination of these elements
		$heading = 'MySource '.$this->_types->register[$this->type_set()]->name.' Wizard';
		$heading .= '<br><span style="font-size:12px">';
		$heading .= ucfirst(get_class($this->caller));
		if (isset($this->caller->id)) {
			$heading .= ' '.$this->caller->id;
		} else {
			$heading .= ' System';
		}
		if (isset($this->caller->name)) $heading .= ' ('.$this->caller->name.')';
		if (method_exists($this->caller,'get_lineage')) {
			$lineage = $this->caller->get_lineage();
			if (count($lineage)) {
				$heading .= '</span><br><span style="font-size:10px">';
				# a special case for pages so we can put the
				# site name at the front of the lineage
				if (get_class($this->caller) == 'page') {
					$site = $this->caller->get_site();
					$heading .= strtoupper($site->name);
				}
				foreach($lineage as $pageid => $name) $heading .=  " &gt; $name";
			}
		}
		$heading .= '</span>';

		$backend->set_heading($heading);
		$pset = &$this->get_pset();

		# work out the number of steps we have by looking at the screen names in the pset
		# all screens for steps must be named with the step number
		# eg. ^1^ - the screen name for step 1
		#	  ^2^ - the screen name for step 2
		# it will ignore screens with non numeric names
		$screens = $pset->get_screen_names();
		$num_steps = 0;
		foreach($screens as $screen_name) {
			$screen_name = (int)$screen_name;
			if ($screen_name > 0 && $screen_name > $num_steps) $num_steps = $screen_name;
		}

		# what screen are we on - or at least think we are on?
		$active_step = (int)$_REQUEST['active_step'];

		# print a basic navigation to show the user where they are in the step-by-step process
		if ($active_step < $num_steps) $backend->set_subheading('Step '.($active_step+1)." of $num_steps");

		if ($active_step && $action == 'Commit') {
			# process the last screen
			$pset->process_screen($backend,$active_step);
		}

		# print the next screen or print the result of this wizard
		if ($active_step > $num_steps) $active_step = $num_steps;
		$active_step++;
		if ($active_step > 1) {
			$backend->add_button($this->button_names['back'],'document.edit.action.value=\'\';document.edit.active_step.value='.($active_step-2).';document.edit.submit()');
		}

		# add special buttons for this screen
		foreach ($this->special_buttons[$active_step] as $button => $data) {
			$backend->add_button($button,"document.edit.action.value='".$data['action']."';document.edit.active_step.value=".$data['skip_to'].";document.edit.submit()");
		}

		 # we are printing the result of this wizard
		if ($active_step > $num_steps) {
			$backend->add_button($this->button_names['start'],'document.edit.action.value=\'\';document.edit.wizard_start.value=1;document.edit.submit()');
			$backend->print_header();
			$this->process_wizard($backend);
			$backend->print_commit_button();
			$backend->print_footer();
		} else {

			$backend->add_button($this->button_names['cancel'],'if (confirm(\'Are you sure you want to cancel?\')) { window.close(); }');
			if ($active_step == $num_steps) {
				$backend->add_button($this->button_names['finish'],"document.edit.action.value='Commit';document.edit.active_step.value=$active_step;document.edit.submit()");
			} else {
				$backend->add_button($this->button_names['next'],"document.edit.action.value='Commit';document.edit.active_step.value=$active_step;document.edit.submit()");
			}
			$pset->print_screen($backend,$active_step);
		}
		
		# save params to the session
		$this->parameters['active_step'] = $active_step;
		$session->set_var($param_code, $this->parameters);

	}



	/**
	* Use this function to add a sepcial button to the wizard
	*
	* Pass in the button name (text on the button), the action to perform
	* (you will need to process this in your process_special_action function),
	* the step to skip to when this action is performed, and an array of
	* step numbers to show this button on. The step numbers can be an array
	* or a single integer value.
	*
	* @param   string $name		The text on the button
	* @param   string $action	The action to perform when the button is pressed
	* @param   string $skip_to	The step to skip to when the action is performed
	* @param   array  $screens	An array of step numbers to show this button on.
	*							This can be an array of a single value
	* @returns void
	* @access  public
	*/
	function add_button($name,$action,$skip_to,$screens) {
		if (is_array($screens)) {
			foreach ($screens as $screen) {
				$this->special_buttons[$screen][$name]['action'] = $action;
				$this->special_buttons[$screen][$name]['skip_to'] = $skip_to;
			}
		} else {
			$this->special_buttons[$screens][$name]['action'] = $action;
			$this->special_buttons[$screens][$name]['skip_to'] = $skip_to;
		}
	}



	/**
	* The function that does all the processing
	*
	* Wizards need to overwrite this function or they will end up doing nothing
	*
	* @param   object Wizard_Backend &$backend A reference to the wizard backend object
	* @returns void
	* @access  public
	*/
	function process_wizard(&$backend) {
		return;
	}


	/**
	* Set default dynamic values for this wizard
	*
	* Only need to override this function if you can't set the
	* defaults in the $parameters array
	*
	* @returns void
	* @access  public
	*/
	function set_defaults() {
		return;
	}


	/**
	* Use this function to process custom actions that were assigned to special buttons
	*
	* @param   string $action The action to perform when this button is pressed
	* @returns void
	* @access  public
	*/
	function process_special_action($action) {
		return;
	}



	/**
	* Tells you if this wizard is of a particular type or if we still need to select the type
	*
	* @returns boolean
	* @access  public
	*/
	function type_set() {
		$wizard_type = strtolower(trim($_GET['wizard_type']));
		if (isset($this->_types->register[$wizard_type])) {
			return $wizard_type;
		}
		return false;
	}


	/**
	* Get the parameter set for this wizard
	*
	* All wizards MUST have a parameter set
	*
	* @returns object Parameter_Set
	* @access  public
	*/
	function &get_pset() {
		global $XTRAS_PATH;
		$class = get_class($this);
		$this->temp['pset'] = new Parameter_Set($class,"$XTRAS_PATH/wizards/$class/$class.pset", $this->parameters, $this);
		return $this->temp['pset'];
	}



	/**
	* Returns a relative url to the wizard
	*
	* @param   string $wizard_type The code of the wizard we are running
	* @returns string
	* @access  public
	*/
	function get_wizard_link($wizard_type='') {
		return $_SERVER['PHP_SELF'].'?wizard_type='.$wizard_type.'&'.$_SERVER['QUERY_STRING'];
	}



	/**
	* Returns a reference to the Wizard backend object
	*
	* @returns object Wizard_Backend
	* @access  public
	*/
	function &get_backend() {
		if(get_class($this->backend) != 'wizard_backend') {
			global $INCLUDE_PATH;
			include_once("$INCLUDE_PATH/wizard_backend.inc");
			global $EDIT_DIR, $EDIT_PATH;
			$this->backend = new Wizard_Backend($EDIT_DIR,$EDIT_PATH);

			# carry over the hidden fields so we submit to the right spot
			$web_system = &$this->get_web_system();
			$web_backend = &$web_system->get_backend();
			$this->backend->hidden_fields = $web_backend->hidden_fields;
		}
		return $this->backend;
	}

}