<?  ##############################################
   ### MySource ------------------------------###
  ##- Include Files ------ PHP4 --------------##
 #-- Copyright Squiz.net ---------------------#
##############################################
## This file is subject to version 1.0 of the
## MySource License, that is bundled with
## this package in the file LICENSE, and is
## available at through the world-wide-web at
## http://mysource.squiz.net/
## If you did not receive a copy of the MySource
## license and are unable to obtain it through
## the world-wide-web, please contact us at
## mysource@squiz.net so we can mail you a copy
## immediately.
##
## Desc: Backend functions for dealing with a site
## $Source: /home/cvsroot/mysource/include/site_backend.inc,v $
## $Revision: 1.1.2.14 $
## $Author: csmith $
## $Date: 2003/01/20 02:44:36 $
#######################################################################
#---------------------------------------------------------------------#

 ##########################
# Global variables
global $URL_PROTOCOLS;
$URL_PROTOCOLS = array (
	'http' => 'http://',
	'https' => 'https://',
	'' => 'http(s)://',
);

/**
* Used for printing Site Backends
*
* This class is the result of splitting up the original site.inc
* into it's backend and frontend functions in order to make it smaller
* and therefore quicker to load and require less memory on the frontend
*
* This object should only be created from within Site::print_backend()
* and is passed a reference to the site that it is editing.
*
* Where you would normally reference $this you need to reference $this->site
* eg. $this->id becomes $this->site->id
*
* @access public
* @see Site::print_backend()
*
*/

class Site_Backend extends WebObject {

	/**
	* A boolean specifiying whether the backend has been setup or not
	* @var boolean
	* @see &setup_backend()
	*/
	var $_backend_setup = false;

	/**
	* A reference to the site that is currently being edited by this object
	* @var object Site
	*/
	var $site;

	/**
	* Constructor
	*
	* @param   object Site $site	The site object we are going to deal with
	* @returns object Site_Backend
	* @access  public
	*/
	function Site_Backend(&$site) {
		WebObject::WebObject();
		if (get_class($site) != 'site') {
			$this->_set_error('Attempt to use site backend with an object that is not a "site".',__FILE__,__LINE__);
		} else {
			$this->site = &$site;
		}
	}


	/**
	* Perform some actions before the object is serialised
	*
	* @returns array
	* @access  private
	*/
	function __sleep() {
		$result = WebObject::__sleep();
		array_remove_element('_backend_setup', $result);
		array_remove_element('site', $result);
		return $result;
	}#end __sleep()

	/**
	* Returns a reference to a page
	*
	* @param   int $pageid	The pageid of the page that has been requested
	* @returns object Page
	* @access  private
	*/
	function &get_page($pageid=0) {
		return $this->web_system->get_page($pageid);
	}

	/**
	* Sets up the backend with all this nice things for an entity in the site
	*
	* @returns object Backend
	* @access  public
	*/
	function &setup_backend() {
		$backend = &$this->web_system->setup_backend();

		if (!$this->_backend_setup) {
			$system_config = &get_system_config();
			# if they want the DHTML navigation then use it
			if ($system_config->site_backend_dhtml_navigation) {

				global $SQUIZLIB_PATH;
				include_once("$SQUIZLIB_PATH/dhtml_menu/dhtml_menu.inc");
				$dhtml_menu = new dhtml_menu();
				$page_index = &$this->site->get_page_index();

				for(reset($page_index); NULL !== ($pageid = key($page_index)); next($page_index)){
					if (!$pageid) continue; # ignore the top level pages index
					$page = &$page_index[$pageid];
					$str  = '<a href="page.php?p='.$pageid.'" class="page-lineage" onMouseOver="window.status=\'Edit the General Properties for this Page\'; return true;" onMouseOut="window.status=\'\'; return true;">P</a>'
							.'&nbsp;&nbsp;'
							.'<a href="page.php?p='.$pageid.'&template_edit=1" class="page-lineage" onMouseOver="window.status=\'Edit the Page Contents for this Page\'; return true;" onMouseOut="window.status=\'\'; return true;">C</a>'
							.'&nbsp;&nbsp;'.
							$page['short_name'];
					$dhtml_menu->add_flat_entry($pageid, $page['parentid'], $str, "page.php?p=$pageid", false);
				}#end for

				$dhtml_menu->set_attribute('left_position', '%anchor_left_pos%');
				$dhtml_menu->set_attribute('top_position',  '%anchor_top_pos% + 16');

				$dhtml_menu->set_attribute('menu_width', 250);
				$dhtml_menu->set_attribute('top_is_permanent', false);
				$dhtml_menu->set_attribute('top_is_horizontal', false);
				$dhtml_menu->set_attribute('top_is_variable_width', true);
				$dhtml_menu->set_attribute('tree_is_variable_width', true);
				$dhtml_menu->set_attribute('font_size', '9');
				$dhtml_menu->set_attribute('font_color', '#000000');
				$dhtml_menu->set_attribute('background_color', '#e0e0e0');
				$dhtml_menu->set_attribute('mouseover_font_color', '#ff0000');
				$dhtml_menu->set_attribute('mouseover_background_color', '#c0c0c0');
				$dhtml_menu->set_attribute('border_width', 1);
				$dhtml_menu->set_attribute('border_color', '#000000');
				$dhtml_menu->set_attribute('separator_size', 0);

				$anchor = '<a href="site.php?s='.$this->site->id.'" class="page-lineage" %link_name% onMouseOver="javascript: %onmouseover% return true;" onMouseOut="javascript: %onmouseout% return true;"><b>'.$this->site->name.'</b></a>';
				$content = $dhtml_menu->get_html(squizlib_href('dhtml_menu'), $anchor, true);

			# else they don't want the DHTML navigation so just print the site link
			} else {
				$content = '<a href="site.php?s='.$this->site->id.'" class="page-lineage"><b>'.$this->site->name.'</b></a>';
			}
			$backend->append_context_bar('page_lineage', $content);


			$backend->set_title($this->site->name.' - Edit Site');
			$backend->set_heading('Edit Site','site');
			$backend->set_name($this->site->name);
			$backend->set_id_string($this->site->id);

			$this->_backend_setup = true;

		}#end if

		return $backend;
	}


	/**
	* Prints the interface for editing the site
	*
	* @access  public
	*/
	function print_backend() {
		global $XTRAS;

		$system_config = &get_system_config();
		$session = &get_mysource_session();

		 ##############
		# Die on no ID
		if(!$this->site->id) return;


		 ###################################
		# Setup the backend a little
		$backend = &$this->setup_backend(); # Backend refrence

		 ####################################################################
		# SECUIRTY - Only let in those who have permission to work on a site
		if (!$session->logged_in()) {
			$session->login_screen($backend->title, 'You must be logged in and have permission to edit the site <i>'.$this->site->name.'</i> in order to proceed.');
		}

		 ######################################################################
		# This particular user must be affiliated with an managed organisation
		if (!$this->site->staff_access()) {
			$session->login_screen($backend->title,'You are not a designated staff member of this site.');
		}


		 #########################################
		# Process a submitted form
		$action = $_REQUEST['action'];
		if($action) {
			# Check they're who we think they are
			$current_userid = $_REQUEST['current_userid'];
			if($session->user->id != $current_userid) {
				# Gasp! Someone else has logged in since this form was diaplyed.
				# They might not have had all the options and there could be problems.
				# We can't let them do anything this time.
				$backend->add_message("You have logged in as someone else since Commiting.\nFor security reasons, any changes have been ignored.");
				$action = '';
			}
		}


		$order_pages = $_REQUEST['order_pages'];
		$design_edit = $_REQUEST['design_edit'];
		$extension_edit = $_REQUEST['extension_edit'];
		$floating_site_map = $_REQUEST['floating_site_map'];
		$backend->set_hidden_field('action','Commit');
		$backend->set_hidden_field('siteid',$this->site->id);
		$backend->set_hidden_field('current_userid',$session->user->id);
		$backend->set_hidden_field('userid');
		$backend->set_hidden_field('order_pages',$order_pages);
		$backend->set_hidden_field('design_edit',$design_edit);
		$backend->set_hidden_field('extension_edit',$extension_edit);
		$backend->set_hidden_field('preview_url',url_protocol().'://'.key($this->site->urls).'/');


		#############################################
		# The floating site map
		if($floating_site_map) {
			$this->print_floating_site_map();
			return;
		}


		 #################
		# Set up the tabs
		$backend->set_tab('site_properties', 'site.php?s='.$this->site->id, 'Site Properties', 'Edit this site\'s general information and the structure of the pages in this site.','site');
		$backend->set_active_tab('site_properties');
		if($this->site->admin_access()) {
			$backend->set_tab('site_custom_design', 'site.php?s='.$this->site->id.'&design_edit=1', 'Custom Design', 'Customize this site\'s design.', 'page');
		}
		$backend->set_tab('site_internationalisation', 'site.php?s='.$this->site->id.'&PARAMETER_SCREEN=site_internationalisation', 'Internationalisation', 'Manage the default language and character set settings for this site.','page');
		$backend->set_tab('site_security', 'site.php?s='.$this->site->id.'&PARAMETER_SCREEN=site_security', 'Security', 'Manage the read- and write-permissions for this site.','security');
		# if the user is an editor or above and we are logging page visits
		# then show the stats tab
		if($this->site->editor_access()) {
			$backend->set_tab('wizards', 'site.php?s='.$this->site->id.'&PARAMETER_SCREEN=wizards', 'Wizards', 'View wizards for this site.','graph');
		}
		$backend->set_tab('site_search', 'site.php?s='.$this->site->id.'&PARAMETER_SCREEN=site_search', 'Site Search', 'Search for pages and files in this site.','search');



		$parameter_screen = $_GET['PARAMETER_SCREEN'];
		if($parameter_screen && $backend->get_tab_label($parameter_screen)) {
			$backend->set_active_tab($parameter_screen);
		}
		$backend->set_hidden_field('PARAMETER_SCREEN',$parameter_screen);

		$backend->set_subheading($backend->get_tab_label($backend->active_tab));

		 ####################################################
		# Print a little preview-site button on every screen
		if(!empty($this->site->urls)) {
			reset($this->site->urls);
			#if protocol is http(s) then its saved as blank in the database, so assign a default value
			if(!$protocol = current($this->site->urls)) $protocol = url_protocol(); #default
			$backend->set_toolbar_button('preview',$protocol.'://'.key($this->site->urls), 'Preview this site on the frontend (Alt + V).', 'preview', '_blank');
		}

		 #############################################
		# Do they want to order pages on the site?
		if($order_pages) {
			$this->_print_page_orderer();
			return;
		}

		 ##########################################################
		# Display the edit interface for the extension if asked for
		if($extension_edit) {
			$extension = &$this->site->get_extension($extension_edit);
			if($extension->id == $this->site->id) {
				$backend->set_subheading($extension->name);
				$extension->print_backend();
				return;
			}
		}

		 ##########################################################
		# Display the edit interface for the design if asked for
		if($design_edit) {
			$backend->clear_tabs(Array('site_custom_design'));
			$backend->set_active_tab('site_custom_design');
			$design = &$this->site->get_design();
			$design->print_user_backend('site.php?s='.$this->site->id.'&design_edit=1');
			return;
		}


		 #################
		# Toolbar buttons
		if(superuser('web')) {
			$backend->set_toolbar_button('delete',"javascript: if (confirm('Are you sure you want to delete this entire site?') && confirm('Really sure? This is irreversible.') && confirm('This is a third and final warning. \\nYou are about to delete an entire site and all of its pages and content.')) {document.edit.action.value='Delete';document.edit.submit()}",'Delete this site','delete');

			$backend->set_toolbar_button('dupe',"javascript: if ((confirm('Are you sure you want to duplicate this entire site?')) && (confirm('Are you REALLY sure you want to duplicate this entire site? This could take some time - especially on very large sites.'))) {document.edit.action.value = 'Dupe';document.edit.submit();}",'Duplicate this site','dupe');
		}

		 ################################
		# We'll be needing this for sure
		$db = &$this->get_db();
		# And this
		$index = &$this->site->get_page_index();


		 ####################################
		# Special tab-independant functions..
		switch($action) {
			case 'Delete':
				if(superuser('web')) {

					$num_to_delete = $_REQUEST['num_to_delete'];
					$num = $_REQUEST['num'];
					$num_deleted = $_REQUEST['num_deleted'];
					$started = $_REQUEST['started'];
					$start_time = $_REQUEST['start_time'];

					if (isset($num) && isset($num_to_delete)) {

						# Tell the backend that it showuld shows our messages
						$backend->set_delay_messages(false);

						if (!$started) {
							$now = time();
							$process_url = $this->site->get_backend_href()."&num_to_delete=$num_to_delete&num=$num&num_deleted=0&action=Delete&started=1&start_time=$now&current_userid=".$session->user->id;
							echo status_popup(1,$process_url,false,false,'#FF0033','Deleting Site - Please wait', "Starting to delete $num_to_delete pages");
							exit();
						}

						# delete $num pages from the site
						$backend->add_message(ereg_replace("[\n]+","\n",$this->site->delete($num)));

						$num_deleted += $num;
						$percent = ceil(($num_deleted / $num_to_delete) * 100);
						$finish = (($num_deleted >= $num_to_delete) ? 1 : 0);
						$time_diff = time() - $start_time;
						$time_per_page = $time_diff / $num_deleted;
						$time_left = $time_per_page * ($num_to_delete - $num_deleted);
						if ($time_left <= 0) $time_left = 1;
						$status = '';

						if ($finish) {
							$process_url = $this->site->get_backend_href()."&cleanup=0&action=Delete_finished&started=1&current_userid=".$session->user->id;
							$status = 'Finished deleting. Cleaning up...';
						} else {
							$process_url = $this->site->get_backend_href()."&num_to_delete=$num_to_delete&num=$num&num_deleted=$num_deleted&action=Delete&started=1&start_time=$start_time&current_userid=".$session->user->id;
							$status = "$num_deleted deleted - ".($num_to_delete - $num_deleted).' remaining - est time: '.easy_time_total($time_left);
						}
						echo status_popup($percent,$process_url,false,false,'#FF0033','Deleting Site - Please wait',$status);
						exit();
					}

					$index = &$this->site->get_page_index();
					$num_to_delete = count($index) -1;
					$num = (int) $system_config->batch_delete; # number of pages to process at a time
					if ($num <= 0) $num = 10;
					$process_url = $this->site->get_backend_href()."&num_to_delete=$num_to_delete&num=$num&num_deleted=0&action=Delete&started=0&current_userid=".$session->user->id;
					echo status_popup(1,$process_url,true,false,'#FF0033','Deleting Site - Please wait', "Starting to delete $num_to_delete pages");
				}
				break;

			case 'Delete_finished' :
				if(superuser('web')) {
					# Trick the backend so that it shows our messages
					$backend->header_printed = true;

					# finished deleting ?
					$cleanup = $_REQUEST['cleanup'];

					if (!$cleanup) {
						$backend->add_message(ereg_replace("[\n]+","\n",$this->site->delete_cleanup()));
						$session->unset_var('active_pageid');
						$session->unset_var('active_siteid');
						echo status_popup('100','web.php',false,true,'#FF0033','Delete Complete','Redirecting you to site list');
						exit();
					}
				}
				break;

			case 'Dupe':
				if(superuser('web')) {

					$num_to_dupe = $_REQUEST['num_to_dupe'];
					$num = $_REQUEST['num'];
					$num_duped = $_REQUEST['num_duped'];
					$started = $_REQUEST['started'];
					$start_time = $_REQUEST['start_time'];

					if (isset($num) && isset($num_to_dupe)) {

						# Tell the backend that it showuld shows our messages
						$backend->set_delay_messages(false);

						if (!$started) {
							$now = time();
							$process_url = $this->site->get_backend_href()."&num_to_dupe=$num_to_dupe&num=$num&num_duped=0&action=Dupe&started=1&start_time=$now&current_userid=".$session->user->id;
							echo status_popup(1,$process_url,false,false,'#330099','Duping Site - Please wait', "Starting to dupe $num_to_dupe pages");
							exit();
						}

						$new_siteid = $session->get_var('dupe_siteid');

						# dupe $num pages to the new site
						$this->site->dupe_pages($new_siteid,$num);

						$num_duped += $num;
						$percent = ceil(($num_duped / $num_to_dupe) * 100);
						$finish = (($num_duped >= $num_to_dupe) ? 1 : 0);
						$time_diff = time() - $start_time;
						$time_per_page = $time_diff / $num_duped;
						$time_left = $time_per_page * ($num_to_dupe - $num_duped);
						if ($time_left <= 0) $time_left = 1;
						$status = '';

						if ($finish) {
							$process_url = $this->site->get_backend_href()."&cleanup=0&action=Dupe_remap&started=1&current_userid=".$session->user->id;
							$status = 'Finished duping. Preparing to remap links...';
						} else {
							$process_url = $this->site->get_backend_href()."&num_to_dupe=$num_to_dupe&num=$num&num_duped=$num_duped&action=Dupe&started=1&start_time=$start_time&current_userid=".$session->user->id;
							$status = "$num_duped duped - ".($num_to_dupe - $num_duped).' remaining - est time: '.easy_time_total($time_left);
						}
						echo status_popup($percent,$process_url,false,false,'#330099','Duping Site - Please wait', $status);
						exit();
					}

					$index = &$this->site->get_page_index();
					$num_to_dupe = count($index) -1;
					$num = (int) $system_config->batch_dupe; # number of pages to process at a time
					if ($num <= 0) $num = 10;
					$new_siteid = $this->site->dupe_prepare($dupe_map,$dupe_message);
					$session->set_var('dupe_siteid', $new_siteid);

					$process_url = $this->site->get_backend_href()."&num_to_dupe=$num_to_dupe&num=$num&num_duped=0&action=Dupe&started=0&current_userid=".$session->user->id;
					echo status_popup(1,$process_url,true,false,'#330099','Duping Site - Please wait', "Starting to dupe $num_to_dupe pages");
				}
				break;

			case 'Dupe_remap':
				if(superuser('web')) {

					$num_to_dupe = $_REQUEST['num_to_dupe'];
					$num = $_REQUEST['num'];
					$num_duped = $_REQUEST['num_duped'];
					$started = $_REQUEST['started'];
					$start_time = $_REQUEST['start_time'];

					if (isset($num) && isset($num_to_dupe)) {

						# Tell the backend that it should shows our messages
						$backend->set_delay_messages(false);

						if (!$started) {
							$now = time();
							$process_url = $this->site->get_backend_href()."&num_to_dupe=$num_to_dupe&num=$num&num_duped=0&action=Dupe_remap&started=1&start_time=$now&current_userid=".$session->user->id;
							echo status_popup('1',$process_url,false,false,'#330099','Remaping links - Please wait', "Starting to remap $num_to_dupe page".(($num_to_dupe > 1) ? 's' : ''));
							exit();
						}

						# remap $num subpages
						$this->site->dupe_remap($num);

						$num_duped += $num;
						$percent = ceil(($num_duped / $num_to_dupe) * 100);
						$finish = (($num_duped >= $num_to_dupe) ? 1 : 0);
						$time_diff = time() - $start_time;
						$time_per_page = $time_diff / $num_duped;
						$time_left = $time_per_page * ($num_to_dupe - $num_duped);
						if ($time_left <= 0) $time_left = 1;
						$status = '';

						if ($finish) {
							$process_url = $this->site->get_backend_href()."&cleanup=0&action=Dupe_finished&started=1&current_userid=".$session->user->id;
							$status = 'Finished remaping links. Cleaning up...';
						} else {
							$process_url = $this->site->get_backend_href()."&num_to_dupe=$num_to_dupe&num=$num&num_duped=$num_duped&start_time=$start_time&action=Dupe_remap&started=1&current_userid=".$session->user->id;
							$status = "$num_duped pages remaped - ".($num_to_dupe - $num_duped).' remaining - est time: '.easy_time_total($time_left);
						}
						echo status_popup($percent,$process_url,false,false,'#330099','Remaping Links - Please wait', $status);
						exit();
					}

					$new_siteid = $session->get_var('dupe_siteid');
					$new_site = &$this->site->web_system->get_site($new_siteid);
					$index = &$new_site->get_page_index();
					$num_to_dupe = count($index) -1;
					$num = (int) $system_config->batch_dupe; # number of pages to process at a time
					if ($num <= 0) $num = 10;
					
					$process_url = $this->site->get_backend_href()."&num_to_dupe=$num_to_dupe&num=$num&num_duped=0&action=Dupe_remap&started=0&current_userid=".$session->user->id;
					echo status_popup('1',$process_url,true,false,'#330099','Remaping Links - Please wait', "Starting to remap $num_to_dupe pages");
				}
				break;

			case 'Dupe_finished' :
				if(superuser('web')) {
					$dupe_message = $session->get_var('dupe_message');
					# Trick the backend so that it shows our messages
					$backend->header_printed = true;

					# finished deleting ?
					$cleanup = $_REQUEST['cleanup'];
					if (!$cleanup) {
						$new_siteid = $session->get_var('dupe_siteid');
						$dupe_map = $session->get_var('dupe_map');
						$dupe_message = $session->get_var('dupe_message');
						$this->site->dupe_cleanup($new_siteid, $dupe_map, $dupe_message);
						$backend->add_message(ereg_replace("[\n]+","\n",$dupe_message));
						$session->unset_var('dupe_siteid');
						$session->unset_var('dupe_map');
						$session->unset_var('dupe_message');
						echo status_popup('100',"site.php?s=$new_siteid",false,true,'#330099','Dupe Complete',"Redirecting you to site $new_siteid");
						exit();
					}
				}
				break;
		}


		$parameter_screen = $_REQUEST['PARAMETER_SCREEN'];
		switch($parameter_screen) {

			 ##########################################
			# The Site Internationalisation Screen
			case "site_internationalisation":
				if($action == 'Commit') {
					if($this->site->admin_access()) {
						$default_languages = $_POST['default_languages'];
						$default_charset = $_POST['default_charset'];	$backend->add_message($this->site->set_default_languages(gpc_stripslashes(implode(",",$default_languages))));
						$backend->add_message($this->site->set_default_charset(gpc_stripslashes($default_charset)));
						$backend->set_charset($this->site->get_effective_default_charset());
					}
				}

				$backend->print_header();

				$backend->open_section('Internationalisation');

				$backend->open_field('Languages','top');
				$languages_config = &get_config('languages');
				$language_options = &$languages_config->languages;
				if ($this->site->admin_access()) {
					echo('<table width=100% cellpadding=2 cellspacing=0 border=0><tr>');
					$i = 0;
					foreach($language_options as $code => $language) {
						if($i++ % 4 == 0) echo '</tr><tr>';
						echo("<td valign=top><input type=checkbox name=default_languages[] value=\"$code\" ".((in_array($code,explode(",",$this->site->default_languages)))?"checked":"")."> $language</td>");
					}
					echo('</tr></table>');
					echo("<span class=smallprint><br>Leave all unselected to use the system default: <i>".$languages_config->name_list($system_config->default_language)."</i></span>");
				} else {
					echo "<p class=data>".$languages_config->name_list((($this->site->default_languages)?$this->site->default_languages:$system_config->default_language));
				}


				$backend->open_field("Character Set","top");
				$charsets_config = &get_config("charsets");
				$charset_options = array("" => "-- System Default -- ". $charsets_config->charsets[$system_config->default_charset]) + $charsets_config->charsets;
				if ($this->site->admin_access()) {
					echo combo_box("default_charset",$charset_options,$this->site->default_charset, "class=data");
				} else {
					echo('<p class=data>'.$charset_options[$this->site->default_charset]);
				}


				break;

			 ############################
			# The Site Security screen
			case "site_security":
				if($action == 'Commit') {

					if($this->site->admin_access()) {
						$public = $_REQUEST['public'];
						$access_grants = $_REQUEST['access_grants'];
						$backend->add_message($this->site->set_public($public));
						$backend->add_message($this->site->update_access_grants($access_grants));

						$new_site_group_name = $_REQUEST['new_site_group_name'];
						if ($new_site_group_name) {
							$backend->add_message($this->site->new_access_group(gpc_stripslashes($new_site_group_name)));
						}
					}

					if(superuser("web")) {
						$allowed_extensions = $_REQUEST['allowed_extensions'];
						$allowed_templates = $_REQUEST['allowed_templates'];
						$allowed_designids = $_REQUEST['allowed_designids'];

						$backend->add_message($this->site->update_allowed_extensions($allowed_extensions));
						$backend->add_message($this->site->update_allowed_templates($allowed_templates));
						$backend->add_message($this->site->update_allowed_designids($allowed_designids));

					}
					if(superuser("web")) {
						$delete_adminids = $_REQUEST['delete_adminids'];
						$email_adminids = $_REQUEST['email_adminids'];

						//check for changes to email settings
						$backend->add_message($this->site->update_parameter_adminids("email_adminids", $email_adminids));

						foreach($delete_adminids as $id) {
							$backend->add_message($this->site->remove_adminid($id));
						}

						$new_admin = $_REQUEST['new_admin'];
						$users_system = &get_users_system();
						if($new_admin) {
							$new_admin = gpc_stripslashes($new_admin);
							$user = &$users_system->get_user($new_admin);
							if($user->id) {
								$backend->add_message($this->site->add_adminid($user->id));
							} else {
								$backend->add_message("Couldn't find a user (to make a site administrator) with login or email of: $new_admin");
							}
						}
					}

					if($this->site->admin_access()) {
						$delete_editorids = $_REQUEST['delete_editorids'];

						foreach($delete_editorids as $id) {
							$backend->add_message($this->site->remove_editorid($id));
						}

						$new_editor = $_REQUEST['new_editor'];
						$users_system = &get_users_system();
						if($new_editor) {
							$new_editor = gpc_stripslashes($new_editor);
							$user = &$users_system->get_user($new_editor);
							if($user->id) {
								$backend->add_message($this->site->add_editorid($user->id));
							} else {
								$backend->add_message("Couldn't find a user (to make a site editor) with login or email of: $new_editor");
							}
						}
					}

					$this->site->clear_page_index();
					$index = &$this->site->get_page_index();
				}
				$backend->print_header();

				$backend->open_section("Read Access Grants");

				if(!$this->site->public && empty($this->site->access_grants)) {
					$backend->open_field("<span class=warning>WARNING</span>","top");
					echo("<span class=warning>You have not granted access to the public <i>or</i> any of the access groups. Noone can see this site on the frontend.</span>");
				}

				$backend->open_field("Public");
				echo("<input type=checkbox value=\"1\" name=public ".(($this->site->public)?"checked":"")." ".(($this->site->admin_access())?"":"onfocus=\"alert('Permission denied.');blur();\"").">");

				$general_access_groups = &$this->web_system->get_general_access_group_list();
				if($this->site->admin_access() || !empty($general_access_groups)) {
					$backend->open_field("Gen. Access Groups","top");
					if(!count($general_access_groups)) {
						echo("None.");
					}
					foreach($general_access_groups as $groupid => $name) {
						$granted = in_array($groupid, $this->site->access_grants);
						echo("<input type=checkbox value=\"$groupid\" name=access_grants[] ".(($granted)?"checked":"")." ".(($this->site->admin_access())?"":"onfocus=\"alert('Permission denied.');blur();\"").">");
						echo("<a href=\"access_group.php?groupid=$groupid\">$name</a><br>");
					}
				}

				if($this->site->admin_access() || !empty($this->site->access_groups)) {
					$backend->open_field("Site Access Groups","top");
					if(!count($this->site->access_groups)) {
						echo("None.");
					}
					foreach($this->site->access_groups as $groupid => $name) {
						$granted = in_array($groupid, $this->site->access_grants);
						echo("<input type=checkbox value=\"$groupid\" name=access_grants[] ".(($granted)?"checked":"")." ".(($this->site->admin_access())?"":"onfocus=\"alert('Permission denied.');blur();\"").">");
						echo("<a href=\"access_group.php?groupid=$groupid\">$name</a><br>");
					}
				}

				if($this->site->admin_access()) {
					$backend->open_field("Create New Site Group?");
					echo text_box("new_site_group_name","",50,255, "class=data");
				}

				$backend->open_section("Allowed Usage");

				 ###########################
				# List available extensions
				$backend->open_field("Site Extensions","top");
				$all_extensions = $XTRAS->list_type("site/extensions");
				$i = 0;
				foreach($all_extensions as $codename => $name) {
					$i++;
					$granted = in_array($codename,$this->site->allowed_extensions);
					if ($granted || superuser("web")) {
						if (superuser("web")) {
							echo("<input type=checkbox value=\"$codename\" name=allowed_extensions[] ".(($granted)?"checked":"").">");
						}
						echo "$name<br>";
					}
				}

				$backend->open_field("Page Templates","top");
				$all_templates = $XTRAS->list_type("page/templates");
				foreach($all_templates as $codename => $name) {
					$granted = in_array($codename,$this->site->allowed_templates);
					if ($granted || superuser("web")) {
						if(superuser("web")) {
							echo("<input type=checkbox value=\"$codename\" name=allowed_templates[] ".(($granted)?"checked":"").">");
						}
						echo("$name<br>");
					}
				}

				$backend->open_field("Site Designs","top");
				$all_designs = &$this->web_system->get_site_design_list();
				foreach($all_designs as $designid => $name) {
					$granted = in_array($designid,$this->site->allowed_designids);
					if ($granted || superuser("web")) {
						if(superuser("web")) {
							echo("<input type=checkbox value=\"$designid\" name=allowed_designids[] ".(($granted)?"checked":"").">");
						}
						echo("<a href=\"site_design.php?designid=$designid\">$name</a><br>");
					}
				}

				if($this->site->editor_access()) {
					$backend->open_section("Write Access Permissions");

					$backend->open_field("Site Admins","top");
					$users_system = &get_users_system();

				/*
				   This displays all parameters and calculates any presets before passing to
				   display_users_table. Each $checkboxes has an array as it's second dimension
				   which contains all adminids that have that parameter preset (ie checkbox
				   will be checked). Fully backwards compatible.
				*/

				$checkbox_names='';
				$checkboxes='';
				if (superuser("web")) {
					$checkbox_names = array("delete_adminids"=>array(), "email_adminids"=>array());
					$checkboxes = array("Delete?", "Email?");
					foreach ($this->site->adminids as $id) {
						$parameters = unserialize($this->site->adminids_parameters[$id]);
						while(list($name, $value) = each ($parameters)) {
							if ($parameters[$name] == 1) {
								array_push($checkbox_names[$name], $id);
							}
						}
					}
				}
				$users_system->display_users_table($this->site->adminids,$checkbox_names,$checkboxes);

				if(superuser("web")) {
					$backend->open_field("New Admin?<span class=fineprint><br>(login/email)</span>","top");
					echo text_box("new_admin","",20,128, "class=data");
				}

				$backend->open_field("Site Editors","top");
				$users_system->display_users_table($this->site->editorids,(($this->site->admin_access())?"delete_editorids":""),"Delete?");

				if($this->site->admin_access()) {
					$backend->open_field("New Editor?<span class=fineprint><br>(login/email)</span>","top");
					echo text_box("new_editor","",20,128, "class=data");
				}
			}
			break;


			 #####################################
			# The "Page Statisitcs" screen
			case 'wizards':
				# Don't wanna be commitin' nothin'!
				$backend->set_hidden_field('action','');

				global $INCLUDE_PATH;
				include_once("$INCLUDE_PATH/wizard.inc");
				$report = new Wizard($this->site);
				$type_set = $report->type_set();
				if (!$type_set) $backend->print_header();
				$report->print_backend();
				if (!$type_set) $backend->print_footer();

				return;



			#####################################
			# The "Site Search" screen
			case 'site_search':
				$pagesearch = $_REQUEST['pagesearch'];
				$filesearch = $_REQUEST['filesearch'];
				$pagesearchby = $_REQUEST['pagesearchby'];
				$filesearchby = $_REQUEST['filesearchby'];

				$backend->remove_toolbar_button('delete');
				$backend->remove_toolbar_button('dupe');

				if ($pagesearch) {
					$filesearch = '';
					$filesearchby = '';
				}

				$pagesearch = str_replace('\\\\', '\\', $pagesearch);
				$filesearch = str_replace('\\\\', '\\', $filesearch);

				$backend->print_header();

				$backend->open_section('Search');

				$backend->open_field('Pages','top');
				?>
				<input type="text" name="pagesearch" size="30" value="<?=$pagesearch?>">
				<select name="pagesearchby" class="smallprint">
					<option value="name">by name</option>
					<option value="id"<?=($pagesearchby == 'id') ? ' selected' : ''?>>by ID</option>
				</select>
				<?
				$backend->close_field();
				$backend->open_field('Files','top');
				?>
				<input type="text" name="filesearch" size="30" value="<?=$filesearch?>">
				<select name="filesearchby" class="smallprint">
					<option value="name">by name</option>
					<option value="id"<?=($filesearchby == 'id') ? ' selected' : ''?>>by ID</option>
				</select>
				<?
				$backend->close_field();
				$backend->close_section();
				$backend->print_commit_button('Search','document.edit.submit()');
				if($action == 'Commit' && ($filesearch || $pagesearch)) {

					$what_searched = 'This search looked for ';

					$db = &$this->get_db();

					if ($pagesearch) {
						$pagesearch = trim($pagesearch);
						$original = $pagesearch;
						$what_searched .= 'pages ';
						$str_sql = 'SELECT t1.pageid, t1.name, t1.parentid, t2.name AS parentname FROM page AS t1, page AS t2 WHERE ((t1.parentid = t2.pageid) OR (t1.parentid=0 and t2.pageid=t1.pageid)) AND t1.siteid='.$this->site->id.' AND ';
						if ($pagesearchby == 'name') {
							$what_searched .= 'with a page name matching the pattern:<br>';
							$pagesearch = str_replace('_', "\\_", $pagesearch);
							$pagesearch = str_replace('%', "\\%", $pagesearch);

							$str_sql .= "t1.name LIKE '";
							$pagesearch_temp = '';
							if (substr($pagesearch, 0, 1) != '^') {
								$pagesearch_temp .= '%';
								$original = '[any number of chars]'.$original;
								$pagesearch = str_replace('\^', '^', $pagesearch);
							} else {
								$pagesearch = substr($pagesearch, 1);
								$original = '[start of name]'.substr($original, 1);
							}
							if (substr($pagesearch, -1) != '$') {
								$pagesearch_temp .= "$pagesearch%";
							} else {
								if (substr($pagesearch, -2) != '\\$') {
									$pagesearch = substr($pagesearch, 0, -1);
									$pagesearch_temp .= $pagesearch;
									$original = substr($original, 0, -1).'[end of name]';
								} else {
									$pagesearch = str_replace('\\$', '$', $pagesearch);
									$pagesearch_temp .= $pagesearch;
								}
							}

							$sections = explode('*', $original);
							$i = 0;
							foreach ($sections as $section) {
								# remove the last char if it is a "\"
								if (trim($section) == '[any number of chars]') {
									$i++;
									continue;
								}
								if (strstr($section, '[end of name]')){
									$i++;
									continue;
								}
								if (substr($section, -1) == '\\') {
									$sections[$i] = substr($section, 0, -1).'*';
								} else {
									$sections[$i] = $section.'[any number of chars]';
								}
								$i++;
							}

							$original = implode('', $sections);

							$sections = explode('.', $original);
							$i = 0;
							foreach ($sections as $section) {
								# remove the last char if it is a "\"
								if (trim($section) == '[one char]') {
									$i++;
									continue;
								}
								if (strstr($section, '[end of name]') || count($sections) == ($i+1)){
									$i++;
									continue;
								}
								if (substr($section, -1) == '\\') {
									$sections[$i] = substr($section, 0, -1).'.';
								} else {
									$sections[$i] = $section.'[one char]';
								}
								$i++;
							}

							$original = implode('', $sections);

							$original = str_replace('\^', '^', $original);
							$original = str_replace('\$', '$', $original);
							$what_searched .= '<i>'.$original.'</i>';

							$temp = $original;
							$temp = str_replace('[one char]', '_', $temp);
							$temp = str_replace('[any number of chars]', '%', $temp);
							if (strstr($temp, '[start of name]')) {
								$temp = str_replace('[start of name]', '', $temp);
							} else {
								$temp = '%'.$temp;
							}
							if (strstr($temp, '[end of name]')) {
								$temp = str_replace('[end of name]', '', $temp);
							} else {
								$temp = $temp.'%';
							}
							$str_sql .= $temp."'";


						}
						if ($pagesearchby == 'id') {
							$what_searched .= "with a page ID of $pagesearch";
							$str_sql .= "t1.pageid='$pagesearch'";
						}
						$str_sql .= ' ORDER BY name';
						$pagesearch = true;
					} else if ($filesearch) {
						$original = $filesearch;
						$filesearch = trim($filesearch);
						$what_searched .= 'files ';
						$str_sql = 'SELECT t1.fileid, t1.filename, t1.pageid, t2.name FROM file AS t1, page AS t2 WHERE ((t1.pageid = t2.pageid) OR (t1.pageid=0 and t2.pageid=t1.pageid)) AND ';
						if ($filesearchby == 'name') {
							$what_searched .= 'with a filename matching the pattern:<br>';
							$filesearch = str_replace('_', '\\_', $filesearch);
							$filesearch = str_replace('%', '\\%', $filesearch);

							$str_sql .= "t1.filename LIKE '";
							$filesearch_temp = '';
							if (substr($filesearch, 0, 1) != '^') {
								$filesearch_temp .= '%';
								$original = '[any number of chars]'.$original;
								$filesearch = str_replace('\^', '^', $filesearch);
							} else {
								$filesearch = substr($filesearch, 1);
								$original = '[start of name]'.substr($original, 1);
							}
							if (substr($filesearch, -1) != '$') {
								$filesearch_temp .= "$filesearch%";
							} else {
								if (substr($filesearch, -2) != '\\$') {
									$filesearch = substr($filesearch, 0, -1);
									$filesearch_temp .= $filesearch;
									$original = substr($original, 0, -1).'[end of name]';
								} else {
									$filesearch = str_replace('\\$', '$', $filesearch);
									$filesearch_temp .= $filesearch;
								}
							}

							$sections = explode('*', $original);
							$i = 0;
							foreach ($sections as $section) {
								# remove the last char if it is a "\"
								if (trim($section) == '[any number of chars]') {
									$i++;
									continue;
								}
								if (strstr($section, '[end of name]')){
									$i++;
									continue;
								}
								if (substr($section, -1) == '\\') {
									$sections[$i] = substr($section, 0, -1).'*';
								} else {
									$sections[$i] = $section.'[any number of chars]';
								}
								$i++;
							}

							$original = implode('', $sections);

							$sections = explode('.', $original);
							$i = 0;
							foreach ($sections as $section) {
								# remove the last char if it is a "\"
								if (trim($section) == '[one char]') {
									$i++;
									continue;
								}
								if (strstr($section, '[end of name]') || count($sections) == ($i+1)){
									$i++;
									continue;
								}
								if (substr($section, -1) == '\\') {
									$sections[$i] = substr($section, 0, -1).'.';
								} else {
									$sections[$i] = $section.'[one char]';
								}
								$i++;
							}

							$original = implode('', $sections);

							$original = str_replace('\^', '^', $original);
							$original = str_replace('\$', '$', $original);
							$what_searched .= '<i>'.$original.'</i>';

							$temp = $original;
							$temp = str_replace('[one char]', '_', $temp);
							$temp = str_replace('[any number of chars]', '%', $temp);
							if (strstr($temp, '[start of name]')) {
								$temp = str_replace('[start of name]', '', $temp);
							} else {
								$temp = "%".$temp;
							}
							if (strstr($temp, '[end of name]')) {
								$temp = str_replace('[end of name]', '', $temp);
							} else {
								$temp = $temp.'%';
							}
							$str_sql .= $temp."'";


						}
						if ($filesearchby == 'id') {
							$what_searched .= "with a file ID of $filesearch";
							$str_sql .= "t1.fileid='$filesearch'";
						}
						$str_sql .= ' ORDER BY filename';
						$filesearch = true;
					}

					$results = $db->associative_array($str_sql);

					$num_results = count($results);

					if ($num_results > 0) {
						if ($num_results == 1) {
							$backend->open_section('Search Results (1 record found)');
						} else {
							$backend->open_section("Search Results ($num_results records found)");
						}
						$backend->open_field('','top');

						echo '<table cellpadding=2 cellspacing=1 border=0 width=100%>';

						if ($pagesearch) {
							echo '<tr><td><p class=field>Page ID</td><td><p class=field><p class=field>Page Name</td><td><p class=field>Parent ID</td><td><p class=field>Parent Name</td></tr>';
						} else if ($filesearch) {
							echo '<tr><td><p class=field>File ID</td><td><p class=field>File Name</td><td><p class=field>Page ID</td><td><p class=field>Page Name</td></tr>';
						}

						foreach ($results as $id => $info) {
							echo '<tr>';
							if ($pagesearch) {
								?>
								<td bgcolor=#d0d0d0><?=$info['pageid']?></td>
								<td bgcolor=#d0d0d0><a href="page.php?pageid=<?=$info['pageid']?>"><?=$info['name']?></a></td>
								<td bgcolor=#d0d0d0><?=($info['parentid'] == 0) ? '-' : $info['parentid']?></td>
								<td bgcolor=#d0d0d0><?=($info['parentid'] == 0) ? '-' : '<a href=page.php?pageid='.$info['parentid'].'>'.$info['parentname'].'</a>'?></td>
								<?
							} else if ($filesearch) {
								?>
								<td bgcolor=#d0d0d0><?=$info['fileid']?></td>
								<td bgcolor=#d0d0d0><a href="page.php?fileid=<?=$info[fileid]?>&file_edit=1"><?=$info['filename']?></a></td>
								<td bgcolor=#d0d0d0><?=($info['pageid'] == 0) ? '-' : $info['pageid'];?></td>
								<td bgcolor=#d0d0d0><?=($info['pageid'] == 0) ? '-' : '<a href=page.php?pageid='.$info['pageid'].'>'.$info['name'].'</a>'?></td>
								<?
							}

							echo '</tr>';

						}

						echo "<tr><td colspan=4>$what_searched</td></tr>";
						echo '</table>';
						$backend->close_section();

					} else {
						$backend->open_section('Your search did not produce any results');
						$backend->open_field('','top');
						echo "<table><tr><td colspan=4>$what_searched</td></tr></table>";
						$backend->close_field();
					}
				}


				$backend->print_footer();
				return;


			 #################################
			# The Site Properties screen
			case 'site_properties': default:
				if($action == 'Commit') {
					if($this->site->admin_access()) {
						$name = $_REQUEST['name'];
						$description = $_REQUEST['description'];
						$default_languages = $_REQUEST['default_languages'];
						$default_charset = $_REQUEST['default_charset'];
						$backend->add_message($this->site->set_name(gpc_stripslashes($name)));
						$backend->add_message($this->site->set_description(gpc_stripslashes($description)));

						$designid = $_REQUEST['designid'];
						if(superuser('web') || in_array($designid, $this->site->allowed_designids)) {
							$backend->add_message($this->site->set_design($designid));
						}
					}
					$backend->set_name($this->site->name);
					$backend->set_id_string($this->site->id);
					$this->site->clear_page_index();
					$index = &$this->site->get_page_index();

					if($this->site->admin_access()) {
						$urls = $_POST['urls'];
						foreach($urls as $url_data) {
							if($url_data['url']) $new_urls[$url_data['url']] = $url_data['protocol'];
						}

						$backend->add_message($this->site->update_urls($new_urls));

						$index_pageid = $_POST['index_pageid'];
						$backend->add_message($this->site->set_index_pageid($index_pageid));
						$not_found_pageid = $_POST['not_found_pageid'];
						$backend->add_message($this->site->set_not_found_pageid($not_found_pageid));
						$forbidden_pageid = $_POST['forbidden_pageid'];
						$backend->add_message($this->site->set_forbidden_pageid($forbidden_pageid));
					}

					if(superuser('web')) {
						$max_pages = $_POST['max_pages'];
						$max_files = $_POST['max_files'];
						$max_file_bytes = $_POST['max_file_bytes'];
						$backend->add_message($this->site->set_maximums(
														abs((int) $max_pages),
														abs((int) $max_files),
														abs((int)($max_file_bytes * 1024 * 1024))
													));
					}

					if($this->site->editor_access()) {
						$new_page_names = $_POST['new_page_names'];
						$new_page_template = $_POST['new_page_template'];
						if($new_page_names && (superuser('web') || in_array($new_page_template,$this->site->allowed_templates))) {
							$new_page_count = 0;
							$new_pageid = 0;
							foreach(split("[\r\n]+",$new_page_names) as $new_page_name) {
								if(!($new_page_name = gpc_stripslashes(trim($new_page_name)))) continue;
								list($error_code, $msg, $new_pageid) = $this->site->create_page($new_page_name, $new_page_template);
								$backend->add_message(Array($error_code, $msg));
								# only add if no errors occured
								if ($error_code == MYSOURCE_ERROR_CODE_NONE) {
									$new_page_count++;
								}#end if
							}#end foreach
							if($new_page_count > 1) {
								$backend->add_message("$new_page_count new pages created.");
							} elseif ($new_page_count == 1 && $new_pageid) {
								$backend->set_relocation("page.php?p=$new_pageid");
							# else do nothing
							}#end if
						}#end if
					}#end if
					$this->site->clear_page_index();
					$index = &$this->site->get_page_index();

				} elseif ($action == 'Connect') {
					$parentid = $_POST['parentid'];
					$childid = $_POST['childid'];
					$child = new Page($childid,$this->web_system);
					$backend->add_message($child->move($this->site->id,$parentid));
					$this->site->clear_page_index();
					$index = &$this->site->get_page_index();
				} elseif ($action == 'dock_floating_site_map') {
					$session->unset_var('floating_site_map_open');
				}

				$active_pageid = $_POST['active_pageid'];
				$backend->set_hidden_field('childid');
				$backend->set_hidden_field('parentid');
				$backend->set_hidden_field('active_pageid',$active_pageid);
				$backend->set_hidden_field('open_pageid');
				$backend->set_hidden_field('close_pageid');
				$backend->set_hidden_field('expand_all_pageid');
				$backend->set_hidden_field('collapse_all_pageid');
				$backend->set_hidden_field('undock_site_map',0);

				$backend->print_header();

				$backend->open_section('Identification');

				$backend->open_field('Site Name');
				if($this->site->admin_access())
					echo text_box(name,$this->site->name,50,128,'class=data');
				else
					echo ('<span class=data>'.$this->site->name.'</span>');


				$backend->open_field("Description of Site:<span class=fineprint><br>(not shown on front-end)</span>","top");
				if($this->site->admin_access())
					echo text_area(description,$this->site->description,50,6,0,"class=data");
				else
					echo nl2br('<span class=data>'.$this->site->description.'</span>');


				$backend->open_section("Custom Design");

				$backend->open_field("Design");
				$site_designs = &$this->web_system->get_site_design_list();
				if (
					superuser('web') || 
					($this->site->admin_access() && !empty($this->site->allowed_designids))
				) {
					$designs = array();
					if(!superuser("web")) {
						foreach($this->site->allowed_designids as $designid) {
							$designs[$designid] = $site_designs[$designid];
						}
					} else $designs = &$site_designs;
					echo combo_box("designid",$designs,$this->site->designid, "class=data");
				} else {
					echo('<p class=data>'.$site_designs[$this->site->designid]);
				}

				$pages_section_link = $backend->open_section("Page Tree","page");

				$backend->open_field("Count");
				$page_count = count($index) - 1;
				$too_many_pages = $this->site->max_pages > 0 && $page_count >= $this->site->max_pages;
				echo ("<span ".(($too_many_pages)?"class=warning":"").">$page_count</span>");
				if(superuser("web")) {
					echo(" / ".text_box("max_pages",(($this->site->max_pages > 0)?$this->site->max_pages:"-"),4,6,"class=data")." (Max)");
				} elseif($this->site->max_pages > 0) {
					echo(' / '.$this->site->max_pages.' (Max)');
				}

				$backend->set_hidden_field('max_files',$this->site->max_files); #PUT THESE IN AN PROPER FIELDS
				$backend->set_hidden_field('max_file_bytes',($this->site->max_file_bytes/1024)/1024); # WHEN THE FILES SECTION APPEARS


				$floating_site_map_open   = $session->get_var('floating_site_map_open');
				$floating_site_map_siteid = $session->get_var('floating_site_map_siteid');

				if ($floating_site_map_open) {
					if ($floating_site_map_siteid != $this->site->id) {
						?><script language="javascript">undock_site_map(<?=$this->site->id?>)</script><?
					}

					$backend->open_field('Site Map<span class=fineprint><br>(Alt + H)</span>','top');
					?>&nbsp;&nbsp;<a href="javascript:dock_site_map(<?=$this->site->id?>);"><img src="images/icons/dock.gif" border="0"></a>&nbsp;&nbsp;&nbsp;<a href="javascript:undock_site_map(<?=$this->site->id?>);"><img src="images/icons/bring2front.gif" border="0"></a><?
				} else {
					if($this->site->admin_access() && count($this->site->get_top_pageids()) > 1) {
						$backend->open_field('Reorder Main Pages');
						$backend->print_icon_button('javascript: popup_page_orderer('.$this->site->id.',0)','Reorder the main pages','reorder');
					}

					$site_map_jump = $backend->open_field('Site Map<span class=fineprint><br>(Alt + H)</span>','top');

					$open_pageid = $_POST['open_pageid'];
					$close_pageid = $_POST['close_pageid'];
					if($open_pageid || $close_pageid) {
						$backend->set_jumpto($site_map_jump);
					}
					?>
					<table cellpadding=0 cellspacing=0 border=0>
						<tr>
							<td><a href="javascript:if (connect_child > 0) {document.edit.action.value='Connect';document.edit.childid.value=connect_child;document.edit.parentid.value='0';document.edit.submit()}" onmouseover="if (connect_child > 0) {window.status='Make \''+connect_child_name+'\' a Main Page.';} else{window.status='';} return true;" onmouseout="window.status='';return true;"><img src="images/icons/site.gif" width=20 height=20 border=0></a></td>
							<td nowrap><p class=data><b><?=$this->site->name?></td>
							<td>&nbsp;&nbsp;&nbsp;</td>
							<td><a href="javascript:expand_all_page(0);"><img src="images/expand_all.gif" width="82" height="19" border="0"></a></td>
							<td>&nbsp;&nbsp;&nbsp;</td>
							<td><a href="javascript:collapse_all_page(0);"><img src="images/collapse_all.gif" width="88" height="19" border="0"></a></td>
							<td align="right" width="100%">&nbsp;<a href="javascript:undock_site_map(<?=$this->site->id?>);"><img src="images/icons/undock.gif" border="0"></a></td>
						</tr>
					</table>
					<table cellpadding=0 cellspacing=0 border=0 width=100%>
					<?
					$this->print_page_hierarchy($this->site->get_top_pageids());
					?></table><?
				}

				$backend->open_field("Index Page");
				if ($this->site->admin_access()) {
					$top_pageids = $this->site->get_top_pageids();
					foreach($top_pageids as $top_pageid)
						$top_pages_array[$top_pageid] = $index[$top_pageid]['name'];
					echo combo_box("index_pageid",$top_pages_array,$this->site->index_pageid,"class=data");
					unset($top_pages_array);
				} else {
					echo ("<p class=data>".$index[$this->site->index_pageid]['name']);
				}

				$backend->open_field("Not Found Page");
				if ($this->site->admin_access()) {
					$top_pageids = $this->site->get_top_pageids();
					$top_pages_array = array();
					foreach($top_pageids as $top_pageid)
						$top_pages_array[$top_pageid] = $index[$top_pageid]['name'];
					echo combo_box("not_found_pageid",array("")+$top_pages_array,$this->site->not_found_pageid,"class=data");
					unset($top_pages_array);
				} else {
					echo ("<p class=data>".$index[$this->site->not_found_pageid]['name']);
				}

				$backend->open_field("Forbidden Page");
				if ($this->site->admin_access()) {
					$pages_array = $this->web_system->page_array_with_sticks($this->site->id);
					echo combo_box("forbidden_pageid",array("")+$pages_array,$this->site->forbidden_pageid,"class=data");
					unset($pages_array);
				} else {
					echo ("<p class=data>".$index[$this->site->forbidden_pageid]['name']);
				}

				if($this->site->editor_access()) {
					$backend->open_field("Create New Pages?","top");
					echo combo_box("new_page_template", $XTRAS->list_type("page/templates",((superuser("web")) ? Array() : $this->site->allowed_templates)), "standard", "class=data")."<br>";
					echo text_area("new_page_names","", 50, 5, 0,"class=data");
				}

				$backend->open_section("URLs","preview");
				if(!count($this->site->urls)) {
					$backend->open_field("<span class=warning>WARNING:</span>");
					echo ("<span class=warning>This site has no URLs pointing to it. It cannot be viewed, previewed, or edited.</span>");
				}
				global $URL_PROTOCOLS;
				if($this->site->admin_access()) {
					$url_count = 0;
					foreach($this->site->urls as $url => $protocol) {
						$backend->open_field(++$url_count);
						echo combo_box("urls[$url_count][protocol]",$URL_PROTOCOLS,$protocol,'class=data');
						echo text_box("urls[$url_count][url]",$url,50,128,'class=data');
					}
					while($url_count <= count($this->site->urls)) {
						$backend->open_field(++$url_count);
						echo combo_box("urls[$url_count][protocol]",$URL_PROTOCOLS,'','class=data');
						echo text_box("urls[$url_count][url]","",50,128,'class=data');
					}
				} else {
					$url_count = 0;
					foreach($this->site->urls as $url => $protocol) {
						$backend->open_field(++$url_count);
						echo "<span class=data>$URL_PROTOCOLS[$protocol]</span>";
						echo "<span class=data>$url</span>";
					}
				}

				break;
		}


		$backend->print_commit_button("Commit","document.edit.submit()");
		$backend->print_footer();

	}


	/**
	* Prints a hierarchy table of all the site's page information
	*
	* @param   array int $pageids		The array or pageids representing pages to print
	* @param   array boolean $depth
	* @param   boolean $static			Whether or not moving of pages is enabled
	* @param   boolean $from_popup		Whether this heirarchy is being printed in a popup or not
	* @access  public
	*/
	function print_page_hierarchy(&$pageids,$depth=array(),$static=false,$from_popup=false) {
		global $PAGE_STATUSES, $SQUIZLIB_PATH, $XTRAS;
		include_once("$SQUIZLIB_PATH/colour/colour.inc");
		$depth[] = true; # The indenting level, stalk on/off
		if ($from_popup) {
			$href_prefix = 'window.opener';
		} else {
			$href_prefix = 'document';
		}

		global $PAGE_STATUS_COLOUR;

		 ########################################
		# Make sure we know which pages are open
		$index   = &$this->site->get_page_index();
		$this->_print_page_hierarchy_open_pages();
		if (!$pageid) $pageid = array();
		reset($pageid);
		for($pageid = reset($pageids); $pageid; $pageid = next($pageids)) {
			if (!next($pageids)) $end = true;
			else $end = false;
			prev($pageids);

			$page    = &$index[$pageid];
			$haskids = isset($page['childids']) && !empty($page['childids']);
			$open    = $page[open];

			$bg_img = 'images/page_'.(($page['effective_visible']) ? '' : 'in').'visible_'.$PAGE_STATUS_COLOUR[$page['effective_status']].'.gif';

			?>
			<a name=page<?=$pageid?>>
			<tr>
			<td background="<?=$bg_img?>"><table cellpadding=0 cellspacing=0 border=0>
				<tr>
				<?
				for ($i = 0; $i < count($depth); $i++) {
					?><td valign=top <? if ($depth[$i] && !($end && ($i == count($depth)-1))) echo "background=\"images/tree/stalk.gif\"" ?> ><?
					if ($i != count($depth) - 1) {
						?><img src="images/blank.gif" height=1 width=20><?
					} else {
						if ($haskids && !$static) {
							?><a href="javascript:<?=(($open) ? "close_page('$page[pageid]')" : "open_page('$page[pageid]')")?>;" onmouseover="window.status='<?=(($open)?"Hide subpages":"Show sub-pages")?>'; return true;" onmouseout="window.status='';return true;"><img src="images/tree/branch_<?=(($open)?"open":"closed")?>.gif" alt="<?=(($open)?"Hide":"Show")?> subpages" height=20 width=20 border=0></a><?
						} else {
							?><img src="images/tree/branch.gif" height=20 width=20><?
						}
					}
					?></td><?
				}

				$state = (($page['public'])?"Public":"Private") ."/" . $PAGE_STATUSES[$page['status']];
				$effective_state = (($page['effective_public'])?"Public":"Private") ."/" . $PAGE_STATUSES[$page['effective_status']];

				?>
					<td valign=top background="<?=$bg_img?>"><? if (!$static) { ?><a href="javascript:if (connect_child != 0) {document.edit.action.value='Connect';document.edit.childid.value=connect_child;document.edit.parentid.value='<?=$page['pageid']?>';document.edit.submit()} else {set_connect_child( ((confirm('To connect this page to a new parent, click the icon of another page you wish <?=addslashes($page['name'])?> page to be a sub-page of.'))?'<?=$page['pageid']?>':false),'<?=addslashes($page['name'])?>');}" onmouseover="if (connect_child != 0) {window.status='Make this page the parent of the \''+connect_child_name+'\'.';} else{window.status='Connect this page to a different parent.';} return true;" onmouseout="window.status='';return true;"><? } ?><img src="images/tree/page_<?=(($page['effective_public'])?"tick":"cross") ?>.gif" width=16 height=20 border=0 alt="<?=(($effective_state != $state)?"$state, but parent is $effective_state":$state) ?>"></a><img src="images/blank.gif" width=5 height=20></td>
					<td><img src="images/blank.gif" width=5 height=20></td>
					<td<?=(!$from_popup) ? ' class=data' : ''?>><a href="#" <?=($from_popup) ? 'style="font-size=10"' : ''?> onClick="Javascript:<?=$href_prefix?>.location.href='page.php?pageid=<?=$page['pageid']?>'; return false;" onmouseover="show_tooltip(event,'<?=addslashes(htmlspecialchars($page['name']))?> (ID: <?=$page['pageid']?>)','<?=addslashes(htmlspecialchars(ereg_replace("[\n\r]"," ",$page['description'])))?>',300); return true;" onmouseout="hide_tooltip(); return true;"><?=$page['name']?></a></td>
				</tr>
			</table></td><td background="<?=$bg_img?>" valign="bottom">
				<?=($from_popup && $this->site->admin_access()) ? '<input type="checkbox" name="with_selected_ids['.$page['pageid'].']">&nbsp;' : ''?>
				<?=(!$from_popup) ? '(' : ''?><a href="#" onClick="Javascript:<?=$href_prefix?>.location.href='page.php?pageid=<?=$page['pageid']?>&template_edit=1'; return false;" onmouseover="show_tooltip(event,'Contents - <?=addslashes(htmlspecialchars($XTRAS->name("page/templates", $page['template'])));?> (ID: <?=$page['pageid']?>)', 'Edit the Contents of &quot;<?=addslashes(htmlspecialchars($page['name']))?>&quot;',300); return true;" onmouseout="hide_tooltip(); return true;"><?=($from_popup) ? '<img src="images/icons/contents.gif" height=15 width=15 border=0>' : 'contents'?></a><?=(!$from_popup) ? ')' : ''?></td>
			</tr>
			<?
			if (isset($page['childids']) && count($page['childids']) > 0 && ($open||$static)) {
				if ($end) $depth[count($depth)-1] = false;
				$this->print_page_hierarchy($page['childids'], $depth, $static, $from_popup);
			}
		}
	}


	/**
	* Simply remebers which pages are open in the displayed tree
	*
	* @access  private
	*/
	function _print_page_hierarchy_open_pages() {
		$session = &get_mysource_session();
		if($session->get_var('print_page_hierarchy_open_pages_called')) return 0;

		 ##########################################################
		# Remember which pages have been opened in the printed tree
		if(!$open_pages = &$session->get_var('site_backend_open_pages')) {
			$open_pages = array();
			$session->set_var("site_backend_open_pages",$open_pages);
		}

		$open_pageid = $_POST['open_pageid'];
		$close_pageid = $_POST['close_pageid'];
		$expand_all_pageid = $_POST['expand_all_pageid'];
		$collapse_all_pageid = $_POST['collapse_all_pageid'];
		if ($expand_all_pageid != "") {
			$this->_print_page_hierarchy_expand_all($open_pages, $expand_all_pageid);
		}
		if($open_pageid && !in_array($open_pageid,$open_pages)) {
			$open_pages[] = $open_pageid;
		}
		if ($collapse_all_pageid != "") {
			$this->_print_page_hierarchy_collapse_all($open_pages, $collapse_all_pageid);
		}
		if($close_pageid) {
			foreach($open_pages as $id => $pageid) {
				if($close_pageid == $pageid) {
					unset ($open_pages[$id]);
				}
			}
		}
		$index = &$this->site->get_page_index();
		foreach($open_pages as $id => $pageid) {
			if(isset($index[$pageid])) $index[$pageid]['open'] = true;
		}

		return ($print_page_hierarchy_open_pages_called = 1);
	}

	/**
	* Opens out all the pages under the given page
	*
	* @param   array int $open_pages	The array of pageids representing pages that are currently being displayed in the page heirarchy
	* @param   int $pageid				The pageid to start the expansion from
	* @access  private
	*/
	function _print_page_hierarchy_expand_all(&$open_pages, $pageid=0) {
		$index = &$this->site->get_page_index();
		if (count($index[$pageid]['childids'])) {
			$open_pages[] = $pageid;
			foreach ($index[$pageid]['childids'] as $childid) {
				$this->_print_page_hierarchy_expand_all($open_pages, $childid);
			}#end foreach
		}#end if
	}#end _print_page_hierarchy_expand_all()

	/**
	* Closes out all the pages under the given page
	*
	* @param   array int $open_pages	The array of pageids representing pages that are currently being displayed in the page heirarchy
	* @param   int $pageid				The pageid to start collapsing from
	* @access  private
	*/
	function _print_page_hierarchy_collapse_all(&$open_pages, $pageid=0) {
		$index = &$this->site->get_page_index();
		if (count($index[$pageid]['childids'])) {
			foreach($open_pages as $id => $open_pageid) {
				if($open_pageid == $pageid) {
					unset ($open_pages[$id]);
				}
			}
			foreach ($index[$pageid]['childids'] as $childid) {
				$this->_print_page_hierarchy_collapse_all($open_pages, $childid);
			}#end foreach
		}#end if
	}#end _print_page_hierarchy_collapse_all()

	/**
	* Prints an interface for ordering pages
	*
	* @access  private
	*/
	function _print_page_orderer() {
		$backend = &$this->web_system->get_backend();

		# if they passed a pageid then we are re-ordering a specific pages subpages
		# otherwise we are redordering the top-level pages
		$pageid = $_GET['pageid'];
		if ($pageid) {
			# Get the current page - will return false if none
			$page = &$this->get_page($pageid);
		}

		$backend->set_heading("Reorder ".(($page->id)?"Subp":"Main P")."ages","page");
		$backend->set_subheading((($page->id)?$page->name:$this->site->name));
		$backend->set_id_string($this->site->id);
		$backend->hide_tabs();

		$index = &$this->site->get_page_index();
		$childids = $index[$pageid]['childids'];

		$js = "
			var temp_no = 0;
			var temp_name = 'Blah';
			var f = 'document.edit';
			function swap(a,b) {
				// Swap Pageids
				eval('temp_no = '+f+'.childid' + a + '.value');
				eval(f+'.childid' + a + '.value = '+f+'.childid' + b + '.value');
				eval(f+'.childid' + b + '.value = temp_no');
				// Swap page names
				eval('temp_name = '+f+'.name' + a + '.value');
				eval(f+'.name' + a + '.value = '+f+'.name' + b + '.value');
				eval(f+'.name' + b + '.value = temp_name');
			}

			function move_up(no) {
				if (no > 1) {
					swap(no, no - 1);
				}
			}
			function move_down(no) {
				if (no < ".count($childids).") {
					swap(no, no + 1);
				}
			}

			var reverse = 1;
			function sort_list(sort_num) {
				reverse = sort_num;
				var nameArray = new Array();
				for(var i = 1; i < ".(count($childids) + 1)."; i++)	{
					// put page names into array
					var obj = new Object();
					obj.name    = window.document.edit.elements['name'    + i].value;
					obj.childid = window.document.edit.elements['childid' + i].value;
					obj.i = i;
					nameArray.push (obj)
				}
				nameArray.sort(compare);
				// go through the sorted list and swap pages into their correct positions
				for(var x = 0; x < nameArray.length; x++)	{
					window.document.edit.elements['name'    + (x+1)].value = nameArray[x].name;
					window.document.edit.elements['childid' + (x+1)].value = nameArray[x].childid;
				}
			}
			function compare(a,b) {
				if (a.name.toLowerCase() < b.name.toLowerCase()) {
					return (-1 * reverse);
				}
				if (a.name.toLowerCase() == b.name.toLowerCase()) {
					return 0;
				}
				if (a.name.toLowerCase() > b.name.toLowerCase()) {
					return (1 * reverse);
				}
			}
		";

		$backend->set_javascript($js);


		 ######################################################
		# Commit changes
		$action = $_POST['action'];
		if ($action == "Commit") {
			$db = &$this->get_db();
			if (is_array($_POST)) {
				foreach($_POST as $key => $childid) {
					if (substr($key, 0, 7) != "childid") continue;
					$orderno = substr($key, 7);
					$db->update("UPDATE page SET orderno='$orderno' WHERE pageid='$childid'");
				}
			}
			$this->site->clear_page_index();
			$backend->add_message("Pages reordered");
			$backend->set_javascript("window.opener.refresh();window.close();");
		}

		$backend->set_subheading("", "");
		$backend->remove_toolbar_button("preview");
		$backend->print_header();
		?>
		<p>&nbsp;
		<?
		if (strstr(strtolower($_SERVER['HTTP_USER_AGENT']), "msie")) {
			$boxwidth = 40;
		} else {
			$boxwidth = 20;
		}
		$backend->open_section("List");
		$backend->open_field("<a href=\"javascript:sort_list(1)\" onmouseover=\"show_tooltip(event,'Sort Ascending','Sorts the pages in alphabetical order (A-Z)',200); return true;\" onmouseout=\"hide_tooltip(); return true;\"><img src=\"images/icons/sorta_z.gif\" border=0></a>&nbsp;<br><br><a href=\"javascript:sort_list(-1)\" onmouseover=\"show_tooltip(event,'Sort Descending','Sorts the pages in reverse alphabetical order (Z-A)',200); return true;\" onmouseout=\"hide_tooltip(); return true;\"><img src=\"images/icons/sortz_a.gif\" border=0></a>&nbsp;</p>","top");

		$i = 1;
		if (is_array($childids)) {
			foreach($childids as $childid) {
				$name = $index[$childid]['name'];
				?>
				<a href="javascript:move_up(<?=$i?>)"><img src="images/uparrow.gif" alt="Move Up" border=0></a>
				<input type=hidden name="childid<?=$i?>" value=<?=$childid?>>
				<input type=text name="name<?=$i?>" value="<?=str_replace("\"","&quot;",$name)?>" size=<?=$boxwidth?> onfocus=blur()>
				<a href="javascript:move_down(<?=$i?>)"><img src="images/downarrow.gif" alt="Move Down" border=0></a><br>
				<?
				$i++;
			}
		}

		$backend->print_commit_button("Commit","document.edit.action.value='Commit';document.edit.submit();");

		$backend->print_footer();

	}#end _print_page_orderer()


	/**
	* Prints the interface for the floating site map
	*
	* @access  public
	*/
	function print_floating_site_map() {
		$action = $_POST['action'];
		$backend = &$this->setup_backend();
		$session = &get_mysource_session();

		if ($action == 'Connect') {
			$parentid = $_POST['parentid'];
			$childid = $_POST['childid'];
			$child = new Page($childid,$this->web_system);
			$backend->add_message($child->move($this->site->id,$parentid));
			$this->site->clear_page_index();
			$index = &$this->site->get_page_index();
		} elseif ($action == 'Dock') {
			$session->unset_var('floating_site_map_open');
			?><script language="Javascript">window.close();</script><?
			return;
		} elseif ($action == 'Commit') {
			$with_selected_action = trim($_POST['with_selected_action']);
			$with_selected_ids = $_POST['with_selected_ids'];
			$with_selected_children = $_POST['with_selected_children'];
			if ($this->site->admin_access() && $with_selected_action && count($with_selected_ids)) {
				switch ($with_selected_action) {
					case 'live' :
						foreach ($with_selected_ids as $pageid => $on) {
							$page = &$this->get_page($pageid);
							if ($page->admin_access()) {
								$backend->add_message($page->add_status('L'));
								if($with_selected_children) {
									$subpageids = $page->get_subpageids();
									foreach($subpageids as $subpageid) {
										$subpage = &$this->get_page($subpageid);
										$backend->add_message($subpage->add_status('L'));
										$this->web_system->forget_page($subpage);
									}
								}
							}
							$this->web_system->forget_page($page);
						}
						break;
					case 'under_construction' :
						foreach ($with_selected_ids as $pageid => $on) {
							$page = &$this->get_page($pageid);
							if ($page->admin_access()) {
								$backend->add_message($page->add_status('U'));
								if($with_selected_children) {
									$subpageids = $page->get_subpageids();
									foreach($subpageids as $subpageid) {
										$subpage = &$this->get_page($subpageid);
										$backend->add_message($subpage->add_status('U'));
										$this->web_system->forget_page($subpage);
									}
								}
							}
							$this->web_system->forget_page($page);
						}
						break;
					case 'show' :
							foreach ($with_selected_ids as $pageid => $on) {
								$page = &$this->get_page($pageid);
								if ($page->admin_access()) {
									$backend->add_message($page->set_visible(1));
									if($with_selected_children) {
										$subpageids = $page->get_subpageids();
										foreach($subpageids as $subpageid) {
											$subpage = &$this->get_page($subpageid);
											$backend->add_message($subpage->set_visible(1));
											$this->web_system->forget_page($subpage);
										}
									}
								}
								$this->web_system->forget_page($page);
							}
						break;
					case 'hide' :
						foreach ($with_selected_ids as $pageid => $on) {
							$page = &$this->get_page($pageid);
							if ($page->admin_access()) {
								$backend->add_message($page->set_visible(0));
								if($with_selected_children) {
									$subpageids = $page->get_subpageids();
									foreach($subpageids as $subpageid) {
										$subpage = &$this->get_page($subpageid);
										$backend->add_message($subpage->set_visible(0));
										$this->web_system->forget_page($subpage);
									}
								}
							}
							$this->web_system->forget_page($page);
						}
						break;
					case 'public' :
						foreach ($with_selected_ids as $pageid => $on) {
							$page = &$this->get_page($pageid);
							if ($page->admin_access()) {
								$backend->add_message($page->set_public(1));
								if($with_selected_children) {
									$subpageids = $page->get_subpageids();
									foreach($subpageids as $subpageid) {
										$subpage = &$this->get_page($subpageid);
										$backend->add_message($subpage->set_public(1));
										$this->web_system->forget_page($subpage);
									}
								}
							}
							$this->web_system->forget_page($page);
						}
						break;
					case 'private' :
						foreach ($with_selected_ids as $pageid => $on) {
							$page = &$this->get_page($pageid);
							if ($page->admin_access()) {
								$backend->add_message($page->set_public(0));
								if($with_selected_children) {
									$subpageids = $page->get_subpageids();
									foreach($subpageids as $subpageid) {
										$subpage = &$this->get_page($subpageid);
										$backend->add_message($subpage->set_public(0));
										$this->web_system->forget_page($subpage);
									}
								}
							}
							$this->web_system->forget_page($page);
						}
						break;
				}
			}
		}

		$active_pageid = $_POST['active_pageid'];
		$backend->set_hidden_field('childid');
		$backend->set_hidden_field('parentid');
		$backend->set_hidden_field('active_pageid',$active_pageid);
		$backend->set_hidden_field('open_pageid');
		$backend->set_hidden_field('close_pageid');
		$backend->set_hidden_field('expand_all_pageid');
		$backend->set_hidden_field('collapse_all_pageid');

		$backend->print_floating_site_map_header();

		?>
		<script language="javascript">
		function markAll(form, on) {

			for(var j=0; j < form.elements.length; j++) {
				if (form.elements[j].type == 'checkbox' && form.elements[j].name != 'with_selected_children') {
					if (form.elements[j].checked != on) {
						form.elements[j].checked = on;
					}
				}
			}// end for

		}// end markAll()
		</script>
		<table width="100%" cellpadding="3" cellspacing="0" border="0">
			<tr>
				<td bgcolor="#e0e0e0" valign="top">
		<?


		if($this->site->admin_access() && count($this->site->get_top_pageids()) > 1) {
			$backend->print_icon_button('javascript: popup_page_orderer('.$this->site->id.',0)','Reorder the main pages','reorder');
			echo '&nbsp;Reorder Main Pages';
		}

		if($_POST['open_pageid'] || $_POST['close_pageid']) {
			$backend->set_jumpto($site_map_jump);
		}
		?>
		<table cellpadding=0 cellspacing=0 border=0>
			<tr>
				<td><a href="javascript:if (connect_child > 0) {document.edit.action.value='Connect';document.edit.childid.value=connect_child;document.edit.parentid.value='0';document.edit.submit()}" onmouseover="if (connect_child > 0) {window.status='Make \''+connect_child_name+'\' a Main Page.';} else{window.status='';} return true;" onmouseout="window.status='';return true;"><img src="images/icons/site.gif" width=20 height=20 border=0></a></td>
				<td width="100%"><p class=data></td>
				<td>&nbsp;&nbsp;&nbsp;</td>
				<td><a href="javascript:expand_all_page(0);"><img src="images/expand_all.gif" width="82" height="19" border="0"></a></td>
				<td>&nbsp;&nbsp;&nbsp;</td>
				<td><a href="javascript:collapse_all_page(0);"><img src="images/collapse_all.gif" width="88" height="19" border="0"></a></td>
			</tr>
		</table>
		<table cellpadding=0 cellspacing=0 border=0 width=100%>
			<?
			$this->print_page_hierarchy($this->site->get_top_pageids(),'','',true);
			?>
		</table>
		</td></tr>
		<?
		if ($this->site->admin_access()) {
			?>
			<tr>
				<td style="font-size=10" align="right">&nbsp;<b>With Selected</b>&nbsp;
				<select name="with_selected_action" style="font-size=10">
					<option value="">&nbsp;</option>
					<option value="live">Make Live</option>
					<option value="under_construction">Place Under Contruction</option>
					<option value="show">Show In Menu</option>
					<option value="hide">Hide In Menu</option>
					<option value="public">Make Public</option>
					<option value="private">Make Private</option>
				</select>
				&nbsp;<b>Affect Children</b>&nbsp;<input type="checkbox" name="with_selected_children" value="on">
				</td>
			</tr>
			<tr>
				<td>
					<table border="0" width="100%" bgcolor="#c0c0c0" cellspacing="0" cellpadding="0">
						<tr>
						<td>
							<span class="sectionheading"><input type="button" class="field" value="Update" onclick="document.edit.submit()"><script language="javascript">function checksubmitform() { document.edit.submit()}</script></span>
						</td>
						<td style="font-size=10" align="right">
							&nbsp;<b>Check/Uncheck All</b>&nbsp;<input type="checkbox" name="master" value="on" onClick="javascript: markAll(this.form, this.checked);">
						</td>
						</tr>
					</table>
				</td>
			</tr>
			<?
		}
		?></table><?

		$backend->print_footer();

		$floating_site_map_open = $session->get_var('floating_site_map_open');

		if (!$floating_site_map_open) {
			?>
			<script language="Javascript">
				window.opener.edit.action.value = '';
				window.opener.edit.submit();
			</script>
			<?
			# register in the session that the popup is open
			$open = true;
			$session->set_var('floating_site_map_open', $open);
		}
		$session->set_var('floating_site_map_siteid', $this->site->id);
	}

}#end class


?>
