    ##############################################
   ### MySource ------------------------------###
  ##- Database Table Definition File - MySQL--##
 #-- Copyright Squiz.net ---------------------#
##############################################
## This file is subject to version 1.0 of the
## MySource License, that is bundled with
## this package in the file LICENSE, and is
## available at through the world-wide-web at
## http://mysource.squiz.net/
## If you did not receive a copy of the MySource
## license and are unable to obtain it through
## the world-wide-web, please contact us at
## mysource@squiz.net so we can mail you a copy
## immediately.
##
## File: db/web_ChangeLog.sql
## Desc: Listing of changes to the web database structure for each release
## $Source: /home/cvsroot/mysource/db/mysql_web_ChangeLog.sql,v $
## $Revision: 2.12.2.3 $
## $Author: bvial $
## $Date: 2002/12/06 05:34:55 $
#######################################################################

 ####################
# 2.2.0 to 2.4.0
ALTER TABLE site_url ADD COLUMN protocol VARCHAR(10) NOT NULL;
ALTER TABLE page ADD COLUMN ssl TINYINT NOT NULL;


ALTER TABLE site ADD COLUMN forbidden_pageid MEDIUMINT UNSIGNED NOT NULL;
ALTER TABLE page ADD COLUMN imageid MEDIUMINT UNSIGNED DEFAULT 0 NOT NULL;
ALTER TABLE file ADD COLUMN log_hits SET('Y','N') DEFAULT 'N' NOT NULL AFTER visible;

CREATE TABLE log_page_not_found (
  pageid    MEDIUMINT UNSIGNED NOT NULL,
  sessionid CHAR(32)  NOT NULL,
  hit_time  DATETIME  NOT NULL,
  userid    MEDIUMINT UNSIGNED NOT NULL,
  referer   TEXT      NOT NULL,
  KEY       (pageid),
  KEY       (hit_time),
  KEY       (sessionid),
  KEY       (userid)
);

ALTER TABLE page        CHANGE next_status_change next_action DATETIME NOT NULL;
ALTER TABLE page_status RENAME page_action;
ALTER TABLE page_action CHANGE status action_value VARCHAR(255) NOT NULL;
ALTER TABLE page_action ADD COLUMN action VARCHAR(255) NOT NULL;
ALTER TABLE page_action ADD INDEX (ACTION);
ALTER TABLE page_action DROP PRIMARY KEY;
ALTER TABLE page_action ADD  PRIMARY KEY (pageid,date,action);
UPDATE      page_action SET action='status';

CREATE TABLE page_admin (
  userid      MEDIUMINT UNSIGNED NOT NULL,
  pageid      MEDIUMINT UNSIGNED NOT NULL,
  PRIMARY KEY (userid,pageid),
  KEY         (pageid)
);

ALTER TABLE page_action DROP PRIMARY KEY;
ALTER TABLE page_action CHANGE userid userid MEDIUMINT(8) UNSIGNED NOT NULL;
ALTER TABLE page_action ADD KEY(pageid);
ALTER TABLE page_action ADD KEY(date);
ALTER TABLE page_action ADD KEY(userid);

ALTER TABLE page_admin ADD COLUMN parameters VARCHAR(255) DEFAULT '0';
ALTER TABLE site_admin ADD COLUMN parameters VARCHAR(255) DEFAULT '0';


 ####################
# 2.0.2 BETA to 2.2.0
ALTER TABLE page ADD COLUMN designid MEDIUMINT UNSIGNED DEFAULT 0 NOT NULL;
ALTER TABLE page CHANGE COLUMN short_name short_name VARCHAR(40) NOT NULL;
ALTER TABLE page_editor ADD COLUMN readonly TINYINT UNSIGNED DEFAULT 0 NOT NULL;

 ###########################
# 0.9.5 BETA to 2.0.2 BETA
CREATE TABLE site_design_customisation (
  customisationid  varchar(255) NOT NULL,
  designid         MEDIUMINT(7) UNSIGNED NOT NULL,
  design           LONGTEXT     NOT NULL,
  PRIMARY KEY   (customisationid)
);
ALTER TABLE site DROP COLUMN design;
ALTER TABLE site_design ADD COLUMN public TINYINT UNSIGNED NOT NULL DEFAULT 1;


ALTER TABLE site ADD COLUMN not_found_pageid MEDIUMINT UNSIGNED NOT NULL;
ALTER TABLE page ADD COLUMN visible TINYINT(3) UNSIGNED DEFAULT 1 NOT NULL;

ALTER TABLE page DROP COLUMN status;
ALTER TABLE page ADD COLUMN next_status_change datetime NOT NULL;
ALTER TABLE page ADD KEY (next_status_change);

CREATE TABLE page_status (
	pageid         MEDIUMINT     UNSIGNED NOT NULL,
	date           DATETIME      NOT NULL,
	status         CHAR(1)       NOT NULL,
	userid         MEDIUMINT(8)  UNSIGNED NOT NULL,
	log            VARCHAR(255)  NOT NULL,
	PRIMARY KEY(pageid,date),
	KEY(userid),
	KEY(status)
);



 ###########################
# 0.9.4 BETA to 0.9.5 BETA
ALTER TABLE site ADD default_languages VARCHAR(255) NOT NULL;
ALTER TABLE site ADD default_charset   VARCHAR(255) NOT NULL;

ALTER TABLE page ADD default_languages VARCHAR(255) NOT NULL;
ALTER TABLE page ADD default_charset   VARCHAR(255) NOT NULL;

 ##########################
# 0.9.1 BETA to 0.9.2 BETA
ALTER TABLE log_session ADD referer TEXT NOT NULL;

CREATE TABLE url_lookup (
	url       VARCHAR(255) NOT NULL,
	info      TEXT,
	PRIMARY KEY(url)
);

CREATE TABLE page_dir (
  pageid       MEDIUMINT    UNSIGNED NOT NULL,
  dir          VARCHAR(255) NOT NULL,
  orderno      TINYINT      UNSIGNED NOT NULL,
  PRIMARY KEY (pageid,dir),
  KEY         (dir),
  KEY         (orderno)
);
