/***************************************************************************
 Mutella - A commandline/HTTP client for the Gnutella filesharing network.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 packet.h  -  Node and packet definitions for gnutella protocol.
 
 the original version of this file was taken from Gnucleus (http://gnucleus.sourceforge.net)

    begin                : Thu May 31 2001
    copyright            : (C) 2001 by
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#if !defined(__PACKET_H_INCLUDED__)
#define __PACKET_H_INCLUDED__

#include "byteorder.h"

/////////////////////////////////////////////////////////////////////////////
// Gnutella packets

#pragma pack (1)

struct packet_Header		// Size 23
{
	GUID  Guid;					// 0  - 15
	BYTE  Function;				// 16
	BYTE  TTL;					// 17
	BYTE  Hops;					// 18
	LE(DWORD) le_Payload;		// 19 - 22
};


struct packet_Ping			// Size 23
{
	packet_Header Header;		// 0  - 22	
};


struct packet_Pong				// Size 37
{
	packet_Header Header;		// 0  - 22
	LE(WORD)      le_Port;		// 23 - 24
	IP            Host;			// 25 - 28
	LE(DWORD)     le_FileCount;	// 29 - 32
	LE(DWORD)     le_FileSize;	// 33 - 36
};


struct packet_Query			// Size 26+
{		
	packet_Header Header;		// 0  - 22
	LE(WORD)      le_Speed;		// 23 - 24
	// Search					// 25+
};


struct packet_QueryHit		// Size 35+
{
	packet_Header Header;		// 0  - 22
	BYTE          TotalHits;	// 23
	LE(WORD)      le_Port;		// 24 - 25
	IP            Host;			// 26 - 29
	LE(DWORD)     le_Speed;		// 30 - 33
	// QueryHitItem				// 34+
	
	// QueryHit Descriptor

	// ClientGuid				// Last 16 bytes
};

struct packet_QueryHitItem	// Size 9+
{
	LE(DWORD) le_Index;				// 0  - 3
	LE(DWORD) le_Size;				// 4  - 7
	// FileName						// 8+	
};

struct packet_QueryHitEx	    // Size 6+
{
	BYTE VendorID[4];			// 0  - 3
	BYTE Length;				// 4

	// Public Sector
	unsigned	FlagPush	 : 1; // 5
	unsigned	FlagBad 	 : 1;
	unsigned	FlagBusy	 : 1;
	unsigned	FlagStable   : 1;
	unsigned	FlagSpeed	 : 1;
	unsigned    FlagTrash    : 3;

	unsigned    Push		 : 1; // 6
	unsigned	Bad			 : 1;
	unsigned	Busy		 : 1;
	unsigned	Stable  	 : 1;
	unsigned	Speed		 : 1;
	unsigned    Trash		 : 3;

	// Private Sector
	LE(WORD)	le_MetaSize;
};

/*struct packet_QueryHitEx	    // Size 6+
{
	byte VendorID[4];			// 0  - 3
	byte Length;				// 4

	// Public Sector
	byte Push		 : 1; // 5
	byte FlagBad 	 : 1;
	byte FlagBusy	 : 1;
	byte FlagStable  : 1;
	byte FlagSpeed	 : 1;
	byte FlagTrash   : 3;

	byte FlagPush	 : 1; // 6
	byte Bad		 : 1;
	byte Busy		 : 1;
	byte Stable  	 : 1;
	byte Speed		 : 1;
	byte Trash		 : 3;

	WORD MetaSize;

	// Private Sector

};*/

struct packet_Push			// Size 49
{
	packet_Header Header;		// 0  - 22
	GUID          ServerID;		// 23 - 38
	LE(DWORD)     le_Index;		// 39 - 42
	IP            Host;			// 43 - 46
	LE(WORD)      le_Port;		// 47 - 48
};

struct packet_RouteTableReset	// Size 29
{
	packet_Header Header;		// 0  - 22

	BYTE      PacketType;		// 23
	LE(DWORD) le_TableLength;	// 24 - 27
	BYTE      Infinity;			// 28
};

struct packet_RouteTablePatch	// Size 29+
{
	packet_Header Header;		// 0  - 22

	BYTE PacketType;			// 23
	BYTE SeqNum;				// 24
	BYTE SeqSize;				// 25

	BYTE Compression;		    // 26
	BYTE EntryBits;				// 27

	// Patch Table...			// 28+
};

#pragma pack ()

#endif // __PACKET_H_INCLUDED__


