/***************************************************************************
 Mutella - A commandline/HTTP client for the Gnutella filesharing network.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 gnusearch.h  -  Definition of a representation of a search in progress

    begin                : Wed May 30 2001
    copyright            : (C) 2001 by 
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#ifndef __GNUSEARCH_H_INCLUDED__
#define __GNUSEARCH_H_INCLUDED__

class MGnuDirector;
class MGnuPreferences;
class MGnuNode;

class MGnuSearch : public SGnuSearch
{
friend class MGnuDirector;
public: 
	MGnuSearch(MGnuDirector* pControl,
				const CString& search,
				const CString& sha1,
				int type,
				int size = 0,
				int sizeMode = LIMIT_NONE);
	~MGnuSearch();

	void AddSha1Hash(const CString sha1) {
		if (sha1.length()==32) {
			m_mutex.lock();
			m_setSha1.insert(sha1);
			m_mutex.unlock();
		}
	}
	
	void RemoveSha1Hash(const CString sha1) {
		m_mutex.lock();
		m_setSha1.erase(sha1);
		m_mutex.unlock();
	}
	
	void SendQuery();

	void SendSpecificQuery(const CString& sText, const CString& sSha1);

	void AddtoGroup(const Result&);

	bool IsFull();
	bool CheckLimit(int, DWORD, DWORD);
	
	bool CheckAgainstResult(Result &);
	
	void SetSearchString(const CString& s, bool bLockMutex = true);
	
	void Clear();
	// some public members
	bool   m_bUpdated; // updated flag for MGnuDownload
	MMutex m_mutex;
	//
    typedef list<ResultGroup> GroupList;
	list<ResultGroup>  m_listGroups; // groups of results are stored here
	typedef map<DWORD, Result> ResultMap;
	ResultMap m_mapResults;  // results container
protected:
	bool UpdateExisting(const Result & result); // just checks wether the result is in the list and update it
protected:
	// search kitchen
	char*   m_szSearch;
	vector<char*> m_PlusWords;
	vector<char*> m_MinusWords;
	// packet
	BYTE*  m_Packet;
	int    m_nPacketLength;
	//
	MGnuDirector* m_pDirector;
	MGnuPreferences* m_pPrefs;
};

#endif //__GNUSEARCH_H_INCLUDED__

