//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: musewidgetsplug.cpp,v 1.1.1.1 2003/10/29 10:06:22 wschweer Exp $
//  (C) Copyright 2001-2003 Werner Schweer (ws@seh.de)
//=========================================================

// this file makes some of the MusE widgets available
// to QT-Designer

#include <qwidgetplugin.h>
#include "posedit.h"
#include "poslabel.h"
#include "pitchedit.h"
#include "pitchlabel.h"
#include "sig.h"
#include "tempo.h"
#include "tempolabel.h"
#include "sigedit.h"
#include "slider.h"
#include "doublelabel.h"

int sampleRate = 44100;   // some dummy values to get things compiled/linked
int division = 384;
int mtcType = 0;
bool hIsB = false;

/* XPM */
static const char* slider_pixmap[]={
"22 22 50 1",
". c None",
"f c #004005",
"g c #004007",
"h c #004107",
"m c #004108",
"j c #00430a",
"E c #00501f",
"s c #005021",
"e c #014006",
"l c #024006",
"F c #095e34",
"D c #0b572a",
"k c #0b582b",
"n c #0f5328",
"u c #12562d",
"o c #155a35",
"p c #165c38",
"q c #165c39",
"i c #17501a",
"I c #175522",
"r c #18603f",
"N c #18795e",
"t c #187a60",
"R c #1e5a29",
"y c #22633d",
"O c #307755",
"B c #408262",
"v c #439191",
"G c #468667",
"d c #4c7a51",
"H c #4d8a6c",
"J c #569174",
"C c #599276",
"P c #5e967a",
"A c #63b1c2",
"V c #659477",
"Q c #659b80",
"S c #6da087",
"w c #70b2bc",
"x c #72b5c0",
"z c #74b7c3",
"K c #79a891",
"a c #7ea48a",
"T c #8cb4a0",
"L c #a3c3b3",
"M c #b7d8d1",
"U c #bedcd5",
"c c #c3d2c3",
"b c #f1f5f1",
"# c #ffffff",
"......................",
"......................",
"......................",
"......................",
"......................",
"......###a............",
"......#bcad...........",
"......#bcad...........",
"......#bcad...........",
"..efgh#bcaihhhhhhhjk..",
".lmnop#bcaippppppqrst.",
".huvwx#bcayxxxxxxzABC.",
".DEFGH#bcaIHHHHHHJKLM.",
"..NOPQ#bcaRQQQQQQSTU..",
"......#bcad...........",
"......#bcad...........",
"......#bcad...........",
"......VVVVd...........",
".......dddd...........",
"......................",
"......................",
"......................"};
static const char *posedit_pixmap[] = {
          "22 22 8 1",
          "  c Gray100",
          ". c Gray97",
          "X c #4f504f",
          "o c #00007f",
          "O c Gray0",
          "+ c none",
          "@ c Gray0",
          "# c Gray0",
          "++++++++++++++++++++++",
          "++++++++++++++++++++++",
          "++++++++++++++++++++++",
          "++++++++++++++++++++++",
          "+OOOOOOOOOOOOOOOOOOOO+",
          "OOXXXXXXXXXXXXXXXXXXOO",
          "OXX.          OO OO  O",
          "OX.      oo     O    O",
          "OX.      oo     O   .O",
          "OX  ooo  oooo   O    O",
          "OX    oo oo oo  O    O",
          "OX  oooo oo oo  O    O",
          "OX oo oo oo oo  O    O",
          "OX oo oo oo oo  O    O",
          "OX  oooo oooo   O    O",
          "OX            OO OO  O",
          "OO..................OO",
          "+OOOOOOOOOOOOOOOOOOOO+",
          "++++++++++++++++++++++",
          "++++++++++++++++++++++",
          "++++++++++++++++++++++",
          "++++++++++++++++++++++"
      };

static const char *pitchedit_pixmap[] = {
          "22 22 8 1",
          "  c Gray100",
          ". c Gray97",
          "X c #4f504f",
          "o c #00007f",
          "O c Gray0",
          "+ c none",
          "@ c Gray0",
          "# c Gray0",
          "++++++++++++++++++++++",
          "++++++++++++++++++++++",
          "++++++++++++++++++++++",
          "++++++++++++++++++++++",
          "+OOOOOOOOOOOOOOOOOOOO+",
          "OOXXXXXXXXXXXXXXXXXXOO",
          "OXX.          OO OO  O",
          "OX.      o      O    O",
          "OX.      oo     O   .O",
          "OX       o o    O    O",
          "OX       o      O    O",
          "OX     o o      O    O",
          "OX    oooo      O    O",
          "OX     o        O    O",
          "OX              O    O",
          "OX            OO OO  O",
          "OO..................OO",
          "+OOOOOOOOOOOOOOOOOOOO+",
          "++++++++++++++++++++++",
          "++++++++++++++++++++++",
          "++++++++++++++++++++++",
          "++++++++++++++++++++++"
      };

//---------------------------------------------------------
//   MusEPlugin
//---------------------------------------------------------

class MusEPlugin : public QWidgetPlugin {
   public:
      MusEPlugin() {}
      virtual ~MusEPlugin() {}
      virtual QStringList keys() const;
      virtual QWidget* create(const QString& key, QWidget* parent=0,
        const char* name = 0);
      virtual QString group(const QString& key) const;
      virtual QIconSet iconSet(const QString& key) const;
      virtual QString includeFile(const QString& key) const;
      virtual QString toolTip(const QString& key) const;
      virtual QString whatsThis(const QString& key) const;
      virtual bool isContainer(const QString& key) const;
      };

//---------------------------------------------------------
//   keys
//---------------------------------------------------------

QStringList MusEPlugin::keys() const
      {
      QStringList list;
      list << QString("PosEdit") << QString("PitchEdit")
         << QString("PosLabel") << QString("PitchLabel")
         << QString("TempoLabel")
         << QString("TempoEdit")
         << QString("SigEdit")
         << QString("Slider")
         << QString("DoubleLabel");
      return list;
      }

//---------------------------------------------------------
//   create
//---------------------------------------------------------

QWidget* MusEPlugin::create(const QString& key, QWidget* parent,
   const char* name)
      {
      if (key == QString("PosEdit"))
            return new PosEdit(parent, name);
      else if (key == QString("PitchEdit"))
            return new PitchEdit(parent, name);
      else if (key == QString("PitchLabel"))
            return new PitchLabel(parent, name);
      else if (key == QString("PosLabel"))
            return new PosLabel(parent, name);
      else if (key == QString("TempoLabel"))
            return new TempoLabel(parent, name);
      else if (key == QString("TempoEdit"))
            return new TempoEdit(parent, name);
      else if (key == QString("SigEdit"))
            return new SigEdit(parent, name);
      else if (key == QString("Slider"))
            return new Slider(parent, name);
      else if (key == QString("DoubleLabel"))
            return new DoubleLabel(parent, name);
      return 0;
      }

//---------------------------------------------------------
//   group
//---------------------------------------------------------

QString MusEPlugin::group(const QString& /*key*/) const
      {
      return QString("MusE");
      }

//---------------------------------------------------------
//   iconSet
//---------------------------------------------------------

QIconSet MusEPlugin::iconSet(const QString& key) const
      {
      if (key == "PosEdit" || key == "PosLabel")
            return QIconSet(QPixmap(posedit_pixmap));
      else if (key == "PitchEdit" || key == "PitchLabel")
            return QIconSet(QPixmap(pitchedit_pixmap));
      else if (key == "TempoEdit" || key == "TempoLabel")
            return QIconSet(QPixmap(pitchedit_pixmap));
      else if (key == "SigEdit")
            return QIconSet(QPixmap(pitchedit_pixmap));
      else if (key == QString("Slider"))
            return QIconSet(QPixmap(slider_pixmap));
      return QIconSet();
      }

//---------------------------------------------------------
//   includeFile
//---------------------------------------------------------

QString MusEPlugin::includeFile(const QString& key) const
      {
      if (key == QString("PosEdit"))
            return QString("posedit.h");
      else if (key == QString("PitchEdit"))
            return QString("pitchedit.h");
      else if (key == QString("PitchLabel"))
            return QString("pitchlabel.h");
      else if (key == QString("PosLabel"))
            return QString("poslabel.h");
      else if (key == QString("TempoLabel"))
            return QString("tempolabel.h");
      else if (key == QString("TempoEdit"))
            return QString("tempolabel.h");
      else if (key == QString("SigEdit"))
            return QString("sigedit.h");
      else if (key == QString("Slider"))
            return QString("slider.h");
      else if (key == QString("DoubleLabel"))
            return QString("dentry.h");
      return QString::null;
      }

//---------------------------------------------------------
//   toolTip
//---------------------------------------------------------

QString MusEPlugin::toolTip (const QString& key) const
      {
      if (key == QString("PosEdit"))
            return QString("midi time position editor");
      else if (key == QString("PitchEdit"))
            return QString("midi pitch spinbox");
      else if (key == QString("PitchLabel"))
            return QString("midi pitch label");
      else if (key == QString("PosLabel"))
            return QString("midi time position label");
      else if (key == QString("TempoLabel"))
            return QString("midi tempo label");
      else if (key == QString("TempoEdit"))
            return QString("midi tempo spinbox");
      else if (key == QString("SigEdit"))
            return QString("midi signature spinbox");
      else if (key == QString("Slider"))
            return QString("slider for double values");
      else if (key == QString("DoubleLabel"))
            return QString("entry/label for double values");
      return QString::null;
      }

//---------------------------------------------------------
//   whatsThis
//---------------------------------------------------------

QString MusEPlugin::whatsThis (const QString& key) const
      {
      if (key == QString("PosEdit"))
            return QString("midi time position editor");
      else if (key == QString("PitchEdit"))
            return QString("midi pitch spinbox");
      else if (key == QString("PitchLabel"))
            return QString("midi pitch label");
      else if (key == QString("PosLabel"))
            return QString("midi time position label");
      else if (key == QString("TempoLabel"))
            return QString("midi tempo label");
      else if (key == QString("TempoEdit"))
            return QString("midi tempo spinbox");
      else if (key == QString("SigEdit"))
            return QString("midi signature spinbox");
      else if (key == QString("Slider"))
            return QString("slider for double values");
      else if (key == QString("DoubleLabel"))
            return QString("entry/label for double values");
      return QString::null;
      }

//---------------------------------------------------------
//   isContainer
//---------------------------------------------------------

bool MusEPlugin::isContainer (const QString& /*key*/) const
      {
      return false;
      }

Q_EXPORT_PLUGIN(MusEPlugin)

