#include <iterator>
#include <memory>
#include <mrpt/bayes/CParticleFilter.h>
#include <mrpt/hwdrivers/CGenericSensor.h>
#include <mrpt/obs/CActionRobotMovement2D.h>
#include <mrpt/system/COutputLogger.h>
#include <mrpt/typemeta/TEnumType.h>
#include <sstream> // __str__
#include <string>

#include <functional>
#include <pybind11/pybind11.h>
#include <string>
#include <pybind11/stl.h>


#ifndef BINDER_PYBIND11_TYPE_CASTER
	#define BINDER_PYBIND11_TYPE_CASTER
	PYBIND11_DECLARE_HOLDER_TYPE(T, std::shared_ptr<T>)
	PYBIND11_DECLARE_HOLDER_TYPE(T, T*)
	PYBIND11_MAKE_OPAQUE(std::shared_ptr<void>)
#endif

void bind_mrpt_typemeta_TEnumType(std::function< pybind11::module &(std::string const &namespace_) > &M)
{
	{ // mrpt::typemeta::internal::bimap file:mrpt/typemeta/TEnumType.h line:22
		pybind11::class_<mrpt::typemeta::internal::bimap<mrpt::system::VerbosityLevel,std::string>, std::shared_ptr<mrpt::typemeta::internal::bimap<mrpt::system::VerbosityLevel,std::string>>> cl(M("mrpt::typemeta::internal"), "bimap_mrpt_system_VerbosityLevel_std_string_t", "");
		cl.def( pybind11::init( [](mrpt::typemeta::internal::bimap<mrpt::system::VerbosityLevel,std::string> const &o){ return new mrpt::typemeta::internal::bimap<mrpt::system::VerbosityLevel,std::string>(o); } ) );
		cl.def( pybind11::init( [](){ return new mrpt::typemeta::internal::bimap<mrpt::system::VerbosityLevel,std::string>(); } ) );
		cl.def_readwrite("m_k2v", &mrpt::typemeta::internal::bimap<mrpt::system::VerbosityLevel,std::string>::m_k2v);
		cl.def_readwrite("m_v2k", &mrpt::typemeta::internal::bimap<mrpt::system::VerbosityLevel,std::string>::m_v2k);
		cl.def("direct", (bool (mrpt::typemeta::internal::bimap<mrpt::system::VerbosityLevel,std::string>::*)(const enum mrpt::system::VerbosityLevel &, std::string &) const) &mrpt::typemeta::internal::bimap<mrpt::system::VerbosityLevel, std::string>::direct, "C++: mrpt::typemeta::internal::bimap<mrpt::system::VerbosityLevel, std::string>::direct(const enum mrpt::system::VerbosityLevel &, std::string &) const --> bool", pybind11::arg("k"), pybind11::arg("out_v"));
		cl.def("inverse", (bool (mrpt::typemeta::internal::bimap<mrpt::system::VerbosityLevel,std::string>::*)(const std::string &, enum mrpt::system::VerbosityLevel &) const) &mrpt::typemeta::internal::bimap<mrpt::system::VerbosityLevel, std::string>::inverse, "C++: mrpt::typemeta::internal::bimap<mrpt::system::VerbosityLevel, std::string>::inverse(const std::string &, enum mrpt::system::VerbosityLevel &) const --> bool", pybind11::arg("v"), pybind11::arg("out_k"));
		cl.def("insert", (void (mrpt::typemeta::internal::bimap<mrpt::system::VerbosityLevel,std::string>::*)(const enum mrpt::system::VerbosityLevel &, const std::string &)) &mrpt::typemeta::internal::bimap<mrpt::system::VerbosityLevel, std::string>::insert, "C++: mrpt::typemeta::internal::bimap<mrpt::system::VerbosityLevel, std::string>::insert(const enum mrpt::system::VerbosityLevel &, const std::string &) --> void", pybind11::arg("k"), pybind11::arg("v"));
		cl.def("assign", (struct mrpt::typemeta::internal::bimap<enum mrpt::system::VerbosityLevel, std::string > & (mrpt::typemeta::internal::bimap<mrpt::system::VerbosityLevel,std::string>::*)(const struct mrpt::typemeta::internal::bimap<enum mrpt::system::VerbosityLevel, std::string > &)) &mrpt::typemeta::internal::bimap<mrpt::system::VerbosityLevel, std::string>::operator=, "C++: mrpt::typemeta::internal::bimap<mrpt::system::VerbosityLevel, std::string>::operator=(const struct mrpt::typemeta::internal::bimap<enum mrpt::system::VerbosityLevel, std::string > &) --> struct mrpt::typemeta::internal::bimap<enum mrpt::system::VerbosityLevel, std::string > &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // mrpt::typemeta::internal::bimap file:mrpt/typemeta/TEnumType.h line:22
		pybind11::class_<mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleFilterAlgorithm,std::string>, std::shared_ptr<mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleFilterAlgorithm,std::string>>> cl(M("mrpt::typemeta::internal"), "bimap_mrpt_bayes_CParticleFilter_TParticleFilterAlgorithm_std_string_t", "");
		cl.def( pybind11::init( [](){ return new mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleFilterAlgorithm,std::string>(); } ) );
		cl.def( pybind11::init( [](mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleFilterAlgorithm,std::string> const &o){ return new mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleFilterAlgorithm,std::string>(o); } ) );
		cl.def_readwrite("m_k2v", &mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleFilterAlgorithm,std::string>::m_k2v);
		cl.def_readwrite("m_v2k", &mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleFilterAlgorithm,std::string>::m_v2k);
		cl.def("direct", (bool (mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleFilterAlgorithm,std::string>::*)(const enum mrpt::bayes::CParticleFilter::TParticleFilterAlgorithm &, std::string &) const) &mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleFilterAlgorithm, std::string>::direct, "C++: mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleFilterAlgorithm, std::string>::direct(const enum mrpt::bayes::CParticleFilter::TParticleFilterAlgorithm &, std::string &) const --> bool", pybind11::arg("k"), pybind11::arg("out_v"));
		cl.def("inverse", (bool (mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleFilterAlgorithm,std::string>::*)(const std::string &, enum mrpt::bayes::CParticleFilter::TParticleFilterAlgorithm &) const) &mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleFilterAlgorithm, std::string>::inverse, "C++: mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleFilterAlgorithm, std::string>::inverse(const std::string &, enum mrpt::bayes::CParticleFilter::TParticleFilterAlgorithm &) const --> bool", pybind11::arg("v"), pybind11::arg("out_k"));
		cl.def("insert", (void (mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleFilterAlgorithm,std::string>::*)(const enum mrpt::bayes::CParticleFilter::TParticleFilterAlgorithm &, const std::string &)) &mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleFilterAlgorithm, std::string>::insert, "C++: mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleFilterAlgorithm, std::string>::insert(const enum mrpt::bayes::CParticleFilter::TParticleFilterAlgorithm &, const std::string &) --> void", pybind11::arg("k"), pybind11::arg("v"));
		cl.def("assign", (struct mrpt::typemeta::internal::bimap<enum mrpt::bayes::CParticleFilter::TParticleFilterAlgorithm, std::string > & (mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleFilterAlgorithm,std::string>::*)(const struct mrpt::typemeta::internal::bimap<enum mrpt::bayes::CParticleFilter::TParticleFilterAlgorithm, std::string > &)) &mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleFilterAlgorithm, std::string>::operator=, "C++: mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleFilterAlgorithm, std::string>::operator=(const struct mrpt::typemeta::internal::bimap<enum mrpt::bayes::CParticleFilter::TParticleFilterAlgorithm, std::string > &) --> struct mrpt::typemeta::internal::bimap<enum mrpt::bayes::CParticleFilter::TParticleFilterAlgorithm, std::string > &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // mrpt::typemeta::internal::bimap file:mrpt/typemeta/TEnumType.h line:22
		pybind11::class_<mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleResamplingAlgorithm,std::string>, std::shared_ptr<mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleResamplingAlgorithm,std::string>>> cl(M("mrpt::typemeta::internal"), "bimap_mrpt_bayes_CParticleFilter_TParticleResamplingAlgorithm_std_string_t", "");
		cl.def( pybind11::init( [](){ return new mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleResamplingAlgorithm,std::string>(); } ) );
		cl.def( pybind11::init( [](mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleResamplingAlgorithm,std::string> const &o){ return new mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleResamplingAlgorithm,std::string>(o); } ) );
		cl.def_readwrite("m_k2v", &mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleResamplingAlgorithm,std::string>::m_k2v);
		cl.def_readwrite("m_v2k", &mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleResamplingAlgorithm,std::string>::m_v2k);
		cl.def("direct", (bool (mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleResamplingAlgorithm,std::string>::*)(const enum mrpt::bayes::CParticleFilter::TParticleResamplingAlgorithm &, std::string &) const) &mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleResamplingAlgorithm, std::string>::direct, "C++: mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleResamplingAlgorithm, std::string>::direct(const enum mrpt::bayes::CParticleFilter::TParticleResamplingAlgorithm &, std::string &) const --> bool", pybind11::arg("k"), pybind11::arg("out_v"));
		cl.def("inverse", (bool (mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleResamplingAlgorithm,std::string>::*)(const std::string &, enum mrpt::bayes::CParticleFilter::TParticleResamplingAlgorithm &) const) &mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleResamplingAlgorithm, std::string>::inverse, "C++: mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleResamplingAlgorithm, std::string>::inverse(const std::string &, enum mrpt::bayes::CParticleFilter::TParticleResamplingAlgorithm &) const --> bool", pybind11::arg("v"), pybind11::arg("out_k"));
		cl.def("insert", (void (mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleResamplingAlgorithm,std::string>::*)(const enum mrpt::bayes::CParticleFilter::TParticleResamplingAlgorithm &, const std::string &)) &mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleResamplingAlgorithm, std::string>::insert, "C++: mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleResamplingAlgorithm, std::string>::insert(const enum mrpt::bayes::CParticleFilter::TParticleResamplingAlgorithm &, const std::string &) --> void", pybind11::arg("k"), pybind11::arg("v"));
		cl.def("assign", (struct mrpt::typemeta::internal::bimap<enum mrpt::bayes::CParticleFilter::TParticleResamplingAlgorithm, std::string > & (mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleResamplingAlgorithm,std::string>::*)(const struct mrpt::typemeta::internal::bimap<enum mrpt::bayes::CParticleFilter::TParticleResamplingAlgorithm, std::string > &)) &mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleResamplingAlgorithm, std::string>::operator=, "C++: mrpt::typemeta::internal::bimap<mrpt::bayes::CParticleFilter::TParticleResamplingAlgorithm, std::string>::operator=(const struct mrpt::typemeta::internal::bimap<enum mrpt::bayes::CParticleFilter::TParticleResamplingAlgorithm, std::string > &) --> struct mrpt::typemeta::internal::bimap<enum mrpt::bayes::CParticleFilter::TParticleResamplingAlgorithm, std::string > &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // mrpt::typemeta::internal::bimap file:mrpt/typemeta/TEnumType.h line:22
		pybind11::class_<mrpt::typemeta::internal::bimap<mrpt::obs::CActionRobotMovement2D::TEstimationMethod,std::string>, std::shared_ptr<mrpt::typemeta::internal::bimap<mrpt::obs::CActionRobotMovement2D::TEstimationMethod,std::string>>> cl(M("mrpt::typemeta::internal"), "bimap_mrpt_obs_CActionRobotMovement2D_TEstimationMethod_std_string_t", "");
		cl.def( pybind11::init( [](){ return new mrpt::typemeta::internal::bimap<mrpt::obs::CActionRobotMovement2D::TEstimationMethod,std::string>(); } ) );
		cl.def( pybind11::init( [](mrpt::typemeta::internal::bimap<mrpt::obs::CActionRobotMovement2D::TEstimationMethod,std::string> const &o){ return new mrpt::typemeta::internal::bimap<mrpt::obs::CActionRobotMovement2D::TEstimationMethod,std::string>(o); } ) );
		cl.def_readwrite("m_k2v", &mrpt::typemeta::internal::bimap<mrpt::obs::CActionRobotMovement2D::TEstimationMethod,std::string>::m_k2v);
		cl.def_readwrite("m_v2k", &mrpt::typemeta::internal::bimap<mrpt::obs::CActionRobotMovement2D::TEstimationMethod,std::string>::m_v2k);
		cl.def("direct", (bool (mrpt::typemeta::internal::bimap<mrpt::obs::CActionRobotMovement2D::TEstimationMethod,std::string>::*)(const enum mrpt::obs::CActionRobotMovement2D::TEstimationMethod &, std::string &) const) &mrpt::typemeta::internal::bimap<mrpt::obs::CActionRobotMovement2D::TEstimationMethod, std::string>::direct, "C++: mrpt::typemeta::internal::bimap<mrpt::obs::CActionRobotMovement2D::TEstimationMethod, std::string>::direct(const enum mrpt::obs::CActionRobotMovement2D::TEstimationMethod &, std::string &) const --> bool", pybind11::arg("k"), pybind11::arg("out_v"));
		cl.def("inverse", (bool (mrpt::typemeta::internal::bimap<mrpt::obs::CActionRobotMovement2D::TEstimationMethod,std::string>::*)(const std::string &, enum mrpt::obs::CActionRobotMovement2D::TEstimationMethod &) const) &mrpt::typemeta::internal::bimap<mrpt::obs::CActionRobotMovement2D::TEstimationMethod, std::string>::inverse, "C++: mrpt::typemeta::internal::bimap<mrpt::obs::CActionRobotMovement2D::TEstimationMethod, std::string>::inverse(const std::string &, enum mrpt::obs::CActionRobotMovement2D::TEstimationMethod &) const --> bool", pybind11::arg("v"), pybind11::arg("out_k"));
		cl.def("insert", (void (mrpt::typemeta::internal::bimap<mrpt::obs::CActionRobotMovement2D::TEstimationMethod,std::string>::*)(const enum mrpt::obs::CActionRobotMovement2D::TEstimationMethod &, const std::string &)) &mrpt::typemeta::internal::bimap<mrpt::obs::CActionRobotMovement2D::TEstimationMethod, std::string>::insert, "C++: mrpt::typemeta::internal::bimap<mrpt::obs::CActionRobotMovement2D::TEstimationMethod, std::string>::insert(const enum mrpt::obs::CActionRobotMovement2D::TEstimationMethod &, const std::string &) --> void", pybind11::arg("k"), pybind11::arg("v"));
		cl.def("assign", (struct mrpt::typemeta::internal::bimap<enum mrpt::obs::CActionRobotMovement2D::TEstimationMethod, std::string > & (mrpt::typemeta::internal::bimap<mrpt::obs::CActionRobotMovement2D::TEstimationMethod,std::string>::*)(const struct mrpt::typemeta::internal::bimap<enum mrpt::obs::CActionRobotMovement2D::TEstimationMethod, std::string > &)) &mrpt::typemeta::internal::bimap<mrpt::obs::CActionRobotMovement2D::TEstimationMethod, std::string>::operator=, "C++: mrpt::typemeta::internal::bimap<mrpt::obs::CActionRobotMovement2D::TEstimationMethod, std::string>::operator=(const struct mrpt::typemeta::internal::bimap<enum mrpt::obs::CActionRobotMovement2D::TEstimationMethod, std::string > &) --> struct mrpt::typemeta::internal::bimap<enum mrpt::obs::CActionRobotMovement2D::TEstimationMethod, std::string > &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // mrpt::typemeta::internal::bimap file:mrpt/typemeta/TEnumType.h line:22
		pybind11::class_<mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CGenericSensor::TSensorState,std::string>, std::shared_ptr<mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CGenericSensor::TSensorState,std::string>>> cl(M("mrpt::typemeta::internal"), "bimap_mrpt_hwdrivers_CGenericSensor_TSensorState_std_string_t", "");
		cl.def( pybind11::init( [](){ return new mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CGenericSensor::TSensorState,std::string>(); } ) );
		cl.def( pybind11::init( [](mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CGenericSensor::TSensorState,std::string> const &o){ return new mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CGenericSensor::TSensorState,std::string>(o); } ) );
		cl.def_readwrite("m_k2v", &mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CGenericSensor::TSensorState,std::string>::m_k2v);
		cl.def_readwrite("m_v2k", &mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CGenericSensor::TSensorState,std::string>::m_v2k);
		cl.def("direct", (bool (mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CGenericSensor::TSensorState,std::string>::*)(const enum mrpt::hwdrivers::CGenericSensor::TSensorState &, std::string &) const) &mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CGenericSensor::TSensorState, std::string>::direct, "C++: mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CGenericSensor::TSensorState, std::string>::direct(const enum mrpt::hwdrivers::CGenericSensor::TSensorState &, std::string &) const --> bool", pybind11::arg("k"), pybind11::arg("out_v"));
		cl.def("inverse", (bool (mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CGenericSensor::TSensorState,std::string>::*)(const std::string &, enum mrpt::hwdrivers::CGenericSensor::TSensorState &) const) &mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CGenericSensor::TSensorState, std::string>::inverse, "C++: mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CGenericSensor::TSensorState, std::string>::inverse(const std::string &, enum mrpt::hwdrivers::CGenericSensor::TSensorState &) const --> bool", pybind11::arg("v"), pybind11::arg("out_k"));
		cl.def("insert", (void (mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CGenericSensor::TSensorState,std::string>::*)(const enum mrpt::hwdrivers::CGenericSensor::TSensorState &, const std::string &)) &mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CGenericSensor::TSensorState, std::string>::insert, "C++: mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CGenericSensor::TSensorState, std::string>::insert(const enum mrpt::hwdrivers::CGenericSensor::TSensorState &, const std::string &) --> void", pybind11::arg("k"), pybind11::arg("v"));
		cl.def("assign", (struct mrpt::typemeta::internal::bimap<enum mrpt::hwdrivers::CGenericSensor::TSensorState, std::string > & (mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CGenericSensor::TSensorState,std::string>::*)(const struct mrpt::typemeta::internal::bimap<enum mrpt::hwdrivers::CGenericSensor::TSensorState, std::string > &)) &mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CGenericSensor::TSensorState, std::string>::operator=, "C++: mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CGenericSensor::TSensorState, std::string>::operator=(const struct mrpt::typemeta::internal::bimap<enum mrpt::hwdrivers::CGenericSensor::TSensorState, std::string > &) --> struct mrpt::typemeta::internal::bimap<enum mrpt::hwdrivers::CGenericSensor::TSensorState, std::string > &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
}
