#include <functional>
#include <iterator>
#include <map>
#include <memory>
#include <mrpt/bayes/CKalmanFilterCapable.h>
#include <mrpt/config/CConfigFileBase.h>
#include <mrpt/img/CImage.h>
#include <mrpt/img/color_maps.h>
#include <mrpt/kinematics/CVehicleVelCmd.h>
#include <mrpt/math/CMatrixDynamic.h>
#include <mrpt/math/CMatrixFixed.h>
#include <mrpt/math/TBoundingBox.h>
#include <mrpt/math/TPoint2D.h>
#include <mrpt/math/TPoint3D.h>
#include <mrpt/math/TPose2D.h>
#include <mrpt/math/TPose3D.h>
#include <mrpt/math/TSegment3D.h>
#include <mrpt/math/TTwist2D.h>
#include <mrpt/nav/holonomic/ClearanceDiagram.h>
#include <mrpt/nav/tpspace/CParameterizedTrajectoryGenerator.h>
#include <mrpt/opengl/CMesh.h>
#include <mrpt/opengl/CRenderizable.h>
#include <mrpt/opengl/CSetOfLines.h>
#include <mrpt/poses/CPoint2D.h>
#include <mrpt/poses/CPoint3D.h>
#include <mrpt/poses/CPose2D.h>
#include <mrpt/poses/CPose3D.h>
#include <mrpt/poses/CPoseOrPoint.h>
#include <mrpt/rtti/CObject.h>
#include <mrpt/serialization/CArchive.h>
#include <mrpt/serialization/CMessage.h>
#include <mrpt/serialization/CSerializable.h>
#include <mrpt/system/COutputLogger.h>
#include <mrpt/typemeta/static_string.h>
#include <sstream> // __str__
#include <string>
#include <utility>
#include <variant>
#include <vector>

#include <functional>
#include <pybind11/pybind11.h>
#include <string>
#include <pybind11/stl.h>


#ifndef BINDER_PYBIND11_TYPE_CASTER
	#define BINDER_PYBIND11_TYPE_CASTER
	PYBIND11_DECLARE_HOLDER_TYPE(T, std::shared_ptr<T>)
	PYBIND11_DECLARE_HOLDER_TYPE(T, T*)
	PYBIND11_MAKE_OPAQUE(std::shared_ptr<void>)
#endif

void bind_mrpt_nav_holonomic_ClearanceDiagram(std::function< pybind11::module &(std::string const &namespace_) > &M)
{
	{ // mrpt::nav::ClearanceDiagram file:mrpt/nav/holonomic/ClearanceDiagram.h line:29
		pybind11::class_<mrpt::nav::ClearanceDiagram, std::shared_ptr<mrpt::nav::ClearanceDiagram>> cl(M("mrpt::nav"), "ClearanceDiagram", "Clearance information for one particular PTG and one set of obstacles.\n Usage:\n - Declare an object of this type (it will be initialized to \"empty\"),\n - Call CParameterizedTrajectoryGenerator::initClearanceDiagram()\n - Repeatedly call CParameterizedTrajectoryGenerator::updateClearance() for\n each 2D obstacle point.\n\n  \n\n ");
		cl.def( pybind11::init( [](){ return new mrpt::nav::ClearanceDiagram(); } ) );
		cl.def( pybind11::init( [](mrpt::nav::ClearanceDiagram const &o){ return new mrpt::nav::ClearanceDiagram(o); } ) );
		cl.def("clear", (void (mrpt::nav::ClearanceDiagram::*)()) &mrpt::nav::ClearanceDiagram::clear, "Reset to default, empty state \n\nC++: mrpt::nav::ClearanceDiagram::clear() --> void");
		cl.def("resize", (void (mrpt::nav::ClearanceDiagram::*)(size_t, size_t)) &mrpt::nav::ClearanceDiagram::resize, "Initializes the container to allocate `decimated_num_paths` entries, as\n a decimated\n subset of a total of `actual_num_paths` paths \n\nC++: mrpt::nav::ClearanceDiagram::resize(size_t, size_t) --> void", pybind11::arg("actual_num_paths"), pybind11::arg("decimated_num_paths"));
		cl.def("empty", (bool (mrpt::nav::ClearanceDiagram::*)() const) &mrpt::nav::ClearanceDiagram::empty, "C++: mrpt::nav::ClearanceDiagram::empty() const --> bool");
		cl.def("get_actual_num_paths", (size_t (mrpt::nav::ClearanceDiagram::*)() const) &mrpt::nav::ClearanceDiagram::get_actual_num_paths, "C++: mrpt::nav::ClearanceDiagram::get_actual_num_paths() const --> size_t");
		cl.def("get_decimated_num_paths", (size_t (mrpt::nav::ClearanceDiagram::*)() const) &mrpt::nav::ClearanceDiagram::get_decimated_num_paths, "C++: mrpt::nav::ClearanceDiagram::get_decimated_num_paths() const --> size_t");
		cl.def("getClearance", (double (mrpt::nav::ClearanceDiagram::*)(uint16_t, double, bool) const) &mrpt::nav::ClearanceDiagram::getClearance, "Gets the clearance for path `k` and distance `TPS_query_distance` in one\n of two modes:\n - [integrate_over_path=false] clearance from that specific spot, or\n - [integrate_over_path=true] average clearance over the path from the\n origin to that specific spot.\n\nC++: mrpt::nav::ClearanceDiagram::getClearance(uint16_t, double, bool) const --> double", pybind11::arg("k"), pybind11::arg("TPS_query_distance"), pybind11::arg("integrate_over_path"));
		cl.def("renderAs3DObject", (void (mrpt::nav::ClearanceDiagram::*)(class mrpt::opengl::CMesh &, double, double, double, double, double, bool) const) &mrpt::nav::ClearanceDiagram::renderAs3DObject, "C++: mrpt::nav::ClearanceDiagram::renderAs3DObject(class mrpt::opengl::CMesh &, double, double, double, double, double, bool) const --> void", pybind11::arg("mesh"), pybind11::arg("min_x"), pybind11::arg("max_x"), pybind11::arg("min_y"), pybind11::arg("max_y"), pybind11::arg("cell_res"), pybind11::arg("integrate_over_path"));
		cl.def("readFromStream", (void (mrpt::nav::ClearanceDiagram::*)(class mrpt::serialization::CArchive &)) &mrpt::nav::ClearanceDiagram::readFromStream, "C++: mrpt::nav::ClearanceDiagram::readFromStream(class mrpt::serialization::CArchive &) --> void", pybind11::arg("in"));
		cl.def("writeToStream", (void (mrpt::nav::ClearanceDiagram::*)(class mrpt::serialization::CArchive &) const) &mrpt::nav::ClearanceDiagram::writeToStream, "C++: mrpt::nav::ClearanceDiagram::writeToStream(class mrpt::serialization::CArchive &) const --> void", pybind11::arg("out"));
		cl.def("get_path_clearance", (class std::map<double, double> & (mrpt::nav::ClearanceDiagram::*)(size_t)) &mrpt::nav::ClearanceDiagram::get_path_clearance, "C++: mrpt::nav::ClearanceDiagram::get_path_clearance(size_t) --> class std::map<double, double> &", pybind11::return_value_policy::automatic, pybind11::arg("actual_k"));
		cl.def("get_path_clearance_decimated", (class std::map<double, double> & (mrpt::nav::ClearanceDiagram::*)(size_t)) &mrpt::nav::ClearanceDiagram::get_path_clearance_decimated, "C++: mrpt::nav::ClearanceDiagram::get_path_clearance_decimated(size_t) --> class std::map<double, double> &", pybind11::return_value_policy::automatic, pybind11::arg("decim_k"));
		cl.def("real_k_to_decimated_k", (size_t (mrpt::nav::ClearanceDiagram::*)(size_t) const) &mrpt::nav::ClearanceDiagram::real_k_to_decimated_k, "C++: mrpt::nav::ClearanceDiagram::real_k_to_decimated_k(size_t) const --> size_t", pybind11::arg("k"));
		cl.def("decimated_k_to_real_k", (size_t (mrpt::nav::ClearanceDiagram::*)(size_t) const) &mrpt::nav::ClearanceDiagram::decimated_k_to_real_k, "C++: mrpt::nav::ClearanceDiagram::decimated_k_to_real_k(size_t) const --> size_t", pybind11::arg("k"));
		cl.def("assign", (class mrpt::nav::ClearanceDiagram & (mrpt::nav::ClearanceDiagram::*)(const class mrpt::nav::ClearanceDiagram &)) &mrpt::nav::ClearanceDiagram::operator=, "C++: mrpt::nav::ClearanceDiagram::operator=(const class mrpt::nav::ClearanceDiagram &) --> class mrpt::nav::ClearanceDiagram &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	// mrpt::nav::PTG_collision_behavior_t file:mrpt/nav/tpspace/CParameterizedTrajectoryGenerator.h line:42
	pybind11::enum_<mrpt::nav::PTG_collision_behavior_t>(M("mrpt::nav"), "PTG_collision_behavior_t", pybind11::arithmetic(), "Defines behaviors for where there is an obstacle *inside* the robot shape\nright at the beginning of a PTG trajectory.\n\n\n \n Used in CParameterizedTrajectoryGenerator::COLLISION_BEHAVIOR")
		.value("COLL_BEH_BACK_AWAY", mrpt::nav::COLL_BEH_BACK_AWAY)
		.value("COLL_BEH_STOP", mrpt::nav::COLL_BEH_STOP)
		.export_values();

;

	{ // mrpt::nav::CParameterizedTrajectoryGenerator file:mrpt/nav/tpspace/CParameterizedTrajectoryGenerator.h line:79
		pybind11::class_<mrpt::nav::CParameterizedTrajectoryGenerator, std::shared_ptr<mrpt::nav::CParameterizedTrajectoryGenerator>, mrpt::serialization::CSerializable, mrpt::config::CLoadableOptions> cl(M("mrpt::nav"), "CParameterizedTrajectoryGenerator", "This is the base class for any user-defined PTG.\n  There is a class factory interface in\nCParameterizedTrajectoryGenerator::CreatePTG.\n\n Papers:\n  - J.L. Blanco, J. Gonzalez-Jimenez, J.A. Fernandez-Madrigal, \"Extending\nObstacle Avoidance Methods through Multiple Parameter-Space Transformations\",\nAutonomous Robots, vol. 24, no. 1, 2008.\nhttp://ingmec.ual.es/~jlblanco/papers/blanco2008eoa_DRAFT.pdf\n\n Changes history:\n	- 30/JUN/2004: Creation (JLBC)\n	- 16/SEP/2004: Totally redesigned.\n	- 15/SEP/2005: Totally rewritten again, for integration into MRPT\nApplications Repository.\n	- 19/JUL/2009: Simplified to use only STL data types, and created the class\nfactory interface.\n	- MAY/2016: Refactored into CParameterizedTrajectoryGenerator,\nCPTG_DiffDrive_CollisionGridBased, PTG classes renamed.\n	- 2016-2018: Many features added to support \"PTG continuation\", dynamic\npaths depending on vehicle speeds, etc.\n\n  \n\n ");
		cl.def("GetRuntimeClass", (const struct mrpt::rtti::TRuntimeClassId * (mrpt::nav::CParameterizedTrajectoryGenerator::*)() const) &mrpt::nav::CParameterizedTrajectoryGenerator::GetRuntimeClass, "C++: mrpt::nav::CParameterizedTrajectoryGenerator::GetRuntimeClass() const --> const struct mrpt::rtti::TRuntimeClassId *", pybind11::return_value_policy::automatic);
		cl.def_static("GetRuntimeClassIdStatic", (const struct mrpt::rtti::TRuntimeClassId & (*)()) &mrpt::nav::CParameterizedTrajectoryGenerator::GetRuntimeClassIdStatic, "C++: mrpt::nav::CParameterizedTrajectoryGenerator::GetRuntimeClassIdStatic() --> const struct mrpt::rtti::TRuntimeClassId &", pybind11::return_value_policy::automatic);
		cl.def_static("CreatePTG", (class std::shared_ptr<class mrpt::nav::CParameterizedTrajectoryGenerator> (*)(const std::string &, const class mrpt::config::CConfigFileBase &, const std::string &, const std::string &)) &mrpt::nav::CParameterizedTrajectoryGenerator::CreatePTG, "The class factory for creating a PTG from a list of parameters in a\nsection of a given config file (physical file or in memory).\n  Possible parameters are:\n	  - Those explained in\nCParameterizedTrajectoryGenerator::loadFromConfigFile()\n	  - Those explained in the specific PTG being created (see list of\nderived classes)\n\n `ptgClassName` can be any PTG class name which has been registered as\nany other\n mrpt::serialization::CSerializable class.\n\n \n std::logic_error On invalid or missing parameters.\n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::CreatePTG(const std::string &, const class mrpt::config::CConfigFileBase &, const std::string &, const std::string &) --> class std::shared_ptr<class mrpt::nav::CParameterizedTrajectoryGenerator>", pybind11::arg("ptgClassName"), pybind11::arg("cfg"), pybind11::arg("sSection"), pybind11::arg("sKeyPrefix"));
		cl.def("getDescription", (std::string (mrpt::nav::CParameterizedTrajectoryGenerator::*)() const) &mrpt::nav::CParameterizedTrajectoryGenerator::getDescription, "@{ \n\n Gets a short textual description of the PTG and its parameters \n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::getDescription() const --> std::string");
		cl.def("inverseMap_WS2TP", [](mrpt::nav::CParameterizedTrajectoryGenerator const &o, double const & a0, double const & a1, int & a2, double & a3) -> bool { return o.inverseMap_WS2TP(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("y"), pybind11::arg("out_k"), pybind11::arg("out_normalized_d"));
		cl.def("inverseMap_WS2TP", (bool (mrpt::nav::CParameterizedTrajectoryGenerator::*)(double, double, int &, double &, double) const) &mrpt::nav::CParameterizedTrajectoryGenerator::inverseMap_WS2TP, "Computes the closest (alpha,d) TP coordinates of the trajectory point\n closest to the Workspace (WS)\n   Cartesian coordinates (x,y), relative to the current robot frame.\n \n\n X coordinate of the query point, relative to the robot\n frame.\n \n\n Y coordinate of the query point, relative to the robot\n frame.\n \n\n Trajectory parameter index (discretized alpha value,\n 0-based index).\n \n\n Trajectory distance, normalized such that D_max\n becomes 1.\n\n \n true if the distance between (x,y) and the actual trajectory\n point is below the given tolerance (in meters).\n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::inverseMap_WS2TP(double, double, int &, double &, double) const --> bool", pybind11::arg("x"), pybind11::arg("y"), pybind11::arg("out_k"), pybind11::arg("out_normalized_d"), pybind11::arg("tolerance_dist"));
		cl.def("PTG_IsIntoDomain", (bool (mrpt::nav::CParameterizedTrajectoryGenerator::*)(double, double) const) &mrpt::nav::CParameterizedTrajectoryGenerator::PTG_IsIntoDomain, "Returns the same than inverseMap_WS2TP() but without any additional\n cost. The default implementation\n just calls inverseMap_WS2TP() and discards (k,d). \n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::PTG_IsIntoDomain(double, double) const --> bool", pybind11::arg("x"), pybind11::arg("y"));
		cl.def("isBijectiveAt", (bool (mrpt::nav::CParameterizedTrajectoryGenerator::*)(uint16_t, uint32_t) const) &mrpt::nav::CParameterizedTrajectoryGenerator::isBijectiveAt, "Returns true if a given TP-Space point maps to a unique point in\n Workspace, and viceversa. Default implementation returns `true`. \n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::isBijectiveAt(uint16_t, uint32_t) const --> bool", pybind11::arg("k"), pybind11::arg("step"));
		cl.def("directionToMotionCommand", (class std::shared_ptr<class mrpt::kinematics::CVehicleVelCmd> (mrpt::nav::CParameterizedTrajectoryGenerator::*)(uint16_t) const) &mrpt::nav::CParameterizedTrajectoryGenerator::directionToMotionCommand, "Converts a discretized \"alpha\" value into a feasible motion command or\n action. See derived classes for the meaning of these actions \n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::directionToMotionCommand(uint16_t) const --> class std::shared_ptr<class mrpt::kinematics::CVehicleVelCmd>", pybind11::arg("k"));
		cl.def("getSupportedKinematicVelocityCommand", (class std::shared_ptr<class mrpt::kinematics::CVehicleVelCmd> (mrpt::nav::CParameterizedTrajectoryGenerator::*)() const) &mrpt::nav::CParameterizedTrajectoryGenerator::getSupportedKinematicVelocityCommand, "Returns an empty kinematic velocity command object of the type supported\n by this PTG.\n Can be queried to determine the expected kinematic interface of the PTG.\n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::getSupportedKinematicVelocityCommand() const --> class std::shared_ptr<class mrpt::kinematics::CVehicleVelCmd>");
		cl.def("setRefDistance", (void (mrpt::nav::CParameterizedTrajectoryGenerator::*)(const double)) &mrpt::nav::CParameterizedTrajectoryGenerator::setRefDistance, "C++: mrpt::nav::CParameterizedTrajectoryGenerator::setRefDistance(const double) --> void", pybind11::arg("refDist"));
		cl.def("getPathStepCount", (size_t (mrpt::nav::CParameterizedTrajectoryGenerator::*)(uint16_t) const) &mrpt::nav::CParameterizedTrajectoryGenerator::getPathStepCount, "Access path `k` ([0,N-1]=>[-pi,pi] in alpha): number of discrete \"steps\"\n along the trajectory.\n May be actual steps from a numerical integration or an arbitrary small\n length for analytical PTGs.\n \n\n getAlphaValuesCount() \n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::getPathStepCount(uint16_t) const --> size_t", pybind11::arg("k"));
		cl.def("getPathPose", (struct mrpt::math::TPose2D (mrpt::nav::CParameterizedTrajectoryGenerator::*)(uint16_t, uint32_t) const) &mrpt::nav::CParameterizedTrajectoryGenerator::getPathPose, "Access path `k` ([0,N-1]=>[-pi,pi] in alpha): pose of the vehicle at\n discrete step `step`.\n \n\n getPathStepCount(), getAlphaValuesCount(), getPathTwist() \n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::getPathPose(uint16_t, uint32_t) const --> struct mrpt::math::TPose2D", pybind11::arg("k"), pybind11::arg("step"));
		cl.def("getPathTwist", (struct mrpt::math::TTwist2D (mrpt::nav::CParameterizedTrajectoryGenerator::*)(uint16_t, uint32_t) const) &mrpt::nav::CParameterizedTrajectoryGenerator::getPathTwist, "Gets velocity (\"twist\") for path `k` ([0,N-1]=>[-pi,pi] in alpha),\n at vehicle discrete step `step`. The default implementation in this base\n class uses numerical differentiation to estimate the twist (vx,vy,omega).\n Velocity is given in \"global\" coordinates, relative to the starting pose\n of the robot at t=0 for this PTG path.\n \n\n getPathStepCount(), getAlphaValuesCount(), getPathPose() \n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::getPathTwist(uint16_t, uint32_t) const --> struct mrpt::math::TTwist2D", pybind11::arg("k"), pybind11::arg("step"));
		cl.def("getPathDist", (double (mrpt::nav::CParameterizedTrajectoryGenerator::*)(uint16_t, uint32_t) const) &mrpt::nav::CParameterizedTrajectoryGenerator::getPathDist, "Access path `k` ([0,N-1]=>[-pi,pi] in alpha): traversed distance at\n discrete step `step`.\n \n\n Distance in pseudometers (real distance, NOT normalized to [0,1]\n for [0,refDist])\n \n\n getPathStepCount(), getAlphaValuesCount() \n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::getPathDist(uint16_t, uint32_t) const --> double", pybind11::arg("k"), pybind11::arg("step"));
		cl.def("getPathStepDuration", (double (mrpt::nav::CParameterizedTrajectoryGenerator::*)() const) &mrpt::nav::CParameterizedTrajectoryGenerator::getPathStepDuration, "Returns the duration (in seconds) of each \"step\"\n \n\n getPathStepCount() \n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::getPathStepDuration() const --> double");
		cl.def("getMaxLinVel", (double (mrpt::nav::CParameterizedTrajectoryGenerator::*)() const) &mrpt::nav::CParameterizedTrajectoryGenerator::getMaxLinVel, "Returns the maximum linear velocity expected from this PTG [m/s] \n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::getMaxLinVel() const --> double");
		cl.def("getMaxAngVel", (double (mrpt::nav::CParameterizedTrajectoryGenerator::*)() const) &mrpt::nav::CParameterizedTrajectoryGenerator::getMaxAngVel, "Returns the maximum angular velocity expected from this PTG [rad/s] \n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::getMaxAngVel() const --> double");
		cl.def("getPathStepForDist", (bool (mrpt::nav::CParameterizedTrajectoryGenerator::*)(uint16_t, double, unsigned int &) const) &mrpt::nav::CParameterizedTrajectoryGenerator::getPathStepForDist, "Access path `k` ([0,N-1]=>[-pi,pi] in alpha): largest step count for\n which the traversed distance is < `dist`\n \n\n Distance in pseudometers (real distance, NOT normalized\n to [0,1] for [0,refDist])\n \n\n false if no step fulfills the condition for the given trajectory\n `k` (e.g. out of reference distance).\n Note that, anyway, the maximum distance (closest point) is returned in\n `out_step`.\n \n\n getPathStepCount(), getAlphaValuesCount() \n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::getPathStepForDist(uint16_t, double, unsigned int &) const --> bool", pybind11::arg("k"), pybind11::arg("dist"), pybind11::arg("out_step"));
		cl.def("updateTPObstacleSingle", (void (mrpt::nav::CParameterizedTrajectoryGenerator::*)(double, double, uint16_t, double &) const) &mrpt::nav::CParameterizedTrajectoryGenerator::updateTPObstacleSingle, "Like updateTPObstacle() but for one direction only (`k`) in TP-Space.\n `tp_obstacle_k` must be initialized with initTPObstacleSingle() before\n call (collision-free ranges, in \"pseudometers\", un-normalized). \n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::updateTPObstacleSingle(double, double, uint16_t, double &) const --> void", pybind11::arg("ox"), pybind11::arg("oy"), pybind11::arg("k"), pybind11::arg("tp_obstacle_k"));
		cl.def("loadDefaultParams", (void (mrpt::nav::CParameterizedTrajectoryGenerator::*)()) &mrpt::nav::CParameterizedTrajectoryGenerator::loadDefaultParams, "Loads a set of default parameters into the PTG. Users normally will call\n `loadFromConfigFile()` instead, this method is provided\n exclusively for the PTG-configurator tool. \n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::loadDefaultParams() --> void");
		cl.def("supportVelCmdNOP", (bool (mrpt::nav::CParameterizedTrajectoryGenerator::*)() const) &mrpt::nav::CParameterizedTrajectoryGenerator::supportVelCmdNOP, "Returns true if it is possible to stop sending velocity commands to the\n robot and, still, the\n robot controller will be able to keep following the last sent trajectory\n (\"NOP\" velocity commands).\n Default implementation returns \"false\". \n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::supportVelCmdNOP() const --> bool");
		cl.def("supportSpeedAtTarget", (bool (mrpt::nav::CParameterizedTrajectoryGenerator::*)() const) &mrpt::nav::CParameterizedTrajectoryGenerator::supportSpeedAtTarget, "Returns true if this PTG takes into account the desired velocity at\n target. \n\n updateNavDynamicState() \n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::supportSpeedAtTarget() const --> bool");
		cl.def("maxTimeInVelCmdNOP", (double (mrpt::nav::CParameterizedTrajectoryGenerator::*)(int) const) &mrpt::nav::CParameterizedTrajectoryGenerator::maxTimeInVelCmdNOP, "Only for PTGs supporting supportVelCmdNOP(): this is the maximum time\n (in seconds) for which the path\n can be followed without re-issuing a new velcmd. Note that this is only\n an absolute maximum duration,\n navigation implementations will check for many other conditions. Default\n method in the base virtual class returns 0.\n \n\n Queried path `k` index  [0,N-1] \n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::maxTimeInVelCmdNOP(int) const --> double", pybind11::arg("path_k"));
		cl.def("getActualUnloopedPathLength", (double (mrpt::nav::CParameterizedTrajectoryGenerator::*)(uint16_t) const) &mrpt::nav::CParameterizedTrajectoryGenerator::getActualUnloopedPathLength, "Returns the actual distance (in meters) of the path, discounting\n possible circular loops of the path (e.g. if it comes back to the\n origin).\n Default: refDistance \n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::getActualUnloopedPathLength(uint16_t) const --> double", pybind11::arg("k"));
		cl.def("evalPathRelativePriority", (double (mrpt::nav::CParameterizedTrajectoryGenerator::*)(uint16_t, double) const) &mrpt::nav::CParameterizedTrajectoryGenerator::evalPathRelativePriority, "Query the PTG for the relative priority factor (0,1) of this PTG, in\n comparison to others, if the k-th path is to be selected. \n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::evalPathRelativePriority(uint16_t, double) const --> double", pybind11::arg("k"), pybind11::arg("target_distance"));
		cl.def("getMaxRobotRadius", (double (mrpt::nav::CParameterizedTrajectoryGenerator::*)() const) &mrpt::nav::CParameterizedTrajectoryGenerator::getMaxRobotRadius, "Returns an approximation of the robot radius. \n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::getMaxRobotRadius() const --> double");
		cl.def("isPointInsideRobotShape", (bool (mrpt::nav::CParameterizedTrajectoryGenerator::*)(const double, const double) const) &mrpt::nav::CParameterizedTrajectoryGenerator::isPointInsideRobotShape, "Returns true if the point lies within the robot shape. \n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::isPointInsideRobotShape(const double, const double) const --> bool", pybind11::arg("x"), pybind11::arg("y"));
		cl.def("evalClearanceToRobotShape", (double (mrpt::nav::CParameterizedTrajectoryGenerator::*)(const double, const double) const) &mrpt::nav::CParameterizedTrajectoryGenerator::evalClearanceToRobotShape, "Evals the clearance from an obstacle (ox,oy) in coordinates relative to\n the robot center. Zero or negative means collision. \n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::evalClearanceToRobotShape(const double, const double) const --> double", pybind11::arg("ox"), pybind11::arg("oy"));
		cl.def("updateNavDynamicState", [](mrpt::nav::CParameterizedTrajectoryGenerator &o, const struct mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState & a0) -> void { return o.updateNavDynamicState(a0); }, "", pybind11::arg("newState"));
		cl.def("updateNavDynamicState", (void (mrpt::nav::CParameterizedTrajectoryGenerator::*)(const struct mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState &, const bool)) &mrpt::nav::CParameterizedTrajectoryGenerator::updateNavDynamicState, "To be invoked by the navigator *before* each navigation step, to let the\n PTG to react to changing dynamic conditions. * \n\n\n onNewNavDynamicState(), m_nav_dyn_state  \n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::updateNavDynamicState(const struct mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState &, const bool) --> void", pybind11::arg("newState"), pybind11::arg("force_update"));
		cl.def("getCurrentNavDynamicState", (const struct mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState & (mrpt::nav::CParameterizedTrajectoryGenerator::*)() const) &mrpt::nav::CParameterizedTrajectoryGenerator::getCurrentNavDynamicState, "C++: mrpt::nav::CParameterizedTrajectoryGenerator::getCurrentNavDynamicState() const --> const struct mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState &", pybind11::return_value_policy::automatic);
		cl.def_static("OUTPUT_DEBUG_PATH_PREFIX", (std::string & (*)()) &mrpt::nav::CParameterizedTrajectoryGenerator::OUTPUT_DEBUG_PATH_PREFIX, "The path used as defaul output in, for example, debugDumpInFiles.\n (Default=\"./reactivenav.logs/\") \n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::OUTPUT_DEBUG_PATH_PREFIX() --> std::string &", pybind11::return_value_policy::automatic);
		cl.def("initialize", [](mrpt::nav::CParameterizedTrajectoryGenerator &o) -> void { return o.initialize(); }, "");
		cl.def("initialize", [](mrpt::nav::CParameterizedTrajectoryGenerator &o, const std::string & a0) -> void { return o.initialize(a0); }, "", pybind11::arg("cacheFilename"));
		cl.def("initialize", (void (mrpt::nav::CParameterizedTrajectoryGenerator::*)(const std::string &, const bool)) &mrpt::nav::CParameterizedTrajectoryGenerator::initialize, "Must be called after setting all PTG parameters and before requesting\n converting obstacles to TP-Space, inverseMap_WS2TP(), etc. \n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::initialize(const std::string &, const bool) --> void", pybind11::arg("cacheFilename"), pybind11::arg("verbose"));
		cl.def("deinitialize", (void (mrpt::nav::CParameterizedTrajectoryGenerator::*)()) &mrpt::nav::CParameterizedTrajectoryGenerator::deinitialize, "This must be called to de-initialize the PTG if some parameter is to be\n changed. After changing it, call initialize again \n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::deinitialize() --> void");
		cl.def("isInitialized", (bool (mrpt::nav::CParameterizedTrajectoryGenerator::*)() const) &mrpt::nav::CParameterizedTrajectoryGenerator::isInitialized, "Returns true if `initialize()` has been called and there was no errors,\n so the PTG is ready to be queried for paths, obstacles, etc. \n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::isInitialized() const --> bool");
		cl.def("getAlphaValuesCount", (uint16_t (mrpt::nav::CParameterizedTrajectoryGenerator::*)() const) &mrpt::nav::CParameterizedTrajectoryGenerator::getAlphaValuesCount, "Get the number of different, discrete paths in this family \n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::getAlphaValuesCount() const --> uint16_t");
		cl.def("getPathCount", (uint16_t (mrpt::nav::CParameterizedTrajectoryGenerator::*)() const) &mrpt::nav::CParameterizedTrajectoryGenerator::getPathCount, "Get the number of different, discrete paths in this family \n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::getPathCount() const --> uint16_t");
		cl.def("index2alpha", (double (mrpt::nav::CParameterizedTrajectoryGenerator::*)(uint16_t) const) &mrpt::nav::CParameterizedTrajectoryGenerator::index2alpha, "Alpha value for the discrete corresponding value \n alpha2index \n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::index2alpha(uint16_t) const --> double", pybind11::arg("k"));
		cl.def_static("Index2alpha", (double (*)(uint16_t, const unsigned int)) &mrpt::nav::CParameterizedTrajectoryGenerator::Index2alpha, "C++: mrpt::nav::CParameterizedTrajectoryGenerator::Index2alpha(uint16_t, const unsigned int) --> double", pybind11::arg("k"), pybind11::arg("num_paths"));
		cl.def("alpha2index", (uint16_t (mrpt::nav::CParameterizedTrajectoryGenerator::*)(double) const) &mrpt::nav::CParameterizedTrajectoryGenerator::alpha2index, "Discrete index value for the corresponding alpha value \n index2alpha\n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::alpha2index(double) const --> uint16_t", pybind11::arg("alpha"));
		cl.def_static("Alpha2index", (uint16_t (*)(double, const unsigned int)) &mrpt::nav::CParameterizedTrajectoryGenerator::Alpha2index, "C++: mrpt::nav::CParameterizedTrajectoryGenerator::Alpha2index(double, const unsigned int) --> uint16_t", pybind11::arg("alpha"), pybind11::arg("num_paths"));
		cl.def("getRefDistance", (double (mrpt::nav::CParameterizedTrajectoryGenerator::*)() const) &mrpt::nav::CParameterizedTrajectoryGenerator::getRefDistance, "C++: mrpt::nav::CParameterizedTrajectoryGenerator::getRefDistance() const --> double");
		cl.def("initTPObstacleSingle", (void (mrpt::nav::CParameterizedTrajectoryGenerator::*)(uint16_t, double &) const) &mrpt::nav::CParameterizedTrajectoryGenerator::initTPObstacleSingle, "C++: mrpt::nav::CParameterizedTrajectoryGenerator::initTPObstacleSingle(uint16_t, double &) const --> void", pybind11::arg("k"), pybind11::arg("TP_Obstacle_k"));
		cl.def("getScorePriority", (double (mrpt::nav::CParameterizedTrajectoryGenerator::*)() const) &mrpt::nav::CParameterizedTrajectoryGenerator::getScorePriority, "When used in path planning, a multiplying factor (default=1.0) for the\n scores for this PTG. Assign values <1 to PTGs with low priority. \n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::getScorePriority() const --> double");
		cl.def("setScorePriorty", (void (mrpt::nav::CParameterizedTrajectoryGenerator::*)(double)) &mrpt::nav::CParameterizedTrajectoryGenerator::setScorePriorty, "C++: mrpt::nav::CParameterizedTrajectoryGenerator::setScorePriorty(double) --> void", pybind11::arg("prior"));
		cl.def("getClearanceStepCount", (unsigned int (mrpt::nav::CParameterizedTrajectoryGenerator::*)() const) &mrpt::nav::CParameterizedTrajectoryGenerator::getClearanceStepCount, "C++: mrpt::nav::CParameterizedTrajectoryGenerator::getClearanceStepCount() const --> unsigned int");
		cl.def("setClearanceStepCount", (void (mrpt::nav::CParameterizedTrajectoryGenerator::*)(const unsigned int)) &mrpt::nav::CParameterizedTrajectoryGenerator::setClearanceStepCount, "C++: mrpt::nav::CParameterizedTrajectoryGenerator::setClearanceStepCount(const unsigned int) --> void", pybind11::arg("res"));
		cl.def("getClearanceDecimatedPaths", (unsigned int (mrpt::nav::CParameterizedTrajectoryGenerator::*)() const) &mrpt::nav::CParameterizedTrajectoryGenerator::getClearanceDecimatedPaths, "C++: mrpt::nav::CParameterizedTrajectoryGenerator::getClearanceDecimatedPaths() const --> unsigned int");
		cl.def("setClearanceDecimatedPaths", (void (mrpt::nav::CParameterizedTrajectoryGenerator::*)(const unsigned int)) &mrpt::nav::CParameterizedTrajectoryGenerator::setClearanceDecimatedPaths, "C++: mrpt::nav::CParameterizedTrajectoryGenerator::setClearanceDecimatedPaths(const unsigned int) --> void", pybind11::arg("num"));
		cl.def("renderPathAsSimpleLine", [](mrpt::nav::CParameterizedTrajectoryGenerator const &o, const unsigned short & a0, class mrpt::opengl::CSetOfLines & a1) -> void { return o.renderPathAsSimpleLine(a0, a1); }, "", pybind11::arg("k"), pybind11::arg("gl_obj"));
		cl.def("renderPathAsSimpleLine", [](mrpt::nav::CParameterizedTrajectoryGenerator const &o, const unsigned short & a0, class mrpt::opengl::CSetOfLines & a1, const double & a2) -> void { return o.renderPathAsSimpleLine(a0, a1, a2); }, "", pybind11::arg("k"), pybind11::arg("gl_obj"), pybind11::arg("decimate_distance"));
		cl.def("renderPathAsSimpleLine", (void (mrpt::nav::CParameterizedTrajectoryGenerator::*)(const unsigned short, class mrpt::opengl::CSetOfLines &, const double, const double) const) &mrpt::nav::CParameterizedTrajectoryGenerator::renderPathAsSimpleLine, "Returns the representation of one trajectory of this PTG as a 3D OpenGL\n object (a simple curved line).\n \n\n The 0-based index of the selected trajectory (discrete\n \"alpha\" parameter).\n \n\n Output object.\n \n\n Minimum distance between path points (in\n meters).\n \n\n If >=0, cut the path at this distance (in\n meters).\n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::renderPathAsSimpleLine(const unsigned short, class mrpt::opengl::CSetOfLines &, const double, const double) const --> void", pybind11::arg("k"), pybind11::arg("gl_obj"), pybind11::arg("decimate_distance"), pybind11::arg("max_path_distance"));
		cl.def("debugDumpInFiles", (bool (mrpt::nav::CParameterizedTrajectoryGenerator::*)(const std::string &) const) &mrpt::nav::CParameterizedTrajectoryGenerator::debugDumpInFiles, "Dump PTG trajectories in four text files:\n `./reactivenav.logs/PTGs/PTG%i_{x,y,phi,d}.txt`\n Text files are loadable from MATLAB/Octave, and can be visualized with\n the script `[MRPT_DIR]/scripts/viewPTG.m`\n \n\n The directory \"./reactivenav.logs/PTGs\" will be created if doesn't\n exist.\n \n\n false on any error writing to disk.\n \n\n OUTPUT_DEBUG_PATH_PREFIX\n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::debugDumpInFiles(const std::string &) const --> bool", pybind11::arg("ptg_name"));
		cl.def("loadFromConfigFile", (void (mrpt::nav::CParameterizedTrajectoryGenerator::*)(const class mrpt::config::CConfigFileBase &, const std::string &)) &mrpt::nav::CParameterizedTrajectoryGenerator::loadFromConfigFile, "Parameters accepted by this base class:\n   - `${sKeyPrefix}num_paths`: The number of different paths in this\n family (number of discrete `alpha` values).\n   - `${sKeyPrefix}ref_distance`: The maximum distance in PTGs [meters]\n   - `${sKeyPrefix}score_priority`: When used in path planning, a\n multiplying factor (default=1.0) for the scores for this PTG. Assign\n values <1 to PTGs with low priority.\n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::loadFromConfigFile(const class mrpt::config::CConfigFileBase &, const std::string &) --> void", pybind11::arg("cfg"), pybind11::arg("sSection"));
		cl.def("saveToConfigFile", (void (mrpt::nav::CParameterizedTrajectoryGenerator::*)(class mrpt::config::CConfigFileBase &, const std::string &) const) &mrpt::nav::CParameterizedTrajectoryGenerator::saveToConfigFile, "C++: mrpt::nav::CParameterizedTrajectoryGenerator::saveToConfigFile(class mrpt::config::CConfigFileBase &, const std::string &) const --> void", pybind11::arg("cfg"), pybind11::arg("sSection"));
		cl.def("add_robotShape_to_setOfLines", [](mrpt::nav::CParameterizedTrajectoryGenerator const &o, class mrpt::opengl::CSetOfLines & a0) -> void { return o.add_robotShape_to_setOfLines(a0); }, "", pybind11::arg("gl_shape"));
		cl.def("add_robotShape_to_setOfLines", (void (mrpt::nav::CParameterizedTrajectoryGenerator::*)(class mrpt::opengl::CSetOfLines &, const class mrpt::poses::CPose2D &) const) &mrpt::nav::CParameterizedTrajectoryGenerator::add_robotShape_to_setOfLines, "Auxiliary function for rendering \n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::add_robotShape_to_setOfLines(class mrpt::opengl::CSetOfLines &, const class mrpt::poses::CPose2D &) const --> void", pybind11::arg("gl_shape"), pybind11::arg("origin"));
		cl.def_static("COLLISION_BEHAVIOR", (enum mrpt::nav::PTG_collision_behavior_t & (*)()) &mrpt::nav::CParameterizedTrajectoryGenerator::COLLISION_BEHAVIOR, "Defines the behavior when there is an obstacle *inside* the robot shape\n right at the beginning of a PTG trajectory.\n Default value: COLL_BEH_BACK_AWAY\n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::COLLISION_BEHAVIOR() --> enum mrpt::nav::PTG_collision_behavior_t &", pybind11::return_value_policy::automatic);
		cl.def("initClearanceDiagram", (void (mrpt::nav::CParameterizedTrajectoryGenerator::*)(class mrpt::nav::ClearanceDiagram &) const) &mrpt::nav::CParameterizedTrajectoryGenerator::initClearanceDiagram, "Must be called to resize a CD to its correct size, before calling\n updateClearance() \n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::initClearanceDiagram(class mrpt::nav::ClearanceDiagram &) const --> void", pybind11::arg("cd"));
		cl.def("updateClearance", (void (mrpt::nav::CParameterizedTrajectoryGenerator::*)(const double, const double, class mrpt::nav::ClearanceDiagram &) const) &mrpt::nav::CParameterizedTrajectoryGenerator::updateClearance, "Updates the clearance diagram given one (ox,oy) obstacle point, in\n coordinates relative\n to the PTG path origin.\n \n\n The clearance will be updated here.\n \n\n m_clearance_dist_resolution\n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::updateClearance(const double, const double, class mrpt::nav::ClearanceDiagram &) const --> void", pybind11::arg("ox"), pybind11::arg("oy"), pybind11::arg("cd"));
		cl.def("evalClearanceSingleObstacle", [](mrpt::nav::CParameterizedTrajectoryGenerator const &o, const double & a0, const double & a1, const unsigned short & a2, class std::map<double, double> & a3) -> void { return o.evalClearanceSingleObstacle(a0, a1, a2, a3); }, "", pybind11::arg("ox"), pybind11::arg("oy"), pybind11::arg("k"), pybind11::arg("inout_realdist2clearance"));
		cl.def("evalClearanceSingleObstacle", (void (mrpt::nav::CParameterizedTrajectoryGenerator::*)(const double, const double, const unsigned short, class std::map<double, double> &, bool) const) &mrpt::nav::CParameterizedTrajectoryGenerator::evalClearanceSingleObstacle, "Evals the robot clearance for each robot pose along path `k`, for the\n real distances in\n the key of the map<>, then keep in the map value the minimum of its\n current stored clearance,\n or the computed clearance. In case of collision, clearance is zero.\n \n\n true: normal use for obstacles; false: compute\n shortest distances to a target point (no collision)\n\nC++: mrpt::nav::CParameterizedTrajectoryGenerator::evalClearanceSingleObstacle(const double, const double, const unsigned short, class std::map<double, double> &, bool) const --> void", pybind11::arg("ox"), pybind11::arg("oy"), pybind11::arg("k"), pybind11::arg("inout_realdist2clearance"), pybind11::arg("treat_as_obstacle"));
		cl.def("assign", (class mrpt::nav::CParameterizedTrajectoryGenerator & (mrpt::nav::CParameterizedTrajectoryGenerator::*)(const class mrpt::nav::CParameterizedTrajectoryGenerator &)) &mrpt::nav::CParameterizedTrajectoryGenerator::operator=, "C++: mrpt::nav::CParameterizedTrajectoryGenerator::operator=(const class mrpt::nav::CParameterizedTrajectoryGenerator &) --> class mrpt::nav::CParameterizedTrajectoryGenerator &", pybind11::return_value_policy::automatic, pybind11::arg(""));

		{ // mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState file:mrpt/nav/tpspace/CParameterizedTrajectoryGenerator.h line:176
			auto & enclosing_class = cl;
			pybind11::class_<mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState, std::shared_ptr<mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState>> cl(enclosing_class, "TNavDynamicState", "Dynamic state that may affect the PTG path parameterization. \n\n nav_reactive  ");
			cl.def( pybind11::init( [](){ return new mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState(); } ) );
			cl.def( pybind11::init( [](mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState const &o){ return new mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState(o); } ) );
			cl.def_readwrite("curVelLocal", &mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState::curVelLocal);
			cl.def_readwrite("relTarget", &mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState::relTarget);
			cl.def_readwrite("targetRelSpeed", &mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState::targetRelSpeed);
			cl.def("__eq__", (bool (mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState::*)(const struct mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState &) const) &mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState::operator==, "C++: mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState::operator==(const struct mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState &) const --> bool", pybind11::arg("o"));
			cl.def("__ne__", (bool (mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState::*)(const struct mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState &) const) &mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState::operator!=, "C++: mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState::operator!=(const struct mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState &) const --> bool", pybind11::arg("o"));
			cl.def("writeToStream", (void (mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState::*)(class mrpt::serialization::CArchive &) const) &mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState::writeToStream, "C++: mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState::writeToStream(class mrpt::serialization::CArchive &) const --> void", pybind11::arg("out"));
			cl.def("readFromStream", (void (mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState::*)(class mrpt::serialization::CArchive &)) &mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState::readFromStream, "C++: mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState::readFromStream(class mrpt::serialization::CArchive &) --> void", pybind11::arg("in"));
			cl.def("assign", (struct mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState & (mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState::*)(const struct mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState &)) &mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState::operator=, "C++: mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState::operator=(const struct mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState &) --> struct mrpt::nav::CParameterizedTrajectoryGenerator::TNavDynamicState &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		}

	}
}
