/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2009  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */
#ifndef  CDebugOutputCapable_H
#define  CDebugOutputCapable_H

#include <mrpt/utils/utils_defs.h>
#include <mrpt/utils/CStream.h>

/*---------------------------------------------------------------
	Class
  ---------------------------------------------------------------*/
namespace mrpt
{
	namespace utils
	{
		/** This base class provides a common printf-like method to send debug information to std::cout, with the purpose of allowing its redirection to other streams if desired.
		  *  By default, messages sent to "printf_debug" will be shown in the console (cout) and the stream passed to debugOutputSetStream, but console output can be
		  *  switched off with debugOutputEnableConsole(false).
		  *
		  *  See CDebugOutputCapable::printf_debug.
		 */
		class MRPTDLLIMPEXP CDebugOutputCapable
		{
		private:
			CStream		*m_stream;
			bool		m_show_console;

		public:
			/** Default initialization */
			CDebugOutputCapable(CStream	*strm=NULL) : m_stream(strm), m_show_console(true) { }

			virtual ~CDebugOutputCapable() { }

			/** The passed stream MUST be a valid pointer during all the life of the derived class. Set to NULL to disable.  */
			void debugOutputSetStream( CStream	*str) { m_stream = str; }

			/** Display messages into the console (std::cout) apart from the stream (default=true). */
			void debugOutputEnableConsole( bool enable ) { m_show_console = enable; }

			/** Sends a formated text to "debugOut" if not NULL, or to cout otherwise.
			  */
			void printf_debug( const char *frmt, ... );

		}; // End of class def.

	} // End of namespace
} // end of namespace
#endif
