/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2009  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */

#ifndef opengl_CSetOfLines_H
#define opengl_CSetOfLines_H

#include <mrpt/opengl/CRenderizable.h>

namespace mrpt
{
	namespace opengl
	{
		class MRPTDLLIMPEXP CSetOfLines;

		// This must be added to any CSerializable derived class:
		DEFINE_SERIALIZABLE_PRE_CUSTOM_BASE( CSetOfLines, CRenderizable )

		/** A set of independent lines (or segments), one line with its own start and end positions (X,Y,Z).
		  *  \sa opengl::COpenGLScene
		  */
		class MRPTDLLIMPEXP CSetOfLines : public CRenderizable
		{
			DEFINE_SERIALIZABLE( CSetOfLines )
		protected:
			vector_float	m_x0,m_y0,m_z0;
			vector_float	m_x1,m_y1,m_z1;
            float			m_lineWidth;

		public:
			void clear();	/** Clear the list of segments */

			void setLineWidth(float w) { m_lineWidth=w; }
			float getLineWidth() const { return m_lineWidth; }

			void appendLine(
				const float &x0,const float &y0, const float &z0,
				const float &x1,const float &y1, const float &z1 );

			void resize(const size_t &nLines);

			void reserve(size_t r);

			template<class T,class U>
			inline void appendLine(T p0,U p1)	{
				appendLine(p0.x,p0.y,p0.z,p1.x,p1.y,p1.z);
			}

			inline size_t getLineCount() const	{
				return m_x0.size();
			}

			void setLineByIndex(
				const size_t &index,
				const float &x0,const float &y0, const float &z0,
				const float &x1,const float &y1, const float &z1 );

			/** Class factory  */
			static CSetOfLinesPtr Create()
			{
				return CSetOfLinesPtr( new CSetOfLines() );
			}

			/** Render
			  */
			void  render() const;

		private:
			/** Constructor
			  */
			CSetOfLines( ) :
				m_x0(),m_y0(),m_z0(),
				m_x1(),m_y1(),m_z1(),
				m_lineWidth(1.0f)
			{
			}
			/** Private, virtual destructor: only can be deleted from smart pointers */
			virtual ~CSetOfLines() { }
		};

	} // end namespace

} // End of namespace


#endif
