//****
//****

#include <wx/filename.h>
#include <wx/config.h>

#include <iostream>
#include <string>

#include "SeriesHandler.h"
#include "OutputterBase.h"

using namespace std;
using namespace jcs;

OutputterBase::OutputterBase(const Options& options): mOptions(options)
{

#ifndef NO_CONFIG
  wxString oldPath = wxConfig::Get()->GetPath();
  wxConfig::Get()->SetPath(wxString("/", wxConvLocal));
  wxConfig::Get()->SetPath(wxString(mOptions.pathname.c_str(), wxConvLocal));

  map<string, bool>::iterator bool_it;
  for (bool_it = mOptions.boolOptions.begin(); bool_it != mOptions.boolOptions.end(); ++bool_it) 
    wxConfig::Get()->Read(wxString(bool_it->first.c_str(), wxConvLocal), 
    &bool_it->second, bool_it->second);

  map<string, int>::iterator int_it;
  for (int_it = mOptions.intOptions.begin(); int_it != mOptions.intOptions.end(); ++int_it) 
    wxConfig::Get()->Read(wxString(int_it->first.c_str(), wxConvLocal), &int_it->second, int_it->second);

  map<string, wxString>::iterator string_it;
  for (string_it = mOptions.stringOptions.begin(); string_it != mOptions.stringOptions.end(); ++string_it) 
    wxConfig::Get()->Read(wxString(string_it->first.c_str(), wxConvLocal), 
    &string_it->second, string_it->second);

  map<string, double>::iterator double_it;
  for (double_it = mOptions.doubleOptions.begin(); double_it != mOptions.doubleOptions.end(); ++double_it) 
    wxConfig::Get()->Read(wxString(double_it->first.c_str(), wxConvLocal), 
    &double_it->second, double_it->second);

  wxConfig::Get()->SetPath(oldPath);
#endif

  mSplitDirsFlag = mOptions.boolOptions["split"];

  defaultNameFields[PatientName] = NameField("PatientName", mOptions.boolOptions["PatientName"], PatientName);
  defaultNameFields[PatientId] = NameField("PatientId", mOptions.boolOptions["PatientId"], PatientId);
  defaultNameFields[SeriesDate] = NameField("SeriesDate", mOptions.boolOptions["SeriesDate"], SeriesDate);
  defaultNameFields[SeriesTime] = NameField("SeriesTime", mOptions.boolOptions["SeriesTime"], SeriesTime);
  defaultNameFields[StudyId] = NameField("StudyId", mOptions.boolOptions["StudyId"], StudyId);
  defaultNameFields[StudyDescription] = NameField("StudyDescription", mOptions.boolOptions["StudyDescription"], StudyDescription);
  defaultNameFields[SeriesNumber] = NameField("SeriesNumber", mOptions.boolOptions["SeriesNumber"],SeriesNumber);
  defaultNameFields[SequenceName] = NameField("SequenceName", mOptions.boolOptions["SequenceName"], SequenceName);
  defaultNameFields[ProtocolName] = NameField("ProtocolName", mOptions.boolOptions["ProtocolName"], ProtocolName);
  defaultNameFields[SeriesDescription] = NameField("SeriesDescription", mOptions.boolOptions["SeriesDescription"], SeriesDescription);

}

OutputterBase::~OutputterBase()
{
  mOptions.boolOptions["split"] = mSplitDirsFlag;
  mOptions.boolOptions["PatientName"] = defaultNameFields[PatientName].value;
  mOptions.boolOptions["PatientId"] = defaultNameFields[PatientId].value;
  mOptions.boolOptions["SeriesDate"] = defaultNameFields[SeriesDate].value;
  mOptions.boolOptions["SeriesTime"] = defaultNameFields[SeriesTime].value;
  mOptions.boolOptions["StudyId"] = defaultNameFields[StudyId].value;
  mOptions.boolOptions["StudyDescription"] = defaultNameFields[StudyDescription].value;
  mOptions.boolOptions["SeriesNumber"] = defaultNameFields[SeriesNumber].value;
  mOptions.boolOptions["SequenceName"] = defaultNameFields[SequenceName].value;
  mOptions.boolOptions["ProtocolName"] = defaultNameFields[ProtocolName].value;
  mOptions.boolOptions["SeriesDescription"] = defaultNameFields[SeriesDescription].value;


#ifndef NO_CONFIG
  wxString oldPath = wxConfig::Get()->GetPath();
  wxConfig::Get()->SetPath(wxString("/", wxConvLocal));
  wxConfig::Get()->SetPath(wxString(mOptions.pathname.c_str(), wxConvLocal));

  map<string, bool>::iterator bool_it;
  for (bool_it = mOptions.boolOptions.begin(); bool_it != mOptions.boolOptions.end(); ++bool_it) 
    wxConfig::Get()->Write(wxString(bool_it->first.c_str(), wxConvLocal), bool_it->second);

  map<string, int>::iterator int_it;
  for (int_it = mOptions.intOptions.begin(); int_it != mOptions.intOptions.end(); ++int_it) 
    wxConfig::Get()->Write(wxString(int_it->first.c_str(), wxConvLocal), int_it->second);

  map<string, wxString>::iterator string_it;
  for (string_it = mOptions.stringOptions.begin(); string_it != mOptions.stringOptions.end(); ++string_it) 
    wxConfig::Get()->Write(wxString(string_it->first.c_str(), wxConvLocal), string_it->second);

  map<string, double>::iterator double_it;
  for (double_it = mOptions.doubleOptions.begin(); double_it != mOptions.doubleOptions.end(); ++double_it) 
    wxConfig::Get()->Write(wxString(double_it->first.c_str(), wxConvLocal), double_it->second);

  wxConfig::Get()->SetPath(oldPath);

#endif

}

//****
// Create and initialize an Options object with program default
// values for output operations.
//****
Options
OutputterBase::GetBaseOptions()
{
  Options options;

  // Flag whether to save in separate directories.
  options.boolOptions["split"] = true;

  // Options pertaining to output file naming.
  options.boolOptions["PatientName"] = true;
  options.boolOptions["PatientId"] = false;
  options.boolOptions["SeriesDate"] = true;
  options.boolOptions["SeriesTime"] = false;
  options.boolOptions["StudyId"] = true;
  options.boolOptions["StudyDescription"] = false;
  options.boolOptions["SeriesNumber"] = true;
  options.boolOptions["SequenceName"] = false;
  options.boolOptions["ProtocolName"] = true;
  options.boolOptions["SeriesDescription"] = true;

  return options;
}

//****
// Generate and return a filename prefix according to program rules
// and user selection.
//****
string
OutputterBase::GenerateDefaultPrefix(SeriesHandler* series)
{
  string prefix;
  bool first = true;
  FieldMap::iterator it = defaultNameFields.begin();
  FieldMap::iterator it_end = defaultNameFields.end();

  string pn = "";
  while (it != it_end) {
    if (it->second.value) {
      string str;
      if (series->Find(it->second.name, str)) {
        // If using protocol name AND series description, don't use
        // both if they are the same
        if (it->second.name == "ProtocolName") {
          pn = str;
        }
        else {
	  if (str == pn) {
            ++it;
            continue;
          }
	}
	// Separate filename elements with an underscore character.
        if (!first)
	  prefix.append("_");
        // Any numbers should be padded out to at least 3 digits
        if (itos(stoi(str)) == str) {
          str = itos(stoi(str), 3);
        }
        prefix.append(str);
        first = false;
      }
    }
    ++it;
  }

  if (prefix.empty()) prefix = "output";
  
  return RemoveInvalidChars(prefix);
}

//****
//****
void
OutputterBase::FillInDefaultDirs(ImageFileName& name, SeriesHandler* series)
{
  name.ResetPath();

  if (mSplitDirsFlag) {
    string subject_dir = series->seriesInfo.subject_name;
    if (subject_dir.empty())
      subject_dir = series->seriesInfo.subject_id;
    subject_dir = RemoveInvalidChars(subject_dir);
    if (subject_dir.empty())
      subject_dir = "unknown";

    name.AppendDir(subject_dir, subject_dir);

    string series_dir = series->seriesInfo.study_number
      + "_" + series->seriesInfo.series_number;

    if (!series->seriesInfo.series_description.empty()) {
      series_dir.append("_");
      series_dir.append(series->seriesInfo.series_description);
    }

    if (!series->seriesInfo.SeriesDate.empty()) {
      series_dir.append("_");
      series_dir.append(series->seriesInfo.SeriesDate);
    }
    series_dir = RemoveInvalidChars(series_dir);
    name.AppendDir(series->GetSeriesUid(), series_dir);
  }
}

//****
//****
ImageFileName
OutputterBase::GetImageFileName(const string& series_uid, const string& name)
{
  OutputList::ListType::iterator pos;
  pos = mOutputList.fileNameList.lower_bound(series_uid);

  while (pos != mOutputList.fileNameList.end()) {
    if (pos->second.GetFullName() == name)
      return pos->second;
    ++pos;
  }

  return ImageFileName();
}

//****
//****
wxFileName
OutputterBase::GetFileName(const string& series_uid)
{
  OutputList::ListType::iterator pos;
  pos = mOutputList.fileNameList.lower_bound(series_uid);

  //todo: handle not found 
  assert(pos != mOutputList.fileNameList.end());

  wxFileName name(mOutputList.rootDir + wxFileName::GetPathSeparator());
  wxFileName fname(wxString(pos->second.GetFullPath().c_str(), wxConvLocal));
  wxArrayString dirs = fname.GetDirs();
  for (unsigned int i = 0; i < dirs.size(); ++i) 
    name.AppendDir(dirs[i]);  

  name.SetFullName(fname.GetFullName());

  return name;
}

//****
//****
void
OutputterBase::ChangeFileName(const string& series_uid, const string& new_name)
{
  OutputList::ListType::iterator pos;
  pos = mOutputList.fileNameList.lower_bound(series_uid);
  while (pos != mOutputList.fileNameList.end() && !pos->first.compare(0, series_uid.size(), series_uid)) {
    if (pos->second.isRenameable)
      pos->second.SetPrefix(new_name);
    ++pos;
  }
}

//****
//****
void
OutputterBase::ChangeDirName(const vector<string>& series_uids, 
               const string& new_name, int position)
{
  vector<string>::const_iterator it;
  for (it = series_uids.begin(); it != series_uids.end(); ++it) {
    OutputList::ListType::iterator pos;
    pos = mOutputList.fileNameList.lower_bound(*it);
    while (pos != mOutputList.fileNameList.end() && !pos->first.compare(0, it->size(), *it)) {
      pos->second.SetDirName(position, new_name);
      ++pos;
    } 
  }
}

//****
// Sets only the mSplitDirsFlag class variable. Does not touch
// the options object. Why not?
//****
void
OutputterBase::SetOption(const string& name, bool value)
{
  if (name.find("split") != string::npos) {
    mSplitDirsFlag = value;
  }
}

