/*
 * Decompiled with CFR 0.152.
 */
package base.statistics;

import base.drawable.TimeBoundingBox;
import base.statistics.CategoryWeightF;
import java.awt.Color;
import java.util.Comparator;

public class CategoryTimeBox
extends TimeBoundingBox {
    public static final Comparator INDEX_ORDER = new IndexOrder();
    public static final Comparator INCL_RATIO_ORDER = new InclRatioOrder();
    public static final Comparator EXCL_RATIO_ORDER = new ExclRatioOrder();
    public static final Comparator COUNT_ORDER = new CountOrder();
    private CategoryWeightF twgf;

    public CategoryTimeBox() {
        this.twgf = null;
    }

    public CategoryTimeBox(CategoryWeightF in_twgf) {
        this.twgf = in_twgf;
    }

    public float getCategoryRatio(boolean isInclusive) {
        return this.twgf.getRatio(isInclusive);
    }

    public Color getCategoryColor() {
        return this.twgf.getCategory().getColor();
    }

    public boolean isCategoryVisiblySearchable() {
        return this.twgf.getCategory().isVisiblySearchable();
    }

    public CategoryWeightF getCategoryWeightF() {
        return this.twgf;
    }

    private static class CountOrder
    implements Comparator {
        private CountOrder() {
        }

        public int compare(Object o1, Object o2) {
            CategoryTimeBox typebox1 = (CategoryTimeBox)o1;
            CategoryTimeBox typebox2 = (CategoryTimeBox)o2;
            return CategoryWeightF.COUNT_ORDER.compare(typebox1.twgf, typebox2.twgf);
        }
    }

    private static class ExclRatioOrder
    implements Comparator {
        private ExclRatioOrder() {
        }

        public int compare(Object o1, Object o2) {
            CategoryTimeBox typebox1 = (CategoryTimeBox)o1;
            CategoryTimeBox typebox2 = (CategoryTimeBox)o2;
            return CategoryWeightF.EXCL_RATIO_ORDER.compare(typebox1.twgf, typebox2.twgf);
        }
    }

    private static class InclRatioOrder
    implements Comparator {
        private InclRatioOrder() {
        }

        public int compare(Object o1, Object o2) {
            CategoryTimeBox typebox1 = (CategoryTimeBox)o1;
            CategoryTimeBox typebox2 = (CategoryTimeBox)o2;
            return CategoryWeightF.INCL_RATIO_ORDER.compare(typebox1.twgf, typebox2.twgf);
        }
    }

    private static class IndexOrder
    implements Comparator {
        private IndexOrder() {
        }

        public int compare(Object o1, Object o2) {
            CategoryTimeBox typebox1 = (CategoryTimeBox)o1;
            CategoryTimeBox typebox2 = (CategoryTimeBox)o2;
            return CategoryWeightF.INDEX_ORDER.compare(typebox1.twgf, typebox2.twgf);
        }
    }
}

