/*
 * Decompiled with CFR 0.152.
 */
package logformat.clog2TOdrawable;

import base.drawable.Category;
import base.drawable.ColorAlpha;
import base.drawable.Composite;
import base.drawable.InputAPI;
import base.drawable.Kind;
import base.drawable.Primitive;
import base.drawable.Topology;
import base.drawable.YCoordMap;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import logformat.clog2.MixedDataInputStream;
import logformat.clog2.RecBare;
import logformat.clog2.RecCargo;
import logformat.clog2.RecColl;
import logformat.clog2.RecComm;
import logformat.clog2.RecDefConst;
import logformat.clog2.RecDefEvent;
import logformat.clog2.RecDefMsg;
import logformat.clog2.RecDefState;
import logformat.clog2.RecHeader;
import logformat.clog2.RecMsg;
import logformat.clog2.RecSrc;
import logformat.clog2.RecTshift;
import logformat.clog2TOdrawable.ColorNameMap;
import logformat.clog2TOdrawable.ObjDef;
import logformat.clog2TOdrawable.ObjMethod;
import logformat.clog2TOdrawable.Topo_Arrow;
import logformat.clog2TOdrawable.Topo_State;
import logformat.clog2TOdrawable.TwoEventsMatching;

public class InputLog
extends logformat.clog2.InputLog
implements InputAPI {
    private MixedDataInputStream blk_ins;
    private long total_bytesize;
    private int rectype;
    private Map evtdefs = new HashMap();
    private List topos = new ArrayList();
    private ObjDef statedef;
    private ObjDef arrowdef;
    private Primitive drawobj;
    private RecHeader header;
    private RecDefState staterec;
    private RecDefEvent eventrec;
    private RecDefConst constrec;
    private RecBare bare;
    private RecCargo cargo;
    private RecMsg msg;
    private RecColl coll;
    private RecComm comm;
    private RecSrc src;
    private RecTshift tshift;
    private Topo_Arrow arrowform;
    private Topo_State stateform;
    private ObjMethod obj_fn;
    private Object[] arglist;
    private boolean isFirstPeekForCategory;
    private int num_topology_returned;

    public InputLog(String string) {
        super(string);
        ColorNameMap.initMapFromRGBtxt("jumpshot.colors");
        ObjDef.setFirstNextCategoryIndex(0);
        this.arrowform = new Topo_Arrow();
        int n = ObjDef.getNextCategoryIndex();
        this.arrowdef = new ObjDef(n, new RecDefMsg(), this.arrowform, 3);
        this.arrowdef.setColor(new ColorAlpha(this.arrowdef.getColor(), 255));
        this.arrowform.setCategory(this.arrowdef);
        this.evtdefs.put(this.arrowdef.start_evt, this.arrowform.getStartEventObjMethod());
        this.evtdefs.put(this.arrowdef.final_evt, this.arrowform.getFinalEventObjMethod());
        List list = RecDefState.getMPIinitUndefinedStateDefs();
        list.addAll(RecDefState.getUSERinitUndefinedStateDefs());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.staterec = (RecDefState)iterator.next();
            this.stateform = new Topo_State();
            n = ObjDef.getNextCategoryIndex();
            this.statedef = new ObjDef(n, this.staterec, this.stateform, 1);
            this.stateform.setCategory(this.statedef);
            this.evtdefs.put(this.statedef.start_evt, this.stateform.getStartEventObjMethod());
            this.evtdefs.put(this.statedef.final_evt, this.stateform.getFinalEventObjMethod());
        }
        this.header = new RecHeader();
        this.staterec = new RecDefState();
        this.eventrec = new RecDefEvent();
        this.constrec = new RecDefConst();
        this.bare = new RecBare();
        this.cargo = new RecCargo();
        this.msg = new RecMsg();
        this.coll = new RecColl();
        this.comm = new RecComm();
        this.src = new RecSrc();
        this.tshift = new RecTshift();
        this.arglist = new Object[2];
        this.total_bytesize = 0L;
        this.num_topology_returned = 0;
        this.isFirstPeekForCategory = true;
        this.blk_ins = super.getBlockStream();
    }

    public Kind peekNextKind() {
        if (this.num_topology_returned < 3) {
            return Kind.TOPOLOGY;
        }
        if (this.isFirstPeekForCategory) {
            return Kind.CATEGORY;
        }
        while (this.blk_ins != null) {
            this.rectype = -1;
            block27: while (this.rectype != 1 && this.rectype != 0) {
                int n = this.header.readFromDataStream(this.blk_ins);
                this.total_bytesize += (long)n;
                this.rectype = this.header.getRecType();
                switch (this.rectype) {
                    case 2: {
                        n = this.staterec.readFromDataStream(this.blk_ins);
                        this.total_bytesize += (long)n;
                        ObjMethod objMethod = (ObjMethod)this.evtdefs.get(this.staterec.startetype);
                        ObjMethod objMethod2 = (ObjMethod)this.evtdefs.get(this.staterec.finaletype);
                        if (objMethod == null || objMethod2 == null) {
                            this.stateform = new Topo_State();
                            int n2 = ObjDef.getNextCategoryIndex();
                            this.statedef = new ObjDef(n2, this.staterec, this.stateform, 1);
                            this.stateform.setCategory(this.statedef);
                            this.evtdefs.put(this.statedef.start_evt, this.stateform.getStartEventObjMethod());
                            this.evtdefs.put(this.statedef.final_evt, this.stateform.getFinalEventObjMethod());
                        } else if (objMethod.obj == objMethod2.obj) {
                            this.stateform = (Topo_State)objMethod.obj;
                            this.statedef = (ObjDef)this.stateform.getCategory();
                            this.statedef.setName(this.staterec.name);
                            this.statedef.setColor(ColorNameMap.getColorAlpha(this.staterec.color));
                            this.statedef.setInfoKeys(this.staterec.format);
                        } else {
                            System.err.println("**** Error! " + objMethod.obj + "!=" + objMethod2.obj);
                        }
                        return Kind.CATEGORY;
                    }
                    case 3: {
                        n = this.eventrec.skipBytesFromDataStream(this.blk_ins);
                        this.total_bytesize += (long)n;
                        continue block27;
                    }
                    case 4: {
                        n = this.constrec.skipBytesFromDataStream(this.blk_ins);
                        this.total_bytesize += (long)n;
                        continue block27;
                    }
                    case 5: {
                        n = this.bare.readFromDataStream(this.blk_ins);
                        this.total_bytesize += (long)n;
                        int n3 = this.bare.etype;
                        if (n3 == -1) continue block27;
                        ObjMethod objMethod = (ObjMethod)this.evtdefs.get(this.bare.etype);
                        this.arglist[0] = this.header;
                        this.arglist[1] = null;
                        this.drawobj = null;
                        try {
                            this.drawobj = (Primitive)objMethod.method.invoke(objMethod.obj, this.arglist);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            illegalAccessException.printStackTrace();
                            System.err.println("Offending RecBare = " + this.bare);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            invocationTargetException.printStackTrace();
                        }
                        catch (NullPointerException nullPointerException) {
                            nullPointerException.printStackTrace();
                            System.err.println("Offending RecHeader = " + this.header);
                            System.err.println("Offending RecBare = " + this.bare);
                            System.exit(1);
                        }
                        if (this.drawobj == null) continue block27;
                        return Kind.PRIMITIVE;
                    }
                    case 6: {
                        n = this.cargo.readFromDataStream(this.blk_ins);
                        this.total_bytesize += (long)n;
                        int n4 = this.cargo.etype;
                        if (n4 == -1) continue block27;
                        ObjMethod objMethod = (ObjMethod)this.evtdefs.get(this.cargo.etype);
                        this.arglist[0] = this.header;
                        this.arglist[1] = this.cargo;
                        this.drawobj = null;
                        try {
                            this.drawobj = (Primitive)objMethod.method.invoke(objMethod.obj, this.arglist);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            illegalAccessException.printStackTrace();
                            System.err.println("Offending RecCargo = " + this.cargo);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            invocationTargetException.printStackTrace();
                        }
                        catch (NullPointerException nullPointerException) {
                            nullPointerException.printStackTrace();
                            System.err.println("Offending RecHeader = " + this.header);
                            System.err.println("Offending RecCargo = " + this.cargo);
                            System.exit(1);
                        }
                        if (this.drawobj == null) continue block27;
                        return Kind.PRIMITIVE;
                    }
                    case 7: {
                        n = this.msg.readFromDataStream(this.blk_ins);
                        this.total_bytesize += (long)n;
                        int n5 = this.msg.etype;
                        if (n5 == -1) continue block27;
                        ObjMethod objMethod = (ObjMethod)this.evtdefs.get(this.msg.etype);
                        this.arglist[0] = this.header;
                        this.arglist[1] = this.msg;
                        this.drawobj = null;
                        try {
                            this.drawobj = (Primitive)objMethod.method.invoke(objMethod.obj, this.arglist);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            illegalAccessException.printStackTrace();
                            System.err.println("Offending RecMsg = " + this.msg);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            invocationTargetException.printStackTrace();
                        }
                        catch (NullPointerException nullPointerException) {
                            nullPointerException.printStackTrace();
                            System.err.println("Offending RecHeader = " + this.header);
                            System.err.println("Offending RecMsg = " + this.msg);
                            System.exit(1);
                        }
                        if (this.drawobj == null) continue block27;
                        return Kind.PRIMITIVE;
                    }
                    case 8: {
                        n = this.coll.skipBytesFromDataStream(this.blk_ins);
                        this.total_bytesize += (long)n;
                        continue block27;
                    }
                    case 9: {
                        n = this.comm.skipBytesFromDataStream(this.blk_ins);
                        this.total_bytesize += (long)n;
                        continue block27;
                    }
                    case 10: {
                        n = this.src.skipBytesFromDataStream(this.blk_ins);
                        this.total_bytesize += (long)n;
                        continue block27;
                    }
                    case 11: {
                        n = this.tshift.skipBytesFromDataStream(this.blk_ins);
                        this.total_bytesize += (long)n;
                        continue block27;
                    }
                    case 1: {
                        this.blk_ins = super.getBlockStream();
                        continue block27;
                    }
                    case 0: {
                        this.blk_ins = null;
                        continue block27;
                    }
                }
                System.err.println("Unknown Record type = " + this.rectype);
            }
        }
        return Kind.EOF;
    }

    public Topology getNextTopology() {
        switch (this.num_topology_returned) {
            case 0: {
                this.num_topology_returned = 1;
                return Topology.EVENT;
            }
            case 1: {
                this.num_topology_returned = 2;
                return Topology.STATE;
            }
            case 2: {
                this.num_topology_returned = 3;
                return Topology.ARROW;
            }
        }
        System.err.println("All Topology Names have been returned");
        return null;
    }

    public Category getNextCategory() {
        if (this.isFirstPeekForCategory) {
            this.isFirstPeekForCategory = false;
            this.topos.add(this.arrowdef.getTopology());
            return this.arrowdef;
        }
        this.topos.add(this.statedef.getTopology());
        return this.statedef;
    }

    public Primitive getNextPrimitive() {
        return this.drawobj;
    }

    public Composite getNextComposite() {
        return null;
    }

    public YCoordMap getNextYCoordMap() {
        return null;
    }

    public long getTotalBytesRead() {
        return this.total_bytesize;
    }

    public List getAllUsedTopos() {
        return this.topos;
    }

    public long getNumberOfUnMatchedEvents() {
        int n = 0;
        Iterator iterator = this.topos.iterator();
        while (iterator.hasNext()) {
            n += ((TwoEventsMatching)iterator.next()).getPartialObjects().size();
        }
        return n;
    }
}

