/***************************************************************************
                          export.cpp  -  description
                             -------------------
    begin                : Thu May 3 2001
    copyright            : (C) 2001 by Stefano Brustia
    email                : hio@lombardiacom.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "export.h"
#include "resources.h"
#include "mp3kult.h"
#include "item.h"

#include <iostream.h>
#include <qfileinfo.h>
#include <qlist.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kconfig.h>
#include <kapp.h>

Export::Export(const Mp3List* list, const QString file)
{
	this->list=list;
	this->file=file;
}

Export::~Export()
{
}

// Writes m3u files for Playlists

void Export::exportM3uPL()
{
	PLListItem* item;
	ofstream fwrite(file);

	item = (PLListItem*) list->firstChild();
	while (item)
	{
		fwrite << item->getFileN() << endl;
		item = item->itemBelow();
	}
	fwrite.close();
}

// Writes m3u files for main db (main view)

void Export::exportM3u(bool selected, bool tree)
{
	QListViewItem* item;
	ofstream fwrite(file);

	if (selected)
	{
		//item = list->currentItem();

		QList<QListViewItem> itemList(list->selectedItems());
		QListIterator<QListViewItem> itemIt(itemList);
		cerr << "Selected : "<< itemList.count() << endl;
		if (/*!item || !(item->isSelected())*/!(itemIt.current()))
		{
			KMessageBox::error(mp3kult , i18n("There aren't any mp3s\nselected !"));
			fwrite.close();
			return;
		}

		// Moves pointer to first item selected



		/*while ((item->itemAbove())!=NULL && (item->itemAbove()->isSelected()))
            item = item->itemAbove();*/

		while (/*(item != NULL) && (item->isSelected())*/(item = itemIt.current()))
		{
			//item = itemIt.current();
			fwrite << item->text(ID_PATH) << "/" << item->text(ID_FNAME) << endl;
			//item = item->itemBelow();
			++itemIt;
		}
	}
	else
	{
		item = list->firstChild();

		if(tree)
		{
			QListViewItem *parent_item ;
			parent_item = item;
			bool open;

			while (parent_item)
			{
				open = parent_item->isOpen();
				parent_item->setOpen(true);
				item = parent_item->itemBelow();

				while ((item) && (item->isSelectable()))
				{
					fwrite << item->text(ID_PATH) << "/" << item->text(ID_FNAME) << endl;
					item = item->itemBelow();
				}
				parent_item->setOpen(open);
				parent_item = parent_item->nextSibling();
			}
		}
		else
		{
			while (item)
			{
				fwrite << item->text(ID_PATH) << "/" << item->text(ID_FNAME) << endl;
				item = item->itemBelow();
			}
		}
	}
    fwrite.close();
}

// Writes html files for main db (main view)

void Export::exportHtml(bool selected, bool tree)
{
	bool createLink, useTemplate;
	QString buf;
	QValueList<int> exItem;
	ofstream fwrite(file);
	/*ifstream *fread;*/
	KConfig* config;

	config = kapp->config();

	config->setGroup("Export");
		exItem = config->readIntListEntry("ExItem");
		createLink = config->readBoolEntry("CreateLinks", false);
		useTemplate = config->readBoolEntry("UseTemplate", false);

	/*fwrite = fopen(file, "w");*/
	if (useTemplate)
	{
		QString temp;
		bool found=false;
		char buf[1024];
		temp = config->readEntry("TempPath", "");
		ifstream fread(temp);
		if (!fread)
		{
			KMessageBox::error(mp3kult , i18n("Template not found \n or not readable"  ));
			return;
		}

		while (fread)
		{
			fread.getline(buf,1024,'\n');
			if (!strcmp(buf,"<!-- Mp3Kult -->"))
			{
				found = true;
				if (selected)
					writeSelectedHtmlTab(&fwrite, exItem, createLink);
				else
					writeHtmlTab(&fwrite, exItem, createLink, tree);
			}
			else
				fwrite << buf << endl;
		}
		if (!found)
		{
			KMessageBox::error(mp3kult , i18n("Template not valid ! \n Tag <!-- Mp3Kult --> \n not Found ! "  ));
			fread.close();
			fwrite.close();
			QFile(file).remove();
			return;
		}
		fread.close();
		fwrite.close();
	}
	else
	{
		fwrite << "<html><head><title> Mp3s </title></head>" << endl;
		fwrite << "<body><center><h1> Mp3s  </h1></center><br>" << endl;
		if (selected)
			writeSelectedHtmlTab(&fwrite, exItem, createLink);
		else
			writeHtmlTab(&fwrite, exItem, createLink, tree);

		fwrite << "</body></html>" << endl;

		/* fputs (buf, fwrite);*/
	}
	fwrite.close();
}

// Writes html tab (all mp3s)

void Export::writeHtmlTab(ofstream* fwrite, const QValueList<int>& exItem, bool createLinks, bool tree)
{
	QListViewItem* item;
	int total = 0;
	int numExItem = exItem.count();

	item = list->firstChild();

	writeHtmlTabTh(fwrite, exItem, numExItem);

	if (tree)
	{
		QListViewItem *parent_item ;
		parent_item = item;
		int numItemVis = 0;
		bool open;

		for (int i=0; i < numExItem; i++)
			if (exItem[i])
				numItemVis++;

		while (parent_item)
		{
			open = parent_item->isOpen();
			parent_item->setOpen(true);

			item = parent_item->itemBelow();
			*fwrite << "<tr><td colspan=\"" << numItemVis << "\" ><br><div align=\"center\"><b>" << parent_item->text(0) << "</b></div><br></td></tr>" <<  endl;
			while (item && item->isSelectable())
			{
				total++;
				writeHtmlTabItem (fwrite, exItem, createLinks, item, numExItem);
				item = item->itemBelow();
			}
			parent_item->setOpen(open);
			parent_item = parent_item->nextSibling();
		}
	}
	else
	{
		while (item)
		{
			total++;
			writeHtmlTabItem (fwrite, exItem, createLinks, item, numExItem);
			item = item->itemBelow();
		}
	}
	*fwrite << "</table><br>" << endl;
	//*fwrite << "Total Mp3s:" <<  total << "<br>" << endl;
	*fwrite << "<font size=\"-1\">This tab was created with <a href=\"http://mp3kult.sourceforge.net\">Mp3Kult</a></font>" << endl;
}

// Writes html table (selected mp3s)

void Export::writeSelectedHtmlTab(ofstream* fwrite, const QValueList<int>& exItem, bool createLinks)
{
	QListViewItem* item;
	int total = 0;
	int numExItem = exItem.count();

	writeHtmlTabTh(fwrite, exItem, numExItem);
	//item = list->currentItem();

	QList<QListViewItem> itemList(list->selectedItems());
	QListIterator<QListViewItem> itemIt(itemList);
	cerr << "Selected : "<< itemList.count() << endl;
	if (/*!item || !(item->isSelected())*/!(itemIt.current()))
	{
		KMessageBox::error(mp3kult , i18n("There aren't any mp3s\nselected !"));
		fwrite->close();
		QFile(file).remove();
		return;
	}

	/*while ((item->itemAbove())!=NULL && (item->itemAbove()->isSelected()))
		item = item->itemAbove();*/

	while (/*(item != NULL) && (item->isSelected())*/ (item = itemIt.current()))
	{
		total++;
		writeHtmlTabItem (fwrite, exItem, createLinks, item, numExItem);
		//item = item->itemBelow();
		++itemIt;
	}

	*fwrite << "</table><br>" << endl;
	//*fwrite << "Total Mp3s:" <<  total << "<br>" << endl;
	*fwrite << "<font size=\"-1\">This tab was created with <a href=\"http://mp3kult.sourceforge.net\">Mp3Kult</a></font>" << endl;
}

// Writes an row of the table

void Export::writeHtmlTabItem (ofstream* fwrite, const QValueList<int>& exItem, bool createLinks, QListViewItem* item, int numExItem)
{
	*fwrite << "<tr>";
	if ((numExItem < ID_TITLE) || exItem[ID_TITLE])
	{
		if (createLinks)
		{
			*fwrite << "<td><a href=\""<< item->text(ID_PATH) << "/" <<  item->text(ID_FNAME) << "\">" << item->text(ID_TITLE) << "</a></td>";
		}
		else
			*fwrite << "<td>" << item->text(ID_TITLE) << "</td>";
	}
	if ((numExItem < ID_ARTIST) || exItem[ID_ARTIST])
		*fwrite << "<td>" << item->text(ID_ARTIST) << "</td>";
	if ((numExItem < ID_ALBUM) || exItem[ID_ALBUM])
		*fwrite << "<td>" << item->text(ID_ALBUM) << "</td>";
	if ((numExItem < ID_LENGTH) || exItem[ID_LENGTH])
		*fwrite << "<td><div align=\"center\">" << item->text(ID_LENGTH) << "</div></td>";
	if ((numExItem < ID_GENRE) || exItem[ID_GENRE])
		*fwrite << "<td>" << item->text(ID_GENRE) << "</td>";
	*fwrite << endl << "  ";
	if ((numExItem < ID_YEAR) || exItem[ID_YEAR])
		*fwrite << "<td><div align=\"center\">" << item->text(ID_YEAR) << "</div></td>";
	if ((numExItem < ID_TRACK) || exItem[ID_TRACK])
		*fwrite << "<td><div align=\"right\">" << item->text(ID_TRACK) << "</div></td>";
	if ((numExItem < ID_COMMENT) || exItem[ID_COMMENT])
		*fwrite << "<td>" << item->text(ID_COMMENT) << "</td>";
	if ((numExItem < ID_VOLUME) || exItem[ID_VOLUME])
		*fwrite << "<td>" << item->text(ID_VOLUME) << "</td>";
	if ((numExItem < ID_PATH) || exItem[ID_PATH])
		*fwrite << "<td>" << item->text(ID_PATH) << "</td>";
	*fwrite << endl << "  ";
	if ((numExItem < ID_FNAME) || exItem[ID_FNAME])
		*fwrite << "<td>" << item->text(ID_FNAME) << "</td>";
	if ((numExItem < ID_SIZE) || exItem[ID_SIZE])
		*fwrite << "<td><div align=\"right\">" << item->text(ID_SIZE) << "</div></td>";
	if ((numExItem < ID_MODE) || exItem[ID_MODE])
		*fwrite << "<td>" << item->text(ID_MODE) << "</td>";
	if ((numExItem < ID_BIT) || exItem[ID_BIT])
		*fwrite << "<td><div align=\"right\">" << item->text(ID_BIT) << "</div></td>";
	if ((numExItem < ID_SAMPLE) || exItem[ID_SAMPLE])
		*fwrite << "<td><div align=\"right\">" << item->text(ID_SAMPLE) << "</div></td>";
	*fwrite << endl << "</tr>" << endl;
}

// Writes the header of the table

void Export::writeHtmlTabTh(ofstream* fwrite, const QValueList<int>& exItem, int numExItem)
{
	*fwrite << "<table border=1>" << endl;
	*fwrite << "<tr>";
	if ((numExItem < ID_TITLE) || exItem[ID_TITLE])
		*fwrite << "<th><font size=\"+1\"> Title </font></th>";
	if ((numExItem < ID_ARTIST) || exItem[ID_ARTIST])
		*fwrite << "<th><font size=\"+1\"> Artist </font></th>";
	if ((numExItem < ID_ALBUM) || exItem[ID_ALBUM])
		*fwrite << "<th><font size=\"+1\"> Album </font></th>";
	if ((numExItem < ID_LENGTH) || exItem[ID_LENGTH])
		*fwrite << "<th><font size=\"+1\"> Length </font></th>";
	if ((numExItem < ID_GENRE) || exItem[ID_GENRE])
		*fwrite << "<th><font size=\"+1\"> Genre </font></th>";
	*fwrite << endl << "  ";
	if ((numExItem < ID_YEAR) || exItem[ID_YEAR])
		*fwrite << "<th><font size=\"+1\"> Year </font></th>";
	if ((numExItem < ID_TRACK) || exItem[ID_TRACK])
		*fwrite << "<th><font size=\"+1\"> Track </font></th>";
	if ((numExItem < ID_COMMENT) || exItem[ID_COMMENT])
		*fwrite << "<th><font size=\"+1\"> Comment </font></th>";
	if ((numExItem < ID_VOLUME) || exItem[ID_VOLUME])
		*fwrite << "<th><font size=\"+1\"> Volume </font></th>";
	if ((numExItem < ID_PATH) || exItem[ID_PATH])
		*fwrite << "<th><font size=\"+1\"> Path </font></th>";
	*fwrite << endl << "  ";
	if ((numExItem < ID_FNAME) || exItem[ID_FNAME])
		*fwrite << "<th><font size=\"+1\"> File Name </font></th>";
	if ((numExItem < ID_SIZE) || exItem[ID_SIZE])
		*fwrite << "<th><font size=\"+1\"> Size </font></th>";
	if ((numExItem < ID_MODE) || exItem[ID_MODE])
		*fwrite << "<th><font size=\"+1\"> Mode </font></th>";
	if ((numExItem < ID_BIT) || exItem[ID_BIT])
		*fwrite << "<th><font size=\"+1\"> Kbit/s </font></th>";
	if ((numExItem < ID_SAMPLE) || exItem[ID_SAMPLE])
		*fwrite << "<th><font size=\"+1\"> KHz </font></th>";
	*fwrite << endl << "</tr>" << endl;;
}

