var mgDefaultMappings =
{
  mappings : {
     browser     : new Array(),
     viewsource  : new Array(),
     window      : new Array(),
     messenger   : new Array(),
     mailcompose : new Array()
  },

  /* =================================================================================
     func: is important!
     func can be: built-in-function, script-code, keyboard-shortcut, bookmark-id
     =================================================================================
     x[mapping] = {func:xxx, type:xxx, name:xxx, count:xxx}
          type = 0  -> normal gesture
                       func is predefined (no name)
                       note: 0 will never be stored
          type = 1  -> custom gesture
                       func is a JavaScript snippet (evaled)
          type = 2  -> keyboard gesture
                       func is a mixture of ctrl|alt|shift|meta and keyCode|charcode
                       and will be fired to document.documentElement
          type = 9x -> bookmark gesture
                       func is a unique bookmark id
                       90 -> current Window
                       91 -> new Window
                       92 -> current Tab
                       93 -> new Tab
                       94 -> Sidebar
     ================================================================================= */

  init : function() {
    // "b" == browser
    var b = this.mappings.browser;
    b[":02"]   = {func: "mgB_Forward"}
    b[":20"]   = {func: "mgB_Back"}
    b[":12"]   = {func: "mgB_NextTab"}
    b[":10"]   = {func: "mgB_PreviousTab"}
    b[":2+"]   = {func: "mgB_NextTab"}
    b[":2-"]   = {func: "mgB_PreviousTab"}
    b["L"]     = {func: "mgB_Back"}
    b["R"]     = {func: "mgB_Forward"}
    b["LU"]    = {func: "mgB_Stop"}
    b["DURD"]  = {func: "mgB_Home"}
    b["D"]     = {func: "mgB_OpenNewDocument"}
    b["U"]     = {func: "mgB_OpenTab"}
    b["UR"]    = {func: "mgB_NextTab"}
    b["UL"]    = {func: "mgB_PreviousTab"}
    b["ULU"]   = {func: "mgB_UpDir"}
    b["DR"]    = {func: "mgB_CloseTab"}
    b["RD"]    = {func: "mgB_ViewPageInfo"}
    b["LDRDL"] = {func: "mgB_ViewPageSource"}
    b["DRDLU"] = {func: "mgB_AddBookmark"}
    b["RUDR"]  = {func: "mgB_DoubleStackWin"}
    b["9"]     = {func: "mgB_HideImage"}
    b["3"]     = {func: "mgB_ZoomIn_DoubleImage"}
    b["7"]     = {func: "mgB_ZoomOut_HalveImage"}
    b["1"]     = {func: "mgB_ResetZoom"}
    b["31"]    = {func: "mgB_ZoomIn"}
    b["13"]    = {func: "mgB_ZoomOut"}
    b["*RU"]   = {func: "mgB_LinksInWindows"}
    b["*RUL"]  = {func: "mgB_LinksInTabs"}

    //"vs" == viewsource
    var vs = this.mappings.viewsource;
    vs["3"]    = {func: "mgB_ZoomIn"}
    vs["7"]    = {func: "mgB_ZoomOut"}
    vs["1"]    = {func: "mgB_ResetZoom"}

    //"w" == generic (for all window types)
    var w = this.mappings.window;
    w["9L3"]   = {func: "mgW_Cut"}
    w["93"]    = {func: "mgW_Copy"}
    w["39"]    = {func: "mgW_Paste"}
    w["DRD"]   = {func: "mgW_CloseWin"}
    w["DL"]    = {func: "mgW_MinWin"}
    w["RU"]    = {func: "mgW_RestMaxWin"}
    w["U1"]    = {func: "mgW_ScrollUp"}
    w["D7"]    = {func: "mgW_ScrollDown"}
    w["R7"]    = {func: "mgW_ScrollRight"}
    w["L9"]    = {func: "mgW_ScrollLeft"}

    //"m" == messenger
    var m = this.mappings.messenger;
    m[":20"]   = {func: "mgM_PrevMessage"}
    m[":02"]   = {func: "mgM_NextMessage"}
    m["L"]     = {func: "mgM_PrevMessage"}
    m["R"]     = {func: "mgM_NextMessage"}
    m["DRU"]   = {func: "mgM_DeleteMessage"}
    m["DUR"]   = {func: "mgM_ReplyMessage"}
    m["DURL"]  = {func: "mgM_ForwardMessage"}
    m["UD"]    = {func: "mgM_Reload"}
    m["DURD"]  = {func: "mgM_Home"}
    m["D"]     = {func: "mgM_NewMessage"}
    m["*RUL"]  = {func: "mgM_OpenLinks"}
    m["URD"]   = {func: "mgM_ViewSource"}
    m["9"]     = {func: "mgB_HideImage"}
    m["3"]     = {func: "mgB_ZoomIn_DoubleImage"}
    m["7"]     = {func: "mgB_ZoomOut_HalveImage"}
    m["1"]     = {func: "mgB_ResetZoom"}
    m["31"]    = {func: "mgB_ZoomIn"}
    m["13"]    = {func: "mgB_ZoomOut"}

    //"mc" == mailcompose
    var mc     = this.mappings.mailcompose;
  },

  getMappings : function() {
    return this.mappings
  }
}

var mgDefaultFunctions =
{
  functions : {
     browser     : new Array(),
     viewsource  : new Array(),
     window      : new Array(),
     messenger   : new Array(),
     mailcompose : new Array()
  },

  init : function() {
    /* "b" == functions for browser
    ======================================================
    b["mgB_ResetZoom"] = ["B", "M", "VS"] -> this function
    will work in (B)rowser, (M)essenger and (V)iew(S)ource
    ====================================================== */
    var b = this.functions.browser;
    b["mgB_AddBookmark"] = ["B"]
    b["mgB_Back"] = ["B"]
    b["mgB_CloseDoc"] = ["B"]
    b["mgB_CloseTab"] = ["B"]
    b["mgB_DoubleImageSize"] = ["B", "M"]
    b["mgB_DoubleStackWin"] = ["B"]
    b["mgB_Forward"] = ["B"]
    b["mgB_HalveImageSize"] = ["B", "M"]
    b["mgB_HideImage"] = ["B", "M"]
    b["mgB_Home"] = ["B"]
    b["mgB_LinksInTabs"] = ["B"]
    b["mgB_LinksInWindows"] = ["B"]
    b["mgB_NextTab"] = ["B"]
    b["mgB_OpenNewDocument"] = ["B"]
    b["mgB_OpenTab"] = ["B"]
    b["mgB_PreviousTab"] = ["B"]
    b["mgB_Reload"] = ["B"]
    b["mgB_ResetZoom"] = ["B", "M", "VS"]
    b["mgB_Stop"] = ["B"]
    b["mgB_UpDir"] = ["B"]
    b["mgB_ViewPageInfo"] = ["B"]
    b["mgB_ViewPageSource"] = ["B"]
    b["mgB_ZoomIn"] = ["B", "M", "VS"]
    b["mgB_ZoomIn_DoubleImage"] = ["B", "M"]
    b["mgB_ZoomOut"] = ["B", "M", "VS"]
    b["mgB_ZoomOut_HalveImage"] = ["B", "M"]

    // "w" == functions for all window types (generic)
    var w = this.functions.window;
    w["mgW_CloseWin"] = ["W"]
    w["mgW_Copy"] = ["W"]
    w["mgW_Cut"] = ["W"]
    w["mgW_MinWin"] = ["W"]
    w["mgW_Paste"] = ["W"]
    w["mgW_RestMaxWin"] = ["W"]
    w["mgW_ScrollDown"] = ["W"]
    w["mgW_ScrollUp"] = ["W"]
    w["mgW_ScrollRight"] = ["W"]
    w["mgW_ScrollLeft"] = ["W"]

    // "m" == functions for messenger
    var m = this.functions.messenger;
    m["mgM_DeleteMessage"] = ["M"]
    m["mgM_ForwardMessage"] = ["M"]
    m["mgM_Home"] = ["M"]
    m["mgM_NewMessage"] = ["M"]
    m["mgM_NextMessage"] = ["M"]
    m["mgM_NextUnreadMessage"] = ["M"]
    m["mgM_OpenLinks"] = ["M"]
    m["mgM_PrevMessage"] = ["M"]
    m["mgM_PrevUnreadMessage"] = ["M"]
    m["mgM_Reload"] = ["M"]
    m["mgM_ReplyMessage"] = ["M"]
    m["mgM_ViewSource"] = ["M"]

    // "mc" == functions for mailcompose
    var mc = this.functions.mailcompose;
  },

  getFunctions : function() {
    return this.functions
  }
}

var mgDefaultPrefs = {
  prefs : new Array(),

  init : function() {
    var p = this.prefs

    // int [default, min, max]
    p["grid"] = [15, 4, 500]
    p["delay"] = [1000, 200, 10000]
    p["lmbGestureLimit"] = [500, 100, 10000]
    p["dragdropDelay"] = [400, 100, 10000]
    p["staticRockersDelay"] = [1000, 200, 10000]
    p["diagonalTolerance"] = [60, 0, 75]
    p["mousebutton"] = navigator.platform.indexOf("Mac") == 0 ? [0, 0, 2] : [2, 0, 2]
    p["trails.width"] = [4, 1, 100]
    p["trails.interval"] = [2, 1, 100]
    p["status.timeout"] = [1000, 0, 5000]
    p["selectedTabIndex"] = [3, 0, 3]

    // bool
    p["browser"] = [true]
    p["viewsource"] = [true]
    p["messenger"] = [true]
    p["mailcompose"] = [true]
    p["enableDump"] = [false]
    p["enableStrokes"] = [true]
    p["enableRockers"] = [true]
    p["staticRockers"] = [false]
    p["enableWheelRockers"] = [false]
    p["staticWheelRockers"] = [false]
    p["lefthanded"] = [false]
    p["modifier.ctrl"] = [false]
    p["modifier.alt"] = [false]
    p["modifier.shift"] = [false]
    p["modifier.meta"] = [false]
    p["trails.enabled"] = [false]
    p["status.enabled"] = [true]
    p["status.rockers.enabled"] = [false]
    p["sideBarToolTip"] = [true]

    // char
    p["trails.color"] = ["#FF9900"]
    p["sideBarSort"] = ["sortByUsage"]
    p["importFrom"] = ["www.mousegestures.org"]
  },

  getPref : function(pref) {
    if (pref in this.prefs)
      return this.prefs[pref];
    else
      return ["notFound"];
  }
}