/* ***** BEGIN LICENSE BLOCK *****
 *	 Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is moz-gnome-pm.
 *
 * The Initial Developer of the Original Code is
 * Canonical Ltd.
 * Portions created by the Initial Developer are Copyright (C) 2010
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Chris Coulson <chris.coulson@canonical.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 * ***** END LICENSE BLOCK ***** */

const nsIDownloadManager		= Ci.nsIDownloadManager;
const IGnomeSessionInhibitorService	= Ci.IGnomeSessionInhibitorService

var dsi = null;
window.addEventListener('load', initDownloadSuspendInhibitor, false);

function DownloadManagerListener()
{

}

DownloadManagerListener.prototype = {
	onDownloadStateChange: function(aState, aDownload) {
		dsi.maybe_inhibit();
	},

	onStateChange: function(aWebProgress, aRequest, aStateFlags, aStatus, aDownload) {

	},

	onProgressChange: function(aWebProgress, aRequest, aCurSelfProgress, aMaxSelfProgress, aCurTotalProgress, aMaxTotalProgress, aDownload) {

	},

	onSecurityChange: function(aWebProgress, aRequest, aState, aDownload) {

	}
}

function DownloadSuspendInhibitor()
{
	this.init();
}

DownloadSuspendInhibitor.prototype = {
	init: function() {
		this.nsidm = Cc["@mozilla.org/download-manager;1"].getService(nsIDownloadManager);
		this.inhibitor = Cc["@canonical.com/gnome-session-inhibitor-service;1"].getService(IGnomeSessionInhibitorService);
		this.dml = new DownloadManagerListener();
		this.nsidm.addListener(this.dml);
		this.cookie = null;

		// Cold start
		this.maybe_inhibit();
	},

	maybe_inhibit: function() {
		if((this.nsidm.activeDownloadCount > 0) && (this.cookie == null)) {
			// FIXME: We should probably provide a more informative reason depending on the number of downloads
			// FIXME: We need a way to get the window xid here
			var strbundle = document.getElementById("download-suspend-inhibitor-strings");
			var reason = strbundle.getString("reason")
			this.cookie = this.inhibitor.inhibit(this.inhibitor.GSM_INHIBITOR_FLAG_SUSPEND, reason);
		} else if((this.cookie != null) && (this.nsidm.activeDownloadCount <= 0)) {
			this.inhibitor.uninhibit(this.cookie);
			delete this.cookie;
		}
	}
}

function initDownloadSuspendInhibitor()
{
	if(dsi == null) {
		dsi = new DownloadSuspendInhibitor();
	}
}
